/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.Bindable;
import hlt.language.design.types.CircularTypeException;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.GoalProver;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.ResiduatedGoal;
import hlt.language.design.types.StaticType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.Valuable;
import hlt.language.util.ObjectToIntMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class TypeParameter
extends StaticType
implements Bindable {
    private Type _value = this;
    private int _index = -1;
    private ObjectToIntMap _residuations;

    public final ObjectToIntMap residuations() {
        return this._residuations;
    }

    @Override
    public final int numberOfTypeComponents() {
        return 0;
    }

    @Override
    public final Type typeRefComponent(int n) throws NoSuchTypeComponentException {
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public final void setTypeRefComponent(int n, Type type) throws NoSuchTypeComponentException {
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public final byte kind() {
        return 2;
    }

    @Override
    public final Type value() {
        return this._value == this ? this._value : this._value.value();
    }

    @Override
    public final Type findValue() {
        return this._value == this ? this._value : (this._value = this._value.findValue());
    }

    @Override
    public final boolean isBound() {
        return this != this._value;
    }

    @Override
    public final boolean isUnbound() {
        return this == this._value;
    }

    @Override
    public final boolean bind(Valuable valuable, GoalProver goalProver) {
        if (this != (valuable = valuable.getValue())) {
            this._value = (Type)valuable;
            goalProver.trail(this);
        }
        this._releaseResiduations(this._value, goalProver);
        return true;
    }

    @Override
    public final boolean bind(Valuable valuable) {
        this._value = (Type)valuable;
        return true;
    }

    @Override
    public final void unbind() {
        this._value = this;
        if (this._residuations != null) {
            Iterator iterator = this._residuations.iterator();
            while (iterator.hasNext()) {
                ObjectToIntMap.Entry entry = (ObjectToIntMap.Entry)iterator.next();
                ResiduatedGoal residuatedGoal = (ResiduatedGoal)entry.key();
                int n = entry.value();
                residuatedGoal.setRefCount(n);
                if (n != 0) continue;
                this._residuations.remove(residuatedGoal);
            }
        }
    }

    public final boolean addResiduation(ResiduatedGoal residuatedGoal, int n) {
        if (this._residuations == null) {
            this._residuations = new ObjectToIntMap();
        }
        boolean bl = !this._residuations.containsKey(residuatedGoal) | this._residuations.put(residuatedGoal, n) != n;
        return bl;
    }

    @Override
    public final HashSet getParameters(HashSet hashSet) {
        hashSet.add(this);
        return hashSet;
    }

    @Override
    public final boolean isPolymorphic() {
        return this._value == this ? true : this._value.isPolymorphic();
    }

    @Override
    public final void curry(int n, TypeChecker typeChecker) {
        if (this.isBound()) {
            this._value.curry(n, typeChecker);
        }
    }

    @Override
    public final Type flatten() {
        if (this.isBound()) {
            return this._value.flatten();
        }
        return this;
    }

    public final int parameterIndex() {
        return this._index;
    }

    @Override
    public final Type copy(HashMap hashMap) {
        if (this.isBound()) {
            return this.value().copy(hashMap);
        }
        TypeParameter typeParameter = (TypeParameter)hashMap.get(this);
        if (typeParameter == null) {
            this._index = hashMap.size();
            typeParameter = new TypeParameter();
            hashMap.put(this, typeParameter);
        }
        return typeParameter;
    }

    @Override
    public final Type instantiate(HashMap hashMap) {
        if (this.isBound()) {
            return this.value().instantiate(hashMap);
        }
        Type type = (Type)hashMap.get(this);
        return type == null ? this : type;
    }

    @Override
    public final Type copy() {
        return this;
    }

    @Override
    public final void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        if ((type = type.value()) == this) {
            return;
        }
        type.checkOccurrence(this, type, typeChecker);
        typeChecker.trail(this);
        this._value = type;
        this._releaseResiduations(this._value, typeChecker);
    }

    private final void _releaseResiduations(Type type, GoalProver goalProver) {
        if (this._residuations != null) {
            Iterator iterator = this._residuations.keys();
            while (iterator.hasNext()) {
                ((ResiduatedGoal)iterator.next()).release(type, goalProver);
            }
        }
    }

    @Override
    public final boolean unify(Type type) {
        this._value = type.findValue();
        return true;
    }

    @Override
    public final void checkOccurrence(TypeParameter typeParameter, Type type, TypeChecker typeChecker) throws FailedUnificationException {
        if (this == typeParameter) {
            typeChecker.error(new CircularTypeException((Object)(typeParameter + " occurs in " + type)));
        }
    }

    @Override
    public final int eqCode() {
        return this.kind();
    }

    @Override
    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public final boolean isEqualTo(Type type) {
        return this == type;
    }

    @Override
    public final boolean isEqualTo(Type type, HashMap hashMap) {
        type = type.value();
        Type type2 = (Type)hashMap.get(this);
        if (type2 != null) {
            return type2 == type;
        }
        hashMap.put(this, type);
        return true;
    }

    public final String toString() {
        return TypeParameter.name(this.value());
    }
}

