/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.NamedType;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypeDefinitionException;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;

public abstract class TypeTerm
extends NamedType
implements Cloneable {
    protected Type[] _arguments;

    @Override
    public int numberOfTypeComponents() {
        return this.arity();
    }

    @Override
    public Type typeRefComponent(int n) throws NoSuchTypeComponentException {
        if (n >= 0 && n < this.arity()) {
            return this._arguments[n];
        }
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public void setTypeRefComponent(int n, Type type) throws NoSuchTypeComponentException {
        if (n < 0 || n >= this.arity()) {
            throw new NoSuchTypeComponentException(this, n);
        }
        this._arguments[n] = type;
    }

    public final Type[] arguments() {
        return this._arguments;
    }

    public final Type argument(int n) {
        return this._arguments[n].value();
    }

    public final int arity() {
        if (this._arguments == null) {
            return 0;
        }
        return this._arguments.length;
    }

    public final TypeTerm setArguments(AbstractList abstractList) {
        if (abstractList != null) {
            this._arguments = new Type[abstractList.size()];
            int n = this._arguments.length;
            while (n-- > 0) {
                this._arguments[n] = (Type)abstractList.get(n);
            }
        }
        return this;
    }

    public final TypeTerm setArguments(Type[] typeArray) {
        this._arguments = typeArray;
        return this;
    }

    @Override
    public Type flatten() {
        int n = this.arity();
        while (n-- > 0) {
            this._arguments[n] = this.argument(n).flatten();
        }
        return this;
    }

    @Override
    public boolean isPolymorphic() {
        int n = this.arity();
        while (n-- > 0) {
            if (!this.argument(n).isPolymorphic()) continue;
            return true;
        }
        return false;
    }

    private final TypeTerm _clone() {
        TypeTerm typeTerm = null;
        try {
            typeTerm = (TypeTerm)this.clone();
        }
        catch (Exception exception) {
            throw new TypeDefinitionException((Object)exception);
        }
        return typeTerm;
    }

    @Override
    public Type copy(HashMap hashMap) {
        if (this.arity() == 0) {
            return this;
        }
        Type[] typeArray = new Type[this.arity()];
        int n = this.arity();
        while (n-- > 0) {
            typeArray[n] = this.argument(n).copy(hashMap);
        }
        return this._clone().setArguments(typeArray);
    }

    @Override
    public Type instantiate(HashMap hashMap) {
        if (this.arity() == 0) {
            return this;
        }
        Type[] typeArray = new Type[this.arity()];
        int n = this.arity();
        while (n-- > 0) {
            typeArray[n] = this.argument(n).instantiate(hashMap);
        }
        return this._clone().setArguments(typeArray);
    }

    @Override
    public int eqCode() {
        int n = super.eqCode() + this.arity();
        int n2 = this.arity();
        while (n2-- > 0) {
            n += (n2 + 1) * this.argument(n2).eqCode();
        }
        return n;
    }

    @Override
    public final boolean isEqualTo(Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof TypeTerm)) {
            return false;
        }
        TypeTerm typeTerm = (TypeTerm)type;
        if (this.kind() != typeTerm.kind() || this.name() != typeTerm.name() || this.arity() != typeTerm.arity()) {
            return false;
        }
        int n = this.arity();
        while (n-- > 0) {
            if (this.argument(n).isEqualTo(typeTerm.argument(n))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isEqualTo(Type type, HashMap hashMap) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof TypeTerm)) {
            return false;
        }
        TypeTerm typeTerm = (TypeTerm)type;
        if (this.kind() != typeTerm.kind() || this.name() != typeTerm.name() || this.arity() != typeTerm.arity()) {
            return false;
        }
        int n = this.arity();
        while (n-- > 0) {
            if (this.argument(n).isEqualTo(typeTerm.argument(n), hashMap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        TypeTerm typeTerm;
        if ((type = type.value()) == this) {
            return;
        }
        if (type.kind() == 2) {
            type.unify(this, typeChecker);
            return;
        }
        if (type.kind() != this.kind()) {
            typeChecker.error(new TypeClashException(this, type));
        }
        if ((typeTerm = (TypeTerm)type).name() != this.name() || typeTerm.arity() != this.arity()) {
            typeChecker.error(new TypeClashException(this, typeTerm));
        }
        int n = this.arity();
        while (n-- > 0) {
            this.argument(n).unify(typeTerm.arguments()[n], typeChecker);
            if (!this.argument(n).isVoid()) continue;
            typeChecker.error(new TypingErrorException((Object)"void type instantiation"));
        }
    }

    @Override
    public boolean unify(Type type) {
        boolean bl;
        if ((type = type.findValue()) == this) {
            return true;
        }
        if (type.kind() == 2) {
            ((TypeParameter)type).bind(this);
            return true;
        }
        boolean bl2 = bl = type.kind() == this.kind();
        if (bl) {
            TypeTerm typeTerm = (TypeTerm)type;
            int n = this.arity();
            bl &= n == typeTerm.arity() && this.name() == typeTerm.name();
            while (bl && n-- > 0) {
                bl &= this._arguments[n].findValue().unify(typeTerm.arguments()[n]);
            }
        }
        return bl;
    }

    @Override
    public void checkOccurrence(TypeParameter typeParameter, Type type, TypeChecker typeChecker) throws FailedUnificationException {
        int n = this.arity();
        while (n-- > 0) {
            this.argument(n).checkOccurrence(typeParameter, type, typeChecker);
        }
    }

    @Override
    public HashSet getParameters(HashSet hashSet) {
        int n = this.arity();
        while (n-- > 0) {
            this.argument(n).getParameters(hashSet);
        }
        return hashSet;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this._name);
        if (this.arity() != 0) {
            stringBuilder.append("(");
            for (int i = 0; i < this.arity(); ++i) {
                stringBuilder.append(this.argument(i) + (i == this.arity() - 1 ? ")" : ","));
            }
        }
        return stringBuilder.toString();
    }
}

