/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.kernel.Expression;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.Goal;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.util.Locatable;
import java.util.Iterator;

public class TypingGoal
extends Goal {
    private Expression _expression;
    private Type _type;

    public TypingGoal(Expression expression, Type type) {
        this._expression = expression;
        this._type = type;
    }

    final Expression expression() {
        return this._expression;
    }

    final Type type() {
        return this._type;
    }

    @Override
    final Locatable extent() {
        return this._expression;
    }

    @Override
    final void prove(TypeChecker typeChecker) throws FailedUnificationException {
        this.trail(typeChecker);
        this._expression.type().unify(this._type, typeChecker);
        if (this._expression.otherTypes() != null) {
            Iterator iterator = this._expression.otherTypes().iterator();
            while (iterator.hasNext()) {
                this._expression.type().unify((Type)iterator.next(), typeChecker);
            }
        }
    }

    @Override
    public final String toString() {
        return super.toString() + ": (typing) type => " + this._type.value() + ", expression => " + this._expression;
    }
}

