/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.Goal;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.util.Locatable;

public class UnifyGoal
extends Goal {
    private Type _lhs;
    private Type _rhs;
    private Locatable _extent;

    public UnifyGoal(Type type, Type type2) {
        this._lhs = type;
        this._rhs = type2;
    }

    public UnifyGoal(Type type, Type type2, Locatable locatable) {
        this._lhs = type;
        this._rhs = type2;
        this._extent = locatable;
    }

    @Override
    final Locatable extent() {
        return this._extent;
    }

    final Type lhs() {
        return this._lhs.value();
    }

    final Type rhs() {
        return this._rhs.value();
    }

    @Override
    void prove(TypeChecker typeChecker) throws FailedUnificationException {
        this.trail(typeChecker);
        this.lhs().unify(this.rhs(), typeChecker);
    }

    @Override
    public String toString() {
        return super.toString() + ": (unify) lhs => " + this.lhs() + ", rhs => " + this.rhs();
    }
}

