/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.io;

import hlt.language.io.IncludeReader;
import hlt.language.util.Location;
import hlt.language.util.Span;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public abstract class AbstractStreamTokenizer {
    public static final byte ORDINARY = 0;
    public static final byte WHITESPACE = 1;
    public static final byte QUOTE = 2;
    public static final byte WORD = 3;
    public static final byte NUMERIC = 4;
    public static final byte COMMENT = 5;
    public static final byte SPECIAL = 6;
    protected static final byte EMPTY_TYPE = 0;
    protected static final byte ORDINARY_TYPE = 1;
    protected static final byte WHITESPACE_TYPE = 2;
    protected static final byte QUOTE_TYPE = 4;
    protected static final byte WORD_TYPE = 8;
    protected static final byte NUMERIC_TYPE = 16;
    protected static final byte COMMENT_TYPE = 32;
    protected static final byte SPECIAL_TYPE = 64;
    protected static int ESCAPE_CHAR = 92;
    protected static final int[] typePrecedence = new int[]{3, 1, 5, 2, 0, 6};
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_WORD = -4;
    public static final int TT_NUMBER = -5;
    public static final int TT_NOTHING = -6;
    public static final int TT_SPECIAL = -7;
    public int ttype = -6;
    public String sval;
    public double nval;
    public boolean isInteger;
    protected Reader reader;
    protected Location tokenStart;
    protected Location previousTokenStart;
    protected Location tokenEnd;
    protected Location previousTokenEnd;
    protected int currentChar = -6;
    protected int previousChar = -6;
    protected int followingChar = -6;
    protected int currentCharLine = 1;
    protected int followingCharLine = 1;
    protected int currentCharCol = 0;
    protected int followingCharCol = 0;
    protected String currentCharFile;
    protected String followingCharFile;
    protected StringBuilder wordBuffer;
    protected int leftQuote;
    protected int rightQuote;
    protected boolean parsingNumbers;
    protected boolean parsingNonDecimals;
    protected boolean parsingDigitsOnly;
    protected boolean eolIsSignificant;
    protected boolean spaceIsSignificant;
    protected boolean pushedBack = false;
    protected final CharInfo[] charInfo = new CharInfo[256];

    public abstract void commentChar(int var1);

    public abstract void slashSlashComments(boolean var1);

    public abstract void slashStarComments(boolean var1);

    public int nextTokenType() throws IOException {
        return this.nextToken();
    }

    public abstract int nextToken() throws IOException;

    public abstract void enableComments();

    public abstract void disableComments();

    abstract void readFollowingChar() throws IOException;

    abstract void readDecimal() throws IOException;

    public Location tokenStart() {
        if (this.pushedBack) {
            return this.previousTokenStart;
        }
        return this.tokenStart;
    }

    public Location tokenEnd() {
        if (this.pushedBack) {
            return this.previousTokenEnd;
        }
        return this.tokenEnd;
    }

    protected Location currentCharLocation() {
        return new Location(this.currentCharFile, this.currentCharLine, this.currentCharCol);
    }

    protected void setStartLocation() {
        this.previousTokenStart = this.tokenStart;
        this.tokenStart = this.currentCharLocation();
    }

    protected void setEndLocation() {
        this.previousTokenEnd = this.tokenEnd;
        this.tokenEnd = this.currentCharLocation();
    }

    protected void resetStartLocation() {
        this.tokenStart.setFile(this.currentCharFile);
        this.tokenStart.setLine(this.currentCharLine);
        this.tokenStart.setColumn(this.currentCharCol);
    }

    protected void resetEndLocation() {
        this.tokenEnd.setFile(this.currentCharFile);
        this.tokenEnd.setLine(this.currentCharLine);
        this.tokenEnd.setColumn(this.currentCharCol);
    }

    public final int getLineNumber() {
        return this.currentCharLine;
    }

    public final int lineno() {
        return this.getLineNumber();
    }

    public final String getFile() {
        return this.currentCharFile;
    }

    public String location() {
        String string = "line " + this.lineno();
        String string2 = this.getFile();
        if (string2 == null) {
            return string;
        }
        return "file " + string2 + ", " + string;
    }

    public final void ordinaryChars(int n, int n2) {
        this.resetCharRange((byte)1, n, n2);
    }

    public final void wordChars(int n, int n2) {
        this.resetCharRange((byte)8, n, n2);
    }

    public final void whitespaceChars(int n, int n2) {
        this.resetCharRange((byte)2, n, n2);
    }

    public final void quoteChar(int n) {
        this.quotePair(n, n, ESCAPE_CHAR);
    }

    public final void quoteChar(int n, int n2) {
        this.quotePair(n, n, n2);
    }

    public final void ordinaryChar(int n) {
        if (0 <= n && n < this.charInfo.length) {
            this.charInfo[n].type = 1;
        }
    }

    public final void eolIsSignificant(boolean bl) {
        this.eolIsSignificant = bl;
    }

    public final void spaceIsSignificant(boolean bl) {
        this.spaceIsSignificant = bl;
    }

    public final void parseNumbers() {
        this.parseNumbers(true);
    }

    public final void parseNonDecimals() {
        this.parseNonDecimals(true);
    }

    public final void ignoreNonDecimals() {
        this.parseNonDecimals(false);
    }

    public final void parseDigitsOnly() {
        this.parseNumbers();
        this.parsingDigitsOnly = true;
        this.setType("+-.", 0);
    }

    public final boolean parsingDigitsOnly() {
        return this.parsingDigitsOnly;
    }

    public final void parseNumbers(boolean bl) {
        this.parsingDigitsOnly = false;
        this.parsingNumbers = bl;
        if (this.parsingNumbers) {
            this.setType(48, 57, 4);
            this.setType("+-.", 4);
            this.parseNonDecimals();
        } else {
            this.unsetType(48, 57, 4);
            this.unsetType("+-.", 4);
        }
    }

    public final void parseNonDecimals(boolean bl) {
        this.parsingNonDecimals = bl;
    }

    public final void pushBack() {
        if (this.ttype != -6) {
            this.pushedBack = true;
        }
    }

    public String toString() {
        Object object;
        switch (this.ttype) {
            case -1: {
                object = "EOF";
                break;
            }
            case 10: {
                object = "EOL";
                break;
            }
            case -4: {
                object = "WORD(" + this.sval + ")";
                break;
            }
            case -5: {
                if (this.isInteger) {
                    object = "NUMBER(" + (int)this.nval + ")";
                    break;
                }
                object = "NUMBER(" + this.nval + ")";
                break;
            }
            case -6: {
                object = "NOTHING";
                break;
            }
            default: {
                if (this.ttype == this.leftQuote) {
                    object = "QUOTE(" + (char)this.leftQuote + this.sval + (char)this.rightQuote + ")";
                    break;
                }
                char[] cArray = new char[3];
                cArray[2] = 39;
                cArray[0] = 39;
                cArray[1] = (char)this.ttype;
                object = new String(cArray);
                break;
            }
        }
        return new Span(this.tokenStart, this.tokenEnd) + "\t" + (String)object;
    }

    public final void quotePair(int n, int n2, int n3) {
        if (0 <= n && n < this.charInfo.length) {
            this.charInfo[n].type = (byte)4;
            this.charInfo[n].right = n2;
            this.charInfo[n].escape = n3;
        }
    }

    public final void quotePair(int n, int n2) {
        this.quotePair(n, n2, ESCAPE_CHAR);
    }

    public final void setQuotePair(int n, int n2, int n3) {
        if (0 <= n && n < this.charInfo.length) {
            this.setType(n, (byte)4);
            this.charInfo[n].right = n2;
            this.charInfo[n].escape = n3;
        }
    }

    public final void setQuoteChar(int n) {
        this.setQuotePair(n, n, ESCAPE_CHAR);
    }

    public final void setQuoteChar(int n, int n2) {
        this.setQuotePair(n, n, n2);
    }

    public final void setOrdinaryChar(int n) {
        if (0 <= n && n < this.charInfo.length) {
            this.setType(n, (byte)1);
        }
    }

    public final void wordChar(int n) {
        if (0 <= n && n < this.charInfo.length) {
            this.charInfo[n].type = (byte)8;
        }
    }

    public final void setWordChar(int n) {
        if (0 <= n && n < this.charInfo.length) {
            this.setType(n, (byte)8);
        }
    }

    public final void wordChars(String string) {
        this.resetCharString((byte)8, string);
    }

    public final void setWordChars(String string) {
        this.setCharString((byte)8, string);
    }

    public final void whitespaceChar(int n) {
        if (0 <= n && n < this.charInfo.length) {
            this.charInfo[n].type = (byte)2;
        }
    }

    public final void setWhitespaceChar(int n) {
        if (0 <= n && n < this.charInfo.length) {
            this.setType(n, (byte)2);
        }
    }

    public final void whitespaceChars(String string) {
        this.resetCharString((byte)2, string);
    }

    public final void setWhitespaceChars(String string) {
        this.setCharString((byte)2, string);
    }

    public final void ordinaryChars(String string) {
        this.resetCharString((byte)1, string);
    }

    public final void setOrdinaryChars(String string) {
        this.setCharString((byte)1, string);
    }

    public final boolean isOrdinaryChar(int n) {
        return 0 <= n && n < this.charInfo.length && this.hasType(n, (byte)1);
    }

    public final boolean isNumericChar(int n) {
        return 0 <= n && n < this.charInfo.length && this.hasType(n, (byte)16);
    }

    public final boolean isWordChar(int n) {
        return n >= this.charInfo.length || n > 0 && this.hasType(n, (byte)8);
    }

    public final boolean isWhitespaceChar(int n) {
        return 0 <= n && n < this.charInfo.length && this.hasType(n, (byte)2);
    }

    public final boolean isQuoteChar(int n) {
        return 0 <= n && n < this.charInfo.length && this.hasType(n, (byte)4);
    }

    public final int peek() {
        return this.followingChar;
    }

    public final int peekBack() {
        return this.previousChar;
    }

    public final void skipChar() throws IOException {
        this.nextChar();
    }

    public final void skipChar(boolean bl) throws IOException {
        this.nextChar();
        if (bl) {
            this.resetEndLocation();
        } else {
            this.resetStartLocation();
        }
    }

    public final void setType(int n, int n2) {
        this.setType(n, (byte)(1 << n2));
    }

    public final void setType(int n, int n2, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.setType(i, n3);
        }
    }

    public final void setType(String string, int n) {
        for (int i = 0; i < string.length(); ++i) {
            this.setType((int)string.charAt(i), n);
        }
    }

    public final void unsetType(int n, int n2) {
        this.unsetType(n, (byte)(1 << n2));
    }

    public final void unsetType(int n, int n2, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.unsetType(i, n3);
        }
    }

    public final void unsetType(String string, int n) {
        for (int i = 0; i < string.length(); ++i) {
            this.unsetType((int)string.charAt(i), n);
        }
    }

    public final int currentChar() {
        return this.currentChar;
    }

    protected final void initializeCharInfo() {
        for (int i = 0; i < this.charInfo.length; ++i) {
            this.charInfo[i] = new CharInfo();
        }
    }

    protected final void setType(int n, byte by) {
        this.charInfo[n].type = (byte)(this.charInfo[n].type | by);
    }

    protected final void unsetType(int n, byte by) {
        this.charInfo[n].type = (byte)(this.charInfo[n].type & ~by);
    }

    protected final boolean hasType(int n, byte by) {
        return (this.charInfo[n].type & by) != 0;
    }

    protected final boolean thisHasType(byte by) {
        return this.hasType(this.currentChar, by);
    }

    public final void resetSyntax() {
        AbstractStreamTokenizer.typePrecedence[0] = 3;
        AbstractStreamTokenizer.typePrecedence[1] = 1;
        AbstractStreamTokenizer.typePrecedence[2] = 5;
        AbstractStreamTokenizer.typePrecedence[3] = 2;
        AbstractStreamTokenizer.typePrecedence[4] = 0;
        for (int i = 0; i < this.charInfo.length; ++i) {
            this.charInfo[i].type = 1;
        }
        this.parseNumbers(false);
        this.eolIsSignificant(true);
        this.spaceIsSignificant(true);
        this.disableComments();
    }

    public final void setDefaultSyntax() {
        AbstractStreamTokenizer.typePrecedence[0] = 3;
        AbstractStreamTokenizer.typePrecedence[1] = 1;
        AbstractStreamTokenizer.typePrecedence[2] = 5;
        AbstractStreamTokenizer.typePrecedence[3] = 2;
        AbstractStreamTokenizer.typePrecedence[4] = 0;
        for (int i = 0; i < this.charInfo.length; ++i) {
            this.charInfo[i].type = 1;
        }
        this.whitespaceChars(0, 32);
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(48, 57);
        this.wordChars("_.");
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers(true);
        this.eolIsSignificant(false);
        this.spaceIsSignificant(false);
        this.slashStarComments(true);
        this.slashSlashComments(true);
    }

    final int currentType() {
        return this.currentType(true);
    }

    protected final int currentType(boolean bl) {
        if (bl) {
            if (this.currentChar < 0) {
                return 6;
            }
            if (this.currentChar >= this.charInfo.length) {
                return 3;
            }
            if (this.parsingNumbers && this.thisHasType((byte)16)) {
                if (this.parsingDigitsOnly) {
                    if (this.isDecimalDigit(this.currentChar)) {
                        return 4;
                    }
                    return this.currentType(false);
                }
                switch (this.currentChar) {
                    case 43: 
                    case 45: {
                        if (this.followingChar == 46) {
                            return 4;
                        }
                        if (!this.isDecimalDigit(this.followingChar)) {
                            return this.currentType(false);
                        }
                    }
                    case 46: {
                        if (this.isDecimalDigit(this.followingChar) && this.previousChar != 46) break;
                        return this.currentType(false);
                    }
                }
                return 4;
            }
        }
        for (int i = 0; i < typePrecedence.length; ++i) {
            if (!this.thisHasType((byte)(1 << typePrecedence[i]))) continue;
            return typePrecedence[i];
        }
        return 6;
    }

    protected final void setCharRange(byte by, int n, int n2) {
        if (0 <= n && n2 < this.charInfo.length) {
            for (int i = n; i <= n2; ++i) {
                this.setType(i, by);
            }
        }
    }

    protected final void resetCharRange(byte by, int n, int n2) {
        if (0 <= n && n2 < this.charInfo.length) {
            for (int i = n; i <= n2; ++i) {
                this.charInfo[i].type = by;
            }
        }
    }

    protected final void setCharString(byte by, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\u0000' > c || c >= this.charInfo.length) continue;
            this.setType((int)c, by);
        }
    }

    protected final void resetCharString(byte by, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\u0000' > c || c >= this.charInfo.length) continue;
            this.charInfo[c].type = by;
        }
    }

    protected final void nextChar() throws IOException {
        this.previousChar = this.currentChar;
        this.currentChar = this.followingChar;
        this.currentCharLine = this.followingCharLine++;
        this.currentCharCol = this.followingCharCol;
        this.currentCharFile = this.followingCharFile;
        this.readFollowingChar();
        if (this.reader instanceof IncludeReader) {
            this.followingCharLine = ((IncludeReader)this.reader).getLineNumber();
            this.followingCharCol = ((IncludeReader)this.reader).getColumnNumber();
        } else if (this.followingChar == 10) {
            this.followingCharCol = 0;
        }
        if (this.reader instanceof IncludeReader) {
            this.followingCharFile = ((IncludeReader)this.reader).getFile();
        }
    }

    protected final void skipLine() throws IOException {
        while (this.followingChar != 10) {
            this.nextChar();
            if (this.followingChar != -1) continue;
            break;
        }
    }

    protected final void readWord() throws IOException {
        this.wordBuffer = new StringBuilder();
        this.wordBuffer.append((char)this.currentChar);
        while (this.isWordChar(this.followingChar)) {
            this.wordBuffer.append((char)this.followingChar);
            this.nextChar();
        }
        this.sval = this.wordBuffer.toString().intern();
    }

    protected final void readNumber() throws IOException {
        boolean bl;
        this.isInteger = true;
        this.nval = 0.0;
        boolean bl2 = bl = this.currentChar == 45;
        if (this.currentChar == 45 || this.currentChar == 43) {
            this.nextChar();
        }
        block0 : switch (this.currentChar) {
            case 48: {
                if (this.parsingNonDecimals) {
                    switch (this.followingChar) {
                        case 88: 
                        case 120: {
                            this.readHexadecimal();
                            break block0;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            this.readOctal();
                            break block0;
                        }
                    }
                    this.readDecimal();
                    break;
                }
                this.readDecimal();
                break;
            }
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readDecimal();
                break;
            }
            default: {
                throw new IOException("Bad number format");
            }
        }
        if (bl) {
            this.nval = -this.nval;
        }
    }

    protected final void readOctal() throws IOException {
        while (this.isOctalDigit(this.followingChar)) {
            this.nval = 8.0 * this.nval + (double)(this.followingChar - 48);
            this.nextChar();
        }
        if (this.followingChar == 108 || this.followingChar == 76) {
            this.nextChar();
        }
    }

    protected final void readHexadecimal() throws IOException {
        this.nextChar();
        while (this.isHexadecimalDigit(this.followingChar)) {
            this.nval = 16.0 * this.nval + (double)this.hexValue(this.followingChar);
            this.nextChar();
        }
        if (this.followingChar == 108 || this.followingChar == 76) {
            this.nextChar();
        }
    }

    protected final int hexValue(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return n - 48;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return 10 + (n - 65);
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return 10 + (n - 97);
            }
        }
        return 0;
    }

    protected final boolean canFollowDecimalDot(int n) {
        return this.isDecimalDigit(n) || n == 101 || n == 69 || n == 100 || n == 68 || n == 102 || n == 70;
    }

    protected final void readInteger() throws IOException {
        this.nval = this.currentChar - 48;
        while (this.isDecimalDigit(this.followingChar)) {
            this.nval = 10.0 * this.nval + (double)(this.followingChar - 48);
            this.nextChar();
        }
    }

    protected final void readMantissa(boolean bl) throws IOException {
        double d = 0.0;
        int n = 1;
        while (this.isDecimalDigit(this.followingChar)) {
            bl = true;
            d = 10.0 * d + (double)(this.followingChar - 48);
            n *= 10;
            this.nextChar();
        }
        if (!bl) {
            throw new IOException("Bad number format");
        }
        this.nval += d / (double)n;
    }

    protected final void readExponent() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        this.nextChar();
        if (this.followingChar == 45 || this.followingChar == 43) {
            bl2 = this.followingChar == 45;
            this.nextChar();
        }
        while (this.isDecimalDigit(this.followingChar)) {
            bl = true;
            n = 10 * n + (this.followingChar - 48);
            this.nextChar();
        }
        if (!bl) {
            throw new IOException("Bad number format");
        }
        for (int i = 1; i <= n; ++i) {
            if (bl2) {
                this.nval /= 10.0;
                continue;
            }
            this.nval *= 10.0;
        }
    }

    protected final void readQuotedWord() throws IOException {
        this.wordBuffer = new StringBuilder();
        while (true) {
            this.nextChar();
            if (this.currentChar == this.rightQuote) break;
            if (this.currentChar == this.charInfo[this.leftQuote].escape) {
                this.readEscapedChar();
            }
            if (this.currentChar == -1) {
                throw new EOFException("End of file encountered while reading a quoted string");
            }
            this.wordBuffer.append((char)this.currentChar);
        }
        this.sval = this.wordBuffer.toString().intern();
    }

    protected final void readEscapedChar() throws IOException {
        if (this.isOctalDigit(this.followingChar)) {
            this.readOctalCode();
            return;
        }
        switch (this.followingChar) {
            case 110: {
                this.currentChar = 10;
                break;
            }
            case 116: {
                this.currentChar = 9;
                break;
            }
            case 98: {
                this.currentChar = 8;
                break;
            }
            case 114: {
                this.currentChar = 13;
                break;
            }
            case 102: {
                this.currentChar = 12;
                break;
            }
            case 117: {
                this.readUnicode();
                break;
            }
            default: {
                this.currentChar = this.followingChar;
            }
        }
        this.readFollowingChar();
    }

    protected final void readOctalCode() throws IOException {
        this.currentChar = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.isOctalDigit(this.followingChar)) {
                return;
            }
            this.currentChar = 8 * this.currentChar + (this.followingChar - 48);
            this.readFollowingChar();
        }
    }

    protected final void readUnicode() throws IOException {
        while (this.followingChar == 117) {
            this.readFollowingChar();
        }
        this.currentChar = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.isHexadecimalDigit(this.followingChar)) {
                throw new IOException("Non-hexadecimal digit in unicode (" + this.location() + ")");
            }
            this.currentChar = 16 * this.currentChar + this.hexValue(this.followingChar);
            if (i >= 3) continue;
            this.readFollowingChar();
        }
    }

    protected final boolean isOctalDigit(int n) {
        return 48 <= n && n <= 55;
    }

    protected final boolean isDecimalDigit(int n) {
        return 48 <= n && n <= 57;
    }

    protected final boolean isHexadecimalDigit(int n) {
        return 48 <= n && n <= 57 || 65 <= n && n <= 70 || 97 <= n && n <= 102;
    }

    protected static class CharInfo {
        byte type = 0;
        int right;
        int escape = ESCAPE_CHAR;

        CharInfo() {
        }
    }
}

