/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class FileTools {
    private static char _separator = File.separatorChar;

    private static List pathToList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (File file2 = file.getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                arrayList.add(file2.getName());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            arrayList = null;
        }
        return arrayList;
    }

    private static String matchPathLists(List list, List list2) {
        int n;
        Object object = "";
        int n2 = list.size() - 1;
        for (n = list2.size() - 1; n2 >= 0 && n >= 0 && list.get(n2).equals(list2.get(n)); --n2, --n) {
        }
        while (n2 >= 0) {
            object = (String)object + ".." + File.separator;
            --n2;
        }
        while (n >= 1) {
            object = (String)object + list2.get(n) + File.separator;
            --n;
        }
        object = (String)object + list2.get(n);
        return object;
    }

    public static String getRelativePath(File file, File file2) {
        return FileTools.matchPathLists(FileTools.pathToList(file), FileTools.pathToList(file2));
    }

    public static final void copy(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public static final void setSeparator(String string) {
        if (string.length() == 0) {
            throw new RuntimeException("*** empty file separator");
        }
        if (string.length() > 1) {
            System.err.println("*** WARNING: bad file separator: \"" + string + "\" - taking only first char: '" + string.charAt(0) + "'");
        }
        _separator = string.charAt(0);
    }

    public static final void setSeparator(char c) {
        _separator = c;
    }

    public static final int dotPosition(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return n;
        }
        int n2 = string.lastIndexOf(_separator);
        if (n2 < n) {
            return n;
        }
        return -1;
    }

    public static final boolean hasDot(String string) {
        return FileTools.dotPosition(string) > 0;
    }

    public static final String simpleName(String string) {
        if (!FileTools.hasDot(string)) {
            return FileTools.prefix(string);
        }
        return FileTools.prefix(string) + "." + FileTools.suffix(string);
    }

    public static final String simpleName(File file) {
        return FileTools.simpleName(file.toString());
    }

    public static final String prefix(String string) {
        int n = string.lastIndexOf(_separator);
        int n2 = FileTools.dotPosition(string);
        if (n2 < 0) {
            return string.substring(n + 1);
        }
        return string.substring(n + 1, n2);
    }

    public static final String fullPrefix(String string) {
        int n = FileTools.dotPosition(string);
        if (n < 0) {
            return string.substring(0);
        }
        return string.substring(0, n);
    }

    public static final String prefix(File file) {
        return FileTools.prefix(file.toString());
    }

    public static final String extension(String string) {
        return FileTools.suffix(string);
    }

    public static final String suffix(String string) {
        int n = FileTools.dotPosition(string);
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static final String suffixIfDot(String string) {
        int n = FileTools.dotPosition(string);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static final String suffix(File file) {
        return FileTools.suffix(file.toString());
    }

    public static final String dir(String string) {
        int n = string.lastIndexOf(_separator);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static final String dir(File file) {
        return FileTools.dir(file.toString());
    }
}

