/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.io;

import hlt.language.io.CircularInclusionException;
import hlt.language.tools.Debug;
import hlt.language.tools.Misc;
import hlt.language.util.Stack;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;

public class IncludeReader
extends Reader {
    private Reader _reader;
    private String _file;
    private int _line = 1;
    private int _col = 0;
    private Stack _readerStack = new Stack();
    private HashSet _dejaVu = new HashSet();
    private boolean _isSeamless = true;
    private boolean _isInclusionStart = false;
    private boolean _reachedEndOfInclusion = false;
    private int _chr = -3;

    public boolean reachedEndOfInclusion() {
        return this._reachedEndOfInclusion;
    }

    public IncludeReader(Reader reader) {
        this._reader = reader;
    }

    public IncludeReader(String string) throws FileNotFoundException {
        this._reader = new BufferedReader(new FileReader(string));
        this._file = string;
        this._dejaVu.add(string);
    }

    public final void setSeamless(boolean bl) {
        this._isSeamless = bl;
    }

    public final boolean isSeamless() {
        return this._isSeamless;
    }

    public final String getFile() {
        if (this._file == null && this._reader instanceof IncludeReader) {
            return ((IncludeReader)this._reader).getFile();
        }
        return this._file;
    }

    public final void setFile(String string) {
        this._file = string;
    }

    public final int latestChar() {
        return this._chr;
    }

    public final int getLineNumber() {
        return this._line;
    }

    public final int getColumnNumber() {
        return this._col;
    }

    @Override
    public final void close() throws IOException {
        this._reader.close();
        while (!this._readerStack.isEmpty()) {
            ((ReaderStackElement)this._readerStack.pop()).reader().close();
        }
    }

    public final int depth() {
        return this._readerStack.size();
    }

    public final boolean isOutermost() {
        return this._readerStack.isEmpty();
    }

    @Override
    public final int read() throws IOException {
        if (this._isInclusionStart) {
            this._isInclusionStart = false;
            this._chr = -3;
        } else {
            this._chr = this._reader.read();
            while (this._chr == -1) {
                if (this._readerStack.isEmpty()) {
                    this._chr = -1;
                    this._reachedEndOfInclusion = true;
                    if (!Debug.flagIsOn()) break;
                    System.out.println("Reached the end of inclusion at depth " + this.depth());
                    break;
                }
                this._reader.close();
                if (this._file != null) {
                    this._dejaVu.remove(this._file);
                }
                ReaderStackElement readerStackElement = (ReaderStackElement)this._readerStack.pop();
                this._reader = readerStackElement.reader();
                this._file = readerStackElement.file();
                this._line = readerStackElement.line();
                this._col = readerStackElement.col();
                this._chr = -2;
            }
        }
        switch (this._chr) {
            case -3: {
                this._line = 1;
                this._col = 0;
                break;
            }
            case -2: 
            case -1: {
                break;
            }
            case 10: {
                ++this._line;
                this._col = 0;
                break;
            }
            case 8: {
                if (this._col <= 0) break;
                --this._col;
                break;
            }
            default: {
                ++this._col;
            }
        }
        if (this._isSeamless && (this._chr == -3 || this._chr == -2)) {
            return this.read();
        }
        return this._chr;
    }

    public final void include(Reader reader) {
        this._readerStack.push(new ReaderStackElement(this._reader, this._line, this._col));
        this._reader = reader;
        this._isInclusionStart = true;
    }

    public final void include(String string) throws FileNotFoundException, CircularInclusionException {
        if (this._dejaVu.contains(string)) {
            throw new CircularInclusionException(string);
        }
        this._readerStack.push(new ReaderStackElement(this._reader, this._file, this._line, this._col));
        this._reader = new BufferedReader(new FileReader(string));
        this._file = string;
        this._dejaVu.add(string);
        this._isInclusionStart = true;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = 0; n < cArray.length && n3 < n2; ++n, ++n3) {
            int n4 = this.read();
            switch (n4) {
                case -1: {
                    return n4;
                }
            }
            cArray[n] = (char)n4;
        }
        return n3;
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public final long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Cannot skip negative number of chars: " + l);
        }
        int n = 0;
        block4: while ((long)n < l) {
            switch (this.read()) {
                case -1: {
                    return n;
                }
                case -3: 
                case -2: {
                    continue block4;
                }
            }
            ++n;
        }
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        return this._reader.ready();
    }

    @Override
    public boolean markSupported() {
        return this._reader.markSupported();
    }

    @Override
    public void mark(int n) throws IOException {
        this._reader.mark(n);
    }

    @Override
    public void reset() throws IOException {
        this._reader.reset();
    }

    public final String toString() {
        return "<File: " + this.getFile() + ", Line: " + this._line + ", Column: " + this._col + ", Char: '" + Misc.pform(this._chr) + "'>";
    }

    private static class ReaderStackElement {
        private Reader _reader;
        private String _file;
        private int _line;
        private int _col;

        ReaderStackElement(Reader reader, int n, int n2) {
            this._reader = reader;
            this._line = n;
            this._col = n2;
        }

        ReaderStackElement(Reader reader, String string, int n, int n2) {
            this._reader = reader;
            this._file = string;
            this._line = n;
            this._col = n2;
        }

        final Reader reader() {
            return this._reader;
        }

        final String file() {
            return this._file;
        }

        final int line() {
            return this._line;
        }

        final int col() {
            return this._col;
        }
    }
}

