/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.io;

import hlt.language.tools.Misc;
import java.io.IOException;
import java.io.Reader;

public class LAReader
extends Reader {
    private Reader reader;
    private int[] buffer;
    private int BUFFER_SIZE = 20;
    private int start = 0;
    private int end = 0;
    private boolean eofHasBeenRead = false;

    private final void fill() throws IOException {
        this.fill_from(0);
    }

    private final void fill_from(int n) throws IOException {
        if (this.eofHasBeenRead) {
            return;
        }
        this.end = n;
        for (int i = n; i < this.BUFFER_SIZE; ++i) {
            this.buffer[i] = this.reader.read();
            ++this.end;
            if (this.buffer[i] != -1) continue;
            this.eofHasBeenRead = true;
            break;
        }
        this.start = 0;
    }

    private final void refill() throws IOException {
        if (this.eofHasBeenRead) {
            return;
        }
        for (int i = 0; i < this.end - this.start; ++i) {
            this.buffer[i] = this.buffer[this.start + i];
        }
        this.fill_from(this.end - this.start);
    }

    public LAReader(Reader reader) {
        this.reader = reader;
        this.buffer = new int[this.BUFFER_SIZE];
    }

    public LAReader(Reader reader, int n) {
        this.reader = reader;
        this.BUFFER_SIZE = n;
        this.buffer = new int[this.BUFFER_SIZE];
    }

    @Override
    public final int read() throws IOException {
        if (this.start == this.end) {
            this.fill();
        }
        if (this.buffer[this.start] != -1) {
            return this.buffer[this.start++];
        }
        return -1;
    }

    public final String lookahead(int n) throws IOException {
        if (n <= 0) {
            return "";
        }
        if (n > this.BUFFER_SIZE) {
            this.resizeBuffer(n);
        } else if (n > this.end - this.start) {
            this.refill();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = this.start; i < this.start + n && i != this.end && this.buffer[i] != -1; ++i) {
            stringBuilder.append((char)this.buffer[i]);
        }
        return stringBuilder.toString();
    }

    public final String lookahead() throws IOException {
        return this.lookahead(this.BUFFER_SIZE);
    }

    public void resizeBuffer(int n) throws IOException {
        if (n < this.end - this.start || this.eofHasBeenRead) {
            return;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < this.end - this.start; ++i) {
            nArray[i] = this.buffer[this.start + i];
        }
        this.buffer = nArray;
        this.BUFFER_SIZE = n;
        this.fill_from(this.end - this.start - 1);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BUFFER_SIZE = ").append(this.BUFFER_SIZE);
        stringBuilder.append("\nEOF read? = ").append(this.eofHasBeenRead);
        stringBuilder.append("\nstart = ").append(this.start);
        stringBuilder.append("\nend = ").append(this.end);
        for (int i = this.start; i < this.end; ++i) {
            stringBuilder.append("\nbuffer[").append(i).append("] = ");
            stringBuilder.append("'").append(Misc.pform(this.buffer[i])).append("'");
            if (this.buffer[i] == -1) break;
        }
        return stringBuilder.toString();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = 0; n < cArray.length && n3 < n2; ++n, ++n3) {
            int n4 = this.read();
            switch (n4) {
                case -1: {
                    return n4;
                }
            }
            cArray[n] = (char)n4;
        }
        return n3;
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Cannot skip negative number of chars: " + l);
        }
        int n = 0;
        while ((long)n < l) {
            if (this.read() < 0) {
                return n;
            }
            ++n;
        }
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        return this.start < this.end || this.reader.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) throws IOException {
    }

    @Override
    public void reset() throws IOException {
    }
}

