/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.io;

import hlt.language.io.AbstractStreamTokenizer;
import hlt.language.io.LAReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class LAStreamTokenizer
extends AbstractStreamTokenizer {
    private LAReader input;
    private boolean skipLineComments;
    private boolean skipBracketComments;
    private String COMMENT_START;
    private String COMMENT_END;
    private String COMMENT_LINE;

    public LAStreamTokenizer(Reader reader) {
        this.initializeCharInfo();
        this.reader = reader;
        this.input = new LAReader(reader);
        this.setDefaultSyntax();
    }

    @Override
    public final void enableComments() {
        this.skipLineComments = true;
        this.skipBracketComments = true;
    }

    @Override
    public final void disableComments() {
        this.skipLineComments = false;
        this.skipBracketComments = false;
    }

    @Override
    public final void commentChar(int n) {
        if (0 <= n && n < this.charInfo.length) {
            this.commentLine(String.valueOf((char)n));
            this.skipLineComments = true;
        }
    }

    @Override
    public final void slashSlashComments(boolean bl) {
        if (bl) {
            this.commentLine("//");
        }
        this.skipLineComments = bl;
    }

    @Override
    public final void slashStarComments(boolean bl) {
        if (bl) {
            this.commentBrackets("/*", "*/");
        }
        this.skipBracketComments = bl;
    }

    @Override
    public final int nextToken() throws IOException {
        if (this.pushedBack) {
            this.pushedBack = false;
            if (!(this.ttype == 10 && !this.eolIsSignificant || this.isWhitespaceChar(this.ttype) && !this.spaceIsSignificant)) {
                return this.ttype;
            }
        }
        this.sval = null;
        this.nval = Double.NaN;
        this.isInteger = false;
        this.nextChar();
        this.setStartLocation();
        switch (this.currentChar) {
            case -1: {
                this.setEndLocation();
                this.ttype = -1;
                return -1;
            }
            case -6: {
                return this.nextToken();
            }
        }
        if (this.skipLineComments && this.lookahead(this.COMMENT_LINE.length()).equals(this.COMMENT_LINE)) {
            this.skipLine();
            return this.nextToken();
        }
        if (this.skipBracketComments && this.lookahead(this.COMMENT_START.length()).equals(this.COMMENT_START)) {
            this.skipComment();
            return this.nextToken();
        }
        switch (this.currentType()) {
            case 6: {
                this.setEndLocation();
                this.ttype = -7;
                return -7;
            }
            case 1: {
                if (this.currentChar == 10 && this.eolIsSignificant) {
                    this.setEndLocation();
                    this.ttype = 10;
                    return 10;
                }
                if (this.spaceIsSignificant) {
                    this.setEndLocation();
                    this.ttype = this.currentChar;
                    return this.ttype;
                }
                return this.nextToken();
            }
            case 0: {
                this.setEndLocation();
                this.ttype = this.currentChar;
                return this.ttype;
            }
            case 4: {
                this.readNumber();
                this.setEndLocation();
                this.ttype = -5;
                return -5;
            }
            case 2: {
                this.leftQuote = this.currentChar;
                this.rightQuote = this.charInfo[this.leftQuote].right;
                this.readQuotedWord();
                this.setEndLocation();
                this.ttype = this.leftQuote;
                return this.ttype;
            }
            case 3: {
                this.readWord();
                this.setEndLocation();
                this.ttype = -4;
                return -4;
            }
        }
        return this.ttype;
    }

    public final void setEscapeChar(int n) {
        ESCAPE_CHAR = n;
    }

    public final void commentBrackets(String string, String string2) {
        this.COMMENT_START = string;
        this.COMMENT_END = string2;
        this.skipBracketComments = true;
    }

    public final void commentLine(String string) {
        this.COMMENT_LINE = string;
        this.skipLineComments = true;
    }

    public void setTypePrecedence(int n, int n2, int n3, int n4) throws Exception {
        if ((n | n2 | n3 | n4) != 3 || n + n2 + n3 + n4 != 6) {
            throw new Exception("Illegal type precedence");
        }
        LAStreamTokenizer.typePrecedence[0] = n;
        LAStreamTokenizer.typePrecedence[1] = n2;
        LAStreamTokenizer.typePrecedence[2] = n3;
        LAStreamTokenizer.typePrecedence[3] = n4;
    }

    public final String lookahead(int n) throws IOException {
        return String.valueOf((char)this.currentChar) + String.valueOf((char)this.followingChar) + this.input.lookahead(n - 2);
    }

    private final void skipComment() throws IOException {
        do {
            this.nextChar();
            if (this.currentChar != -1) continue;
            throw new EOFException("Missing end of comment (" + this.COMMENT_END + "): " + this.location());
        } while (!this.lookahead(this.COMMENT_END.length()).equals(this.COMMENT_END));
        for (int i = 1; i < this.COMMENT_END.length(); ++i) {
            this.nextChar();
        }
    }

    @Override
    final void readFollowingChar() throws IOException {
        if (this.followingChar != -1) {
            this.followingChar = this.input.read();
            ++this.followingCharCol;
        }
        if (this.followingChar == 13) {
            this.readFollowingChar();
        }
    }

    @Override
    final void readDecimal() throws IOException {
        boolean bl = false;
        if (this.currentChar != 46) {
            bl = true;
            this.readInteger();
        }
        if (this.parsingDigitsOnly) {
            return;
        }
        if (this.followingChar == 46 && this.input.lookahead(1).charAt(0) != '.') {
            this.nextChar();
        }
        if (this.currentChar == 46) {
            this.isInteger = false;
            this.readMantissa(bl);
        }
        if (this.followingChar == 101 || this.followingChar == 69) {
            this.isInteger = false;
            this.readExponent();
        }
        switch (this.followingChar) {
            case 76: 
            case 108: {
                if (this.isInteger) {
                    this.nextChar();
                }
                return;
            }
            case 68: 
            case 70: 
            case 100: 
            case 102: {
                if (this.isInteger) break;
                this.nextChar();
            }
        }
    }
}

