/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.io;

import hlt.language.io.AbstractStreamTokenizer;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class StreamTokenizer
extends AbstractStreamTokenizer {
    private PushbackReader input;
    private boolean slashSlashComments;
    private boolean slashStarComments;

    public StreamTokenizer(Reader reader) {
        this.initializeCharInfo();
        this.reader = reader;
        this.input = new PushbackReader(reader);
        this.setDefaultSyntax();
    }

    @Override
    public final void enableComments() {
        this.slashStarComments(true);
        this.slashSlashComments(true);
    }

    @Override
    public final void disableComments() {
        this.slashStarComments(false);
        this.slashSlashComments(false);
    }

    @Override
    public final void commentChar(int n) {
        if (0 <= n && n < this.charInfo.length) {
            this.charInfo[n].type = (byte)32;
        }
    }

    @Override
    public final void slashSlashComments(boolean bl) {
        this.slashSlashComments = bl;
    }

    @Override
    public final void slashStarComments(boolean bl) {
        this.slashStarComments = bl;
    }

    @Override
    public final int nextToken() throws IOException {
        if (this.pushedBack) {
            this.pushedBack = false;
            if (!(this.ttype == 10 && !this.eolIsSignificant || this.isWhitespaceChar(this.ttype) && !this.spaceIsSignificant)) {
                return this.ttype;
            }
        }
        this.sval = null;
        this.nval = Double.NaN;
        this.isInteger = false;
        this.nextChar();
        this.setStartLocation();
        switch (this.currentChar) {
            case -1: {
                this.setEndLocation();
                this.ttype = -1;
                return -1;
            }
            case -6: {
                this.setEndLocation();
                return this.nextToken();
            }
            case 47: {
                if (this.followingChar == 47 && this.slashSlashComments) {
                    this.skipLine();
                    return this.nextToken();
                }
                if (this.followingChar != 42 || !this.slashStarComments) break;
                this.skipComment();
                return this.nextToken();
            }
        }
        switch (this.currentType()) {
            case 6: {
                this.setEndLocation();
                this.ttype = -7;
                return -7;
            }
            case 5: {
                this.skipLine();
                return this.nextToken();
            }
            case 1: {
                if (this.currentChar == 10 && this.eolIsSignificant) {
                    this.setEndLocation();
                    this.ttype = 10;
                    return 10;
                }
                if (this.spaceIsSignificant) {
                    this.setEndLocation();
                    this.ttype = this.currentChar;
                    return this.ttype;
                }
                return this.nextToken();
            }
            case 0: {
                this.setEndLocation();
                this.ttype = this.currentChar;
                return this.ttype;
            }
            case 4: {
                this.readNumber();
                this.setEndLocation();
                this.ttype = -5;
                return -5;
            }
            case 2: {
                this.leftQuote = this.currentChar;
                this.rightQuote = this.charInfo[this.leftQuote].right;
                this.readQuotedWord();
                this.setEndLocation();
                this.ttype = this.leftQuote;
                return this.ttype;
            }
            case 3: {
                this.readWord();
                this.setEndLocation();
                this.ttype = -4;
                return -4;
            }
        }
        return this.ttype;
    }

    public final boolean isCommentChar(int n) {
        return 0 <= n && n < this.charInfo.length && this.hasType(n, (byte)32);
    }

    public final void setEscapeChar(int n) {
        ESCAPE_CHAR = n;
    }

    public void setTypePrecedence(int n, int n2, int n3, int n4, int n5) throws Exception {
        if ((n | n2 | n3 | n4 | n5) != 7 || n + n2 + n3 + n4 + n5 != 11) {
            throw new Exception("Illegal type precedence");
        }
        StreamTokenizer.typePrecedence[0] = n;
        StreamTokenizer.typePrecedence[1] = n2;
        StreamTokenizer.typePrecedence[2] = n3;
        StreamTokenizer.typePrecedence[3] = n4;
        StreamTokenizer.typePrecedence[4] = n5;
    }

    private final void skipComment() throws IOException {
        do {
            this.nextChar();
            if (this.currentChar != -1) continue;
            throw new IOException("Premature end of file while reading a comment: (line,col) = " + this.currentCharLocation());
        } while (this.currentChar != 42 || this.followingChar != 47);
        this.nextChar();
    }

    @Override
    final void readFollowingChar() throws IOException {
        if (this.followingChar != -1) {
            this.followingChar = this.input.read();
            ++this.followingCharCol;
        }
        if (this.followingChar == 13) {
            this.readFollowingChar();
        }
    }

    @Override
    final void readDecimal() throws IOException {
        boolean bl = false;
        if (this.currentChar != 46) {
            bl = true;
            this.readInteger();
        }
        if (this.parsingDigitsOnly) {
            return;
        }
        if (this.followingChar == 46) {
            int n = this.input.read();
            this.input.unread(n);
            if (n != 46) {
                this.nextChar();
            }
        }
        if (this.currentChar == 46) {
            this.isInteger = false;
            this.readMantissa(bl);
        }
        if (this.followingChar == 101 || this.followingChar == 69) {
            this.isInteger = false;
            this.readExponent();
        }
        switch (this.followingChar) {
            case 76: 
            case 108: {
                if (this.isInteger) {
                    this.nextChar();
                }
                return;
            }
            case 68: 
            case 70: 
            case 100: 
            case 102: {
                if (this.isInteger) {
                    this.isInteger = false;
                }
                this.nextChar();
            }
        }
    }
}

