/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.ErrorManager;
import hlt.language.util.Error;

public class DefaultErrorManager
extends ErrorManager {
    @Override
    public void reportError(Error error) {
        this.countError();
        if (this.isReportingErrors()) {
            this.errorStream().println(error);
        }
    }

    @Override
    public void tallyErrors() {
        if (this.isReportingErrors()) {
            if (this.errorCount() > 0) {
                this.errorStream().println("*** Number of errors: " + this.errorCount());
            } else {
                this.errorStream().println("*** There are no errors");
            }
        }
    }

    @Override
    public void reportWarning(Error error) {
        this.countWarning();
        if (this.isReportingErrors()) {
            this.errorStream().println(error);
        }
    }

    @Override
    public void tallyWarnings() {
        if (this.isReportingErrors() && this.warningCount() > 0) {
            this.errorStream().println("*** Number of warnings: " + this.warningCount());
        }
    }

    @Override
    public void reportDeprecated(Error error) {
        this.countDeprecated();
        if (this.isReportingErrors()) {
            this.errorStream().println(error);
        }
    }

    @Override
    public void tallyDeprecateds() {
        if (this.isReportingErrors() && this.deprecatedCount() > 0) {
            this.errorStream().println("*** Number of deprecateds: " + this.deprecatedCount());
        }
    }
}

