/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.io.FileTools;
import hlt.language.syntax.Grammar;
import hlt.language.syntax.GrammarSymbol;
import hlt.language.syntax.NonTerminal;
import hlt.language.syntax.Operator;
import hlt.language.syntax.Options;
import hlt.language.syntax.Rule;
import hlt.language.syntax.Terminal;
import hlt.language.syntax.XmlAttributeInfo;
import hlt.language.syntax.XmlInfo;
import hlt.language.syntax.XmlWrapper;
import hlt.language.tools.Misc;
import hlt.language.util.AbstractListIndexed;
import hlt.language.util.ArrayList;
import hlt.language.util.Comparable;
import hlt.language.util.SetOf;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class Documentor {
    Date today = new Date();
    String configFile = "Syntax.Documentor.Configuration";
    boolean needToCopyImages = Options.copyResourceFiles();
    String RESOURCES_PATH = Options.getResourcesPath();
    Properties configuration = new Properties();
    static final Grammar grammar = Grammar.currentGrammar;
    static boolean hasError = false;
    boolean hasOperators;
    boolean hasXmlSerialization;
    boolean hasRoots;
    File docdir;
    String DOCDIR;
    String RAFILE;
    String UAFILE;
    String DAFILE;
    String LGFILE;
    String RARROW;
    String UARROW;
    String DARROW;
    String LOGOIM;
    String HLTLNK;
    ArrayList terminalIndexes;
    ArrayList nonterminalIndexes;
    BufferedWriter out;
    String file;
    String bqstyle;
    String GRAMMAR;
    String MAIN_BODY;
    String TOC_BODY;
    String INDEX_BODY;
    String LINK_STYLE;
    String LOAD_SCRIPT;
    static HashMap knownTags = new HashMap();

    String imagesPath() {
        return this.RESOURCES_PATH + "/images";
    }

    final void configure() {
        File file = new File(this.RESOURCES_PATH + "/" + this.configFile);
        if (file.exists()) {
            try {
                this.configuration.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                System.err.println("*** Can't load Jacc Documentor config file " + this.configFile + " (" + iOException + ")");
            }
        } else {
            System.err.println("*** Jacc Documentor config file " + this.configFile + " not found (using default: " + this.RESOURCES_PATH + "/" + this.configFile + ")");
        }
        this.configureValues();
    }

    final void configureValues() {
        this.RESOURCES_PATH = this.configure("RESOURCES_PATH");
    }

    final String configure(String string) {
        return this.configuration.getProperty(string);
    }

    final String configure(String string, String string2) {
        String string3 = this.configuration.getProperty(string);
        return string3 == null ? string2 : (string3.equals("*") ? null : string3);
    }

    final void copyImageFiles() throws IOException {
        String string = this.DOCDIR + "/images";
        String string2 = this.imagesPath() + "/arrows/misc";
        String string3 = this.imagesPath() + "/hlt";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(string + "/hlt-logo.gif")).exists()) {
            FileTools.copy(new File(string3 + "/hlt-logo.gif"), file);
        }
        if (!(file = new File(string + "/rarrow.gif")).exists()) {
            FileTools.copy(new File(string2 + "/rarrow.gif"), file);
        }
        if (!(file = new File(string + "/darrow.gif")).exists()) {
            FileTools.copy(new File(string2 + "/darrow.gif"), file);
        }
        if (!(file = new File(string + "/uarrow.gif")).exists()) {
            FileTools.copy(new File(string2 + "/uarrow.gif"), file);
        }
    }

    Documentor() {
        this.hasOperators = !Documentor.grammar.operators.isEmpty();
        this.hasXmlSerialization = Documentor.grammar.hasXmlSerialization;
        this.hasRoots = !Documentor.grammar.roots.isEmpty() && Documentor.grammar.roots.size() > 1;
        this.DOCDIR = Options.getGrammarPrefix() + "Doc";
        this.RAFILE = "images/arrows/misc/rarrow.gif";
        this.UAFILE = "images/arrows/misc/uarrow.gif";
        this.DAFILE = "images/arrows/misc/darrow.gif";
        this.LGFILE = "images/hlt/hlt-logo.gif";
        this.RARROW = "<IMG SRC=\"" + this.RAFILE + "\">";
        this.UARROW = "<IMG ALIGN=\"MIDDLE\" SRC=\"" + this.UAFILE + "\">";
        this.DARROW = "<IMG ALIGN=\"MIDDLE\" SRC=\"" + this.DAFILE + "\">";
        this.LOGOIM = "<IMG ALIGN=\"MIDDLE\" SRC=\"" + this.LGFILE + "\" WIDTH=\"90\" HEIGHT=\"90\">";
        this.HLTLNK = "<A HREF=\"http://www.hak-language-technologies.com/\" TARGET=\"MAIN\">" + this.LOGOIM + "</A>";
        this.bqstyle = "margin-top: -10pt; margin-bottom: -7pt; margin-left: 1.3em; margin-right: 0pt";
        this.GRAMMAR = Options.getGrammarPrefix() + "." + Options.getGrammarSuffix();
        this.MAIN_BODY = "<BODY CLASS=\"MAIN\">";
        this.TOC_BODY = "<BODY CLASS=\"TOC\">";
        this.INDEX_BODY = "<BODY CLASS=\"INDEX\">";
        this.LINK_STYLE = "<LINK REL=\"STYLESHEET\" TYPE=\"text/css\" HREF=\"style.css\">";
        this.LOAD_SCRIPT = "<SCRIPT LANGUAGE=\"JavaScript\" SRC=\"script.jvs\"></SCRIPT>";
        try {
            Grammar.out.println("*** Creating documentation directory: " + this.DOCDIR);
            this.docdir = new File(this.DOCDIR);
            this.docdir.mkdir();
            this.configure();
            this.scanRules();
            Grammar.out.println("*** Sorting terminals ... ");
            Misc.sort(Documentor.grammar.terminals);
            this.terminalIndexes = this.indexes(Documentor.grammar.terminals);
            Grammar.out.println("*** Sorting nonterminals ... ");
            Misc.sort(Documentor.grammar.nonterminals);
            this.nonterminalIndexes = this.indexes(Documentor.grammar.nonterminals);
            if (this.hasOperators) {
                Grammar.out.println("*** Sorting operators ... ");
                Misc.sort(Documentor.grammar.operators);
            }
            this.generateHTMLFiles();
            if (this.needToCopyImages) {
                System.out.println("*** Copying resources files to: " + this.DOCDIR);
                this.copyImageFiles();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.err.println("\n*** Couldn't create documentation files");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    final boolean isHidden(GrammarSymbol grammarSymbol) {
        if (grammarSymbol instanceof Terminal) {
            Terminal terminal = (Terminal)grammarSymbol;
            return terminal.isError() && !hasError || !terminal.isError() && terminal.isSpecial();
        }
        return grammarSymbol.isSpecial();
    }

    final boolean isError(GrammarSymbol grammarSymbol) {
        return grammarSymbol instanceof Terminal ? ((Terminal)grammarSymbol).isError() : false;
    }

    final ArrayList indexes(ArrayList arrayList) {
        GrammarSymbol grammarSymbol;
        int n;
        ArrayList arrayList2 = new ArrayList(26);
        for (n = 0; n < arrayList.size() && (this.isHidden(grammarSymbol = (GrammarSymbol)arrayList.get(n)) || !Character.isLetter(grammarSymbol.letterName().charAt(0))); ++n) {
        }
        if (n < arrayList.size()) {
            grammarSymbol = (GrammarSymbol)arrayList.get(n);
            char c = grammarSymbol.initChar();
            arrayList2.add(grammarSymbol);
            ++n;
            while (n < arrayList.size()) {
                char c2;
                grammarSymbol = (GrammarSymbol)arrayList.get(n);
                if (!this.isHidden(grammarSymbol) && (c2 = grammarSymbol.initChar()) != c) {
                    c = c2;
                    arrayList2.add(grammarSymbol);
                }
                ++n;
            }
        }
        return arrayList2;
    }

    final void scanRules() throws IOException {
        for (Rule rule : Documentor.grammar.rules) {
            for (int i = 1; i < rule.sequence.length; ++i) {
                rule.sequence[i].link(rule);
            }
            if (rule.doc == null && rule.xmlInfo() == null) continue;
            this.generateRuleFile(rule);
        }
    }

    final void generateHTMLFiles() throws IOException {
        Grammar.out.println("*** Generating index files ... ");
        this.generateScriptFile();
        this.generateStyleFile();
        this.generateTOCFile();
        this.generateMainFile();
        this.generateMainDocFile();
        this.generateNTFile();
        this.generateNTIndexFile();
        this.generateNTTableFile();
        this.generateTTFile();
        this.generateTTIndexFile();
        this.generateTTTableFile();
        if (this.hasRoots) {
            this.generateRootsFile();
        }
        if (this.hasOperators) {
            this.generateOPFile();
        }
        if (this.hasXmlSerialization) {
            this.generateSerializationTable();
        }
        Grammar.out.println("*** Generating terminal symbol files ... ");
        this.generateTTFiles();
        Grammar.out.println("*** Generating nonterminal symbol files ... ");
        this.generateNTFiles();
        this.generateYaccFormFile();
        System.out.println("*** See index.html in " + this.docdir.getAbsolutePath());
    }

    final void generateScriptFile() throws IOException {
        this.setOutput("script.jvs");
        String string = "width=800,height=800,resizable,scrollbars=no,status=no,directories=no,hotkeys=no,menubar=no";
        this.wl("function showRuleDoc (ref)");
        this.wl("  {");
        this.wl("    window.open(ref+\".html\",ref,\"" + string + "\").focus();");
        this.wl("  }");
        this.out.close();
    }

    final void generateStyleFile() throws IOException {
        this.setOutput("style.css");
        this.wl(".KBD       { color: #AA5577; font-family: courier }");
        this.wl(".CODE      { color: #448899; font-family: courier }");
        this.wl(".TINY      { color: #AA0088; font-family: courier; font-size: x-small }");
        this.wl(".CENTER    { text-align: center }");
        this.wl(".OUTDENT   { margin-left: -2em }");
        this.wl("BODY       { margin-left: 2em; margin-right: 2em }");
        this.wl("BODY.MAIN  { background-color: #CCCCFF }");
        this.wl("BODY.TOC   { background-color: #FFFFCC }");
        this.wl("BODY.INDEX { margin-left: 1em; margin-right: 0em;");
        this.wl("             background-color: #CCFFFF }");
        this.wl("A:hover    { color: orange }");
        this.wl("A.SYMBOL   { color: #11AA55; text-decoration: none }");
        this.wl("A.INDEX    { text-decoration: none }");
        this.wl("DIV        { background: white; width: 100%; padding: 1em;");
        this.wl("             border: black }");
        this.out.close();
    }

    final void preamble(String string, boolean bl) throws IOException {
        this.wl("<HTML>");
        this.wl("<HEAD>");
        this.wl(this.LINK_STYLE);
        if (bl) {
            this.wl(this.LOAD_SCRIPT);
        }
        this.wl("<TITLE>");
        this.wl(string);
        this.wl("</TITLE>");
        this.wl("</HEAD>");
    }

    final void generateTOCFile() throws IOException {
        this.setOutput("toc.html");
        this.preamble("Table of Contents", false);
        this.wl(this.TOC_BODY);
        this.wl("<CENTER>");
        this.wl("<TABLE WIDTH=\"100%\">");
        this.wl("<TR><TD ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">" + this.HLTLNK + "</TD>");
        this.wl("<TD ALIGN=\"CENTER\" VALIGN=\"MIDDLE\"><TABLE WIDTH=\"70%\">");
        this.wl("<TR><TH ALIGN=\"CENTER\">");
        this.wl("<SPAN STYLE=\"FONT-SIZE:LARGER\">Hyperdocumentation for grammar <TT>" + this.GRAMMAR + "</TT></SPAN>");
        this.wl("</TH></TR>");
        this.wl("</TABLE>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" WIDTH=\"75%\"BORDER=3 CELLPADDING=\"5\">");
        this.wl("<TR>");
        this.wl("<TH>");
        this.wl("<A HREF=\"MainDoc.html\" TARGET=\"MAIN\">Main</A>");
        this.wl("</TH>");
        this.wl("<TH>");
        this.wl("<A HREF=\"" + grammar.startSymbol().htmlFileName() + "\" TARGET=\"MAIN\">Start</A>");
        this.wl("</TH>");
        if (this.hasRoots) {
            this.wl("<TH>");
            this.wl("<A HREF=\"Roots.html\" TARGET=\"MAIN\">Roots</A>");
            this.wl("</TH>");
        }
        this.wl("<TH>");
        this.wl("<A HREF=\"NT.html\" TARGET=\"MAIN\">Nonterminals</A>");
        this.wl("</TH>");
        this.wl("<TH>");
        this.wl("<A HREF=\"TT.html\" TARGET=\"MAIN\">Terminals</A>");
        this.wl("</TH>");
        if (this.hasOperators) {
            this.wl("<TH>");
            this.wl("<A HREF=\"OP.html\" TARGET=\"MAIN\">Operators</A>");
            this.wl("</TH>");
        }
        this.wl("<TH>");
        this.wl("<A HREF=\"YaccForm.html\" TARGET=\"MAIN\">Yacc Form</A>");
        this.wl("</TH>");
        if (this.hasXmlSerialization) {
            this.wl("<TH>");
            this.wl("<A HREF=\"XML.html\" TARGET=\"MAIN\">Xml Serialization</A>");
            this.wl("</TH>");
        }
        this.wl("</TR>");
        this.wl("</TABLE>");
        this.wl("</TD></TR>");
        this.wl("</TABLE>");
        this.wl("<SPAN STYLE=\"FONT-SIZE:XX-SMALL\">");
        this.wl("Documentation generated on " + this.today.toString());
        this.wl("</SPAN>");
        this.wl("</CENTER>");
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateMainFile() throws IOException {
        this.setOutput("index.html");
        this.preamble("Hyperdocumentation for " + this.GRAMMAR, false);
        this.wl("<FRAMESET ROWS=\"20%,*\">");
        this.wl("<FRAME NORESIZE SRC=\"toc.html\" NAME=\"TOC\">");
        this.wl("<FRAME SRC=\"MainDoc.html\" NAME=\"MAIN\">");
        this.wl("<NOFRAMES>");
        this.wl(this.MAIN_BODY);
        this.wl("<H1><A HREF=\"MainDoc.html\">Main</A></H1>");
        this.wl("<H1>" + grammar.startSymbol().htmlRef("Start") + "</H1>");
        this.wl("<H1><A HREF=\"NT.html\">Nonterminals</A></H1>");
        this.wl("<H1><A HREF=\"TT.html\">Terminals</A></H1>");
        if (this.hasRoots) {
            this.wl("<H1><A HREF=\"Roots.html\">Roots</A></H1>");
        }
        if (this.hasOperators) {
            this.wl("<H1><A HREF=\"OP.html\">Operators</A></H1>");
        }
        this.wl("<H1><A HREF=\"YaccForm.html\">Main</A></H1>");
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</NOFRAMES>");
        this.wl("</FRAMESET>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateMainDocFile() throws IOException {
        this.setOutput("MainDoc.html");
        this.preamble("Main Documentation for " + this.GRAMMAR, false);
        this.wl(this.MAIN_BODY);
        this.wl("<H1 ALIGN=\"CENTER\">Main Documentation for grammar <SPAN STYLE=\"COLOR:MAROON\">" + grammar.name() + "</SPAN></H1>");
        if (Documentor.grammar.mainDoc != null) {
            this.formatDoc(Documentor.grammar.mainDoc.toString());
        }
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateRootsFile() throws IOException {
        Comparable[] comparableArray = new NonTerminal[Documentor.grammar.roots.size() - 1];
        int n = 0;
        for (NonTerminal nonTerminal : Documentor.grammar.roots.keySet()) {
            if (nonTerminal.isStart()) continue;
            comparableArray[n++] = nonTerminal;
        }
        Misc.sort(comparableArray);
        String string = comparableArray.length > 1 ? "s" : "";
        this.setOutput("Roots.html");
        this.preamble("Root symbols of grammar " + this.GRAMMAR, false);
        this.wl(this.MAIN_BODY);
        this.wl("<H1 ALIGN=\"CENTER\">Root symbols of grammar <SPAN STYLE=\"COLOR:MAROON\">" + grammar.name() + "</SPAN></H1>");
        this.wl("<HR><P>");
        this.wl("<TABLE WIDTH=\"100%\" BGCOLOR=\"WHITE\" CELLPADDING=\"15\"><TR><TD>");
        this.wl("<SPAN STYLE=\"FONT-SIZE:LARGER\">This grammar allows partial parsing: in addition to");
        this.wl("the start symbol (<A CLASS=\"SYMBOL\"HREF=\"" + grammar.startSymbol().htmlFileName() + "\">" + grammar.startSymbol().label() + "</A>), the following nonterminal symbol" + (String)string + " may be parsed as stand-alone unit" + (String)string + ":</SPAN>");
        this.wl("<P>");
        this.wl("<UL>");
        for (n = 0; n < comparableArray.length; ++n) {
            this.wl("<P><LI><A CLASS=\"SYMBOL\" HREF=\"" + ((GrammarSymbol)comparableArray[n]).htmlFileName() + "\" TARGET=\"MAIN\">" + ((NonTerminal)comparableArray[n]).label() + "</A>");
        }
        this.wl("</UL>");
        this.wl("<P>");
        this.wl("</TD></TR></TABLE>");
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateYaccFormFile() throws IOException {
        Iterator iterator;
        NonTerminal nonTerminal;
        int n;
        Documentor.grammar.RULE_ORDER_MODE = true;
        Misc.sort(Documentor.grammar.nonterminals);
        this.setOutput("YaccForm.html");
        this.preamble("Yacc Form of grammar " + this.GRAMMAR, true);
        this.wl(this.MAIN_BODY);
        this.wl("<H1 ALIGN=\"CENTER\">Yacc Form of grammar <SPAN STYLE=\"COLOR:MAROON\">" + grammar.name() + "</SPAN></H1>");
        this.wl("<CENTER>");
        this.wl("<HR>");
        this.wl("<SPAN STYLE=\"COLOR:#F07070; FONT-SIZE:X-SMALL\">" + this.hltCopyrightNotice() + "</SPAN>");
        this.wl("<P>");
        this.wl("<SPAN STYLE=\"COLOR:#F00770; FONT-SIZE:XX-SMALL\"\">\nThis yacc grammar was generated on " + this.today + " from the annotated Jacc grammar file <SPAN STYLE=\"COLOR:BROWN\"><TT>" + grammar.name() + "</TT></SPAN>.");
        this.wl("<HR><P>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" BORDER=\"5\" CELLPADDING=\"20\">");
        this.wl("<TR><TD>");
        this.wl("<PRE>");
        ArrayList arrayList = Documentor.grammar.isDynamic ? new ArrayList() : null;
        for (n = 0; n < Documentor.grammar.ncount; ++n) {
            nonTerminal = (NonTerminal)Documentor.grammar.nonterminals.get(n);
            if (this.isHidden(nonTerminal)) continue;
            if (nonTerminal.isOperator) {
                arrayList.add(nonTerminal);
                continue;
            }
            iterator = nonTerminal.rules.iterator();
            this.formatYaccRule((Rule)iterator.next(), nonTerminal, true);
            while (iterator.hasNext()) {
                this.formatYaccRule((Rule)iterator.next(), nonTerminal, false);
            }
            this.wl("\n\t;\n");
        }
        if (arrayList != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                nonTerminal = (NonTerminal)arrayList.get(n);
                iterator = nonTerminal.rules.iterator();
                this.formatYaccRule((Rule)iterator.next(), nonTerminal, true);
                while (iterator.hasNext()) {
                    this.formatYaccRule((Rule)iterator.next(), nonTerminal, false);
                }
                this.wl("\n\t;\n");
            }
        }
        this.wl("</PRE>");
        this.wl("</TD></TR>");
        this.wl("</TABLE>");
        this.wl("</CENTER>");
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void hltCopyrightStamp() throws IOException {
        this.wl("<P>");
        this.wl("<HR>");
        this.wl("<SPAN STYLE=\"COLOR:#F07070; FONT-SIZE:XX-SMALL\">");
        this.wl("<P ALIGN=\"RIGHT\">" + this.hltCopyrightNotice() + "</SPAN>");
    }

    final String hltCopyrightNotice() throws IOException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return "<B>Copyright &copy; " + gregorianCalendar.get(1) + " by <A HREF=\"http://www.hassan-ait-kaci.net/\">Hassan A&iuml;t-Kaci</A>; All Rights Reserved.</B>";
    }

    final String yaccFormRef(GrammarSymbol grammarSymbol) {
        return "<A CLASS=\"SYMBOL\" HREF=\"#" + grammarSymbol.name() + "\">" + grammarSymbol.name() + "</A>";
    }

    final String yaccFormAnchor(NonTerminal nonTerminal) {
        return "<A CLASS=\"SYMBOL\" NAME=\"" + nonTerminal.name() + "\"></A>";
    }

    final String quotify(String string, GrammarSymbol grammarSymbol) {
        if (grammarSymbol instanceof Terminal && !Misc.isUpperCase(grammarSymbol.name())) {
            return "'" + string + "'";
        }
        return string;
    }

    final void formatYaccRule(Rule rule, NonTerminal nonTerminal, boolean bl) throws IOException {
        if (bl) {
            this.w(this.yaccFormAnchor(nonTerminal));
            this.w(nonTerminal.htmlRef());
        }
        this.yaccRuleLink(rule, nonTerminal, bl);
        if (rule != null) {
            if (rule.sequence.length == 1) {
                this.w("<SPAN STYLE=\"COLOR:ORANGE\">/* empty */</SPAN>");
            } else {
                for (int i = 1; i < rule.sequence.length; ++i) {
                    Object object;
                    GrammarSymbol grammarSymbol = rule.sequence[i];
                    Object object2 = object = grammarSymbol instanceof Terminal ? grammarSymbol.htmlRef() : this.yaccFormRef(grammarSymbol);
                    if (this.isError(grammarSymbol)) {
                        object = "<B><SPAN STYLE=\"COLOR:#4444FF\">" + grammarSymbol.name() + "</SPAN></B>";
                    } else {
                        if (this.isHidden(grammarSymbol)) continue;
                        object = this.quotify((String)object, grammarSymbol);
                    }
                    this.w((String)object + " ");
                }
            }
        }
    }

    final void yaccRuleLink(Rule rule, GrammarSymbol grammarSymbol, boolean bl) throws IOException {
        String string = bl ? ":" : "|";
        this.w("\n\t");
        if (rule == null) {
            this.w("<BLINK><SPAN STYLE=\"COLOR:red\">&lt;THIS SYMBOL HAS NO RULES!&gt;</SPAN></BLINK>");
        } else if (rule.doc == null && rule.xmlInfo() == null) {
            this.w(string);
        } else {
            this.w("<A CLASS=\"SYMBOL\" HREF=\"javascript:showRuleDoc('" + rule.refName() + "')\">" + string + "</A>");
        }
        this.w(" ");
    }

    final void generateNTFile() throws IOException {
        this.setOutput("NT.html");
        this.preamble("Non Terminals", false);
        this.wl("<FRAMESET COLS=\"12%,*\">");
        this.wl("<FRAME NORESIZE SRC=\"NT_index.html\" NAME=\"INDEX\">");
        this.wl("<FRAME SRC=\"NT_table.html\" NAME=\"TABLE\">");
        this.wl("<NOFRAMES>");
        this.wl(this.MAIN_BODY);
        this.wl("<H1><A HREF=\"NT_index.html\">Index of Nonterminals</A></H1>");
        this.wl("<H1><A HREF=\"NT_table.html\">Table of Nonterminals</A></H1>");
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</NOFRAMES>");
        this.wl("</FRAMESET>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateNTIndexFile() throws IOException {
        this.setOutput("NT_index.html");
        this.preamble(this.file, false);
        this.wl(this.INDEX_BODY);
        this.wl("<H1>Index</H1>");
        this.wl("<CENTER>");
        this.wl("<TABLE>");
        this.wl("<TR><TH ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">");
        this.wl("<A CLASS=\"INDEX\" HREF=\"NT_table.html#TOP\" TARGET=\"TABLE\">" + this.UARROW + "</A>");
        this.wl("</TH></TR>");
        for (int i = 0; i < this.nonterminalIndexes.size(); ++i) {
            NonTerminal nonTerminal = (NonTerminal)this.nonterminalIndexes.get(i);
            String string = String.valueOf(nonTerminal.initChar());
            this.wl("<TR><TH ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">");
            this.wl("<A CLASS=\"INDEX\" HREF=\"NT_table.html#" + string + "\" TARGET=\"TABLE\"><TT>" + string + "</TT></A>");
            this.wl("</TH></TR>");
        }
        this.wl("<TR><TH ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">");
        this.wl("<A CLASS=\"INDEX\" HREF=\"NT_table.html#BOTTOM\" TARGET=\"TABLE\">" + this.DARROW + "</A>");
        this.wl("</TH></TR>");
        this.wl("</TABLE>");
        this.wl("</CENTER>");
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateNTTableFile() throws IOException {
        this.setOutput("NT_table.html");
        this.preamble(this.file, false);
        this.wl(this.MAIN_BODY);
        this.wl("<A NAME=\"TOP\"></A><H1>Nonterminals</H1>");
        this.wl("<CENTER>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" BORDER CELLPADDING=4>");
        int n = 0;
        for (NonTerminal nonTerminal : Documentor.grammar.nonterminals) {
            if (this.isHidden(nonTerminal)) continue;
            Object object = nonTerminal.htmlRef();
            this.wl("<TR>");
            if (n < this.nonterminalIndexes.size() && nonTerminal == this.nonterminalIndexes.get(n)) {
                this.wl("<TD></TD></TR><TR>");
                object = "<A NAME=\"" + String.valueOf(nonTerminal.initChar()) + "\">" + (String)object + "</A>";
                ++n;
            }
            this.wl("<TD>" + (String)object + "</TD>");
            this.wl("</TR>");
        }
        this.wl("</TABLE>");
        this.wl("</CENTER>");
        this.wl("<A NAME=\"BOTTOM\">&nbsp;</A>");
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateTTFile() throws IOException {
        this.setOutput("TT.html");
        this.preamble("Terminals", false);
        this.wl("<FRAMESET COLS=\"12%,*\">");
        this.wl("<FRAME NORESIZE SRC=\"TT_index.html\" NAME=\"INDEX\">");
        this.wl("<FRAME SRC=\"TT_table.html\" NAME=\"TABLE\">");
        this.wl("<NOFRAMES>");
        this.wl(this.MAIN_BODY);
        this.wl("<H1><A HREF=\"TT_index.html\">Index of Terminals</A></H1>");
        this.wl("<H1><A HREF=\"TT_table.html\">Table of Terminals</A></H1>");
        this.wl("</BODY>");
        this.wl("</NOFRAMES>");
        this.wl("</FRAMESET>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateTTIndexFile() throws IOException {
        this.setOutput("TT_index.html");
        this.preamble(this.file, false);
        this.wl(this.INDEX_BODY);
        this.wl("<H1>Index</H1>");
        this.wl("<CENTER>");
        this.wl("<TABLE>");
        this.wl("<TR><TH ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">");
        this.wl("<A CLASS=\"INDEX\" HREF=\"TT_table.html#TOP\" TARGET=\"TABLE\">" + this.UARROW + "</A>");
        this.wl("</TH></TR>");
        for (int i = 0; i < this.terminalIndexes.size(); ++i) {
            Terminal terminal = (Terminal)this.terminalIndexes.get(i);
            String string = String.valueOf(terminal.initChar());
            this.wl("<TR><TH ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">");
            this.wl("<A CLASS=\"INDEX\" HREF=\"TT_table.html#" + string + "\" TARGET=\"TABLE\"><TT>" + string + "</TT></A>");
            this.wl("</TH></TR>");
        }
        this.wl("<TR><TH ALIGN=\"CENTER\" VALIGN=\"MIDDLE\">");
        this.wl("<A CLASS=\"INDEX\" HREF=\"TT_table.html#BOTTOM\" TARGET=\"TABLE\">" + this.DARROW + "</A>");
        this.wl("</TH></TR>");
        this.wl("</TABLE>");
        this.wl("</CENTER>");
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateTTTableFile() throws IOException {
        this.setOutput("TT_table.html");
        this.preamble(this.file, false);
        this.wl(this.MAIN_BODY);
        this.wl("<A NAME=\"TOP\"></A><H1>Terminals</H1>");
        this.wl("<CENTER>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" BORDER CELLPADDING=4>");
        this.wl("<TR>");
        this.wl("<TH>Symbol</TH>");
        this.wl("<TH>Associativity</TH>");
        this.wl("<TH>Looseness</TH>");
        this.wl("<TH>Precedence</TH>");
        this.wl("</TR>");
        int n = 0;
        for (Terminal terminal : Documentor.grammar.terminals) {
            if (this.isHidden(terminal)) continue;
            Object object = terminal.htmlRef();
            this.wl("<TR>");
            if (n < this.terminalIndexes.size() && terminal == this.terminalIndexes.get(n)) {
                this.wl("<TD></TD></TR><TR>");
                object = "<A NAME=\"" + String.valueOf(terminal.initChar()) + "\">" + (String)object + "</A>";
                ++n;
            }
            this.wl("<TD ALIGN=\"CENTER\">" + (String)object + "</TD>");
            this.wl("<TD ALIGN=\"CENTER\">" + Grammar.associativity(terminal) + "</TD>");
            this.wl("<TD ALIGN=\"CENTER\">" + Grammar.prologPrecedence(terminal.precedence) + "</TD>");
            this.wl("<TD ALIGN=\"CENTER\">" + terminal.precedence + "</TD>");
            this.wl("</TR>");
        }
        this.wl("</TABLE>");
        this.wl("</CENTER>");
        this.wl("<A NAME=\"BOTTOM\">&nbsp;</A>");
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateOPFile() throws IOException {
        this.setOutput("OP.html");
        this.preamble(this.file, false);
        this.wl(this.MAIN_BODY);
        this.wl("<H1>Operators</H1>");
        this.wl("<CENTER>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" BORDER CELLPADDING=4>");
        this.wl("<TR>");
        this.wl("<TH>Operator</TH>");
        this.wl("<TH>Category</TH>");
        this.wl("<TH>Specifier</TH>");
        this.wl("<TH>Looseness</TH>");
        this.wl("<TH>Precedence</TH>");
        this.wl("</TR>");
        for (Operator operator : Documentor.grammar.operators) {
            this.wl("<TR>");
            this.wl("<TD ALIGN=\"CENTER\"><TT>" + operator.name + "</TT></TD>");
            this.wl("<TD>" + operator.category.htmlRef() + "</TD>");
            this.wl("<TD ALIGN=\"CENTER\">" + operator.specifier() + "</TD>");
            this.wl("<TD ALIGN=\"CENTER\">" + Grammar.prologPrecedence(operator.precedence) + "</TD>");
            this.wl("<TD ALIGN=\"CENTER\">" + operator.precedence + "</TD>");
            this.wl("</TR>");
        }
        this.wl("</TABLE>");
        this.wl("</CENTER>");
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void generateSerializationTable() throws IOException {
        XmlDescriptor xmlDescriptor;
        this.setOutput("XML.html");
        this.preamble(this.file, false);
        this.wl(this.MAIN_BODY);
        this.wl("<H1 ALIGN=\"CENTER\">Summary of XML Serialization Patterns for Grammar <SPAN STYLE=\"COLOR:MAROON\">" + grammar.name() + "</SPAN></H1>");
        this.wl("<CENTER>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" CELLPADDING=10>");
        this.wl("<TR>");
        this.wl("<TH ALIGN=\"LEFT\">Terminal or Rule:</TH>");
        this.wl("<TH ALIGN=\"LEFT\">XML Serialization Pattern:</TH>");
        this.wl("</TR>");
        for (AbstractListIndexed abstractListIndexed : Documentor.grammar.terminals) {
            if (!((Terminal)abstractListIndexed).hasXmlInfo()) continue;
            this.wl("<TR VALIGN=\"TOP\"><TD>");
            this.wl("<BLOCKQUOTE><TABLE BORDER BGCOLOR=\"#EEEEEE\" CELLPADDING=\"20\"><TR><TD>");
            this.wl(((GrammarSymbol)abstractListIndexed).htmlRef());
            this.wl("\n</TD></TR></TABLE></BLOCKQUOTE>");
            this.wl("</TD><TD ALIGN=\"LEFT\">");
            xmlDescriptor = new XmlDescriptor();
            this.generateXmlPatternDescription((Terminal)abstractListIndexed, xmlDescriptor);
            this.generateTerminalLegend(((Terminal)abstractListIndexed).xmlInfo(), xmlDescriptor);
            this.wl("</TD></TR>");
        }
        for (AbstractListIndexed abstractListIndexed : Documentor.grammar.rules) {
            if (!((Rule)abstractListIndexed).hasXmlInfo()) continue;
            this.wl("<TR VALIGN=\"TOP\"><TD>");
            this.wl("<BLOCKQUOTE><TABLE BORDER BGCOLOR=\"#EEEEEE\" CELLPADDING=\"20\"><TR><TD>");
            this.wl(this.ruleHtmlString((Rule)abstractListIndexed));
            this.wl("\n</TD></TR></TABLE></BLOCKQUOTE>");
            this.wl("</TD><TD ALIGN=\"LEFT\">");
            xmlDescriptor = new XmlDescriptor();
            this.generateXmlPatternDescription((Rule)abstractListIndexed, xmlDescriptor);
            this.generateRuleLegend(((Rule)abstractListIndexed).xmlInfo(), xmlDescriptor);
            this.wl("</TD></TR>");
        }
        this.wl("</TABLE>");
        this.wl("</CENTER>");
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    public String ruleHtmlString(Rule rule) {
        StringBuilder stringBuilder = new StringBuilder("<TABLE>");
        stringBuilder.append("<TR VALIGN=\"TOP\">");
        stringBuilder.append("<TD>");
        stringBuilder.append(rule.head().htmlRef()).append("&emsp;").append(this.RARROW);
        stringBuilder.append("</TD>");
        stringBuilder.append("<TD>");
        stringBuilder.append("<TD>");
        stringBuilder.append("<TABLE>");
        for (int i = 1; i < rule.sequence.length; ++i) {
            stringBuilder.append("<TR><TD>");
            stringBuilder.append(rule.body(i).htmlRef());
            stringBuilder.append("</TD></TR>");
        }
        stringBuilder.append("</TABLE>");
        stringBuilder.append("</TD>");
        stringBuilder.append("</TR>");
        return stringBuilder.append("</TABLE>").toString();
    }

    final void generateTTFiles() throws IOException {
        for (Terminal terminal : Documentor.grammar.terminals) {
            if (this.isHidden(terminal)) continue;
            this.setOutput(terminal.htmlFileName());
            this.preamble(this.file, true);
            this.wl(this.MAIN_BODY);
            this.wl("<H1 ALIGN=\"CENTER\">Terminal symbol <SPAN STYLE=\"COLOR:MAROON\">" + this.quotify(terminal.label(), terminal) + "</SPAN></H1>");
            this.wl("<SPAN STYLE=\"FONT-SIZE:LARGER\">Occurrences of symbol");
            this.wl(this.quotify("<SPAN STYLE=\"COLOR:MAROON; FONT-SIZE:LARGER\">" + terminal.label() + "</SPAN>", terminal));
            this.wl("in grammar rules:</SPAN><P>");
            this.wl("<CENTER>");
            this.wl("<TABLE BGCOLOR=\"WHITE\" BORDER=\"5\" CELLPADDING=\"20\">");
            this.wl("<TR><TD>");
            this.wl("<TABLE BGCOLOR=\"WHITE\" CELLPADDING=\"6\">");
            Iterator iterator = terminal.ruleOccurrences.iterator();
            while (iterator.hasNext()) {
                this.formatRule((Rule)iterator.next(), terminal);
            }
            this.wl("</TABLE>");
            this.wl("</TD></TR>");
            this.wl("</TABLE>");
            this.wl("</CENTER>");
            if (terminal.doc != null) {
                this.formatDoc(terminal.doc.toString());
                this.wl("<P><HR><P>");
            }
            if (terminal.xmlInfo() != null) {
                this.wl("<P>");
                this.generateXmlInfoDescription(terminal);
                this.wl("<P>");
            }
            this.hltCopyrightStamp();
            this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
            this.wl("</BODY>");
            this.wl("</HTML>");
            this.out.close();
        }
    }

    void generateXmlInfoDescription(Terminal terminal) throws IOException {
        XmlInfo xmlInfo = terminal.xmlInfo();
        XmlDescriptor xmlDescriptor = new XmlDescriptor();
        xmlDescriptor.prefix = xmlInfo.hasNsPrefix() ? xmlInfo.colorPrefix() + ":" : "";
        xmlDescriptor.name = xmlInfo.colorName();
        this.wl("<TABLE WIDTH=\"100%\" BGCOLOR=\"WHITE\" CELLPADDING=\"15\"><TR><TD>");
        this.wl("<H4 ALIGN=\"CENTER\">XML Serialization Annotation</H4>");
        this.wl("This terminal has the following XML serialization annotation:");
        this.wl("<PRE>");
        this.wl(xmlInfo.toPrettyHtmlString(2));
        this.wl("</PRE>");
        this.wl("This means that terminal " + this.quotify(terminal.label(), terminal) + " is serialized thus:<P>");
        this.wl("<CENTER>");
        this.generateXmlPatternDescription(terminal, xmlDescriptor);
        this.wl("</CENTER>");
        this.generateTerminalLegend(terminal.xmlInfo(), xmlDescriptor);
        this.wl("</TD></TR></TABLE>");
    }

    void generateTerminalLegend(XmlInfo xmlInfo, XmlDescriptor xmlDescriptor) throws IOException {
        if (xmlInfo.hasLegend()) {
            this.wl("<B>Legend:</B>\n<UL>\n");
            Iterator iterator = xmlInfo.legend().iterator();
            while (iterator.hasNext()) {
                this.wl("<P><LI>" + iterator.next() + "\n");
            }
            this.wl("\n</UL>\n");
        }
    }

    void generateRuleLegend(XmlInfo xmlInfo, XmlDescriptor xmlDescriptor) throws IOException {
        if (xmlInfo.hasLegend()) {
            this.wl("<SPAN STYLE=\"FONT-SIZE:SMALLER\"><B>Legend of attribute values for <TT>" + xmlDescriptor.prefix + xmlDescriptor.name + ":</TT></B></SPAN>\n<UL>\n");
            Iterator iterator = xmlInfo.legend().iterator();
            while (iterator.hasNext()) {
                this.wl("<LI>" + iterator.next() + "\n");
            }
            this.wl("\n</UL>\n");
        }
    }

    void generateXmlInfoDescription(Rule rule) throws IOException {
        XmlInfo xmlInfo = rule.xmlInfo();
        XmlDescriptor xmlDescriptor = new XmlDescriptor();
        xmlDescriptor.prefix = xmlInfo.hasNsPrefix() ? xmlInfo.colorPrefix() + ":" : "";
        xmlDescriptor.name = xmlInfo.colorName();
        this.wl("<CENTER>");
        this.wl("<P><HR><P>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" CELLPADDING=\"15\"><TR><TD>");
        this.wl("<H4 ALIGN=\"CENTER\">XML Serialization Annotation</H4>");
        this.wl("This rule has the following XML serialization annotation:");
        this.w("<PRE>");
        this.wl(xmlInfo.toPrettyHtmlString(2));
        this.wl("</PRE>");
        this.wl("This means that a " + rule.sequence[0].htmlRef() + " derived through this rule will be serialized thus:");
        this.wl("<P><CENTER>");
        this.generateXmlPatternDescription(rule, xmlDescriptor);
        this.wl("</CENTER>");
        this.generateRuleLegend(xmlInfo, xmlDescriptor);
        if (xmlDescriptor.starredTag) {
            this.wl("<P><HR><P>");
            this.wl("<SPAN STYLE=\"COLOR:#445577\" SIZE=\"-2\">");
            this.wl("<I><B>N.B.:</B> an XML construct such as ");
            this.wl("<B><SPAN STYLE=\"COLOR:BLUE\"><TT>&lt;" + xmlDescriptor.starredName + "*&gt;...&lt;/" + xmlDescriptor.starredName + "*&gt;</TT></SPAN></B> ");
            this.wl("stands for either zero, one, or many occurrences of ");
            this.wl("<B><SPAN STYLE=\"COLOR:BLUE\"><TT>&lt;" + xmlDescriptor.starredName + "&gt;...&lt;/" + xmlDescriptor.starredName + "&gt;</TT></SPAN></B>. ");
            this.wl("distributed over the element's contents");
            this.wl("(the \"<B><SPAN STYLE=\"COLOR:BLUE\"><TT>...</TT></SPAN></B>\"), which, accordingly, ");
            this.wl("may be either empty, a single XML element, or a list thereof.</I>");
            this.wl("</SPAN>");
            this.wl("<P><HR><P>");
        }
        this.wl("</TD></TR></TABLE>");
        this.wl("</CENTER>");
    }

    void generateXmlPatternDescription(Terminal terminal, XmlDescriptor xmlDescriptor) throws IOException {
        this.wl("<BLOCKQUOTE><TABLE BORDER BGCOLOR=\"#EEEEEE\" CELLPADDING=\"20\"><TR><TD>");
        XmlInfo xmlInfo = terminal.xmlInfo();
        xmlDescriptor.prefix = xmlInfo.hasNsPrefix() ? xmlInfo.colorPrefix() + ":" : "";
        xmlDescriptor.name = xmlInfo.colorName();
        xmlInfo.resetLegend();
        if (xmlInfo.hasAttributes()) {
            XmlAttributeInfo[] xmlAttributeInfoArray = xmlInfo.attributes();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < xmlAttributeInfoArray.length; ++i) {
                stringBuilder.append(" ").append(xmlInfo.colorAttribute(xmlAttributeInfoArray[i].toString()));
            }
            xmlDescriptor.attributes = stringBuilder.toString();
        }
        this.wl("<P>");
        this.wl("<B><TT>");
        if (xmlInfo.hasChildren()) {
            this.wl("&lt;" + xmlDescriptor.prefix + xmlDescriptor.name + xmlDescriptor.attributes + "&gt;&nbsp;" + xmlInfo.colorChild("</TT></B><I><SPAN STYLE=\"FONT-SIZE:SMALLER\">the " + terminal.htmlName().toLowerCase() + "</SPAN></I><B><TT>") + "&nbsp;&lt;/" + xmlDescriptor.prefix + xmlDescriptor.name + "&gt;");
        } else {
            this.wl("&lt;" + xmlDescriptor.prefix + xmlDescriptor.name + xmlDescriptor.attributes.replaceAll("\\$[Vv][Aa][Ll][Uu][Ee]", "<I>" + terminal.label().toLowerCase() + "</I>") + "/&gt;");
        }
        this.wl("</TT></B>");
        this.wl("\n</TD></TR></TABLE></BLOCKQUOTE>");
    }

    void generateXmlPatternDescription(Rule rule, XmlDescriptor xmlDescriptor) throws IOException {
        Object[] objectArray;
        this.wl("<BLOCKQUOTE><TABLE BORDER BGCOLOR=\"#EEEEEE\" CELLPADDING=\"20\"><TR><TD>");
        XmlInfo xmlInfo = rule.xmlInfo();
        xmlDescriptor.prefix = xmlInfo.hasNsPrefix() ? xmlInfo.colorPrefix() + ":" : "";
        xmlDescriptor.name = xmlInfo.colorName();
        xmlInfo.resetLegend();
        if (xmlInfo.hasAttributes()) {
            objectArray = xmlInfo.attributes();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append(" ");
                if (objectArray[i].isDeepAttributeReference()) {
                    stringBuilder.append(xmlInfo.formatAttributeRef(objectArray[i], i, rule.sequence[objectArray[i].child()].htmlRef()));
                    continue;
                }
                if (objectArray[i].hasTextForm()) {
                    stringBuilder.append(xmlInfo.formatAttributeTextForm(objectArray[i], i, rule));
                    continue;
                }
                stringBuilder.append(xmlInfo.colorAttribute(objectArray[i].toString()));
            }
            xmlDescriptor.attributes = stringBuilder.toString();
        }
        if (xmlInfo.hasChildren()) {
            this.wl("<PRE STYLE=\"line-height: 150%\">");
            this.wl("<B>&lt;" + xmlDescriptor.prefix + xmlDescriptor.name + xmlDescriptor.attributes + "&gt;</B>");
            objectArray = xmlInfo.children();
            this.w("<SPAN STYLE=\"COLOR:BROWN\">");
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                int n2;
                XmlWrapper[] xmlWrapperArray = xmlInfo.wrapperPaths()[i];
                if (xmlWrapperArray == null) {
                    if (xmlInfo.hasAttributeRefs() && xmlInfo.attributeRefs(i) != null) {
                        this.wl("</PRE><BLOCKQUOTE STYLE=\"" + this.bqstyle + "\"><SPAN STYLE=\"FONT-SIZE:SMALLER\"><I>Value of attribute named <TT>'<SPAN STYLE=\"COLOR:#EE6622\">" + xmlInfo.attributeRefs(i) + "</SPAN>'</TT> of the XML serialization " + xmlInfo.childRef((int)objectArray[i], null) + "</I></SPAN> (" + rule.sequence[objectArray[i]].htmlRef() + ")</BLOCKQUOTE>");
                        this.wl("<PRE STYLE=\"line-height: 150%\">");
                        continue;
                    }
                    this.wl("</PRE><BLOCKQUOTE STYLE=\"" + this.bqstyle + "\"><SPAN STYLE=\"FONT-SIZE:SMALLER\"><I>XML serialization" + xmlInfo.childRef((int)objectArray[i], xmlInfo.xmlPaths()[i]) + "</I></SPAN> (" + rule.sequence[objectArray[i]].htmlRef() + ")</BLOCKQUOTE>");
                    this.wl("<PRE STYLE=\"line-height: 150%\">");
                    continue;
                }
                for (n2 = 0; n2 < xmlWrapperArray.length; ++n2) {
                    xmlDescriptor.starredTag = xmlWrapperArray[n2].isStarred();
                    if (xmlDescriptor.starredTag && xmlDescriptor.starredName == null) {
                        xmlDescriptor.starredName = xmlWrapperArray[n2].getTag();
                    }
                    for (n = 0; n <= n2; ++n) {
                        this.w("  ");
                    }
                    this.wl("<B>&lt;" + XmlInfo.colorName(xmlWrapperArray[n2].getTag() + (xmlDescriptor.starredTag ? "*" : "")) + "&gt;</B>");
                }
                this.wl("</PRE>");
                n2 = xmlWrapperArray.length;
                while (n2-- > 0) {
                    this.wl("<BLOCKQUOTE STYLE=\"" + this.bqstyle + "\">");
                }
                this.wl("<SPAN STYLE=\"FONT-SIZE:SMALLER\"><I>XML serialization" + xmlInfo.childRef((int)objectArray[i], xmlInfo.xmlPaths()[i]) + "</I></SPAN> (" + rule.sequence[objectArray[i]].htmlRef() + ")");
                n2 = xmlWrapperArray.length;
                while (n2-- > 0) {
                    this.wl("</BLOCKQUOTE>");
                }
                this.wl("<PRE STYLE=\"line-height: 150%\">");
                n2 = xmlWrapperArray.length;
                while (n2-- > 0) {
                    xmlDescriptor.starredTag = xmlWrapperArray[n2].isStarred();
                    for (n = 0; n <= n2; ++n) {
                        this.w("  ");
                    }
                    this.wl("<B>&lt;/" + XmlInfo.colorName(xmlWrapperArray[n2].getTag() + (xmlDescriptor.starredTag ? "*" : "")) + "&gt;</B>");
                }
            }
            this.w("</SPAN>");
            this.wl("<B>&lt;/" + xmlDescriptor.prefix + xmlDescriptor.name + "&gt;</B>");
            this.wl("</PRE>");
        } else {
            this.wl("<TT><B>&lt;" + xmlDescriptor.prefix + xmlDescriptor.name + xmlDescriptor.attributes + "/&gt;</B></TT>");
        }
        this.wl("\n</TD></TR></TABLE></BLOCKQUOTE>");
    }

    final void generateNTFiles() throws IOException {
        for (NonTerminal nonTerminal : Documentor.grammar.nonterminals) {
            if (this.isHidden(nonTerminal)) continue;
            this.setOutput(nonTerminal.htmlFileName());
            this.preamble(this.file, true);
            this.wl(this.MAIN_BODY);
            this.wl("<H1 ALIGN=\"CENTER\">Non-terminal symbol <SPAN STYLE=\"COLOR:MAROON\">" + nonTerminal.label() + "</SPAN></H1>");
            this.wl("<CENTER>");
            this.wl("<SPAN STYLE=\"FONT-SIZE:XX-SMALL\"><TABLE BORDER=\"2\",CELLPADDING=\"8\"><TR><TD BGCOLOR=\"PINK\"><A HREF=\"#RULES\"><SPAN STYLE=\"FONT-SIZE:XX-SMALL\">rule(s)</SPAN></TD><TD BGCOLOR=\"PINK\"><A HREF=\"#OCCS\"><SPAN STYLE=\"FONT-SIZE:XX-SMALL\">occurrences</SPAN></A></TD></TR></TABLE></SPAN>");
            this.wl("</CENTER>");
            if (nonTerminal.doc != null) {
                this.formatDoc(nonTerminal.doc.toString());
            }
            this.wl("<P><HR><P>");
            this.wl("<SPAN STYLE=\"FONT-SIZE:LARGER\"><A NAME=\"RULES\">Defining</A> rules for nonterminal symbol");
            this.wl("<SPAN STYLE=\"COLOR:MAROON; FONT-SIZE:LARGER\">" + nonTerminal.label() + "</SPAN>:</SPAN><P>");
            this.wl("<CENTER>");
            this.wl("<TABLE BGCOLOR=\"WHITE\" BORDER=\"5\" CELLPADDING=\"20\">");
            this.wl("<TR><TD>");
            this.wl("<TABLE BGCOLOR=\"WHITE\" CELLPADDING=\"6\">");
            Iterator iterator = nonTerminal.rules.iterator();
            this.formatRule((Rule)iterator.next(), nonTerminal, true);
            while (iterator.hasNext()) {
                this.formatRule((Rule)iterator.next(), nonTerminal, false);
            }
            this.wl("</TABLE>");
            this.wl("</TD></TR>");
            this.wl("</TABLE>");
            this.wl("</CENTER>");
            this.wl("<P>");
            SetOf setOf = nonTerminal.ruleOccurrences;
            if (setOf != null && !setOf.isEmpty()) {
                this.wl("<HR><P>");
                this.wl("<SPAN STYLE=\"FONT-SIZE:LARGER\"><A NAME=\"OCCS\">Occurrences</A> of symbol");
                this.wl("<SPAN STYLE=\"COLOR:MAROON; FONT-SIZE:LARGER\">" + nonTerminal.label() + "</SPAN>");
                this.wl("in body of other rules:</SPAN><P>");
                this.wl("<CENTER>");
                this.wl("<TABLE BGCOLOR=\"WHITE\" BORDER=\"5\" CELLPADDING=\"20\">");
                this.wl("<TR><TD>");
                this.wl("<TABLE BGCOLOR=\"WHITE\" CELLPADDING=\"6\">");
                iterator = setOf.iterator();
                while (iterator.hasNext()) {
                    this.formatRule((Rule)iterator.next(), nonTerminal);
                }
                this.wl("</TABLE>");
                this.wl("</TD></TR>");
                this.wl("</TABLE>");
                this.wl("</CENTER>");
            }
            this.hltCopyrightStamp();
            this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
            this.wl("</BODY>");
            this.wl("</HTML>");
            this.out.close();
        }
    }

    final void generateRuleFile(Rule rule) throws IOException {
        this.setOutput(rule.htmlFileName());
        this.preamble(this.file, false);
        this.wl(this.MAIN_BODY);
        this.wl("<H2 ALIGN=\"CENTER\">Rule " + rule.head().ruleLabel(rule) + "</H2>");
        this.formatRule(rule);
        this.formatXmlInfo(rule);
        if (rule.doc != null) {
            this.formatDoc(rule.doc.toString());
        }
        this.hltCopyrightStamp();
        this.wl("<P ALIGN=\"RIGHT\">" + this.LOGOIM);
        this.wl("</BODY>");
        this.wl("</HTML>");
        this.out.close();
    }

    final void formatXmlInfo(Rule rule) throws IOException {
        if (rule == null) {
            return;
        }
        if (rule.xmlInfo() == null) {
            return;
        }
        this.wl("<P>");
        this.generateXmlInfoDescription(rule);
        this.wl("<P>");
    }

    final void formatRule(Rule rule) throws IOException {
        if (rule == null) {
            return;
        }
        this.wl("<CENTER>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" BORDER=\"5\" CELLPADDING=\"20\">");
        this.wl("<TR><TD>");
        this.wl("<TABLE BGCOLOR=\"WHITE\" CELLPADDING=\"6\">");
        this.wl("<TR>");
        this.wl("<TD ALIGN=\"RIGHT\" VALIGN=\"TOP\">");
        this.wl(rule.sequence[0].htmlRef());
        this.wl("</TD>");
        this.wl("<TD ALIGN=\"RIGHT\" VALIGN=\"TOP\">");
        this.wl(this.RARROW);
        this.wl("</TD>");
        this.wl("<TD VALIGN=\"TOP\">");
        for (int i = 1; i < rule.sequence.length; ++i) {
            GrammarSymbol grammarSymbol = rule.sequence[i];
            Object object = grammarSymbol.htmlRef();
            if (this.isError(grammarSymbol)) {
                object = "<B><TT><SPAN STYLE=\"COLOR:#4444FF\">" + grammarSymbol.name() + "</SPAN></TT></B>";
            } else {
                if (this.isHidden(grammarSymbol)) continue;
                object = this.quotify((String)object, grammarSymbol);
            }
            this.w((String)object + "&nbsp;");
        }
        this.wl("</TD>");
        this.wl("</TR>");
        this.wl("</TABLE>");
        this.wl("</TD></TR>");
        this.wl("</TABLE>");
        this.wl("</CENTER>");
    }

    final void formatRule(Rule rule, GrammarSymbol grammarSymbol) throws IOException {
        if (rule == null) {
            return;
        }
        this.wl("<TR>");
        this.wl("<TD ALIGN=\"RIGHT\" VALIGN=\"TOP\">");
        this.wl(rule.sequence[0].htmlRef());
        this.wl("</TD>");
        this.wl("<TD ALIGN=\"RIGHT\" VALIGN=\"TOP\">");
        this.ruleLink(rule, grammarSymbol);
        this.wl("</TD>");
        this.wl("<TD VALIGN=\"TOP\">");
        for (int i = 1; i < rule.sequence.length; ++i) {
            GrammarSymbol grammarSymbol2 = rule.sequence[i];
            Object object = grammarSymbol2.htmlRef();
            if (this.isError(grammarSymbol2)) {
                object = "<B><TT><SPAN STYLE=\"COLOR:#4444FF\">" + grammarSymbol2.name() + "</SPAN></TT></B>";
            } else {
                if (this.isHidden(grammarSymbol2)) continue;
                object = this.quotify((String)object, grammarSymbol2);
            }
            if (grammarSymbol2 == grammarSymbol) {
                this.wl(this.quotify("<SPAN STYLE=\"COLOR:MAROON\">" + grammarSymbol.label() + "</SPAN>", grammarSymbol) + "&nbsp;");
                continue;
            }
            this.wl((String)object + "&nbsp;");
        }
        this.wl("</TD>");
        this.wl("</TR>");
    }

    final void formatRule(Rule rule, NonTerminal nonTerminal, boolean bl) throws IOException {
        if (rule == null) {
            return;
        }
        this.wl("<TR>");
        this.wl("<TD ALIGN=\"RIGHT\" VALIGN=\"TOP\">");
        if (bl) {
            this.wl("<SPAN STYLE=\"COLOR:MAROON\">" + nonTerminal.label() + "</SPAN>");
        }
        this.wl("</TD>");
        this.wl("<TD ALIGN=\"RIGHT\" VALIGN=\"TOP\">");
        this.ruleLink(rule, nonTerminal);
        this.wl("</TD>");
        this.wl("<TD VALIGN=\"TOP\">");
        for (int i = 1; i < rule.sequence.length; ++i) {
            GrammarSymbol grammarSymbol = rule.sequence[i];
            Object object = grammarSymbol.htmlRef();
            if (this.isError(grammarSymbol)) {
                object = "<B><TT><SPAN STYLE=\"COLOR:#4444FF\">" + grammarSymbol.name() + "</SPAN></TT></B>";
            } else {
                if (this.isHidden(grammarSymbol)) continue;
                object = this.quotify((String)object, grammarSymbol);
            }
            if (grammarSymbol == nonTerminal) {
                this.wl("<SPAN STYLE=\"COLOR:MAROON\">" + nonTerminal.label() + "</SPAN>&nbsp;");
                continue;
            }
            this.wl((String)object + "&nbsp;");
        }
        this.wl("</TD>");
        this.wl("</TR>");
    }

    final void ruleLink(Rule rule, GrammarSymbol grammarSymbol) throws IOException {
        if (rule.doc == null && rule.xmlInfo() == null) {
            this.wl(this.RARROW);
        } else {
            this.wl("\n<A CLASS=\"SYMBOL\" HREF=\"javascript:showRuleDoc('" + rule.refName() + "')\">" + this.RARROW + "</A>");
        }
    }

    final void setOutput(String string) throws IOException {
        this.file = this.DOCDIR + "/" + string;
        this.out = new BufferedWriter(new FileWriter(this.file));
    }

    final void w(String string) throws IOException {
        this.out.write(string);
    }

    final void w(char c) throws IOException {
        this.w(String.valueOf(c));
    }

    final void wl(String string) throws IOException {
        this.out.write(string + "\n");
    }

    final void wl() throws IOException {
        this.out.write("\n");
    }

    final void formatDoc(String string) throws IOException {
        if (string == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        this.wl("<P><HR><P>");
        this.wl("<H4 ALIGN=\"CENTER\">Description</H4>");
        this.wl("<TABLE WIDTH=\"100%\" BGCOLOR=\"WHITE\" CELLPADDING=\"15\"><TR><TD>");
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '*': {
                    continue block6;
                }
                case '\\': {
                    if (i == string.length() - 1) {
                        this.w('\\');
                        continue block6;
                    }
                    this.w(string.charAt(i + 1));
                    ++i;
                    continue block6;
                }
                case '$': 
                case '%': {
                    i = this.processSymbolRef(i + 1, string, string.charAt(i));
                    continue block6;
                }
                case '@': {
                    i = this.recordTag(i + 1, string, hashMap);
                    continue block6;
                }
                default: {
                    this.w(string.charAt(i));
                }
            }
        }
        if (!hashMap.isEmpty()) {
            this.formatTags(hashMap);
        }
        this.wl("</TD></TR></TABLE>");
    }

    final int processSymbolRef(int n, String string, char c) throws IOException {
        int n2 = n;
        while (n < string.length() && string.charAt(n) != c) {
            ++n;
        }
        if (n == string.length()) {
            this.w(string.substring(n2 - 1));
        } else {
            String string2 = string.substring(n2, n).intern();
            GrammarSymbol grammarSymbol = Grammar.getTerminal(string2);
            if (grammarSymbol == null) {
                grammarSymbol = Grammar.getNonTerminal(string2);
            }
            if (grammarSymbol == null) {
                Grammar.warning("Unknown symbol reference in documentation: " + string2);
                this.w("<SPAN STYLE=\"COLOR:RED\"><b><i><tt>" + string2 + "</tt></i></b></SPAN>");
            } else {
                this.w(grammarSymbol.htmlRef());
            }
        }
        return n;
    }

    final int recordTag(int n, String string, HashMap hashMap) throws IOException {
        if (n == string.length() || !Character.isLetter(string.charAt(n))) {
            this.w('@');
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(string.charAt(n));
        } while (++n < string.length() && Character.isLetter(string.charAt(n)));
        ArrayList arrayList = (ArrayList)hashMap.get(stringBuilder.toString());
        if (arrayList == null) {
            arrayList = new ArrayList();
            hashMap.put(stringBuilder.toString(), arrayList);
        }
        stringBuilder = new StringBuilder();
        while (n < string.length() && string.charAt(n) != '\n') {
            stringBuilder.append(string.charAt(n++));
        }
        arrayList.add(stringBuilder.toString().trim());
        return n;
    }

    final void formatTags(HashMap hashMap) throws IOException {
        this.wl("\n<DL>");
        for (String string : hashMap.keySet()) {
            this.wl("<DT><STRONG>" + this.label(string) + "</STRONG></DT>");
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            if (arrayList.isEmpty()) continue;
            boolean bl = true;
            boolean bl2 = string.equalsIgnoreCase("param");
            this.w("<DD>");
            if (bl2) {
                this.wl("<TABLE BORDER=0>");
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    this.w(bl2 ? "\n" : ", ");
                }
                this.w(this.tagDefFormat(string, (String)iterator.next()));
            }
            if (bl2) {
                this.wl("</TABLE>");
            }
            this.wl("</DD>");
        }
        this.wl("</DL>");
    }

    final String label(String string) {
        Object object = (String)knownTags.get(string);
        if (object != null) {
            return object;
        }
        object = String.valueOf(Character.toUpperCase(string.charAt(0))) + string.toLowerCase().substring(1) + ":";
        return object;
    }

    final String tagDefFormat(String string, String string2) {
        if (string.equalsIgnoreCase("param")) {
            int n = string2.indexOf(32);
            int n2 = string2.indexOf(9);
            n = n >= 0 && n2 >= 0 ? Math.min(n, n2) : Math.max(n, n2);
            return "<TR><TD VALIGN=BASELINE><B><I><TT>" + (n >= 0 ? string2.substring(0, n) : string2) + "&nbsp;</TT></I></B></TD><TD>- " + (n >= 0 ? string2.substring(n) : string2) + "</TD></TR>";
        }
        if (!string.equalsIgnoreCase("see") || string2.regionMatches(true, 0, "<A HREF", 0, 7)) {
            return string2;
        }
        int n = string2.lastIndexOf(35);
        String string3 = n < 0 ? string2 : string2.substring(0, n);
        String string4 = n < 0 ? "" : string2.substring(n);
        return "<A HREF=\"" + string3 + (string3.length() > 0 ? ".html" : "") + string4 + "\">" + (n < 0 ? string3.substring(string3.lastIndexOf(46) + 1) : string4.substring(1)) + "</A>";
    }

    static {
        knownTags.put("deprecated", "<BLINK>Deprecated!</BLINK>");
        knownTags.put("exception", "Throws:");
        knownTags.put("param", "Parameters:");
        knownTags.put("return", "Returns:");
        knownTags.put("see", "See also:");
        knownTags.put("since", "Since:");
        knownTags.put("version", "Version:");
    }

    class XmlDescriptor {
        boolean starredTag = false;
        String starredName = null;
        String name = null;
        String prefix = null;
        String attributes = "";

        XmlDescriptor() {
        }
    }
}

