/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.Choice;
import hlt.language.syntax.DynamicToken;
import hlt.language.syntax.GenericParser;
import hlt.language.syntax.Grammar;
import hlt.language.syntax.NonFatalParseErrorException;
import hlt.language.syntax.ParseNode;
import hlt.language.syntax.ParserAction;
import hlt.language.syntax.ParserNonTerminal;
import hlt.language.syntax.ParserOperator;
import hlt.language.syntax.ParserRule;
import hlt.language.syntax.ParserStackElement;
import hlt.language.syntax.ParserTerminal;
import hlt.language.syntax.TrailEntry;
import hlt.language.tools.Misc;
import hlt.language.util.FiniteStack;
import hlt.language.util.Stack;
import hlt.language.util.TimeStampManager;
import hlt.language.util.TimeStamped;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class DynamicParser
extends GenericParser {
    public AbstractList operators;
    protected final HashMap operatorTable = new HashMap();
    protected final HashMap operatorCategoryTable = new HashMap();
    protected final HashMap operatorNameTable = new HashMap();
    private TimeStampManager tsm = new TimeStampManager();
    private Stack readStack = new Stack();
    protected FiniteStack choiceStack;
    protected FiniteStack trailStack;
    protected boolean resolveRRsWithPrecedence;
    protected static boolean admitsOperators = true;
    private boolean getParseActionFlag = true;

    protected final int precedence(ParserRule parserRule) {
        if (parserRule.precedence != -1) {
            return parserRule.precedence;
        }
        return this.node(parserRule, parserRule.tagPosition).precedence();
    }

    protected final int associativity(ParserRule parserRule) {
        if (parserRule.associativity != -1) {
            return parserRule.associativity;
        }
        return this.node(parserRule, parserRule.tagPosition).associativity();
    }

    protected final boolean hasTag(ParserRule parserRule, ParseNode parseNode) {
        ParseNode parseNode2;
        if (parserRule.tagPosition != -1 && (parseNode2 = this.node(parserRule, parserRule.tagPosition)).isTerminal()) {
            if (parseNode2.isOperator() && parseNode.isOperator()) {
                return parseNode2.operator() == parseNode.operator();
            }
            if (!parseNode2.isOperator() && !parseNode.isOperator()) {
                return parseNode2.symbol() == parseNode.symbol();
            }
        }
        return false;
    }

    protected abstract void undoSemanticAction(ParserRule var1, ParseNode var2) throws IOException;

    protected final void defineOperator(String string, String string2, String string3, int n) throws NonFatalParseErrorException {
        ParserNonTerminal parserNonTerminal;
        ParserOperator parserOperator;
        int n2 = Grammar.checkPrecedenceLevel(Grammar.prologPrecedence(n));
        ArrayList<ParserOperator> arrayList = this.operatorsInCategory(string);
        int n3 = ((AbstractList)arrayList).indexOf(parserOperator = new ParserOperator(this, string2, parserNonTerminal = DynamicParser.nonterminal(string), n2, string3));
        if (n3 == -1) {
            parserOperator.add();
            ((AbstractList)arrayList).add(parserOperator);
            arrayList = this.operators(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<ParserOperator>(3);
                this.operatorNameTable.put(string2, arrayList);
            }
            ((AbstractList)arrayList).add(parserOperator);
        } else {
            ((ParserOperator)this.operators.get(n3)).redefine(n2, string3);
        }
    }

    protected final void newOperator(String string, int n, int n2, int n3, int n4) {
        ParserOperator parserOperator = new ParserOperator(this, string, nonterminals[n], n2, n3, n4);
        this.operatorTable.put(string, parserOperator);
        parserOperator.add();
        ArrayList<ParserOperator> arrayList = this.operatorsInCategory(nonterminals[n].name());
        if (arrayList == null) {
            arrayList = new ArrayList<ParserOperator>(5);
            this.operatorCategoryTable.put(nonterminals[n].name(), arrayList);
        }
        ((AbstractList)arrayList).add(parserOperator);
        arrayList = this.operators(string);
        if (arrayList == null) {
            arrayList = new ArrayList(5);
            this.operatorNameTable.put(string, arrayList);
        }
        ((AbstractList)arrayList).add(parserOperator);
    }

    protected static final void newDynamicActionTable(int n, int n2) {
        DynamicParser.states[n].dynamicActions = new ParserAction[n2][];
    }

    protected static final void newDynamicActions(int n, int n2, int n3) {
        DynamicParser.states[n].dynamicActions[n2] = new ParserAction[n3];
    }

    protected static final void setDynamicAction(int n, int n2, int n3, int n4) {
        DynamicParser.states[n].dynamicActions[n2][n3] = actions[n4];
    }

    public final AbstractList operators(String string) {
        return (AbstractList)this.operatorNameTable.get(string);
    }

    public final AbstractList operatorsInCategory(String string) {
        return (AbstractList)this.operatorCategoryTable.get(string);
    }

    private void stamp(TimeStamped timeStamped) {
        this.tsm.setTimeStamp(timeStamped);
    }

    @Override
    public void resetParser() {
        super.resetParser();
        this.readStack.clear();
        this.choiceStack.flush();
        this.trailStack.flush();
    }

    @Override
    public ParseNode error() {
        return new DynamicToken(super.error());
    }

    public static final ParseNode literalToken(String string) {
        ParserTerminal parserTerminal = DynamicParser.terminal(string);
        return parserTerminal == null ? (admitsOperators ? new ParseNode(string.intern()) : DynamicParser.error(string)) : new ParseNode(parserTerminal);
    }

    @Override
    protected ParseNode latestToken() throws IOException {
        if (this.readStack.isEmpty()) {
            return ((DynamicToken)this.tokenNode()).getOriginal();
        }
        return (ParseNode)this.readStack.get(0);
    }

    @Override
    final void readToken() throws IOException {
        if (this.readStack.isEmpty()) {
            this.tokenNode = new DynamicToken(this.nextToken());
            this.stamp((TimeStamped)((Object)this.tokenNode));
            if (this.trace) {
                this.err.println("*** Read token: " + this.tokenNode + " from input.");
            }
        } else {
            this.tokenNode = new DynamicToken((ParseNode)this.readStack.pop());
            this.stamp((TimeStamped)((Object)this.tokenNode));
            if (this.trace) {
                this.err.println("*** Read token: " + this.tokenNode + " from read stack.");
            }
        }
        if (this.tokenNode.isError()) {
            this.cutAll();
        } else {
            Choice choice = new Choice();
            if (this.tokenNode.hasAlternatives()) {
                this.tallyAlternatives(choice);
            }
            if (admitsOperators) {
                this.tallyOperators(choice);
            }
            if (!choice.isEmpty()) {
                this.pushChoice(choice);
            }
        }
        this.readTokenFlag = false;
    }

    private final void tallyAlternatives(Choice choice) {
        Iterator iterator = this.tokenNode.alternatives().iterator();
        while (iterator.hasNext()) {
            DynamicToken dynamicToken = new DynamicToken((ParseNode)iterator.next());
            dynamicToken.setOriginal(this.tokenNode);
            this.stamp(dynamicToken);
            choice.addOption(dynamicToken);
        }
    }

    private void pushChoice(Choice choice) {
        this.stamp(choice);
        choice = (Choice)this.choiceStack.push(choice);
        if (choice != null) {
            while (!this.trailStack.isEmpty() && ((TrailEntry)this.trailStack.oldest()).getTimeStamp() < choice.getTimeStamp()) {
                this.trailStack.drop();
            }
        }
    }

    private final void tallyOperators(Choice choice) {
        Stack stack = this.admissibleOperators();
        if (this.tokenNode.isUnknown()) {
            if (stack != null) {
                this.tokenNode = (DynamicToken)stack.pop();
                if (stack.isEmpty()) {
                    stack = null;
                }
            } else {
                this.tokenNode = DynamicParser.error(this.tokenNode);
            }
        }
        if (stack != null) {
            choice.addOptions(stack);
        }
    }

    private final Stack admissibleOperators() {
        String string = this.tokenNode.svalue() == null ? this.tokenNode.symbol().name() : this.tokenNode.svalue().intern();
        AbstractList abstractList = this.operators(string);
        if (abstractList == null) {
            return null;
        }
        Stack stack = new Stack();
        for (ParserOperator parserOperator : abstractList) {
            if (!this.symbolIsHandled(parserOperator.subCategory)) continue;
            if (this.tokenNode.isUnknown() && parserOperator.subCategory == this.tokenNode.symbol()) {
                ((DynamicToken)this.tokenNode).makeOperator(parserOperator);
                continue;
            }
            DynamicToken dynamicToken = new DynamicToken(parserOperator, ((DynamicToken)this.tokenNode).getOriginal());
            this.stamp(dynamicToken);
            stack.push(dynamicToken);
        }
        if (stack.isEmpty()) {
            return null;
        }
        return stack;
    }

    @Override
    final void push(ParseNode parseNode) {
        super.push(parseNode);
        this.stamp((TimeStamped)this.parserStack.peek());
    }

    @Override
    final void getParseAction() throws IOException {
        if (this.getParseActionFlag) {
            this.parseAction = this.parseState.getAction((ParserTerminal)this.tokenNode().symbol());
            if (this.parseAction == null || this.nonassociativeUnaryOperator()) {
                this.parseAction = DynamicParser.errorAction();
            }
        }
        this.getParseActionFlag = true;
    }

    final boolean nonassociativeUnaryOperator() throws IOException {
        ParseNode parseNode = this.tokenNode();
        return parseNode.associativity() == 2 && (parseNode.fixity() == 1 && this.parseAction.type == 1 && this.hasTag(rules[this.parseAction.info], parseNode) || parseNode.fixity() == 0 && this.previousTokenIsSameOperator());
    }

    final boolean previousTokenIsSameOperator() throws IOException {
        ParseNode parseNode = null;
        for (int i = this.parserStack.size() - 1; i >= 0; --i) {
            parseNode = ((ParserStackElement)this.parserStack.get(i)).getNode();
            if (!parseNode.isTerminal()) continue;
            return parseNode.isOperator() && parseNode.operator().equals(this.tokenNode().operator());
        }
        return false;
    }

    final String stringForm(ParserStackElement[] parserStackElementArray) {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < parserStackElementArray.length; ++i) {
            stringBuilder.append(parserStackElementArray[i].getNode().nodeInfo());
            if (i >= parserStackElementArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    final void popHandle() {
        super.popHandle();
        if (!this.choiceStack.isEmpty()) {
            TrailEntry trailEntry = new TrailEntry(this.parseHandle, this.parseRule);
            this.stamp(trailEntry);
            trailEntry = (TrailEntry)this.trailStack.push(trailEntry);
            if (trailEntry != null) {
                while (!this.choiceStack.isEmpty() && ((Choice)this.choiceStack.oldest()).getTimeStamp() < trailEntry.getTimeStamp()) {
                    this.choiceStack.drop();
                }
                if (this.choiceStack.isEmpty()) {
                    this.trailStack.flush();
                }
            }
        }
    }

    private final void backtrack() throws IOException {
        if (this.trace) {
            this.out.println("Backtracking... ");
        }
        Choice choice = (Choice)this.choiceStack.peek();
        this.undo(choice);
        Object object = choice.options.pop();
        if (choice.options.isEmpty()) {
            this.choiceStack.pop();
        }
        if (choice.isTokenChoice()) {
            this.tokenNode = (DynamicToken)object;
            this.readTokenFlag = false;
            this.getParseActionFlag = true;
        } else {
            this.parseAction = (ParserAction)object;
            this.readTokenFlag = true;
            this.getParseActionFlag = false;
        }
        if (this.choiceStack.isEmpty()) {
            this.trailStack.flush();
        }
        if (this.trace) {
            this.showDynamicState();
        }
    }

    private final void undo(Choice choice) throws IOException {
        long l = choice.getTimeStamp();
        DynamicToken dynamicToken = (DynamicToken)this.tokenNode;
        if (this.trace) {
            this.err.println("Undoing stamp: " + l);
        }
        if (!choice.isTokenChoice() || dynamicToken.getTimeStamp() > l) {
            this.readStack.push(dynamicToken.getOriginal());
            if (this.trace) {
                this.err.println("Unreading token: " + dynamicToken);
                this.err.println(Misc.view(this.readStack, "   read stack", 0, 80));
            }
        }
        ParserStackElement parserStackElement = (ParserStackElement)this.parserStack.peek();
        while (parserStackElement.getTimeStamp() > l) {
            if (this.trace) {
                this.err.println("Popping parser stack element: " + parserStackElement);
            }
            this.parserStack.pop();
            if (parserStackElement.getNode().isTerminal()) {
                dynamicToken = (DynamicToken)parserStackElement.getNode();
                if (!choice.isTokenChoice() || dynamicToken.getTimeStamp() > l) {
                    this.readStack.push(dynamicToken.getOriginal());
                    if (this.trace) {
                        this.err.println("Unreading token: " + dynamicToken);
                        this.err.println(Misc.view(this.readStack, "   read stack", 0, 80));
                    }
                }
            } else {
                TrailEntry trailEntry = (TrailEntry)this.trailStack.pop();
                for (int i = 0; i < trailEntry.handle.length; ++i) {
                    this.parserStack.push(trailEntry.handle[i]);
                }
                this.undoSemanticAction(trailEntry.rule, parserStackElement.getNode());
            }
            parserStackElement = (ParserStackElement)this.parserStack.peek();
        }
    }

    public final void cutAll() {
        this.choiceStack.flush();
        this.trailStack.flush();
    }

    public final void cut() {
        this.choiceStack.pop();
        if (this.choiceStack.isEmpty()) {
            this.trailStack.flush();
        }
    }

    @Override
    final void trace(ParserAction parserAction) throws IOException {
        this.traceAction(parserAction);
        this.showDynamicState();
        this.step();
    }

    @Override
    final boolean performParseAction() throws IOException {
        switch (this.parseAction.type) {
            case 2: {
                return false;
            }
            case 3: {
                this.resolveDynamicAction();
                return this.performParseAction();
            }
            case 4: {
                this.resolveChoiceAction();
                return this.performParseAction();
            }
            case 0: {
                this.shift();
                break;
            }
            case 1: {
                this.reduce();
                if (this.parseState != null) break;
            }
            case 5: {
                if (!this.choiceStack.isEmpty()) {
                    this.backtrack();
                    break;
                }
                this.recoverFromError();
            }
        }
        return true;
    }

    private final void resolveDynamicAction() throws IOException {
        ParserAction[] parserActionArray = this.currentState().dynamicActions[this.parseAction.info];
        this.parseAction = parserActionArray[0];
        for (int i = 1; i < parserActionArray.length; ++i) {
            this.parseAction = this.chooseAction(this.parseAction, parserActionArray[i]);
        }
        if (this.nonassociativeUnaryOperator()) {
            this.parseAction = DynamicParser.errorAction();
        }
    }

    private final void resolveChoiceAction() throws IOException {
        ParserAction[] parserActionArray = this.currentState().dynamicActions[this.parseAction.info];
        this.parseAction = parserActionArray[0];
        Choice choice = new Choice(parserActionArray.length - 1);
        choice.setIsTokenChoice(false);
        for (int i = 1; i < parserActionArray.length; ++i) {
            choice.addOption(parserActionArray[i]);
        }
        if (!choice.isEmpty()) {
            this.pushChoice(choice);
        }
    }

    private final ParserAction chooseAction(ParserAction parserAction, ParserAction parserAction2) throws IOException {
        if (parserAction.type == 1) {
            if (parserAction2.type == 1) {
                int n = this.precedence(rules[parserAction.info]);
                int n2 = this.precedence(rules[parserAction2.info]);
                if (!this.resolveRRsWithPrecedence || n == n2) {
                    return parserAction.info < parserAction2.info ? parserAction : parserAction2;
                }
                return n > n2 ? parserAction : parserAction2;
            }
            ParserRule parserRule = rules[parserAction.info];
            if (this.precedence(parserRule) > this.tokenNode().precedence()) {
                return parserAction;
            }
            if (this.precedence(parserRule) < this.tokenNode().precedence()) {
                return parserAction2;
            }
            if (this.associativity(parserRule) == 0) {
                return parserAction;
            }
            if (this.tokenNode().associativity() == 2 && this.hasTag(parserRule, this.tokenNode())) {
                return DynamicParser.errorAction();
            }
            return parserAction2;
        }
        return this.chooseAction(parserAction2, parserAction);
    }

    @Override
    void show() throws IOException {
        this.showParseState();
        this.showDynamicState();
    }

    void showDynamicState() {
        if (!this.readStack.isEmpty()) {
            this.err.println(Misc.view(this.readStack, "   read stack", 0, 80));
        }
        if (!this.trailStack.isEmpty()) {
            this.err.println(Misc.view(this.trailStack, "  trail stack", 0, 80));
        }
        if (!this.choiceStack.isEmpty()) {
            this.err.println("choices ==> " + this.choiceStack);
        }
    }

    public final void showOperators() {
        if (!this.operators.isEmpty()) {
            this.err.println("\nDYNAMIC OPERATORS:\n");
            this.err.println("  -----------------------------------------------");
            this.err.println("\tCATEGORY PRECEDENCE SPECIFIER OPERATOR");
            this.err.println("  -----------------------------------------------");
            for (ParserOperator parserOperator : this.operators) {
                this.err.println("  [" + parserOperator.index() + "]\t " + parserOperator.category.name() + "\t   " + Grammar.prologPrecedence(parserOperator.precedence()) + "\t\t" + parserOperator.specifier() + "\t  " + parserOperator.name());
            }
            this.err.println("  -----------------------------------------------");
        }
    }
}

