/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.util.Error;
import java.io.PrintStream;

public abstract class ErrorManager {
    private PrintStream _errorStream = System.err;
    private boolean _isReportingErrors = true;
    private boolean _isRecoveringErrors = true;
    private int _errorCount = 0;
    private int _warningCount = 0;
    private int _deprecatedCount = 0;

    public abstract void reportError(Error var1);

    public abstract void reportWarning(Error var1);

    public abstract void reportDeprecated(Error var1);

    public abstract void tallyErrors();

    public abstract void tallyWarnings();

    public abstract void tallyDeprecateds();

    public final void setErrorStream(PrintStream printStream) {
        this._errorStream = printStream;
    }

    public final PrintStream errorStream() {
        return this._errorStream;
    }

    public final void reportErrors(boolean bl) {
        this._isReportingErrors = bl;
    }

    public final boolean isReportingErrors() {
        return this._isReportingErrors;
    }

    public final void recoverFromErrors(boolean bl) {
        this._isRecoveringErrors = bl;
    }

    public final boolean isRecoveringErrors() {
        return this._isRecoveringErrors;
    }

    public final boolean hasErrors() {
        return this._errorCount > 0;
    }

    public final boolean hasWarnings() {
        return this._warningCount > 0;
    }

    public final boolean hasDeprecateds() {
        return this._deprecatedCount > 0;
    }

    public final void reset() {
        this._isReportingErrors = true;
        this._isRecoveringErrors = true;
        this._errorCount = 0;
        this._warningCount = 0;
        this._deprecatedCount = 0;
    }

    public final int errorCount() {
        return this._errorCount;
    }

    public final void countError() {
        ++this._errorCount;
    }

    public final int warningCount() {
        return this._warningCount;
    }

    public final void countWarning() {
        ++this._warningCount;
    }

    public final int deprecatedCount() {
        return this._deprecatedCount;
    }

    public final void countDeprecated() {
        ++this._deprecatedCount;
    }
}

