/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.io.IncludeReader;
import hlt.language.syntax.DefaultErrorManager;
import hlt.language.syntax.DynamicToken;
import hlt.language.syntax.ErrorManager;
import hlt.language.syntax.FatalParseErrorException;
import hlt.language.syntax.FileTokenizer;
import hlt.language.syntax.Options;
import hlt.language.syntax.ParseNode;
import hlt.language.syntax.ParserAction;
import hlt.language.syntax.ParserNonTerminal;
import hlt.language.syntax.ParserRule;
import hlt.language.syntax.ParserStackElement;
import hlt.language.syntax.ParserState;
import hlt.language.syntax.ParserSymbol;
import hlt.language.syntax.ParserTerminal;
import hlt.language.syntax.Tokenizer;
import hlt.language.tools.Debug;
import hlt.language.tools.Misc;
import hlt.language.util.Error;
import hlt.language.util.Locatable;
import hlt.language.util.Stack;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashMap;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class GenericParser {
    public static final int NO_TREE = 0;
    public static final int COMPACT_TREE = 1;
    public static final int FULL_TREE = 2;
    public static final int XML_TREE = 3;
    protected static ParserTerminal[] terminals;
    protected static ParserNonTerminal[] nonterminals;
    protected static ParserRule[] rules;
    protected static ParserState[] states;
    protected static ParserAction[] actions;
    protected static HashMap[] actionTables;
    protected static HashMap[] gotoTables;
    protected static final HashMap terminalTable;
    protected static final HashMap nonterminalTable;
    public static ParseNode E_O_I;
    public static ParserTerminal ERROR_SYMBOL;
    private static XMLOutputter _o;
    protected String xmlroot = null;
    protected String xmlRootNSPrefix = "";
    protected String[] namespaces = null;
    public int parseTreeType = 0;
    protected PrintStream out = Options.getOutStream();
    protected PrintStream err = Options.getErrStream();
    protected Stack parserStack = new Stack();
    protected Tokenizer input;
    protected boolean readTokenFlag = false;
    private ParseNode switchToken = null;
    protected ParserState parseState;
    protected ParserState previousState;
    protected ParserAction parseAction;
    protected ParserRule parseRule;
    protected ParserStackElement[] parseHandle;
    protected ParseNode tokenNode;
    protected ParseNode parsedNode;
    private ErrorManager _errorManager = new DefaultErrorManager();
    ParseNode previousCulprit;
    protected boolean trace = false;

    public GenericParser() {
        this.initialize();
    }

    public void initialize() {
    }

    public static final ParseNode eoi() {
        return E_O_I;
    }

    public static final ParseNode error(String string) {
        ParseNode parseNode = new ParseNode(ERROR_SYMBOL);
        parseNode.setSvalue(string);
        return parseNode;
    }

    public static final ParseNode error(ParseNode parseNode) {
        if (parseNode instanceof DynamicToken) {
            ((DynamicToken)parseNode).setOriginal(parseNode.copy());
            parseNode.setSvalue(parseNode.toString());
            parseNode.setSymbol(ERROR_SYMBOL);
            return parseNode;
        }
        ParseNode parseNode2 = new ParseNode(ERROR_SYMBOL);
        parseNode2.setSvalue(parseNode.toString());
        parseNode2.setSpan(parseNode);
        return parseNode2;
    }

    protected static final void newTerminal(int n, String string, int n2, int n3) {
        string = string.intern();
        terminalTable.put(string, new ParserTerminal(string, n, n2, n3));
        if (string == "$E_O_I$") {
            E_O_I = new ParseNode(terminals[n]);
        }
        if (string == "error") {
            ERROR_SYMBOL = terminals[n];
        }
    }

    protected static final void newNonTerminal(int n, String string) {
        nonterminalTable.put(string, new ParserNonTerminal(string, n));
    }

    protected static final ParserTerminal terminal(String string) {
        return (ParserTerminal)terminalTable.get(string.intern());
    }

    protected static final ParserNonTerminal nonterminal(String string) {
        return (ParserNonTerminal)nonterminalTable.get(string.intern());
    }

    protected static final void newAction(int n, int n2, int n3) {
        new ParserAction(n2, n3, n);
    }

    protected static final void newState(int n) {
        new ParserState(n);
    }

    protected static final void setAction(int n, int n2, int n3) {
        actionTables[n].put(terminals[n2], actions[n3]);
    }

    protected static final void setGoto(int n, int n2, int n3) {
        gotoTables[n].put(nonterminals[n2], states[n3]);
    }

    protected static final void newActionTables(int n) {
        actionTables = new HashMap[n];
    }

    protected static final void newActionTable(int n, int n2) {
        GenericParser.actionTables[n] = n2 > 0 ? new HashMap(n2) : new HashMap();
    }

    protected static final void newGotoTables(int n) {
        gotoTables = new HashMap[n];
    }

    protected static final void newGotoTable(int n, int n2) {
        GenericParser.gotoTables[n] = n2 > 0 ? new HashMap(n2) : new HashMap();
    }

    protected static final void setTables(int n, int n2, int n3) {
        states[n].setTables(actionTables[n2], gotoTables[n3]);
    }

    public static final ParseNode symbolToken(String string, String string2) {
        ParserTerminal parserTerminal = GenericParser.terminal(string);
        return parserTerminal == null ? GenericParser.error(string + "( " + string2 + ")") : new ParseNode((ParserSymbol)parserTerminal, string2.intern());
    }

    public static final ParseNode numberToken(String string, double d) {
        ParserTerminal parserTerminal = GenericParser.terminal(string);
        return parserTerminal == null ? GenericParser.error(string + "( " + d + ")") : new ParseNode((ParserSymbol)parserTerminal, d);
    }

    public static final ParseNode numberToken(String string, int n) {
        ParserTerminal parserTerminal = GenericParser.terminal(string);
        return parserTerminal == null ? GenericParser.error(string + "( " + n + ")") : new ParseNode((ParserSymbol)parserTerminal, n);
    }

    public static ParseNode literalToken(String string) {
        ParserTerminal parserTerminal = GenericParser.terminal(string);
        return parserTerminal == null ? GenericParser.error(string) : new ParseNode(parserTerminal);
    }

    static final ParserState initialState() {
        return states[0];
    }

    static final ParserAction errorAction() {
        return actions[0];
    }

    static final ParserAction acceptAction() {
        return actions[1];
    }

    public static final XMLOutputter xmlWriter() {
        return _o;
    }

    public static String xmlForm(Document document) {
        return _o.outputString(document);
    }

    public void writeXml(ParseNode parseNode, PrintStream printStream) throws Exception {
        _o.output(this.makeXmlDocument(parseNode), (OutputStream)printStream);
        printStream.println();
    }

    public Document makeXmlDocument(ParseNode parseNode) throws Exception {
        return parseNode.xmlDocument(this.xmlroot, this.xmlRootNSPrefix, this.namespaces);
    }

    protected abstract ParseNode semanticAction(ParserRule var1) throws IOException;

    abstract void readToken() throws IOException;

    abstract boolean performParseAction() throws IOException;

    abstract void getParseAction() throws IOException;

    public ParseNode error() {
        return new ParseNode(ERROR_SYMBOL);
    }

    public ParseNode currentNode() {
        if (this.parsedNode.symbol().name() == "$ROOTS$" && this.parsedNode.children() != null) {
            return this.parsedNode.lastChild();
        }
        return this.parsedNode;
    }

    protected final ParseNode tokenNode() throws IOException {
        if (this.readTokenFlag) {
            this.readToken();
        }
        return this.tokenNode;
    }

    protected ParseNode latestToken() throws IOException {
        return this.tokenNode();
    }

    void push(ParseNode parseNode) {
        this.parserStack.push(new ParserStackElement(this.parseState, parseNode));
    }

    abstract void trace(ParserAction var1) throws IOException;

    final ParseNode nextToken() throws IOException {
        if (this.switchToken == null) {
            return this.input.nextToken();
        }
        ParseNode parseNode = this.switchToken;
        this.switchToken = null;
        return parseNode;
    }

    public final void setSwitchToken(ParseNode parseNode) {
        this.switchToken = parseNode;
    }

    public final void setTokenizer(Tokenizer tokenizer) {
        this.input = tokenizer;
    }

    public final Tokenizer getTokenizer() {
        return this.input;
    }

    public void resetParser() {
        this.parseState = null;
        this.previousState = null;
        this.parseAction = null;
        this.parseRule = null;
        this.parseHandle = null;
        this.tokenNode = null;
        this.parsedNode = null;
        this.previousCulprit = null;
        this.parserStack.clear();
    }

    public final void setTreeType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.parseTreeType = n;
                return;
            }
        }
    }

    public final void setTreeType(String string) {
        if (string.equals("FULL")) {
            this.parseTreeType = 2;
            return;
        }
        if (string.equals("COMPACT")) {
            this.parseTreeType = 1;
            return;
        }
        if (string.equals("XML")) {
            this.parseTreeType = 3;
            return;
        }
        if (string.equals("NONE")) {
            this.parseTreeType = 0;
            return;
        }
    }

    public final void parse() throws IOException {
        this.resetParser();
        this.parserStack.push(new ParserStackElement(GenericParser.initialState(), E_O_I));
        this.readTokenFlag = true;
        do {
            this.setParseState(this.currentState());
            this.getParseAction();
        } while (this.performParseAction());
    }

    public final void parse(Reader reader) throws IOException {
        if (this.input.getReader() != null) {
            this.input.getReader().close();
        }
        this.input.setReader(reader);
        this.parse();
    }

    public final void parse(String string) throws IOException {
        this.parse(new IncludeReader(string));
    }

    public final void parse(Tokenizer tokenizer) throws IOException {
        this.input = tokenizer;
        this.parse();
    }

    public final void parse(int n) throws IOException {
        this.setTreeType(n);
        this.parse();
    }

    public final void parse(boolean bl) throws IOException {
        this.parseTreeType = bl ? 2 : 1;
        this.parse();
    }

    protected final ParseNode node(ParserRule parserRule, int n) {
        return ((ParserStackElement)this.parserStack.peek(parserRule.length - n)).getNode();
    }

    protected final void replaceStackNode(ParserRule parserRule, int n, ParseNode parseNode) {
        ((ParserStackElement)this.parserStack.peek(parserRule.length - n)).setNode(parseNode);
    }

    public final ErrorManager errorManager() {
        return this._errorManager;
    }

    public final void setErrorManager(ErrorManager errorManager) {
        this._errorManager = errorManager;
    }

    final ParserState currentState() {
        return ((ParserStackElement)this.parserStack.peek()).getState();
    }

    public final Error syntaxError(String string) {
        return new Error().setLabel("Syntax Error: ").setMsg(string);
    }

    public final Error syntaxError(String string, Locatable locatable) {
        return this.syntaxError(string).setExtent(locatable);
    }

    public final Error fatalError(String string) {
        return new Error().setLabel("Fatal Error: ").setMsg(string).setSee(" - aborting");
    }

    public final Error fatalError(String string, Locatable locatable) {
        return this.fatalError(string).setExtent(locatable);
    }

    protected final void recoverFromError() throws IOException {
        this.findErrorCulprit();
        this.rewindErrorStack();
        this.performErrorAction();
        this.skipErrorTokens();
    }

    private final void findErrorCulprit() throws IOException {
        String string;
        ParseNode parseNode = this.latestToken();
        if (parseNode.isEOI()) {
            this._errorManager.reportError(this.syntaxError("unexpected end of input", parseNode));
            this.abort();
        }
        String string2 = parseNode.symbol() == ERROR_SYMBOL ? (parseNode.svalue() == null ? "garbage" : parseNode.svalue()) : (string = parseNode.toString());
        if (this._errorManager.isReportingErrors()) {
            if (this.previousCulprit == null || !this.previousCulprit.equals(parseNode)) {
                this._errorManager.reportError(this.syntaxError("unexpected " + string, parseNode));
            }
            this.previousCulprit = parseNode;
            this._errorManager.reportErrors(false);
        }
        if (!this._errorManager.isRecoveringErrors()) {
            this.abort();
        }
        if (this.trace) {
            this.err.println("*** Recovering from error...");
        }
    }

    private final void rewindErrorStack() throws IOException {
        this.tokenNode = this.error();
        while (!this.symbolIsHandled(this.tokenNode.symbol())) {
            if (this.setParseState(this.currentState()) == GenericParser.initialState()) {
                Error error = this.fatalError("unrecoverable syntax error");
                this._errorManager.reportError(error);
                this.abort();
            }
            this.parserStack.pop();
        }
    }

    private final void performErrorAction() throws IOException {
        this.setParseState(this.currentState());
        this.parseAction = this.parseState.getAction((ParserTerminal)this.tokenNode.symbol());
        this.performParseAction();
    }

    private final void skipErrorTokens() throws IOException {
        do {
            this.readToken();
        } while (!this.tokenNode.isEOI() && !this.symbolIsHandled(this.tokenNode.symbol()));
        if (this.tokenNode.isEOI()) {
            Error error = this.fatalError("can't recover past the end of input");
            this._errorManager.reportError(error);
            this.abort();
        }
    }

    final boolean symbolIsHandled(ParserSymbol parserSymbol) {
        return this.currentState().actionTable.containsKey(parserSymbol);
    }

    final ParserState setParseState(ParserState parserState) {
        this.previousState = this.parseState;
        this.parseState = parserState;
        return this.parseState;
    }

    final void changeState() throws IOException {
        this.setParseState(this.currentState().getGoto((ParserNonTerminal)this.parsedNode.symbol()));
    }

    final void shift() throws IOException {
        this.setParseState(states[this.parseAction.info]);
        ParseNode parseNode = this.tokenNode();
        if (parseNode.isTerminal()) {
            parseNode.setXmlInfo(((ParserTerminal)parseNode.symbol()).xmlInfo());
        }
        this.push(parseNode);
        if (this.trace) {
            this.trace(this.parseAction);
        }
        this.readTokenFlag = true;
    }

    final void reduce() throws IOException {
        this.parseRule = rules[this.parseAction.info];
        this.parsedNode = this.semanticAction(this.parseRule);
        this.popHandle();
        this.changeState();
        this.push(this.parsedNode);
        if (this.trace) {
            this.trace(this.parseAction);
        }
    }

    void popHandle() {
        this.parseHandle = new ParserStackElement[this.parseRule.length];
        int n = this.parseRule.length;
        while (n-- > 0) {
            this.parseHandle[n] = (ParserStackElement)this.parserStack.pop();
        }
        if (this.parseHandle.length > 0) {
            this.parsedNode.setSpan(this.parseHandle);
        } else {
            this.parsedNode.setSpan(this.tokenNode.getStart(), this.tokenNode.getStart());
        }
        switch (this.parseTreeType) {
            case 0: {
                break;
            }
            case 3: {
                this.parsedNode.setXmlInfo(this.parseRule.xmlInfo());
            }
            default: {
                for (n = 0; n < this.parseHandle.length; ++n) {
                    this.parsedNode.addChild(this.parseHandle[n].getNode(), this.parseTreeType);
                }
            }
        }
    }

    public String fileName() {
        if (this.input instanceof FileTokenizer) {
            return ((FileTokenizer)this.input).fileName();
        }
        return null;
    }

    protected String location() throws IOException {
        if (this.tokenNode().isLocated()) {
            return this.tokenNode().locationString();
        }
        String string = this.fileName();
        String string2 = "line " + String.valueOf(this.input.lineNumber());
        if (string != null) {
            string2 = "file " + string + ", " + string2;
        }
        return string2;
    }

    public final ParseNode locate(ParseNode parseNode) {
        parseNode.setLineNumber(this.input.lineNumber());
        parseNode.setFile(this.fileName());
        return parseNode;
    }

    public final void abort() {
        throw new FatalParseErrorException();
    }

    public final boolean tracingIsOn() {
        return this.trace;
    }

    public final void setTrace(boolean bl) {
        this.trace = bl;
        this.err.print("*** Tracing is turned " + (this.trace ? "on" : "off"));
        if (this.trace) {
            this.err.print(" (enter '" + Debug.getQuitString() + "' to exit trace mode)");
        }
        this.err.println("\n");
    }

    public final void toggleTrace() {
        this.setTrace(!this.trace);
    }

    protected final void step() {
        String string = Debug.step();
        if (Debug.matchesQuitString(string)) {
            this.toggleTrace();
        }
    }

    public final void trace() throws IOException {
        if (this.trace) {
            this.show();
            this.step();
        }
    }

    public final void traceAction(ParserAction parserAction) throws IOException {
        switch (parserAction.type) {
            case 0: {
                this.err.println("Shifting token: " + this.tokenNode() + "\n    located in: " + this.location() + "\n    from state: " + this.previousState + "\n      to state: " + this.parseState);
                break;
            }
            case 1: {
                this.err.println("  Seeing token: " + this.tokenNode() + "\n    located in: " + this.location() + "\n      in state: " + this.previousState + "\n reducing with: " + this.rule() + "\n      to state: " + this.parseState);
            }
        }
        this.err.println(Misc.view(this.parserStack, " parser stack", 0, 50));
    }

    void show() throws IOException {
        this.showParseState();
    }

    String rule() {
        if (this.parseRule != null) {
            Object object = this.parseRule.toString();
            for (int i = 0; i < this.parseRule.length; ++i) {
                object = (String)object + this.parseHandle[i].getNode() + " ";
            }
            return object;
        }
        return null;
    }

    protected final void showParseState() throws IOException {
        this.err.println("\n-------------------------------------------------------------------");
        this.err.println("parseState\t= " + this.parseState);
        if (this.previousState != null) {
            this.err.println("previousState\t= " + this.previousState);
        }
        this.err.println("tokenNode\t= " + this.tokenNode());
        this.err.println("latestToken\t= " + this.latestToken());
        this.err.println("parsedNode\t= " + this.parsedNode);
        this.err.println("parseAction\t= " + this.parseAction);
        this.err.println("parseRule\t= " + this.rule());
        this.err.println(Misc.view(this.parserStack, "parserStack", 0, 50));
        this.err.println("handledSymbols\t= " + this.currentState().actionTable);
        this.err.println("-------------------------------------------------------------------");
    }

    static {
        terminalTable = new HashMap();
        nonterminalTable = new HashMap();
        _o = new XMLOutputter(Format.getPrettyFormat());
    }
}

