/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.io.IncludeReader;
import hlt.language.io.StreamTokenizer;
import hlt.language.syntax.BadGrammarException;
import hlt.language.syntax.Documentor;
import hlt.language.syntax.Follow;
import hlt.language.syntax.GrammarSymbol;
import hlt.language.syntax.Item;
import hlt.language.syntax.NonFatalParseErrorException;
import hlt.language.syntax.NonTerminal;
import hlt.language.syntax.Operator;
import hlt.language.syntax.OperatorSymbol;
import hlt.language.syntax.Options;
import hlt.language.syntax.Rule;
import hlt.language.syntax.RulePath;
import hlt.language.syntax.RuleTag;
import hlt.language.syntax.State;
import hlt.language.syntax.Symbol;
import hlt.language.syntax.Taggable;
import hlt.language.syntax.Terminal;
import hlt.language.syntax.XmlInfo;
import hlt.language.syntax.xml.XmlAnnotationParser;
import hlt.language.syntax.xml.XmlAnnotationTokenizer;
import hlt.language.util.ArrayList;
import hlt.language.util.SetOf;
import hlt.language.util.Stack;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Grammar {
    StreamTokenizer st;
    static PrintStream out = Options.getOutStream();
    static PrintStream err = Options.getErrStream();
    private int verbosity = Options.getVerbosity();
    String grammarName = Options.getGrammarName();
    String grammarPathedName = Options.getGrammarPathedName() + "." + Options.getGrammarSuffix();
    boolean permissible = Options.getPermissible();
    static Grammar currentGrammar;
    static long startTime;
    static long readingStart;
    static long preprocessStart;
    static long buildingStart;
    static long propagationStart;
    static long analysisTime;
    static long totalTime;
    ArrayList terminals = new ArrayList(200);
    ArrayList nonterminals = new ArrayList(200);
    ArrayList rules = new ArrayList(500);
    ArrayList items = new ArrayList(1000);
    ArrayList states = new ArrayList(3000);
    ArrayList operators = new ArrayList(100);
    boolean RULE_ORDER_MODE = false;
    int tcount = 0;
    int ncount = 0;
    int rcount = 0;
    int icount = 0;
    int scount = 0;
    int ocount = 0;
    HashMap stateTable = new HashMap(500);
    static Terminal EMPTY;
    static Terminal END_OF_INPUT;
    static Terminal ERROR;
    static NonTerminal START;
    static NonTerminal GRAMMAR_START;
    static NonTerminal FIRST_ROOT;
    static String xmlroot;
    static String xmlRootNSPrefix;
    static NonTerminal ROOTS;
    HashMap roots = new HashMap();
    private static final HashMap terminalTable;
    private static final HashMap nonterminalTable;
    private static final ArrayList ruleSequence;
    static final String EMPTY_ACTION = "$empty$";
    static final String DEFAULT_ACTION = "$default$";
    static final int SINGLE_QUOTE = 39;
    static final int DOUBLE_QUOTE = 34;
    static final int RULE_NECK = 58;
    static final int OR_RULE_BODY = 124;
    static final int BEGIN_SCOPE = 123;
    static final int END_SCOPE = 125;
    static final int BEGIN_ANNOTATION = 91;
    static final int END_ANNOTATION = 93;
    static final int COMMAND_START = 37;
    static final int PSEUDO_VAR = 36;
    static final int END_OF_RULE = 59;
    static final int COMMA = 44;
    static final int SPACE = 32;
    static final int NEWLINE = 10;
    static final int TAB = 9;
    String nodePrefix = "$";
    String nodeSuffix = "$";
    private static final String START_COMMAND_ID = "start";
    private static final String ROOT_COMMAND_ID = "root";
    private static final String TOKEN_COMMAND_ID = "token";
    private static final String LEFT_COMMAND_ID = "left";
    private static final String RIGHT_COMMAND_ID = "right";
    private static final String NONASSOC_COMMAND_ID = "nonassoc";
    private static final String LBRACE_COMMAND_ID = "{";
    private static final String RBRACE_COMMAND_ID = "}";
    private static final String USEFILE_COMMAND_ID = "usefile";
    private static final String SECTION_COMMAND_ID = "%";
    private static final String PREC_COMMAND_ID = "prec";
    private static final String PACKAGE_COMMAND_ID = "package";
    private static final String IMPORT_COMMAND_ID = "import";
    private static final String PRECSTEP_COMMAND_ID = "precstep";
    private static final String NODECLASS_COMMAND_ID = "nodeclass";
    private static final String ACCESS_COMMAND_ID = "access";
    private static final String DYNAMIC_COMMAND_ID = "dynamic";
    private static final String NODEPREFIX_COMMAND_ID = "nodeprefix";
    private static final String NODESUFFIX_COMMAND_ID = "nodesuffix";
    private static final String DOC_COMMAND_ID = "doc";
    private static final String INCLUDE_COMMAND_ID = "include";
    private static final String XMLROOT_COMMAND_ID = "xmlroot";
    private static final String XMLNS_COMMAND_ID = "xmlns";
    private static final String XMLINFO_COMMAND_ID = "xmlinfo";
    private static final int UNKNOWN_COMMAND = -1;
    private static final int START_COMMAND = 0;
    private static final int ROOT_COMMAND = 1;
    private static final int TOKEN_COMMAND = 2;
    private static final int LEFT_COMMAND = 3;
    private static final int RIGHT_COMMAND = 4;
    private static final int NONASSOC_COMMAND = 5;
    private static final int LBRACE_COMMAND = 6;
    private static final int RBRACE_COMMAND = 7;
    private static final int USEFILE_COMMAND = 8;
    private static final int SECTION_COMMAND = 9;
    private static final int PREC_COMMAND = 10;
    private static final int PACKAGE_COMMAND = 11;
    private static final int IMPORT_COMMAND = 12;
    private static final int PRECSTEP_COMMAND = 13;
    private static final int NODECLASS_COMMAND = 14;
    private static final int ACCESS_COMMAND = 15;
    private static final int DYNAMIC_COMMAND = 16;
    private static final int OPERATOR_COMMAND = 17;
    private static final int NODEPREFIX_COMMAND = 18;
    private static final int NODESUFFIX_COMMAND = 19;
    private static final int DOC_COMMAND = 20;
    private static final int INCLUDE_COMMAND = 21;
    private static final int XMLROOT_COMMAND = 22;
    private static final int XMLNS_COMMAND = 23;
    private static final int XMLINFO_COMMAND = 24;
    private static final HashMap commandCodeTable;
    String accessTag = "";
    boolean isDynamic = false;
    static final HashMap operatorCategoryTable;
    static final HashMap operatorNameTable;
    private static NonTerminal operatorCategory;
    private GrammarSymbol currentLHS;
    private boolean mainDocSection = true;
    private boolean codeSection = false;
    String packageName = null;
    ArrayList imports = new ArrayList();
    ArrayList parserDeclarations = new ArrayList();
    ArrayList ancillaryClasses = new ArrayList();
    HashMap publicClasses = new HashMap();
    private boolean readingRemainderSection = false;
    private static final int bufferSize = 80;
    private XmlInfo ruleXmlInfo = null;
    private String ruleAction = null;
    private String ruleUndoAction = null;
    private String ruleActionCast = "";
    private String ruleUndoActionCast = "";
    private Taggable ruleTag = null;
    private boolean nodeCast = false;
    private boolean containsHeadReference = false;
    private int newSymbolCount = 0;
    static final int LEFT_ASSOCIATIVE = 0;
    static final int RIGHT_ASSOCIATIVE = 1;
    static final int NON_ASSOCIATIVE = 2;
    static final int MIN_PRECEDENCE = 1;
    static final int MAX_PRECEDENCE = 1200;
    private static int currentPrecedence;
    private static int precedenceLevel;
    private static int precedenceIncrement;
    static final int RAW_MODE = 0;
    static final int NORMAL_MODE = 1;
    static final int EOL_MODE = 2;
    static final int NO_EOL_MODE = 3;
    static boolean isRAW_MODE;
    static boolean isEOL_MODE;
    static boolean wasRAW_MODE;
    static boolean wasEOL_MODE;
    GrammarSymbol docSymbol;
    StringBuilder mainDoc;
    StringBuilder doc;
    IncludeReader rd;
    private SetOf nodeClasses = new SetOf(this.nonterminals);
    private SetOf superNodeClasses = new SetOf(this.nonterminals);
    private ArrayList namespaces = new ArrayList();
    boolean hasXmlSerialization = false;
    private XmlAnnotationParser _xmlAnnotationParser;
    private final HashMap nodeCastTable = new HashMap();
    private SetOf LDomain;
    private SetOf LRange;
    private SetOf LRoots;
    private SetOf LInners;
    private ArrayList LOrder = new ArrayList();
    private final Stack new_states = new Stack();
    private State initState;
    int fcount = 0;
    ArrayList follows = new ArrayList();
    SetOf FDomain = new SetOf(this.follows);
    SetOf FRange = new SetOf(this.follows);
    SetOf FRoots = new SetOf(this.follows);
    SetOf FInners = new SetOf(this.follows);
    ArrayList FOrder;
    int progress = 0;

    Grammar() throws Exception {
        currentGrammar = this;
        EMPTY = new Terminal("$EMPTY$");
        END_OF_INPUT = new Terminal("$E_O_I$");
        ERROR = new Terminal("error");
        terminalTable.put("error", ERROR);
        START = new NonTerminal("$START$");
        ROOTS = new NonTerminal("$ROOTS$");
        GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[]{START, ROOTS};
        new Rule(grammarSymbolArray);
        this.readGrammar();
        if (Options.getDocOnly()) {
            new Documentor();
        } else {
            this.buildGrammar();
        }
    }

    public final String name() {
        return this.grammarName;
    }

    static final Terminal getTerminal(String string) {
        return (Terminal)terminalTable.get(string);
    }

    static final NonTerminal getNonTerminal(String string) {
        return (NonTerminal)nonterminalTable.get(string);
    }

    final Terminal getTerminal(int n) {
        return (Terminal)this.terminals.get(n);
    }

    final NonTerminal getNonTerminal(int n) {
        return (NonTerminal)this.nonterminals.get(n);
    }

    final Rule getRule(int n) {
        return (Rule)this.rules.get(n);
    }

    final Item getItem(int n) {
        return (Item)this.items.get(n);
    }

    final Item getItem(Rule rule, int n) {
        return (Item)this.items.get(rule.items[n - 1]);
    }

    final int itemIndex(Rule rule, int n) {
        return rule.items[n - 1];
    }

    final State getState(int n) {
        return (State)this.states.get(n);
    }

    final Operator getOperator(int n) {
        return (Operator)this.operators.get(n);
    }

    static String xmlroot() {
        if (xmlroot == null) {
            xmlroot = FIRST_ROOT.name();
        }
        return xmlroot;
    }

    static String xmlRootNSPrefix() {
        return xmlRootNSPrefix;
    }

    final NonTerminal startSymbol() {
        return GRAMMAR_START;
    }

    static final void def_cmd(String string, int n) {
        commandCodeTable.put(string, n);
    }

    boolean admitsOperators() {
        return this.isDynamic && this.ocount > 0;
    }

    private static final int commandCode(String string) {
        Integer n = (Integer)commandCodeTable.get(string);
        if (n != null) {
            return n;
        }
        if (operatorCategoryTable.get(string) == null) {
            return -1;
        }
        operatorCategory = Grammar.getNonTerminal(string);
        return 17;
    }

    private boolean startIsDefined() {
        return GRAMMAR_START != null;
    }

    private final NonTerminal newSymbol() {
        return new NonTerminal("$ACTION" + String.valueOf(this.newSymbolCount++) + "$");
    }

    public static final int checkPrecedenceLevel(int n) {
        if (n < 1 || n > 1200) {
            Grammar.warning("Token precedence value out of range: " + n + " (precedence set to 1)");
            return 1;
        }
        return n;
    }

    static final int prologPrecedence(int n) {
        return 1201 - n;
    }

    private final Terminal newTerminal(String string) {
        Terminal terminal = new Terminal(string);
        terminalTable.put(string, terminal);
        return terminal;
    }

    private final Terminal newTerminal(String string, boolean bl) {
        Terminal terminal = new Terminal(string, bl);
        terminalTable.put(string, terminal);
        return terminal;
    }

    private final NonTerminal newNonTerminal(String string) {
        NonTerminal nonTerminal = new NonTerminal(string);
        nonterminalTable.put(string, nonTerminal);
        return nonTerminal;
    }

    private final void newRule() {
        GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[ruleSequence.size()];
        for (int i = 0; i < grammarSymbolArray.length; ++i) {
            grammarSymbolArray[i] = (GrammarSymbol)ruleSequence.get(i);
        }
        if (this.ruleAction == null || this.ruleAction.length() == 0) {
            this.ruleAction = grammarSymbolArray.length == 1 ? EMPTY_ACTION : DEFAULT_ACTION;
        }
        if (this.ruleUndoAction == null || this.ruleUndoAction.length() == 0) {
            this.ruleUndoAction = EMPTY_ACTION;
        }
        Rule rule = new Rule(grammarSymbolArray, this.ruleAction, this.ruleUndoAction, this.nodeCast);
        rule.setXmlInfo(this.ruleXmlInfo);
        if (this.ruleTag != null) {
            rule.tag = this.ruleTag;
            rule.tagPosition = -1;
        }
        if (Options.getDocOnly() && this.doc != null) {
            rule.doc = this.doc;
            this.doc = null;
        }
        this.resetRuleParameters();
    }

    final void setSyntax(int n) {
        switch (n) {
            case 0: {
                this.st.resetSyntax();
                isRAW_MODE = true;
                break;
            }
            case 1: {
                this.setGrammarSyntax();
                isRAW_MODE = false;
                break;
            }
            case 2: {
                this.st.eolIsSignificant(true);
                isEOL_MODE = true;
                break;
            }
            case 3: {
                this.st.eolIsSignificant(false);
                isEOL_MODE = false;
            }
        }
    }

    final void saveSyntax() {
        wasRAW_MODE = isRAW_MODE;
        wasEOL_MODE = isEOL_MODE;
    }

    final void restoreSyntax() {
        this.setSyntax(wasRAW_MODE ? 0 : 1);
        this.setSyntax(wasEOL_MODE ? 2 : 3);
    }

    private final int getToken() throws IOException {
        int n = this.st.nextToken();
        if (isRAW_MODE) {
            return n;
        }
        if (n == 47 && this.st.peek() == 42) {
            this.saveSyntax();
            if (Options.getDocOnly() && !this.codeSection) {
                this.processSlashStarComment();
            } else {
                this.skipSlashStarComment();
            }
            this.restoreSyntax();
            return this.getToken();
        }
        return n;
    }

    private final void processSlashStarComment() throws IOException {
        this.st.skipChar();
        if (this.st.peek() != 42) {
            this.skipSlashStarComment();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.setSyntax(0);
        this.st.nextToken();
        while (this.st.nextToken() != 42 || this.st.peek() != 47) {
            if (this.st.ttype == 42) continue;
            stringBuilder.append((char)this.st.ttype);
        }
        stringBuilder.append("\n<P>\n");
        this.st.nextToken();
        if (this.docSymbol != null) {
            this.docSymbol.addDoc(stringBuilder);
            this.docSymbol = null;
            stringBuilder = null;
            return;
        }
        if (this.mainDocSection) {
            if (this.mainDoc == null) {
                this.mainDoc = new StringBuilder();
            }
            this.mainDoc.append((CharSequence)stringBuilder);
        } else {
            if (this.doc == null) {
                this.doc = new StringBuilder();
            }
            this.doc.append((CharSequence)stringBuilder);
        }
    }

    private final void skipSlashStarComment() throws IOException {
        this.st.pushBack();
        this.setSyntax(0);
        while (this.st.nextToken() != 42 || this.st.peek() != 47) {
        }
        this.st.skipChar();
    }

    private final void setGrammarSyntax() {
        this.st.setDefaultSyntax();
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.slashStarComments(false);
    }

    private final String location() {
        if (this.rd == null) {
            return "unlocatable Reader";
        }
        return "(file " + this.rd.getFile() + ", line " + this.rd.getLineNumber() + ")";
    }

    private final void complain(String string) throws Exception {
        throw new BadGrammarException(string + " " + this.location());
    }

    private final void readGrammar() throws Exception {
        this.reportProgress();
        try {
            this.rd = new IncludeReader(new BufferedReader(new FileReader(this.grammarPathedName)));
            this.rd.setFile(this.grammarPathedName);
            this.st = new StreamTokenizer(this.rd);
        }
        catch (Exception exception) {
            this.complain("File not found: " + exception.getMessage());
        }
        this.setSyntax(1);
        try {
            this.readDeclarations();
            this.readRules();
            this.readRemainder();
        }
        catch (EOFException eOFException) {
            try {
                this.rd.close();
            }
            catch (IOException iOException) {
                this.complain("An IOException happened when closing the input reader");
            }
        }
    }

    private final void readDeclarations() throws Exception {
        while (this.readDeclaration()) {
        }
    }

    private final boolean readDeclaration() throws Exception {
        switch (this.getToken()) {
            case 37: {
                return this.executeNextCommand();
            }
            case -1: {
                this.complain("Premature end of file");
            }
            case 10: {
                return this.readDeclaration();
            }
        }
        this.complain("Ill-formed syntax in grammar declarations section");
        return false;
    }

    private final boolean executeNextCommand() throws Exception {
        String string = this.readCommand();
        switch (Grammar.commandCode(string)) {
            case 9: {
                this.setSyntax(3);
                this.mainDocSection = false;
                return false;
            }
            case -1: {
                this.complain("Unknown grammar command: %" + string);
            }
            case 0: {
                this.declareStart();
                break;
            }
            case 1: {
                this.declareRoot();
                break;
            }
            case 3: {
                this.declareLeftAssoc();
                break;
            }
            case 4: {
                this.declareRightAssoc();
                break;
            }
            case 2: 
            case 5: {
                this.declareNonassoc();
                break;
            }
            case 6: {
                this.codeSection = true;
                this.parserDeclarations.add(this.verbatim(String.valueOf('%') + RBRACE_COMMAND_ID));
                this.codeSection = false;
                break;
            }
            case 8: {
                this.declareList(this.parserDeclarations);
                break;
            }
            case 11: {
                this.declarePackage();
                break;
            }
            case 12: {
                this.declareList(this.imports);
                break;
            }
            case 13: {
                this.declarePrecstep();
                break;
            }
            case 14: {
                this.declareNodeClass();
                break;
            }
            case 18: {
                this.declareNodePrefix();
                break;
            }
            case 19: {
                this.declareNodeSuffix();
                break;
            }
            case 20: {
                this.processDoc();
                break;
            }
            case 21: {
                this.processInclude();
                break;
            }
            case 22: {
                this.processXmlRoot();
                break;
            }
            case 23: {
                this.processXmlNs();
                break;
            }
            case 24: {
                this.processTerminalXmlAnnotation();
                break;
            }
            case 16: {
                this.declareDynamic();
                break;
            }
            case 17: {
                this.declareOperator();
                break;
            }
            case 15: {
                this.declareAccess();
                break;
            }
            default: {
                this.complain("Command " + string + " is not yet implemented - sorry!");
            }
        }
        return true;
    }

    private final String readCommand() throws Exception {
        this.checkCommandSyntax();
        String string = null;
        if (this.getToken() == -4) {
            string = this.st.sval.intern();
        } else {
            string = String.valueOf((char)this.st.ttype).intern();
            if (string != LBRACE_COMMAND_ID && string != SECTION_COMMAND_ID) {
                this.complain("Ill-formed grammar command: " + string);
            }
        }
        return string;
    }

    private final void checkCommandSyntax() throws Exception {
        if (!this.validCommandStartCharacter(this.st.peek())) {
            this.complain("Invalid command start: %" + (char)this.st.peek() + "...");
        }
    }

    private final boolean validCommandStartCharacter(int n) {
        Iterator iterator = commandCodeTable.keySet().iterator();
        while (iterator.hasNext()) {
            if ((char)n != ((String)iterator.next()).charAt(0)) continue;
            return true;
        }
        iterator = operatorCategoryTable.keySet().iterator();
        while (iterator.hasNext()) {
            if ((char)n != ((String)iterator.next()).charAt(0)) continue;
            return true;
        }
        return false;
    }

    private final void declareStart() throws Exception {
        GrammarSymbol grammarSymbol;
        if (this.startIsDefined()) {
            this.complain("Start symbol (" + this.startSymbol() + ") cannot be redefined");
        }
        if (this.getToken() != -4) {
            this.complain("Ill-formed start symbol declaration");
        }
        if ((grammarSymbol = Grammar.getTerminal(this.st.sval)) != null) {
            this.complain("Token " + grammarSymbol + " cannot be the start symbol!");
        }
        if ((grammarSymbol = Grammar.getNonTerminal(this.st.sval)) != null) {
            if (((NonTerminal)grammarSymbol).isStart()) {
                this.complain("Symbol " + grammarSymbol + " is already the start symbol!");
            } else {
                this.defineStart((NonTerminal)grammarSymbol);
            }
        } else {
            this.defineStart(this.newNonTerminal(this.st.sval));
        }
    }

    private final void defineStart(NonTerminal nonTerminal) {
        GRAMMAR_START = nonTerminal;
        GRAMMAR_START.makeStart();
        GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[]{ROOTS, GRAMMAR_START};
        new Rule(grammarSymbolArray);
        if (!nonTerminal.isRoot()) {
            this.defineRoot(nonTerminal);
        }
    }

    private final void declareRoot() throws Exception {
        GrammarSymbol grammarSymbol;
        if (this.getToken() != -4) {
            this.complain("Ill-formed root symbol declaration");
        }
        if ((grammarSymbol = Grammar.getTerminal(this.st.sval)) != null) {
            this.complain("Token " + grammarSymbol + " cannot be a root symbol!");
        }
        if ((grammarSymbol = Grammar.getNonTerminal(this.st.sval)) != null) {
            if (((NonTerminal)grammarSymbol).isRoot()) {
                this.complain("Symbol " + grammarSymbol + " is already a root symbol!");
            } else {
                this.defineRoot((NonTerminal)grammarSymbol);
            }
        } else {
            this.defineRoot(this.newNonTerminal(this.st.sval));
        }
    }

    private final void defineRoot(NonTerminal nonTerminal) {
        nonTerminal.makeRoot();
        Terminal terminal = this.newTerminal("$" + nonTerminal.name() + "_switch$");
        this.roots.put(nonTerminal, terminal);
        GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[]{ROOTS, terminal, nonTerminal};
        new Rule(grammarSymbolArray, "$head$ = $head$.copy(node($rule$,2));");
        if (FIRST_ROOT == null) {
            FIRST_ROOT = nonTerminal;
        }
    }

    private final void defineTokens(ArrayList arrayList, int n) throws Exception {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.defineToken((String)iterator.next(), n);
        }
    }

    private final void defineToken(String string, int n) throws Exception {
        GrammarSymbol grammarSymbol = Grammar.getNonTerminal(string);
        if (grammarSymbol != null) {
            this.complain("Nonterminal " + grammarSymbol + " cannot be a token!");
        }
        if ((grammarSymbol = Grammar.getTerminal(string)) != null) {
            this.complain("Duplicate token declaration: " + grammarSymbol);
        }
        grammarSymbol = this.newTerminal(string);
        ((Terminal)grammarSymbol).precedence = currentPrecedence;
        ((Terminal)grammarSymbol).associativity = n;
    }

    private final ArrayList tokensInLine() throws Exception {
        ArrayList arrayList = new ArrayList(10);
        this.setSyntax(2);
        currentPrecedence = -1;
        block5: while (this.getToken() != 10) {
            if (this.st.ttype == 92 && this.st.peek() == 10) {
                this.st.skipChar();
                this.getToken();
            }
            switch (this.st.ttype) {
                case -4: 
                case 34: 
                case 39: {
                    arrayList.add(this.st.sval);
                    continue block5;
                }
                case -5: {
                    if (currentPrecedence != -1) {
                        this.complain("Duplicate precedence specified in token declaration");
                    }
                    currentPrecedence = Grammar.checkPrecedenceLevel(Grammar.prologPrecedence((int)this.st.nval));
                    continue block5;
                }
                case -1: {
                    this.complain("Premature end of file");
                }
            }
            arrayList.add(String.valueOf((char)this.st.ttype));
        }
        if (arrayList.isEmpty()) {
            this.complain("No token found in token declaration");
        }
        if (currentPrecedence == -1) {
            currentPrecedence = this.nextPrecedenceLevel();
        }
        this.setSyntax(3);
        return arrayList;
    }

    private final int nextPrecedenceLevel() {
        int n = precedenceLevel;
        precedenceLevel += precedenceIncrement;
        return Grammar.checkPrecedenceLevel(n);
    }

    private final void declareLeftAssoc() throws Exception {
        this.defineTokens(this.tokensInLine(), 0);
    }

    private final void declareRightAssoc() throws Exception {
        this.defineTokens(this.tokensInLine(), 1);
    }

    private final void declareNonassoc() throws Exception {
        this.defineTokens(this.tokensInLine(), 2);
    }

    private final void declareNodePrefix() throws Exception {
        this.setSyntax(2);
        switch (this.getToken()) {
            case -4: 
            case 34: 
            case 39: {
                this.nodePrefix = this.st.sval.intern();
                break;
            }
            default: {
                this.complain("Missing node prefix specifier");
            }
        }
        this.setSyntax(3);
    }

    private final void declareNodeSuffix() throws Exception {
        this.setSyntax(2);
        switch (this.getToken()) {
            case -4: 
            case 34: 
            case 39: {
                this.nodeSuffix = this.st.sval.intern();
                break;
            }
            default: {
                this.complain("Missing node suffix specifier");
            }
        }
        this.setSyntax(3);
    }

    private final void processDoc() throws Exception {
        this.setSyntax(2);
        switch (this.getToken()) {
            case 34: 
            case 39: {
                this.docSymbol = Grammar.getTerminal(this.st.sval);
                if (this.docSymbol != null) break;
                this.docSymbol = this.newTerminal(this.st.sval);
                break;
            }
            case -4: {
                this.docSymbol = Grammar.getTerminal(this.st.sval);
                if (this.docSymbol != null) break;
                this.docSymbol = Grammar.getNonTerminal(this.st.sval);
                if (this.docSymbol == null) break;
                this.docSymbol = this.newTerminal(this.st.sval);
                break;
            }
            default: {
                this.complain("Missing symbol in doc command");
            }
        }
        this.setSyntax(3);
    }

    private final void declareAccess() throws Exception {
        this.setSyntax(2);
        switch (this.getToken()) {
            case -4: {
                this.accessTag = this.st.sval.intern();
                if (this.accessTag != "public" && this.accessTag != "private" && this.accessTag != "protected") {
                    this.complain("Bad access tag value (" + this.accessTag + ")");
                }
                this.accessTag = this.accessTag + " ";
                break;
            }
            default: {
                this.complain("Missing tag in access command");
            }
        }
        this.setSyntax(3);
    }

    private final void declareNodeClass() throws Exception {
        NonTerminal nonTerminal;
        if (this.getToken() != -4) {
            this.complain("Ill-formed node class declaration");
        }
        String string = "";
        if (this.st.sval.intern() == "public") {
            string = "public";
            if (this.getToken() != -4) {
                this.complain("Ill-formed nodeclass declaration");
            }
        }
        if (Grammar.getTerminal(this.st.sval) != null) {
            this.complain("Can't define a node class for a terminal (" + this.st.sval + ")");
        }
        if ((nonTerminal = Grammar.getNonTerminal(this.st.sval)) != null) {
            if (this.nodeClasses.contains(nonTerminal)) {
                this.complain("Duplicate node class declaration for symbol " + nonTerminal);
            }
        } else {
            nonTerminal = this.newNonTerminal(this.st.sval);
        }
        this.nodeClasses.add(nonTerminal);
        NonTerminal nonTerminal2 = null;
        if (this.getToken() == -4 && this.st.sval.intern() == "extends") {
            if (this.getToken() != -4 || this.st.sval.intern() == "implements" || this.st.sval.intern() == "locates") {
                this.complain("Error in node class declaration: identifier missing after 'extends'");
            }
            if (Grammar.getTerminal(this.st.sval) != null) {
                this.complain("Can't define node class " + nonTerminal + " as a subclass of a terminal (" + this.st.sval + ")");
            }
            if ((nonTerminal2 = Grammar.getNonTerminal(this.st.sval)) == null) {
                nonTerminal2 = this.newNonTerminal(this.st.sval);
            }
            this.superNodeClasses.add(nonTerminal2);
        } else {
            this.st.pushBack();
        }
        Object object = "";
        if (this.getToken() == -4 && this.st.sval.intern() == "implements") {
            object = "implements ";
            if (this.getToken() != -4 || this.st.sval.intern() == "locates") {
                this.complain("Error in nodeclass declaration: identifier missing after 'implements'");
            }
            do {
                object = (String)object + this.st.sval;
                if (this.getToken() != 44) break;
                object = (String)object + ", ";
            } while (this.getToken() == -4 && this.st.sval.intern() != "locates");
        }
        this.st.pushBack();
        String string2 = null;
        if (this.getToken() == -4 && this.st.sval.intern() == "locates") {
            if (this.getToken() != -4) {
                this.complain("Error in nodeclass declaration: identifier missing after 'locates'");
            }
            string2 = this.st.sval;
        } else {
            this.st.pushBack();
        }
        if (this.getToken() != 123) {
            this.complain("Missing '{' in nodeclass declaration");
        }
        String string3 = this.bracedString();
        nonTerminal.nodeType = this.nodePrefix + nonTerminal.name + this.nodeSuffix;
        String string4 = nonTerminal2 == null ? "ParseNode" : this.nodePrefix + nonTerminal2.name + this.nodeSuffix;
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(string).append(string.length() > 0 ? " " : "").append("class ").append(nonTerminal.nodeType).append(" extends " + string4 + " ").append((String)object).append("\n{\n  ").append(string).append(string.length() > 0 ? " " : "").append(nonTerminal.nodeType).append(" (ParseNode node)\n    {\n      super(node);\n    }\n\n  ").append(string3.trim());
        if (string2 != null) {
            stringBuilder.append("\n").append("\n  public final void locate ()").append("\n    {").append("\n      if (" + string2 + " != null)").append("\n        {").append("\n          " + string2 + ".setStart(getStart());").append("\n          " + string2 + ".setEnd(getEnd());").append("\n        }").append("\n    }");
        }
        stringBuilder.append("\n}");
        if (string.intern() != "public") {
            this.ancillaryClasses.add(stringBuilder);
        } else {
            this.publicClasses.put(nonTerminal.nodeType, stringBuilder);
        }
    }

    private final String annotationString() throws Exception {
        return this.bracedString(91, 93);
    }

    private final String bracedString() throws Exception {
        return this.bracedString(123, 125);
    }

    private final String bracedString(int n, int n2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(80);
        this.setSyntax(0);
        int n3 = 1;
        while (n3 > 0) {
            int n4 = this.getToken();
            if (n4 == n) {
                stringBuilder.append((char)n);
                ++n3;
                continue;
            }
            if (n4 == n2) {
                if (n3 > 1) {
                    stringBuilder.append((char)n2);
                }
                --n3;
                continue;
            }
            stringBuilder.append((char)n4);
        }
        this.setSyntax(1);
        return stringBuilder.toString();
    }

    private final void declarePackage() throws Exception {
        if (this.packageName != null) {
            this.complain("Duplicate package declaration");
        }
        if (this.getToken() != -4) {
            this.complain("Bad package declaration");
        }
        this.packageName = this.st.sval;
        this.setSyntax(2);
        while (this.getToken() != 10) {
        }
        this.setSyntax(3);
    }

    private final void declareList(ArrayList arrayList) throws Exception {
        this.setSyntax(0);
        StringBuilder stringBuilder = new StringBuilder(80);
        String string = "";
        block6: while (true) {
            switch (this.getToken()) {
                case -1: {
                    if (this.readingRemainderSection) continue block6;
                    this.complain("Premature end of file");
                    continue block6;
                }
                case 37: {
                    this.st.pushBack();
                }
                case 59: {
                    string = stringBuilder.toString().trim();
                    if (string.length() <= 0) break block6;
                    arrayList.add(string);
                    break block6;
                }
                case 9: 
                case 10: 
                case 32: 
                case 44: {
                    string = stringBuilder.toString().trim();
                    if (string.length() <= 0) continue block6;
                    arrayList.add(string);
                    stringBuilder = new StringBuilder(80);
                    continue block6;
                }
                default: {
                    stringBuilder.append((char)this.st.ttype);
                    continue block6;
                }
            }
            break;
        }
        if (!this.readingRemainderSection) {
            this.setSyntax(1);
        }
    }

    private final void processInclude() throws Exception {
        this.setSyntax(2);
        switch (this.getToken()) {
            case -4: 
            case 34: 
            case 39: {
                this.rd.include(Options.includeBase() + File.separator + this.st.sval);
                break;
            }
            default: {
                this.complain("Bad %include argument");
            }
        }
        this.setSyntax(3);
        if (this.verbosity > 0) {
            out.println("*** Including file " + this.rd.getFile() + " ...");
        }
    }

    private final String readLine() throws Exception {
        int n;
        StringBuilder stringBuilder = new StringBuilder(80);
        this.setSyntax(0);
        while ((n = this.getToken()) != 10) {
            stringBuilder.append((char)n);
        }
        this.setSyntax(1);
        return stringBuilder.toString();
    }

    private final void processXmlRoot() throws Exception {
        if (xmlroot != null) {
            this.complain("Duplicate %xmlroot command");
        }
        this.setSyntax(2);
        switch (this.getToken()) {
            case -4: 
            case 34: 
            case 39: {
                xmlRootNSPrefix = this.st.sval;
                break;
            }
            default: {
                this.complain("Ill-formed XML element name in %xmlroot command");
            }
        }
        switch (this.getToken()) {
            case -4: 
            case 34: 
            case 39: {
                xmlroot = this.st.sval;
                break;
            }
            case 10: {
                xmlroot = xmlRootNSPrefix;
                xmlRootNSPrefix = "";
                break;
            }
            default: {
                this.complain("Ill-formed XML element name in %xmlroot command");
            }
        }
        if (this.verbosity > 0) {
            if (xmlRootNSPrefix != "") {
                out.println("*** Setting XML root's namespace to " + xmlRootNSPrefix);
                out.println("*** Setting XML root to " + xmlRootNSPrefix + ":" + xmlroot);
            } else {
                out.println("*** Setting XML root to " + xmlroot);
            }
        }
        this.setSyntax(1);
    }

    ArrayList namespaces() {
        return this.namespaces;
    }

    private final void processXmlNs() throws Exception {
        this.setSyntax(2);
        this.getToken();
        if (this.st.ttype != 39 && this.st.ttype != 34 && this.st.ttype != -4) {
            this.complain("Bad XML namespace identifier in '%xmlns' command");
        }
        String string = this.st.sval;
        this.namespaces.add(string);
        this.getToken();
        if (this.st.ttype != 39 && this.st.ttype != 34) {
            this.complain("Bad XML namespace value: missing quote in '%xmlns' command");
        }
        this.namespaces.add(this.st.sval);
        if (this.verbosity > 0) {
            out.println("*** Defining XML namespace prefix: " + string + " = \"" + this.st.sval + "\"");
        }
        this.setSyntax(1);
    }

    private final Terminal getDefinedTerminal(String string) throws Exception {
        GrammarSymbol grammarSymbol = Grammar.getNonTerminal(string);
        if (grammarSymbol != null) {
            this.complain("Can't annotate non-terminal symbol '" + string + "'");
        }
        if ((grammarSymbol = Grammar.getTerminal(string)) == null) {
            this.complain("Can't annotate undefined terminal symbol '" + string + "'");
        }
        return (Terminal)grammarSymbol;
    }

    private final void declarePrecstep() throws Exception {
        if (this.getToken() != -5) {
            this.complain("Precedence increment must be a number");
        }
        precedenceIncrement = (int)this.st.nval;
    }

    private final void declareDynamic() throws Exception {
        this.setSyntax(2);
        String string = null;
        switch (this.getToken()) {
            case -1: {
                this.complain("Premature end of file");
            }
            case 10: {
                break;
            }
            case -4: {
                string = this.st.sval;
                break;
            }
            default: {
                this.complain("Bad dynamic operator declaration");
            }
        }
        this.isDynamic = true;
        if (string == null) {
            return;
        }
        NonTerminal nonTerminal = Grammar.getNonTerminal(string);
        if (nonTerminal == null) {
            nonTerminal = this.newNonTerminal(string);
        }
        nonTerminal.isOperator = true;
        if (Grammar.getTerminal(string) == null) {
            operatorCategoryTable.put(string, new ArrayList());
            string = string.toUpperCase();
            this.declareSubCategory(nonTerminal, string + "_");
            this.declareSubCategory(nonTerminal, "_" + string + "_");
            this.declareSubCategory(nonTerminal, "_" + string);
        } else {
            this.complain("Terminal " + string + " cannot be used as an operator category!");
        }
        this.setSyntax(3);
    }

    private final void declareSubCategory(GrammarSymbol grammarSymbol, String string) {
        Terminal terminal = Grammar.getTerminal(string);
        if (terminal == null) {
            terminal = this.newTerminal(string, true);
        } else {
            Grammar.warning("operator subcategory " + string + " is multiply defined");
        }
        GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[]{grammarSymbol, terminal};
        new Rule(grammarSymbolArray, DEFAULT_ACTION);
    }

    private final void declareOperator() throws Exception {
        String string = null;
        this.setSyntax(2);
        ArrayList arrayList = (ArrayList)operatorCategoryTable.get(Grammar.operatorCategory.name);
        switch (this.getToken()) {
            case -1: {
                this.complain("Premature end of file");
            }
            case 10: {
                this.complain("Premature end of dynamic operator declaration");
            }
            case -4: 
            case 34: 
            case 39: {
                string = this.st.sval;
                break;
            }
            case -5: {
                this.complain("Bad dynamic operator declaration");
            }
            default: {
                string = String.valueOf((char)this.st.ttype);
            }
        }
        if (Grammar.getNonTerminal(string) != null) {
            this.complain("Nonterminal " + string + " cannot be used as an operator!");
        }
        String string2 = null;
        int n = 0;
        block6 : switch (this.getToken()) {
            case -1: {
                this.complain("Premature end of file");
            }
            case 10: {
                this.complain("Premature end of dynamic operator declaration");
            }
            case -4: 
            case 34: 
            case 39: {
                string2 = this.st.sval;
                switch (this.getToken()) {
                    case -5: {
                        n = Grammar.checkPrecedenceLevel(Grammar.prologPrecedence((int)this.st.nval));
                        break block6;
                    }
                    case 10: {
                        n = this.nextPrecedenceLevel();
                        this.st.pushBack();
                        break block6;
                    }
                }
                this.complain("Bad dynamic operator declaration");
                break;
            }
            case -5: {
                n = Grammar.checkPrecedenceLevel(Grammar.prologPrecedence((int)this.st.nval));
                switch (this.getToken()) {
                    case -4: 
                    case 34: 
                    case 39: {
                        string2 = this.st.sval;
                        break block6;
                    }
                }
                this.complain("Bad dynamic operator declaration");
                break;
            }
            default: {
                this.complain("Bad dynamic operator declaration");
            }
        }
        Operator operator = new Operator(string, operatorCategory, n, string2);
        int n2 = arrayList.indexOf(operator);
        if (n2 == -1) {
            operator.add();
            ++this.ocount;
            arrayList.add(operator);
            arrayList = (ArrayList)operatorNameTable.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                operatorNameTable.put(string, arrayList);
            }
            arrayList.add(operator);
        } else {
            ((Operator)this.operators.get(n2)).redefine(n, string2);
        }
        this.setSyntax(3);
    }

    private final StringBuilder verbatim(String string) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(80);
        StringBuilder stringBuilder2 = new StringBuilder(80);
        this.setSyntax(0);
        int n = string.length();
        if (n > 0) {
            char c = (char)this.getToken();
            while (true) {
                int n2;
                if (c != string.charAt(0)) {
                    stringBuilder.append(c);
                    c = (char)this.getToken();
                    continue;
                }
                stringBuilder2.setLength(0);
                for (n2 = 0; n2 < n && c == string.charAt(n2); ++n2) {
                    stringBuilder2.append(c);
                    c = (char)this.getToken();
                }
                if (n2 == n) {
                    this.st.pushBack();
                    break;
                }
                stringBuilder.append((CharSequence)stringBuilder2);
            }
        }
        this.setSyntax(1);
        return stringBuilder;
    }

    private final void readRules() throws Exception {
        Object object;
        if (!this.superNodeClasses.minus(this.nodeClasses).isEmpty()) {
            System.err.println("*** The following non-terminals must be declared as node classes:");
            System.err.println();
            object = this.superNodeClasses.iterator();
            while (object.hasNext()) {
                System.err.println("\t" + object.next());
            }
            System.err.println();
            this.complain("Incomplete node class declarations");
        }
        while (this.readRule()) {
        }
        if (!this.startIsDefined()) {
            object = "There are no rules in this grammar!";
            if (this.permissible) {
                Grammar.warning((String)object);
            } else {
                this.complain((String)object);
            }
        }
        if (this.undefinedSymbols() | this.unreachableSymbols()) {
            object = "This grammar has disconnected symbols";
            if (this.permissible) {
                Grammar.warning((String)object);
            } else {
                this.complain((String)object);
            }
        }
    }

    private final boolean readRule() throws Exception {
        if (!this.readRuleHead()) {
            return false;
        }
        this.readRuleBody();
        return true;
    }

    private final boolean readRuleHead() throws Exception {
        switch (this.getToken()) {
            case -1: {
                return false;
            }
            case -4: {
                this.checkSymbol(this.st.sval, true);
                if (this.getToken() == 58) break;
                this.complain("Missing RULE_NECK after left-hand side symbol in rule");
                break;
            }
            case 58: {
                if (this.currentLHS != null) break;
                this.complain("Missing left-hand side symbol in rule");
                break;
            }
            case 37: {
                this.setSyntax(0);
                if (this.st.peek() == 37) {
                    return false;
                }
                return this.executeIncludeCommand() && this.readRuleHead();
            }
            default: {
                System.out.println("Read grammar token: " + this.st);
                this.complain("Ill-formed left-hand side in rule");
            }
        }
        return true;
    }

    private final boolean executeIncludeCommand() throws Exception {
        this.setSyntax(1);
        String string = this.readCommand();
        switch (Grammar.commandCode(string)) {
            case 21: {
                this.processInclude();
                break;
            }
            default: {
                this.complain("Command " + string + " is not allowed here");
            }
        }
        return true;
    }

    private final void readRuleBody() throws Exception {
        block10: while (true) {
            int n = this.getToken();
            switch (n) {
                case -1: {
                    this.complain("Premature end of file");
                }
                case -4: {
                    this.checkSymbol(this.st.sval, false);
                    continue block10;
                }
                case 34: 
                case 39: {
                    this.checkTerminal(this.st.sval);
                    continue block10;
                }
                case 124: {
                    this.newRule();
                    ruleSequence.add(this.currentLHS);
                    continue block10;
                }
                case 123: {
                    this.readAction();
                    continue block10;
                }
                case 37: {
                    this.processRulePrec();
                    continue block10;
                }
                case 91: {
                    this.processRuleXmlAnnotation();
                    continue block10;
                }
                case 59: {
                    this.newRule();
                    return;
                }
            }
            this.complain("Ill-formed syntax in rule body ('" + String.valueOf((char)n) + "')");
        }
    }

    XmlAnnotationParser xmlAnnotationParser(String string) {
        if (this._xmlAnnotationParser == null) {
            XmlAnnotationParser xmlAnnotationParser = new XmlAnnotationParser(new XmlAnnotationTokenizer(string));
            xmlAnnotationParser.errorManager().reportErrors(false);
            return xmlAnnotationParser;
        }
        this._xmlAnnotationParser.reset(string);
        return this._xmlAnnotationParser;
    }

    private final void processTerminalXmlAnnotation() throws Exception {
        this.hasXmlSerialization = true;
        this.setSyntax(2);
        this.getToken();
        if (this.st.ttype != 39 && this.st.ttype != 34 && this.st.ttype != -4) {
            this.complain("Bad terminal identifier in '%xmlinfo' command");
        }
        Terminal terminal = this.getDefinedTerminal(this.st.sval.intern());
        if (this.getToken() != 91) {
            this.complain("Missing XML annotation for terminal '" + terminal + "'");
        }
        String string = this.annotationString();
        XmlAnnotationParser xmlAnnotationParser = this.xmlAnnotationParser(string);
        try {
            xmlAnnotationParser.parse();
        }
        catch (Exception exception) {
            this.complain("Bad terminal XML annotation: " + string);
        }
        XmlInfo xmlInfo = xmlAnnotationParser.xmlInfo().setIsTerminal();
        if (xmlInfo.localName() == null) {
            xmlInfo.setLocalName(terminal.name());
        }
        terminal.setXmlInfo(xmlInfo);
        this.setSyntax(1);
    }

    private final void processRuleXmlAnnotation() throws Exception {
        if (this.ruleXmlInfo != null) {
            this.complain("Duplicate rule annotation");
        }
        this.hasXmlSerialization = true;
        String string = this.annotationString();
        XmlAnnotationParser xmlAnnotationParser = this.xmlAnnotationParser(string);
        try {
            xmlAnnotationParser.parse();
        }
        catch (Exception exception) {
            this.complain("Bad rule XML annotation: " + string);
        }
        this.ruleXmlInfo = xmlAnnotationParser.xmlInfo();
    }

    private final void processRulePrec() throws Exception {
        if (this.st.peek() == PREC_COMMAND_ID.charAt(0)) {
            this.getToken();
            if (Grammar.commandCode(this.st.sval) == 10) {
                if (this.ruleTag != null) {
                    this.complain("Duplicate %prec command in rule");
                }
                this.readRuleTag();
                return;
            }
        }
        this.complain("Bad %prec command in grammar rule body");
    }

    private final void readRuleTag() throws Exception {
        this.getToken();
        if (this.st.ttype == -4 || this.st.ttype == 39 || this.st.ttype == 34) {
            this.ruleTag = Grammar.getTerminal(this.st.sval);
            if (this.ruleTag == null) {
                this.complain("Unknown token as %prec argument " + this.st.sval);
            }
            if (this.ruleTag.isOperator()) {
                this.complain("Dynamic operators cannot be used as %prec argument " + this.st.sval);
            }
            ((Terminal)this.ruleTag).isTag = true;
            return;
        }
        if (this.st.ttype == -5) {
            int n = Grammar.checkPrecedenceLevel(Grammar.prologPrecedence((int)this.st.nval));
            this.getToken();
            if (this.st.ttype != -4 && this.st.ttype != 39 && this.st.ttype != 34) {
                this.complain("Bad %prec associativity specifier");
            }
            try {
                this.ruleTag = new RuleTag(n, this.st.sval);
            }
            catch (NonFatalParseErrorException nonFatalParseErrorException) {
                Grammar.loudWarning("Ill-formed specifier " + this.location() + " - " + this.st.sval + "; %prec command ignored");
            }
        } else {
            this.complain("Ill-formed %prec argument in grammar rule body");
        }
    }

    private final boolean undefinedSymbols() {
        ArrayList arrayList = new ArrayList();
        for (NonTerminal nonTerminal : this.nonterminals) {
            if (!nonTerminal.rules.isEmpty()) continue;
            arrayList.add(nonTerminal);
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() > 1) {
                err.println("*** These non-terminal symbols have no rules:\n");
            } else {
                err.println("*** This non-terminal symbol has no rules:\n");
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                err.println("\t" + iterator.next());
            }
            err.println();
            if (arrayList.size() > 1) {
                err.println("*** Declare them as tokens or give rules for them.");
            } else {
                err.println("*** Declare it as a token or give rules for it.");
            }
            return true;
        }
        return false;
    }

    private final void traverseRules(GrammarSymbol grammarSymbol, HashSet hashSet) {
        hashSet.add(grammarSymbol);
        if (grammarSymbol instanceof NonTerminal) {
            for (Rule rule : ((NonTerminal)grammarSymbol).rules) {
                for (int i = 1; i < rule.sequence.length; ++i) {
                    if (hashSet.contains(rule.sequence[i])) continue;
                    this.traverseRules(rule.sequence[i], hashSet);
                }
            }
        }
    }

    private final boolean unreachableSymbols() {
        HashSet hashSet = new HashSet();
        this.traverseRules(START, hashSet);
        HashSet<GrammarSymbol> hashSet2 = new HashSet<GrammarSymbol>();
        for (GrammarSymbol grammarSymbol : this.nonterminals) {
            if (hashSet.contains(grammarSymbol)) continue;
            hashSet2.add(grammarSymbol);
        }
        for (GrammarSymbol grammarSymbol : this.terminals) {
            if (grammarSymbol.isSpecial() || hashSet.contains(grammarSymbol)) continue;
            hashSet2.add(grammarSymbol);
        }
        if (!hashSet2.isEmpty()) {
            if (hashSet2.size() > 1) {
                err.print("*** These symbols are ");
            } else {
                err.print("*** This symbol is ");
            }
            err.println("not reachable from any root:\n");
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                err.println("\t" + iterator.next());
            }
            err.println();
            err.println("*** Check the grammar in File " + this.grammarPathedName + " and correct this.");
            return true;
        }
        return false;
    }

    private final void checkSymbol(String string, boolean bl) throws Exception {
        GrammarSymbol grammarSymbol = Grammar.getTerminal(string);
        if (grammarSymbol != null) {
            if (bl) {
                this.complain("Terminal " + grammarSymbol + " cannot be a left-hand side!");
            }
        } else {
            grammarSymbol = Grammar.getNonTerminal(string);
            if (grammarSymbol == null) {
                grammarSymbol = this.newNonTerminal(string);
            }
            if (bl) {
                this.currentLHS = grammarSymbol;
                if (!this.startIsDefined()) {
                    this.defineStart(FIRST_ROOT == null ? (NonTerminal)grammarSymbol : FIRST_ROOT);
                }
                grammarSymbol.addDoc(this.doc);
                this.doc = null;
            }
        }
        this.checkAction(grammarSymbol);
    }

    private final void checkTerminal(String string) {
        Terminal terminal = Grammar.getTerminal(string);
        if (terminal == null) {
            terminal = this.newTerminal(string);
        }
        this.checkAction(terminal);
    }

    private final void checkAction(GrammarSymbol grammarSymbol) {
        if (this.ruleAction != null) {
            NonTerminal nonTerminal = this.newSymbol();
            GrammarSymbol[] grammarSymbolArray = new GrammarSymbol[1];
            int n = ruleSequence.size() - 1;
            grammarSymbolArray[0] = nonTerminal;
            new Rule(grammarSymbolArray, this.offsetActionNodes(this.ruleAction, n), this.offsetActionNodes(this.ruleUndoAction, n), this.nodeCast).setXmlInfo(this.ruleXmlInfo);
            ruleSequence.add(nonTerminal);
            if (this.containsHeadReference) {
                Grammar.warning("pseudo-variable $$ in intermediate action " + this.location());
            }
            this.resetActionParameters();
        }
        ruleSequence.add(grammarSymbol);
    }

    private final void resetRuleParameters() {
        this.ruleTag = null;
        ruleSequence.clear();
        this.ruleXmlInfo = null;
        this.resetActionParameters();
    }

    private final void resetActionParameters() {
        this.ruleAction = null;
        this.ruleUndoAction = null;
        this.ruleActionCast = "";
        this.ruleUndoActionCast = "";
        this.nodeCast = false;
        this.containsHeadReference = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String offsetActionNodes(String string, int n) {
        if (string == null || string.length() == 0) {
            return EMPTY_ACTION;
        }
        StringBuilder stringBuilder = new StringBuilder(80);
        int n2 = string.length();
        int n3 = 0;
        char c = string.charAt(n3);
        while (true) {
            if (c < '0' || c > '9') {
                stringBuilder.append(c);
                if (++n3 == n2) return stringBuilder.toString();
                c = string.charAt(n3);
                continue;
            }
            if (this.nodeReference(string, n3)) {
                int n4 = 0;
                do {
                    n4 = n4 * 10 + (c - 48);
                } while (++n3 != n2 && '0' <= (c = string.charAt(n3)) && c <= '9');
                stringBuilder.append(String.valueOf(n4 - n));
            } else {
                do {
                    stringBuilder.append(c);
                } while (++n3 != n2 && '0' <= (c = string.charAt(n3)) && c <= '9');
            }
            if (n3 == n2) return stringBuilder.toString();
        }
    }

    private final boolean nodeReference(String string, String string2, int n) {
        int n2 = string2.length();
        return n > n2 - 1 && string.substring(n - n2, n).equals(string2);
    }

    private final boolean nodeReference(String string, int n) {
        return this.nodeReference(string, "($rule$,", n);
    }

    private final void readAction() throws Exception {
        if (this.ruleAction == null) {
            this.translateRuleAction(true);
        } else if (this.isDynamic && this.ruleUndoAction == null) {
            this.translateRuleAction(false);
        } else {
            this.complain("Illegal action occurrence in rule");
        }
    }

    private final void translateRuleAction(boolean bl) throws Exception {
        this.setSyntax(0);
        this.nodeCastTable.clear();
        StringBuilder stringBuilder = new StringBuilder(80);
        int n = 1;
        block7: while (n > 0) {
            switch (this.getToken()) {
                case 123: {
                    stringBuilder.append('{');
                    ++n;
                    continue block7;
                }
                case 125: {
                    if (n > 1) {
                        stringBuilder.append('}');
                    }
                    --n;
                    continue block7;
                }
                case 36: {
                    stringBuilder.append(this.stackReference(bl));
                    continue block7;
                }
                case 10: {
                    stringBuilder.append("\n  ");
                    continue block7;
                }
                case 9: {
                    stringBuilder.append("\t  ");
                    continue block7;
                }
            }
            stringBuilder.append((char)this.st.ttype);
        }
        this.setSyntax(1);
        if (bl) {
            this.ruleAction = this.ruleActionCast + stringBuilder.toString();
        } else {
            this.ruleUndoAction = this.ruleUndoActionCast + stringBuilder.toString();
        }
    }

    private final int readNumber(int n) throws Exception {
        int n2 = 0;
        do {
            n2 = n2 * 10 + (n - 48);
        } while (48 <= (n = this.getToken()) && n <= 57);
        this.st.pushBack();
        return n2;
    }

    private final String stackReference(boolean bl) throws Exception {
        String string = null;
        int n = this.getToken();
        switch (n) {
            case 36: {
                string = this.typeCast(bl, 0, "$head$");
                this.containsHeadReference = true;
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int n2 = this.readNumber(n);
                string = this.typeCast(bl, n2, "node($rule$," + n2 + ")");
                break;
            }
            case 48: {
                string = this.deepStackReference(0, "node($rule$,0)");
                break;
            }
            case 45: {
                int n3 = -this.readNumber(n);
                string = this.deepStackReference(n3, "node($rule$," + n3 + ")");
                break;
            }
            default: {
                this.complain("Ill-formed pseudovariable");
            }
        }
        return string;
    }

    private final String typeCast(boolean bl, int n, String string) throws Exception {
        Object object;
        GrammarSymbol grammarSymbol;
        String string2;
        StringBuilder stringBuilder = new StringBuilder(80);
        if (n >= ruleSequence.size()) {
            this.complain("Pseudovariable out of range: $" + n);
        }
        String string3 = string2 = (grammarSymbol = (GrammarSymbol)ruleSequence.get(n)) instanceof NonTerminal ? ((NonTerminal)grammarSymbol).nodeType : null;
        if (string2 == null) {
            object = string;
        } else {
            this.nodeCast = true;
            object = "$node" + n + "$";
            if (!this.nodeCastTable.containsKey(object)) {
                stringBuilder.append("    ").append(string2).append(" ").append((String)object);
                if (n == 0) {
                    stringBuilder.append(" = new ").append(string2).append("($head$);").append("\n                 $head$ = (").append(string2).append(")").append((String)object).append(";\n");
                } else {
                    stringBuilder.append(";\n                if (").append(string).append(" instanceof ").append(string2).append(")").append("\n                   ").append((String)object).append(" = (").append(string2).append(")").append(string).append(";").append("\n                 else").append("\n                 {").append("\n                     ").append((String)object).append(" = new ").append(string2).append("(").append(string).append(");").append("\n                     replaceStackNode($rule$,").append(n).append(",").append((String)object).append(");").append("\n                   }\n");
                }
                this.nodeCastTable.put(object, object);
            }
        }
        if (bl) {
            this.ruleActionCast = this.ruleActionCast + stringBuilder.toString();
        } else {
            this.ruleUndoActionCast = this.ruleUndoActionCast + stringBuilder.toString();
        }
        return object;
    }

    private final String deepStackReference(int n, String string) throws Exception {
        if (!this.nodeCastTable.containsKey(string)) {
            this.nodeCastTable.put(string, string);
            Grammar.warning("Unsafe stack reference: " + n + " " + this.location() + " - no type cast was generated");
        }
        return string;
    }

    private final void readRemainder() throws Exception {
        this.readingRemainderSection = true;
        this.getToken();
        StringBuilder stringBuilder = new StringBuilder(80);
        block4: while (true) {
            switch (this.getToken()) {
                case -1: {
                    if (!Grammar.isVacuous(stringBuilder)) {
                        this.ancillaryClasses.add(stringBuilder);
                    }
                    return;
                }
                case 37: {
                    if (this.st.peek() != USEFILE_COMMAND_ID.charAt(0)) break;
                    this.setSyntax(1);
                    this.getToken();
                    if (Grammar.commandCode(this.st.sval) == 8) {
                        if (!Grammar.isVacuous(stringBuilder)) {
                            this.ancillaryClasses.add(stringBuilder);
                            stringBuilder = new StringBuilder(80);
                        }
                        this.declareList(this.ancillaryClasses);
                        continue block4;
                    }
                    stringBuilder.append(this.st.sval);
                    continue block4;
                }
            }
            stringBuilder.append((char)this.st.ttype);
        }
    }

    private static final boolean isVacuous(StringBuilder stringBuilder) {
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (Character.isWhitespace(stringBuilder.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static final void warning(String string) {
        out.println("!!! WARNING: " + string);
    }

    static final void loudWarning(String string) {
        Grammar.warning(string);
    }

    private final void buildGrammar() throws Exception {
        this.reportProgress();
        this.preprocessGrammar();
        this.reportProgress();
        this.computeStates();
        this.reportProgress();
        this.propagateLookaheads();
        this.reportProgress();
    }

    private final void preprocessGrammar() throws Exception {
        this.computeFirsts();
        this.computeLGraph();
        this.computePaths();
    }

    private final void computeFirsts() throws Exception {
        boolean bl;
        for (GrammarSymbol grammarSymbol : this.terminals) {
            ((Terminal)grammarSymbol).first = new SetOf(this.terminals);
            if (grammarSymbol.isEmpty()) {
                ((Terminal)grammarSymbol).isNullable = true;
                continue;
            }
            ((Terminal)grammarSymbol).first.add(grammarSymbol);
        }
        for (GrammarSymbol grammarSymbol : this.nonterminals) {
            ((NonTerminal)grammarSymbol).first = new SetOf(this.terminals);
        }
        do {
            bl = false;
            for (Rule rule : this.rules) {
                NonTerminal nonTerminal = rule.head();
                int n = 1;
                SetOf setOf = new SetOf(nonTerminal.first);
                for (int i = 1; i < rule.sequence.length; ++i) {
                    GrammarSymbol grammarSymbol = rule.sequence[i];
                    nonTerminal.first.union(grammarSymbol.first);
                    if (!grammarSymbol.isNullable) break;
                    ++n;
                }
                bl |= !nonTerminal.first.isEqualTo(setOf);
                if (n > rule.nullableIndex) {
                    bl = true;
                    rule.nullableIndex = n;
                }
                if (rule.nullableIndex != rule.sequence.length) continue;
                bl |= !nonTerminal.isNullable;
                nonTerminal.isNullable = true;
            }
        } while (bl);
        this.checkEmptyFirsts();
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            ((Item)iterator.next()).computeSuffixFirst();
        }
    }

    private final void checkEmptyFirsts() throws Exception {
        ArrayList arrayList = new ArrayList();
        for (NonTerminal nonTerminal : this.nonterminals) {
            if (!nonTerminal.first.isEmpty() || nonTerminal.isNullable) continue;
            arrayList.add(nonTerminal);
        }
        if (!arrayList.isEmpty()) {
            Grammar.warning("Groundless nonterminal symbols.");
            if (arrayList.size() > 1) {
                err.print("\n*** These non-terminal symbols do ");
            } else {
                err.print("\n*** This non-terminal symbol does ");
            }
            err.println("not derive any terminal:\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                err.println("\t" + iterator.next());
            }
            err.println();
            if (!this.permissible) {
                err.println("*** Check the grammar in File " + this.grammarPathedName + ": correct it, or use Jacc with the -i option.");
                this.complain("Groundless nonterminal symbols");
            }
        }
    }

    private void computeLGraph() {
        boolean bl;
        Object object;
        Object object2;
        NonTerminal nonTerminal2;
        this.LDomain = new SetOf(this.nonterminals);
        this.LRange = new SetOf(this.nonterminals);
        for (NonTerminal nonTerminal2 : this.nonterminals) {
            nonTerminal2.initPaths();
            nonTerminal2.LSet = new SetOf(this.nonterminals);
            nonTerminal2.LSet.add(nonTerminal2);
            object2 = nonTerminal2.rules.iterator();
            while (object2.hasNext()) {
                object = ((Rule)object2.next()).leftMost();
                if (!(object instanceof NonTerminal)) continue;
                nonTerminal2.LSet.add(object);
                this.LDomain.add(nonTerminal2);
                this.LRange.add(object);
            }
        }
        this.LRoots = SetOf.minus(this.LDomain, this.LRange);
        this.LInners = SetOf.intersection(this.LDomain, this.LRange);
        Stack stack = new Stack();
        object2 = this.LInners.iterator();
        while (object2.hasNext()) {
            stack.push(object2.next());
        }
        object2 = this.LRoots.iterator();
        while (object2.hasNext()) {
            stack.push(object2.next());
        }
        object2 = new SetOf(this.nonterminals);
        while (!stack.empty()) {
            nonTerminal2 = (NonTerminal)stack.pop();
            if (((SetOf)object2).contains(nonTerminal2)) continue;
            this.LOrder.add(nonTerminal2);
            ((SetOf)object2).add(nonTerminal2);
            object = nonTerminal2.LSet.iterator();
            while (object.hasNext()) {
                stack.push(object.next());
            }
        }
        do {
            bl = false;
            for (int i = this.LOrder.size() - 1; i >= 0; --i) {
                nonTerminal2 = (NonTerminal)this.LOrder.get(i);
                SetOf setOf = new SetOf(nonTerminal2.LSet);
                Iterator iterator = nonTerminal2.LSet.iterator();
                while (iterator.hasNext()) {
                    setOf.union(((NonTerminal)iterator.next()).LSet);
                }
                bl |= !nonTerminal2.LSet.isEqualTo(setOf);
                nonTerminal2.LSet = setOf;
            }
        } while (bl);
    }

    private void computePaths() {
        boolean bl;
        NonTerminal nonTerminal;
        Iterator iterator = this.LDomain.iterator();
        while (iterator.hasNext()) {
            nonTerminal = (NonTerminal)iterator.next();
            for (Rule rule : nonTerminal.rules) {
                GrammarSymbol grammarSymbol = rule.leftMost();
                if (!(grammarSymbol instanceof NonTerminal)) continue;
                ((NonTerminal)grammarSymbol).addLRule(nonTerminal, rule);
            }
        }
        Object object = null;
        do {
            bl = false;
            for (int i = this.LOrder.size() - 1; i >= 0; --i) {
                nonTerminal = (NonTerminal)this.LOrder.get(i);
                if (this.LRoots.contains(nonTerminal)) continue;
                ArrayList arrayList = nonTerminal.paths;
                object = new ArrayList();
                for (RulePath rulePath : arrayList) {
                    for (NonTerminal nonTerminal2 : nonTerminal.LTable.keySet()) {
                        SetOf setOf = nonTerminal.getLRules(nonTerminal2);
                        Iterator iterator2 = setOf.iterator();
                        while (iterator2.hasNext()) {
                            Rule rule;
                            rule = (Rule)iterator2.next();
                            ((ArrayList)object).add(rulePath.prepend(rule));
                        }
                    }
                }
                Iterator iterator3 = ((ArrayList)object).iterator();
                while (iterator3.hasNext()) {
                    RulePath rulePath;
                    rulePath = (RulePath)iterator3.next();
                    bl |= rulePath.start.addPath(rulePath);
                }
            }
        } while (bl);
    }

    private final void addNewState(State state) {
        state.add();
        ++this.scount;
        this.stateTable.put(state, state);
        this.new_states.push(state);
    }

    final State checkNewState(State state) {
        State state2 = (State)this.stateTable.get(state);
        if (state2 != null) {
            return state2;
        }
        this.addNewState(state);
        return state;
    }

    private final void computeStates() {
        int n;
        Item item = this.getItem((Rule)Grammar.START.rules.get(0), 1);
        this.initState = new State(item);
        this.initState.closure();
        this.addNewState(this.initState);
        do {
            ((State)this.new_states.pop()).computeNextStates();
        } while (!this.new_states.isEmpty());
        State state = null;
        boolean bl = false;
        for (n = 0; n < this.scount; ++n) {
            state = this.getState(n);
            state.extractKernels();
            bl |= state.computePreds();
        }
        while (bl) {
            bl = false;
            for (n = 0; n < this.scount; ++n) {
                bl |= this.getState(n).computePreds();
            }
        }
    }

    private final void propagateLookaheads() {
        this.computeFollows();
        this.computeLookaheads();
    }

    private final void computeFollows() {
        this.buildFollowGraph();
        this.orderFollowGraph();
        this.closeFollowGraph();
    }

    private final void buildFollowGraph() {
        this.initState.getFollow(ROOTS).addFollows(new SetOf(this.terminals).add(END_OF_INPUT));
        for (State state : this.states) {
            Iterator iterator = state.kernels.iterator();
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                if (!item.markerIsNonTerminal()) continue;
                NonTerminal nonTerminal = (NonTerminal)item.marker();
                Follow follow = state.getFollow(nonTerminal);
                follow.addFollows(item.suffixFirst);
                if (!item.isNullable) continue;
                Iterator iterator2 = item.pred(state).iterator();
                while (iterator2.hasNext()) {
                    State state2 = (State)iterator2.next();
                    Iterator iterator3 = state2.kernels.iterator();
                    while (iterator3.hasNext()) {
                        Item item2 = (Item)iterator3.next();
                        if (!item2.markerIsNonTerminal()) continue;
                        NonTerminal nonTerminal2 = (NonTerminal)item2.marker();
                        NonTerminal nonTerminal3 = item.rule.head();
                        if (!nonTerminal2.LSet.contains(nonTerminal3)) continue;
                        SetOf setOf = nonTerminal2.path(nonTerminal3);
                        follow.addFollows(setOf);
                        Follow follow2 = state2.getFollow(nonTerminal2);
                        if (!nonTerminal2.pathIsNullable(nonTerminal3)) continue;
                        follow2.addPred(follow);
                        this.FDomain.add(follow2);
                        this.FRange.add(follow);
                    }
                }
            }
        }
        this.FRoots = SetOf.minus(this.FDomain, this.FRange);
        this.FInners = SetOf.intersection(this.FDomain, this.FRange);
    }

    private final void orderFollowGraph() {
        this.FOrder = new ArrayList(this.fcount);
        Stack stack = new Stack();
        Object object = this.FInners.iterator();
        while (object.hasNext()) {
            stack.push(object.next());
        }
        object = this.FRoots.iterator();
        while (object.hasNext()) {
            stack.push(object.next());
        }
        object = new SetOf(this.follows);
        while (!stack.empty()) {
            Follow follow = (Follow)stack.pop();
            if (((SetOf)object).contains(follow)) continue;
            this.FOrder.add(follow);
            ((SetOf)object).add(follow);
            Iterator iterator = follow.preds.iterator();
            while (iterator.hasNext()) {
                stack.push(iterator.next());
            }
        }
    }

    private final void closeFollowGraph() {
        boolean bl;
        do {
            bl = false;
            for (int i = 0; i < this.FOrder.size(); ++i) {
                Follow follow = (Follow)this.FOrder.get(i);
                Iterator iterator = follow.preds.iterator();
                while (iterator.hasNext()) {
                    Follow follow2 = (Follow)iterator.next();
                    bl |= follow2.addFollows(follow.follows);
                }
            }
        } while (bl);
    }

    final void computeLookaheads() {
        for (State state : this.states) {
            Iterator iterator = state.items.iterator();
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                if (!item.isFinal()) continue;
                SetOf setOf = item.initLookaheads(state);
                NonTerminal nonTerminal = item.rule.head();
                Iterator iterator2 = item.pred(state).iterator();
                while (iterator2.hasNext()) {
                    State state2 = (State)iterator2.next();
                    if (nonTerminal.isSTART()) {
                        setOf.union(state2.follow(this.startSymbol()));
                    }
                    Iterator iterator3 = state2.kernels.iterator();
                    while (iterator3.hasNext()) {
                        Item item2 = (Item)iterator3.next();
                        if (!item2.markerIsNonTerminal()) continue;
                        NonTerminal nonTerminal2 = (NonTerminal)item2.marker();
                        if (!nonTerminal2.LSet.contains(nonTerminal)) continue;
                        SetOf setOf2 = nonTerminal2.path(nonTerminal);
                        setOf.union(setOf2);
                        if (!nonTerminal2.pathIsNullable(nonTerminal)) continue;
                        setOf.union(state2.follow(nonTerminal2));
                    }
                }
            }
        }
    }

    private final void reportProgress() {
        switch (++this.progress) {
            case 1: {
                this.reportProgress_1();
                break;
            }
            case 2: {
                this.reportProgress_2();
                break;
            }
            case 3: {
                this.reportProgress_3();
                break;
            }
            case 4: {
                this.reportProgress_4();
                break;
            }
            case 5: {
                this.reportProgress_5();
            }
        }
    }

    private final long now() {
        return System.currentTimeMillis();
    }

    private final void reportProgress_1() {
        startTime = this.now();
        if (this.verbosity > 0) {
            out.println("*** This is Jacc: Just another compiler compiler... ");
            out.println("*** Run of " + new Date());
            out.println("*** Reading grammar in file " + this.grammarPathedName + " ... ");
        }
        readingStart = this.now();
    }

    private final void reportProgress_2() {
        if (this.verbosity > 0) {
            if (this.verbosity > 1) {
                out.println("***\t... in " + (this.now() - readingStart) + " ms");
                if (this.verbosity > 2) {
                    this.showRules();
                }
            }
            out.println("*** Starting grammar analysis ... ");
            if (this.verbosity > 1) {
                out.println("***\tPreprocessing the grammar ... ");
            }
        }
        preprocessStart = this.now();
    }

    private final void reportProgress_3() {
        if (this.verbosity > 1) {
            out.println("***\t... in " + (this.now() - preprocessStart) + " ms");
            if (this.verbosity > 2) {
                this.showSymbols();
            }
        }
        if (this.verbosity > 1) {
            out.println("***\tBuilding canonical LR states ... ");
        }
        buildingStart = this.now();
    }

    private final void reportProgress_4() {
        if (this.verbosity > 1) {
            out.println("***\t ... in " + (this.now() - buildingStart) + " ms");
            out.println("***\tPropagating lookahead symbols ... ");
        }
        propagationStart = this.now();
    }

    private final void reportProgress_5() {
        if (this.verbosity > 1) {
            out.println("***\t ... in " + (this.now() - propagationStart) + " ms");
        }
        analysisTime = this.now() - preprocessStart;
        if (this.verbosity > 0) {
            out.println("*** Grammar analysis completed in " + analysisTime + " ms.");
        }
        totalTime = this.now() - startTime;
    }

    final void showStates() {
        out.println("\n");
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((State)iterator.next()).show();
        }
    }

    private final void showRules() {
        out.println("\nRULES:\n");
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            out.println(iterator.next());
        }
        out.println();
    }

    static final String associativity(Terminal terminal) {
        if (terminal.isOperator) {
            return DYNAMIC_COMMAND_ID;
        }
        switch (terminal.associativity) {
            case 0: {
                return LEFT_COMMAND_ID;
            }
            case 1: {
                return RIGHT_COMMAND_ID;
            }
        }
        return "none";
    }

    private final void showSymbols() {
        out.println("\nTERMINALS:\n");
        out.println("\t----------\t-------------\t--------");
        out.println("\tPRECEDENCE\tASSOCIATIVITY\tTERMINAL");
        out.println("\t----------\t-------------\t--------");
        for (Symbol symbol : this.terminals) {
            out.println("[" + symbol.index() + "]\t" + ((Terminal)symbol).precedence + "\t\t" + Grammar.associativity((Terminal)symbol) + "\t\t" + (Terminal)symbol);
        }
        out.println("\t----------------------------------------");
        if (!this.operators.isEmpty()) {
            out.println("\nDYNAMIC OPERATORS:\n");
            out.println("\t----------\t---------\t--------\t--------");
            out.println("\tPRECEDENCE\tSPECIFIER\tOPERATOR\tCATEGORY");
            out.println("\t----------\t---------\t--------\t--------");
            for (Symbol symbol : this.operators) {
                out.println("[" + symbol.index() + "]\t" + ((Operator)symbol).precedence + "\t\t" + ((OperatorSymbol)symbol).specifier() + "\t\t" + ((Operator)symbol).name + "\t\t" + ((Operator)symbol).category.name);
            }
            out.println("\t---------------------------------------------------------");
        }
        out.println("\nNON TERMINALS:\n");
        for (Symbol symbol : this.nonterminals) {
            out.println("  [" + symbol.index() + "]\t" + (NonTerminal)symbol + (((NonTerminal)symbol).isNullable ? "\t(nullable)" : "") + "\n\tFIRST:\t " + ((NonTerminal)symbol).first + "\n\tLSet:\t " + ((NonTerminal)symbol).LSet + "\n");
        }
        out.println();
    }

    static {
        xmlroot = null;
        xmlRootNSPrefix = "";
        terminalTable = new HashMap(100);
        nonterminalTable = new HashMap(100);
        ruleSequence = new ArrayList(20);
        commandCodeTable = new HashMap(50);
        Grammar.def_cmd(START_COMMAND_ID, 0);
        Grammar.def_cmd(ROOT_COMMAND_ID, 1);
        Grammar.def_cmd(TOKEN_COMMAND_ID, 2);
        Grammar.def_cmd(LEFT_COMMAND_ID, 3);
        Grammar.def_cmd(RIGHT_COMMAND_ID, 4);
        Grammar.def_cmd(NONASSOC_COMMAND_ID, 5);
        Grammar.def_cmd(LBRACE_COMMAND_ID, 6);
        Grammar.def_cmd(RBRACE_COMMAND_ID, 7);
        Grammar.def_cmd(USEFILE_COMMAND_ID, 8);
        Grammar.def_cmd(SECTION_COMMAND_ID, 9);
        Grammar.def_cmd(PREC_COMMAND_ID, 10);
        Grammar.def_cmd(PACKAGE_COMMAND_ID, 11);
        Grammar.def_cmd(IMPORT_COMMAND_ID, 12);
        Grammar.def_cmd(PRECSTEP_COMMAND_ID, 13);
        Grammar.def_cmd(NODECLASS_COMMAND_ID, 14);
        Grammar.def_cmd(ACCESS_COMMAND_ID, 15);
        Grammar.def_cmd(DYNAMIC_COMMAND_ID, 16);
        Grammar.def_cmd(NODEPREFIX_COMMAND_ID, 18);
        Grammar.def_cmd(NODESUFFIX_COMMAND_ID, 19);
        Grammar.def_cmd(DOC_COMMAND_ID, 20);
        Grammar.def_cmd(INCLUDE_COMMAND_ID, 21);
        Grammar.def_cmd(XMLROOT_COMMAND_ID, 22);
        Grammar.def_cmd(XMLNS_COMMAND_ID, 23);
        Grammar.def_cmd(XMLINFO_COMMAND_ID, 24);
        operatorCategoryTable = new HashMap(20);
        operatorNameTable = new HashMap(20);
        precedenceLevel = 1;
        precedenceIncrement = 10;
    }
}

