/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.Grammar;
import hlt.language.syntax.NonTerminal;
import hlt.language.syntax.Rule;
import hlt.language.syntax.Symbol;
import hlt.language.syntax.Terminal;
import hlt.language.util.ArrayList;
import hlt.language.util.SetOf;

public abstract class GrammarSymbol
extends Symbol {
    static final Grammar grammar = Grammar.currentGrammar;
    SetOf first;
    boolean isNullable = false;
    StringBuilder doc;
    String refName;
    SetOf ruleOccurrences;

    GrammarSymbol(String string, ArrayList arrayList, int n) {
        super(string, arrayList, n);
    }

    final boolean isSTART() {
        return this == Grammar.START;
    }

    final boolean isROOTS() {
        return this == Grammar.ROOTS;
    }

    final boolean isEmpty() {
        return this == Grammar.EMPTY;
    }

    final boolean isEndOfInput() {
        return this == Grammar.END_OF_INPUT;
    }

    final boolean isError() {
        return this == Grammar.ERROR;
    }

    final boolean isTag() {
        return this instanceof Terminal && ((Terminal)this).isTag;
    }

    final boolean isAction() {
        return this.name.startsWith("$ACTION") && this.name.endsWith("$");
    }

    final boolean isSpecial() {
        return this.name.startsWith("$") && this.name.length() != 1 && this.name.endsWith("$") || this.isTag() || this.isError();
    }

    final void addDoc(StringBuilder stringBuilder) {
        if (stringBuilder != null) {
            if (this.doc == null) {
                this.doc = new StringBuilder();
            }
            this.doc.append((CharSequence)stringBuilder);
        }
    }

    abstract void link(Rule var1);

    abstract String refName();

    abstract String label();

    final String htmlRef(String string) {
        return "<A CLASS=\"SYMBOL\" HREF=\"" + this.htmlFileName() + "\" TARGET=\"MAIN\" ONCLICK=\"opener.focus()\">" + string + "</A>";
    }

    final String htmlRef() {
        return "<A CLASS=\"SYMBOL\" HREF=\"" + this.htmlFileName() + "\" TARGET=\"MAIN\" ONCLICK=\"opener.focus()\">" + this.label() + "</A>";
    }

    final String htmlFileName() {
        return this.refName() + ".html";
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Terminal) {
            return ((Terminal)object).equals(this);
        }
        return ((NonTerminal)object).equals(this);
    }
}

