/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.Grammar;
import hlt.language.syntax.GrammarSymbol;
import hlt.language.syntax.NonTerminal;
import hlt.language.syntax.Rule;
import hlt.language.syntax.State;
import hlt.language.util.AbstractListIndexed;
import hlt.language.util.SetOf;
import java.util.HashMap;

class Item
extends AbstractListIndexed {
    static final Grammar grammar = Grammar.currentGrammar;
    Rule rule;
    int mark;
    SetOf suffixFirst;
    boolean isNullable = true;
    HashMap predTable;
    HashMap lookaheadTable;

    Item(Rule rule, int n, int n2) {
        super(Rule.grammar.items, n);
        this.rule = rule;
        this.mark = n2;
    }

    final boolean isInitial() {
        return this.mark == 1;
    }

    final boolean isFinal() {
        return this.mark == this.rule.sequence.length;
    }

    final boolean isEmpty() {
        return this.isInitial() && this.isFinal();
    }

    final GrammarSymbol marker() {
        return this.isFinal() ? Grammar.EMPTY : this.rule.sequence[this.mark];
    }

    final boolean markerIsNonTerminal() {
        return this.marker() instanceof NonTerminal;
    }

    final Item shift() {
        if (this.isFinal()) {
            return this;
        }
        return grammar.getItem(this.rule, this.mark + 1);
    }

    final Item unshift() {
        if (this.isInitial()) {
            return this;
        }
        return grammar.getItem(this.rule, this.mark - 1);
    }

    final boolean isKernel() {
        if (this.isInitial()) {
            return this.rule.head().isSTART();
        }
        return this.mark > 1;
    }

    void computeSuffixFirst() {
        this.suffixFirst = new SetOf(Item.grammar.terminals);
        for (int i = this.mark + 1; i < this.rule.sequence.length; ++i) {
            this.suffixFirst.union(this.rule.sequence[i].first);
            this.isNullable &= this.rule.sequence[i].isNullable;
            if (!this.isNullable) break;
        }
    }

    final SetOf pred(State state) {
        SetOf setOf;
        if (this.predTable == null) {
            this.predTable = new HashMap();
        }
        if ((setOf = (SetOf)this.predTable.get(state)) == null) {
            setOf = new SetOf(Item.grammar.states);
            this.predTable.put(state, setOf);
        }
        return setOf;
    }

    final boolean addPred(State state, State state2) {
        SetOf setOf = this.pred(state);
        if (setOf.contains(state2)) {
            return false;
        }
        setOf.add(state2);
        return true;
    }

    final boolean addPred(State state, SetOf setOf) {
        SetOf setOf2 = this.pred(state);
        if (setOf.isSubsetOf(setOf2)) {
            return false;
        }
        setOf2.union(setOf);
        return true;
    }

    final SetOf initLookaheads(State state) {
        if (this.lookaheadTable == null) {
            this.lookaheadTable = new HashMap();
        }
        SetOf setOf = new SetOf(Item.grammar.terminals);
        this.lookaheadTable.put(state, setOf);
        return setOf;
    }

    final SetOf getLookaheads(State state) {
        return (SetOf)this.lookaheadTable.get(state);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Item)) {
            return false;
        }
        return this.index() == ((Item)object).index();
    }

    @Override
    public String toString() {
        String string = "[" + this.rule.index() + "] " + this.rule.sequence[0] + " -->";
        for (int i = 1; i < this.rule.sequence.length; ++i) {
            string = string + (i == this.mark ? " . " : " ") + this.rule.sequence[i];
        }
        if (this.isFinal()) {
            string = string + " .";
        }
        return string;
    }
}

