/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.io.FileTools;
import hlt.language.syntax.Options;
import hlt.language.syntax.ParserGenerator;
import hlt.language.tools.Command;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Jacc
extends Command {
    public static void main(String[] stringArray) {
        Jacc.defineOption("p", Options.getParserPrefix(), "name of java parser file  (default: grammar=\"Foo.grm\" => parser=\"Foo" + Options.getParserPrefix() + ".java\")");
        Jacc.defineOption("v", String.valueOf(Options.getVerbosity()), "information verbosity (number between 0 and 4)");
        Jacc.defineOption("m", String.valueOf(Options.getInitMethodSize()), "max number of instructions in parser initialization method");
        Jacc.defineOption("amb", "", "allow ambiguous actions (for dynamic parsing)");
        Jacc.defineOption("trail", String.valueOf(Options.getTrailHistory()), "max size of trail history (for dynamic parsing)");
        Jacc.defineOption("choices", String.valueOf(Options.getChoiceHistory()), "max size of choice history (for dynamic parsing)");
        Jacc.defineOption("n", "", "do not generate the parser");
        Jacc.defineOption("rf", "", "copy doc resource files");
        Jacc.defineOption("rrp", "", "resolve R/R conflicts based on precedence (dangerous!)");
        Jacc.defineOption("doc", "", "only generate the grammar's html documentation (no parser code)");
        Jacc.defineOption("base", ".", "Jacc's %include command's file base directory");
        Jacc.defineOption("dest", ".", "destination directory where Jacc will write the generated parser file");
        Jacc.defineOption("i", "", "tolerate an incomplete grammar (no parser is generated)");
        Jacc.defineOption("o", "System.out", "redirect the log to the specified file");
        Jacc.defineOption("e", "System.err", "redirect errors to the specified file");
        Jacc.defineOption("s", Options.getSeparator(), "file separator character");
        Jacc.optionalArgument(Options.getGrammarPrefix());
        Jacc.setUsage("\nUsage: jacc [options] grammar_file(s)\n");
        if (stringArray.length == 0) {
            Jacc.printHelp();
            System.exit(1);
        }
        if (Jacc.parseCommandLine(stringArray)) {
            OutputStream outputStream;
            Object object;
            FileTools.setSeparator(Jacc.getOption("s"));
            String string = Jacc.getArgument();
            String string2 = Jacc.fullFileNamePrefix(string);
            String string3 = FileTools.prefix(string);
            String string4 = Jacc.fileNameSuffix(string);
            Object object2 = Jacc.getOption("p");
            if (Jacc.argumentIsPresent() && !Jacc.optionIsPresent("p")) {
                object2 = string3 + "Parser";
            }
            Options.setGrammarPathedName(string2);
            Options.setGrammarPrefix(string3);
            if (string4.length() > 0) {
                Options.setGrammarSuffix(string4);
            }
            Options.setParserPrefix((String)object2);
            Options.setDocOnly(Jacc.optionIsPresent("doc"));
            Options.setNoParser(Jacc.optionIsPresent("n"));
            Options.setCopyResourceFiles(Jacc.optionIsPresent("rf"));
            Options.setPermissible(Jacc.optionIsPresent("i"));
            Options.setIncludeBase(Jacc.getOption("base"));
            Options.setDestination(Jacc.getOption("dest"));
            Options.setVerbosity(Integer.parseInt(Jacc.getOption("v")));
            Options.setInitMethodSize(Integer.parseInt(Jacc.getOption("m")));
            Options.setTrailHistory(Integer.parseInt(Jacc.getOption("trail")));
            Options.setChoiceHistory(Integer.parseInt(Jacc.getOption("choices")));
            Options.setResolveRRsWithPrecedence(Jacc.optionIsPresent("rrp"));
            Options.setAllowChoiceActions(Jacc.optionIsPresent("amb"));
            String string5 = Jacc.getOption("o");
            if (!string5.equals("System.out")) {
                try {
                    object = new FileOutputStream(string5);
                    outputStream = new PrintStream((OutputStream)object, true);
                    Options.setOutStream(outputStream);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    System.err.println("*** Couldn't create file " + string5);
                    System.exit(1);
                }
            }
            if (!((String)(object = Jacc.getOption("e"))).equals("System.err")) {
                try {
                    outputStream = new FileOutputStream((String)object);
                    PrintStream printStream = new PrintStream(outputStream, true);
                    Options.setErrStream(printStream);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    System.err.println("*** Couldn't create file " + (String)object);
                    System.exit(1);
                }
            }
            new ParserGenerator();
        }
    }
}

