/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.Grammar;
import hlt.language.syntax.NonFatalParseErrorException;
import hlt.language.syntax.Symbol;
import hlt.language.util.Named;
import java.util.AbstractList;

public abstract class OperatorSymbol
extends Symbol {
    public static final int PREFIX = 0;
    public static final int POSTFIX = 1;
    public static final int INFIX = 2;
    static final Grammar grammar = Grammar.currentGrammar;
    int precedence;
    int associativity;
    int fixity;

    OperatorSymbol(String string, AbstractList abstractList, int n, String string2) throws NonFatalParseErrorException {
        super(string, abstractList);
        this.precedence = n;
        this.decode(string2);
    }

    OperatorSymbol(String string, AbstractList abstractList, int n, int n2, int n3) {
        super(string, abstractList);
        this.precedence = n;
        this.associativity = n2;
        this.fixity = n3;
    }

    abstract Named category();

    public final void redefine(int n, String string) throws NonFatalParseErrorException {
        this.precedence = n;
        this.decode(string);
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OperatorSymbol)) {
            return false;
        }
        OperatorSymbol operatorSymbol = (OperatorSymbol)object;
        return this.category() == operatorSymbol.category() && this.fixity == operatorSymbol.fixity && this.name.equals(operatorSymbol.name);
    }

    private final void decode(String string) throws NonFatalParseErrorException {
        NonFatalParseErrorException nonFatalParseErrorException = new NonFatalParseErrorException("Bad dynamic operator specifier (" + string + ")");
        if (string.length() == 2) {
            if (string.indexOf(102) == 0) {
                this.fixity = 0;
                if (string.charAt(1) == 'y') {
                    this.associativity = 1;
                    return;
                }
                if (string.charAt(1) == 'x') {
                    this.associativity = 2;
                    return;
                }
                throw nonFatalParseErrorException;
            }
            if (string.indexOf(102) == 1) {
                this.fixity = 1;
                if (string.charAt(0) == 'y') {
                    this.associativity = 0;
                    return;
                }
                if (string.charAt(0) == 'x') {
                    this.associativity = 2;
                    return;
                }
            }
            throw nonFatalParseErrorException;
        }
        if (string.length() == 3 && string.indexOf(102) == 1) {
            this.fixity = 2;
            if (string.charAt(0) == 'y') {
                if (string.charAt(2) != 'x') {
                    throw nonFatalParseErrorException;
                }
                this.associativity = 0;
                return;
            }
            if (string.charAt(0) == 'x') {
                if (string.charAt(2) == 'y') {
                    this.associativity = 1;
                } else if (string.charAt(2) == 'x') {
                    this.associativity = 2;
                } else {
                    throw nonFatalParseErrorException;
                }
                return;
            }
        }
        throw nonFatalParseErrorException;
    }

    public final String specifier() {
        Object object = "";
        if (this.associativity == 0) {
            object = (String)object + "y";
        } else if (this.fixity != 0) {
            object = (String)object + "x";
        }
        object = (String)object + "f";
        if (this.associativity == 1) {
            object = (String)object + "y";
        } else if (this.fixity != 1) {
            object = (String)object + "x";
        }
        return object;
    }

    public int precedence() {
        return this.precedence;
    }

    public int associativity() {
        return this.associativity;
    }

    public int fixity() {
        return this.fixity;
    }

    @Override
    public String toString() {
        return this.category().name() + "(" + Grammar.prologPrecedence(this.precedence) + "," + this.specifier() + "," + this.name + ")";
    }
}

