/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.GenericParser;
import hlt.language.syntax.Grammar;
import hlt.language.syntax.ParserNonTerminal;
import hlt.language.syntax.ParserOperator;
import hlt.language.syntax.ParserStackElement;
import hlt.language.syntax.ParserSymbol;
import hlt.language.syntax.ParserTerminal;
import hlt.language.syntax.TreeDisplay;
import hlt.language.syntax.XmlInfo;
import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;
import hlt.language.util.Locatable;
import hlt.language.util.Location;
import hlt.language.util.Span;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

public class ParseNode
implements Locatable {
    private ParserSymbol _symbol;
    private double _nvalue = Double.NaN;
    private boolean _isInteger = false;
    private String _svalue;
    private ArrayList _alternatives;
    private Span _span;
    private ArrayList _children;
    private ParserOperator _operator;
    private ArrayList _xmlForm;
    private Document _xmlDocument;
    private XmlInfo _xmlInfo = null;

    public ParseNode() {
    }

    public ParseNode(String string) {
        this._svalue = string;
    }

    public ParseNode(ParserSymbol parserSymbol) {
        this._symbol = parserSymbol;
    }

    public ParseNode(ParserSymbol parserSymbol, double d) {
        this._symbol = parserSymbol;
        this._nvalue = d;
    }

    public ParseNode(ParserSymbol parserSymbol, int n) {
        this._symbol = parserSymbol;
        this._nvalue = n;
        this._isInteger = true;
    }

    public ParseNode(ParserSymbol parserSymbol, String string) {
        this._symbol = parserSymbol;
        this._svalue = string;
    }

    public ParseNode(ParseNode parseNode) {
        this._symbol = parseNode.symbol();
        this._svalue = parseNode.svalue();
        this._nvalue = parseNode.nvalue();
        this._isInteger = parseNode.isInteger();
        this._alternatives = parseNode.alternatives();
        this._children = parseNode.children();
        this._span = parseNode.getSpan();
    }

    public ParserSymbol symbol() {
        return this._symbol;
    }

    boolean isDynamic() {
        return false;
    }

    public void setSymbol(ParserSymbol parserSymbol) {
        this._symbol = parserSymbol;
    }

    public double nvalue() {
        return this._nvalue;
    }

    public void setNvalue(double d) {
        this._nvalue = d;
    }

    public boolean isInteger() {
        return this._isInteger;
    }

    public void makeInteger(boolean bl) {
        this._isInteger = bl;
    }

    public String svalue() {
        return this._svalue;
    }

    public void setSvalue(String string) {
        this._svalue = string;
    }

    public ArrayList alternatives() {
        return this._alternatives;
    }

    public void addAlternative(ParseNode parseNode) {
        if (this._alternatives == null) {
            this._alternatives = new ArrayList(2);
        }
        this._alternatives.add(parseNode);
    }

    public boolean hasAlternatives() {
        return this._alternatives != null;
    }

    public boolean isUnknown() {
        return this._symbol == null;
    }

    public boolean isError() {
        return !this.isUnknown() && this._symbol.name() == "error";
    }

    public boolean isEOI() {
        return !this.isUnknown() && this._symbol.name() == "$E_O_I$";
    }

    public final Span span() {
        return this._span == null ? (this._span = new Span()) : this._span;
    }

    public final Span getSpan() {
        return this._span;
    }

    final ParseNode setSpan(ParserStackElement[] parserStackElementArray) {
        int n;
        ParseNode parseNode = null;
        ParseNode parseNode2 = null;
        for (n = 0; n < parserStackElementArray.length && !(parseNode = parserStackElementArray[n].getNode()).isLocated(); ++n) {
        }
        n = parserStackElementArray.length;
        while (n-- > 0 && !(parseNode2 = parserStackElementArray[n].getNode()).isLocated()) {
        }
        if (parseNode != null) {
            if (parseNode2 != null) {
                this.setSpan(parseNode, parseNode2);
            } else {
                this.setSpan(parseNode);
            }
        } else if (parseNode2 != null) {
            this.setSpan(parseNode2);
        }
        this.locate();
        return this;
    }

    public void locate() {
    }

    final void resetSpan() {
        this._span = null;
    }

    final Locatable setSpan(ParseNode parseNode, ParseNode parseNode2) {
        return this.setStart(parseNode.getStart()).setEnd(parseNode2.getEnd());
    }

    final Locatable setSpan(Location location, Location location2) {
        return this.setStart(location).setEnd(location2);
    }

    public final Locatable setSpan(ParseNode parseNode) {
        return this.setStart(parseNode.getStart()).setEnd(parseNode.getEnd());
    }

    public final boolean isLocated() {
        return this.span().isKnown();
    }

    @Override
    public final Location getStart() {
        return this.span().start();
    }

    @Override
    public final Locatable setStart(Location location) {
        this.span().setStart(location);
        return this;
    }

    @Override
    public final Location getEnd() {
        return this.span().end();
    }

    @Override
    public final Locatable setEnd(Location location) {
        this.span().setEnd(location);
        return this;
    }

    public final String getFile() {
        return this.span().getStartFile();
    }

    public final int getLineNumber() {
        return this.span().getStartLine();
    }

    public final ParseNode setFile(String string) {
        this.span().setStartFile(string);
        this.span().setEndFile(string);
        return this;
    }

    public final ParseNode setLineNumber(int n) {
        Grammar.loudWarning("Setting the line number of a ParseNode should not be done! " + this.nodeInfo());
        this.span().setStartLine(n);
        return this;
    }

    @Override
    public final String locationString() {
        return Misc.locationString(this);
    }

    public final ArrayList children() {
        return this._children;
    }

    public void setChildren(ArrayList arrayList) {
        this._children = arrayList;
    }

    public final int numberOfChildren() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    final ParseNode getChild(int n) {
        if (this._children == null || n < 0 || n > this._children.size()) {
            return null;
        }
        return (ParseNode)this._children.get(n);
    }

    final void addChild(ParseNode parseNode) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(parseNode);
    }

    final void addChild(ParseNode parseNode, int n) {
        if (n == 2 || n == 3 || parseNode.isLeafNode()) {
            this.addChild(parseNode);
            return;
        }
        if (parseNode.isEmptyNode()) {
            return;
        }
        if (parseNode.children().size() == 1) {
            this.addChild(parseNode.getChild(0));
            return;
        }
        if (this._symbol.name() == parseNode.symbol().name()) {
            for (int i = 0; i < parseNode.children().size(); ++i) {
                this.addChild(parseNode.getChild(i));
            }
        } else {
            this.addChild(parseNode);
        }
    }

    Object[] nodes(ParserStackElement[] parserStackElementArray) {
        Object[] objectArray = new Object[parserStackElementArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = parserStackElementArray[i].getNode();
        }
        return objectArray;
    }

    public final boolean isTerminal() {
        return this._symbol instanceof ParserTerminal;
    }

    public final boolean hasChildren() {
        return this._children != null && this._children.size() != 0;
    }

    public final boolean isLeafNode() {
        return this.isTerminal() || this._symbol == null;
    }

    public final boolean isInnerNode() {
        return this._symbol instanceof ParserNonTerminal;
    }

    public final boolean isEmptyNode() {
        return this.isInnerNode() && this._children == null;
    }

    public final boolean hasValue() {
        return this._svalue != null || !Double.isNaN(this._nvalue);
    }

    public final String stringValue() {
        return this._svalue != null ? this._svalue : (this._isInteger ? Integer.toString((int)this._nvalue) : Double.toString(this._nvalue));
    }

    public final String nodeInfo() {
        String string = this.toString();
        if (!this.isLocated()) {
            return string;
        }
        return string + ": " + this.span();
    }

    public final ParseNode child(int n) {
        if (this._children == null) {
            return null;
        }
        return (ParseNode)this._children.get(n - 1);
    }

    public final ParseNode firstChild() {
        return this.child(1);
    }

    public final ParseNode lastChild() {
        if (this._children == null) {
            return null;
        }
        return (ParseNode)this._children.get(this._children.size() - 1);
    }

    public ParserOperator operator() {
        return this._operator;
    }

    public void setOperator(ParserOperator parserOperator) {
        this._operator = parserOperator;
    }

    public final boolean isOperator() {
        return this._operator != null;
    }

    public final int precedence() {
        if (this.isOperator()) {
            return this._operator.precedence();
        }
        return ((ParserTerminal)this._symbol).precedence();
    }

    public final int associativity() {
        if (this.isOperator()) {
            return this._operator.associativity();
        }
        return ((ParserTerminal)this._symbol).associativity();
    }

    public final int fixity() {
        if (this.isOperator()) {
            return this._operator.fixity();
        }
        return -1;
    }

    public final ParseNode copy(ParseNode parseNode) {
        ParseNode parseNode2 = new ParseNode(parseNode);
        parseNode2.setSymbol(this._symbol);
        parseNode2.setChildren(null);
        parseNode2.resetSpan();
        return parseNode2;
    }

    public ParseNode copy() {
        return new ParseNode(this);
    }

    public final void display() {
        new TreeDisplay(this);
    }

    public final void display(String string) {
        new TreeDisplay(this, string);
    }

    public final void show() {
        this.show(0, System.out);
    }

    public final void show(PrintStream printStream) {
        this.show(0, printStream);
    }

    public final void show(int n, PrintStream printStream) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            printStream.print(" ");
        }
        printStream.println(this);
        if (!this.isLeafNode() && this._children != null) {
            for (n2 = 0; n2 < this._children.size(); ++n2) {
                this.getChild(n2).show(n + 3, printStream);
            }
        }
    }

    public final ArrayList xmlForm() {
        return this._xmlForm;
    }

    public final boolean hasXmlForm() {
        return !this.xmlForm().isEmpty();
    }

    final void attachXmlFormTo(Element element) {
        Iterator iterator = this.xmlForm().iterator();
        while (iterator.hasNext()) {
            element.addContent((Content)((Element)iterator.next()));
        }
    }

    public final void showXmlElement(Element element, PrintStream printStream) throws IOException {
        if (element != null) {
            GenericParser.xmlWriter().output(element, (OutputStream)printStream);
        } else {
            printStream.println("null");
        }
    }

    public final Document xmlDocument() {
        return this._xmlDocument;
    }

    public Document xmlDocument(String string, String string2, String[] stringArray) {
        if (this._xmlDocument == null) {
            Element element = new Element(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length / 2; ++i) {
                    String string3 = stringArray[2 * i];
                    String string4 = stringArray[2 * i + 1];
                    Namespace namespace = Namespace.getNamespace((String)string3, (String)string4);
                    element.addNamespaceDeclaration(namespace);
                    if (string3 != string2) continue;
                    element.setNamespace(namespace);
                }
            }
            this._xmlForm = this.xmlify(element);
            Iterator iterator = this._xmlForm.iterator();
            while (iterator.hasNext()) {
                element.addContent((Content)((Element)iterator.next()));
            }
            this._xmlDocument = new Document(element);
            this._xmlDocument.addContent((Content)new Comment("XML document generated on " + new Date()));
        }
        return this._xmlDocument;
    }

    XmlInfo xmlInfo() {
        return this._xmlInfo;
    }

    public ParseNode setXmlInfo(XmlInfo xmlInfo) {
        this._xmlInfo = xmlInfo;
        return this;
    }

    public final ArrayList xmlify(Element element) {
        ArrayList arrayList = new ArrayList(this.hasChildren() ? this._children.size() : 0);
        if (this._xmlInfo == null) {
            if (this.isTerminal() && this.hasValue()) {
                Element element2 = new Element(this._symbol.name());
                element2.addContent((Content)new Text(this.stringValue()));
                arrayList.add(element2);
            } else if (this.hasChildren()) {
                Iterator iterator = this._children.iterator();
                while (iterator.hasNext()) {
                    arrayList.addAll(((ParseNode)iterator.next()).xmlify(element));
                }
            }
        } else {
            Element element3 = this._xmlInfo.createXmlForm(this, element);
            arrayList.add(element3);
        }
        return arrayList;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ParseNode) || object == null) {
            return false;
        }
        ParseNode parseNode = (ParseNode)object;
        return this.nodeInfo().equals(parseNode.nodeInfo());
    }

    private String stringForm() {
        Object object;
        if (this.isOperator()) {
            return this._operator.toString();
        }
        Object object2 = object = this._symbol == null ? "'DYNAMIC'" : this._symbol.toString();
        if (this.isLeafNode() && this.hasValue()) {
            object = (String)object + "(";
            if (this._svalue != null) {
                object = (String)object + this._svalue;
                if (!Double.isNaN(this._nvalue)) {
                    object = (String)object + ",";
                }
            }
            if (!Double.isNaN(this._nvalue)) {
                object = this._isInteger ? (String)object + String.valueOf((int)this._nvalue) : (String)object + this._nvalue;
            }
            object = (String)object + ")";
        }
        return object;
    }

    public String toString() {
        String string = this.stringForm();
        return string;
    }
}

