/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.Action;
import hlt.language.syntax.BadGrammarException;
import hlt.language.syntax.Grammar;
import hlt.language.syntax.GrammarSymbol;
import hlt.language.syntax.Item;
import hlt.language.syntax.NonTerminal;
import hlt.language.syntax.Operator;
import hlt.language.syntax.Options;
import hlt.language.syntax.Rule;
import hlt.language.syntax.State;
import hlt.language.syntax.StateTransition;
import hlt.language.syntax.Symbol;
import hlt.language.syntax.Terminal;
import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;
import hlt.language.util.Indexed;
import hlt.language.util.Map;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ParserGenerator {
    static long startTime;
    static long tableBuildingStart;
    static long compressionStart;
    static long totalTime;
    Grammar grammar;
    BufferedWriter p_out;
    PrintStream out = Options.getOutStream();
    PrintStream err = Options.getErrStream();
    int verbosity = Options.getVerbosity();
    String parserDestination = Options.destination();
    String parserPrefix = Options.getParserPrefix();
    String parserFile = this.parserPrefix + ".java";
    String fullParserFile = this.parserDestination + Options.getSeparator() + this.parserFile;
    final String defaultAction = "$head$ = $head$.copy(node($rule$,1));";
    int initMethodSize = Options.getInitMethodSize();
    String initContinuation = null;
    int initContinuationCount;
    private boolean conflict = false;
    int usrCount;
    int rsrCount;
    int rrCount;
    ArrayList ac_tables = new ArrayList();
    int ac_count = 0;
    int ac_compression = 0;
    ArrayList gt_tables = new ArrayList();
    int gt_count = 0;
    int gt_compression = 0;
    static ArrayList actions;
    static HashMap actionTable;
    static int acount;
    private boolean conflictIsUnresolved = false;
    String usefile;

    public ParserGenerator() {
        this.buildParser();
    }

    final void testInitContinuation(int n) throws IOException {
        if (n > 0 && n % this.initMethodSize == 0) {
            this.pl();
            this.pl("      " + this.initContinuation + "_" + ++this.initContinuationCount + "();");
            this.pl("    }");
            this.pl();
            this.pl("  static void " + this.initContinuation + "_" + this.initContinuationCount + " ()");
            this.pl("    {");
        }
    }

    final void buildParser() {
        try {
            this.grammar = new Grammar();
            if (!Options.getDocOnly()) {
                this.buildTables();
                this.writeParser();
            }
        }
        catch (Exception exception) {
            Grammar.warning("Parser generation aborted!");
            if (!(exception instanceof BadGrammarException)) {
                exception.printStackTrace(this.err);
            }
            System.exit(1);
        }
    }

    final void buildTables() {
        this.reportProgress_1();
        Action action = new Action(5);
        action.add();
        ++acount;
        action = new Action(2);
        action.add();
        ++acount;
        for (State state : this.grammar.states) {
            for (StateTransition stateTransition : state.transitions.values()) {
                GrammarSymbol grammarSymbol = stateTransition.symbol;
                if (grammarSymbol instanceof NonTerminal) {
                    state.setGoto((NonTerminal)grammarSymbol, stateTransition.next);
                    continue;
                }
                if (grammarSymbol.isEmpty()) {
                    Iterator iterator = stateTransition.items.iterator();
                    while (iterator.hasNext()) {
                        Item item = (Item)iterator.next();
                        if (item.rule.head().isSTART()) {
                            state.setAction(Grammar.END_OF_INPUT, ParserGenerator.acceptAction());
                            continue;
                        }
                        Iterator iterator2 = item.getLookaheads(state).iterator();
                        while (iterator2.hasNext()) {
                            Terminal terminal = (Terminal)iterator2.next();
                            action = new Action(1, item.rule.index());
                            this.conflict |= this.checkConflict(terminal, state, action);
                        }
                    }
                    continue;
                }
                action = new Action(0, stateTransition.next.index());
                this.conflict |= this.checkConflict((Terminal)grammarSymbol, state, action);
            }
        }
        this.reportProgress_2();
        this.compressTables();
        this.reportProgress_3();
    }

    final void compressTables() {
        this.reportProgress_4();
        for (State state : this.grammar.states) {
            int n = this.ac_tables.indexOf(state.actionTable);
            if (n < 0) {
                this.ac_tables.add(state.actionTable);
                ++this.ac_count;
                state.ac_index = state.ac_index;
            } else {
                state.actionTable = (Map)this.ac_tables.get(n);
                state.ac_index = n;
                ++this.ac_compression;
            }
            n = this.gt_tables.indexOf(state.gotoTable);
            if (n < 0) {
                this.gt_tables.add(state.gotoTable);
                ++this.gt_count;
                state.gt_index = state.gt_index;
                continue;
            }
            state.gotoTable = (Map)this.gt_tables.get(n);
            state.gt_index = n;
            ++this.gt_compression;
        }
        this.reportProgress_5();
    }

    static final Action errorAction() {
        return (Action)actions.get(0);
    }

    static final Action acceptAction() {
        return (Action)actions.get(1);
    }

    final Action checkAction(Action action) {
        Action action2 = (Action)actionTable.get(action);
        if (action2 != null) {
            return action2;
        }
        action.add();
        ++acount;
        actionTable.put(action, action);
        return action;
    }

    final boolean checkConflict(Terminal terminal, State state, Action action) {
        Action action2 = state.getAction(terminal);
        if (action2 == null) {
            state.setAction(terminal, this.checkAction(action));
            return false;
        }
        if (action2.type == 3) {
            ArrayList arrayList = (ArrayList)state.dynamicActions.get(action2.info);
            if (terminal.isOperator || this.isOperator(action)) {
                if (!arrayList.contains(action)) {
                    arrayList.add(this.checkAction(action));
                }
            } else {
                int n = this.findContender(arrayList);
                if (n == -1) {
                    arrayList.add(this.checkAction(action));
                } else {
                    Action action3 = (Action)arrayList.get(n);
                    Action action4 = this.resolveConflict(action3, action, terminal);
                    if (this.conflictIsUnresolved && Options.allowChoiceActions()) {
                        arrayList.add(this.checkAction(action));
                        action2.type = 4;
                        action4 = action2;
                        this.conflictIsUnresolved = false;
                    } else if (action4 == action) {
                        arrayList.set(n, action);
                    } else {
                        action3 = action;
                    }
                    this.tallyConflict(action4, action3, state, terminal);
                }
            }
        } else if (action2.type != 4) {
            if (this.isOperator(action2) || terminal.isOperator || this.isOperator(action)) {
                ArrayList arrayList = new ArrayList();
                arrayList.add(action2);
                arrayList.add(this.checkAction(action));
                int n = state.dynamicActions.indexOf(arrayList);
                if (n == -1) {
                    n = state.dynamicActions.size();
                    state.dynamicActions.add(arrayList);
                }
                state.setAction(terminal, this.checkAction(new Action(3, n)));
            } else {
                Action action5 = this.resolveConflict(action2, action, terminal);
                if (this.conflictIsUnresolved && Options.allowChoiceActions()) {
                    ArrayList arrayList = new ArrayList(2);
                    arrayList.add(action2);
                    arrayList.add(this.checkAction(action));
                    int n = state.dynamicActions.indexOf(arrayList);
                    if (n == -1) {
                        n = state.dynamicActions.size();
                        state.dynamicActions.add(arrayList);
                    }
                    action5 = new Action(4, n);
                    state.setAction(terminal, this.checkAction(action5));
                    this.conflictIsUnresolved = false;
                } else if (action5 == action) {
                    state.setAction(terminal, this.checkAction(action5));
                } else {
                    action2 = action;
                }
                this.tallyConflict(action5, action2, state, terminal);
            }
        } else {
            ArrayList arrayList = (ArrayList)state.dynamicActions.get(action2.info);
            if (terminal.isOperator || this.isOperator(action)) {
                if (!arrayList.contains(action)) {
                    arrayList.add(this.checkAction(action));
                }
            } else {
                boolean bl = true;
                for (Action action6 : arrayList) {
                    if (!this.isOperator(action6) && action6 != this.resolveConflict(action6, action, terminal)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    state.setAction(terminal, this.checkAction(action));
                } else if (!arrayList.contains(action)) {
                    arrayList.add(this.checkAction(action));
                }
            }
        }
        return this.conflictIsUnresolved;
    }

    private final void tallyConflict(Action action, Action action2, State state, Terminal terminal) {
        boolean bl = this.conflictIsUnresolved && !Options.allowChoiceActions();
        String string = action.conflict(action2) + " conflict: choosing " + action + "\tover " + action2;
        state.addConflict((bl ? "Unresolved " : "Resolved   ") + string + ", \ton input " + terminal);
        if (bl && this.verbosity > 1) {
            this.out.println("*** Unresolved " + string + ",\tin state " + state + ", \ton input " + terminal);
        }
    }

    final boolean isOperator(Action action) {
        return action.type == 1 && this.grammar.getRule(action.info).isOperator();
    }

    final int findContender(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (this.isOperator((Action)arrayList.get(i))) continue;
            return i;
        }
        return -1;
    }

    final Action resolveConflict(Action action, Action action2, Terminal terminal) {
        this.conflictIsUnresolved = false;
        if (action.type == 1) {
            if (action2.type == 1) {
                int n = this.grammar.getRule(action.info).precedence();
                int n2 = this.grammar.getRule(action2.info).precedence();
                if (!Options.resolveRRsWithPrecedence() || n == n2) {
                    this.conflictIsUnresolved = true;
                    ++this.rrCount;
                    return action.info < action2.info ? action : action2;
                }
                return n > n2 ? action : action2;
            }
            Rule rule = this.grammar.getRule(action.info);
            ++this.rsrCount;
            if (rule.precedence() > terminal.precedence) {
                return action;
            }
            if (rule.precedence() < terminal.precedence) {
                return action2;
            }
            if (rule.associativity() == 0) {
                return action;
            }
            if (rule.associativity() == 1) {
                return action2;
            }
            if (terminal.associativity == 2 && terminal == rule.tag) {
                if (this.verbosity > 1) {
                    Grammar.warning("Rule " + rule.index() + " may compose the non-associative symbol: " + terminal);
                }
                return ParserGenerator.errorAction();
            }
            --this.rsrCount;
            ++this.usrCount;
            this.conflictIsUnresolved = true;
            return action2;
        }
        return this.resolveConflict(action2, action, terminal);
    }

    final void pl() throws IOException {
        this.p_out.write(10);
    }

    final void pl(String string) throws IOException {
        this.p_out.write(string + "\n");
    }

    final void p(String string) throws IOException {
        this.p_out.write(string);
    }

    final void p(int n) throws IOException {
        this.p_out.write(n);
    }

    final void setOutput(String string) throws IOException {
        this.p_out = new BufferedWriter(new FileWriter(string));
    }

    final void writePreamble() throws IOException {
        this.pl("// *******************************************************************");
        this.pl("// This file has been automatically generated from the grammar in file");
        this.pl("// " + this.grammar.grammarName + " by hlt.language.syntax.ParserGenerator on");
        this.pl("// " + new Date() + " --- !!! PLEASE DO NO EDIT !!!");
        this.pl("// *******************************************************************");
        this.pl();
        if (this.grammar.packageName != null) {
            this.pl("package " + this.grammar.packageName + ";\n");
        }
        this.pl("import java.io.Reader;");
        this.pl("import java.io.StringReader;");
        this.pl("import java.io.IOException;");
        if (this.grammar.isDynamic) {
            this.pl("import hlt.language.util.ArrayList;");
            this.pl("import hlt.language.util.FiniteStack;");
        }
        this.pl("import hlt.language.syntax.*;");
        Iterator iterator = this.grammar.imports.iterator();
        while (iterator.hasNext()) {
            this.pl("import " + iterator.next() + ";");
        }
        this.pl();
    }

    final void writePublicClasses() throws IOException {
        for (String string : this.grammar.publicClasses.keySet()) {
            String string2 = this.grammar.publicClasses.get(string).toString();
            this.setOutput(this.parserDestination + Options.getSeparator() + string + ".java");
            this.writePreamble();
            this.pl(string2);
            this.p_out.close();
        }
    }

    final void dumpCode(ArrayList arrayList, String string) throws IOException {
        if (!arrayList.isEmpty()) {
            this.pl(string);
            for (Object e : arrayList) {
                if (e instanceof String) {
                    this.usefile = (String)e;
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.usefile));
                        this.reportProgress_6();
                        this.pl("\n  /* START OF CONTENTS OF FILE: " + this.usefile + " */\n");
                        int n = bufferedReader.read();
                        while (n != -1) {
                            this.p(n);
                            n = bufferedReader.read();
                        }
                        bufferedReader.close();
                        this.reportProgress_7();
                        this.pl("  /* END OF CONTENTS OF FILE: " + this.usefile + " */\n");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Grammar.warning("Cannot include file: " + this.usefile + " (not found!)");
                    }
                    catch (IOException iOException) {
                        Grammar.warning("Something wrong happened while reading: " + this.usefile + ": " + iOException);
                    }
                    continue;
                }
                this.pl(e.toString());
                this.pl();
            }
        }
    }

    final void writeParser() {
        if (Options.getNoParser()) {
            return;
        }
        this.reportProgress_8();
        String string = this.grammar.isDynamic ? "Dynamic" : "Static";
        try {
            State state;
            Map map;
            int n;
            Action action;
            Terminal terminal;
            int n2;
            Rule rule;
            Object object;
            Iterator iterator;
            this.setOutput(this.fullParserFile);
            this.writePreamble();
            this.pl();
            this.pl("/* ************ */");
            this.pl("/* PARSER CLASS */");
            this.pl("/* ************ */");
            this.pl();
            this.pl(this.grammar.accessTag + "class " + this.parserPrefix + " extends " + string + "Parser\n{");
            this.pl("  /* ************************ */");
            this.pl("  /* PARSER CLASS CONSTRUCTOR */");
            this.pl("  /* ************************ */");
            this.pl();
            this.pl("  public " + this.parserPrefix + " (Tokenizer t)\n    {\n      input = t;");
            ParserGenerator parserGenerator = this;
            if (parserGenerator.grammar.xmlroot() != null) {
                ParserGenerator parserGenerator2 = this;
                this.pl("      xmlroot = \"" + parserGenerator2.grammar.xmlroot() + "\";");
            }
            ParserGenerator parserGenerator3 = this;
            if (parserGenerator3.grammar.xmlRootNSPrefix() != "") {
                ParserGenerator parserGenerator4 = this;
                this.pl("      xmlRootNSPrefix = \"" + parserGenerator4.grammar.xmlRootNSPrefix() + "\";");
            }
            if (!this.grammar.namespaces().isEmpty()) {
                this.pl("      String[] ns = " + Misc.arrayToString(this.grammar.namespaces().toStringArray(), "{", ",", "}") + ";");
                this.pl("      namespaces = ns;");
            }
            if (this.grammar.isDynamic) {
                this.pl("      choiceStack = new FiniteStack(" + Options.getChoiceHistory() + ");");
                this.pl("      trailStack = new FiniteStack(" + Options.getTrailHistory() + ");");
                this.pl("      resolveRRsWithPrecedence = " + Options.resolveRRsWithPrecedence() + ";");
            }
            if (this.grammar.admitsOperators()) {
                this.pl();
                this.pl("      /* **************** */");
                this.pl("      /* OPERATOR SYMBOLS */");
                this.pl("      /* **************** */");
                this.pl();
                this.pl("      operators = new ArrayList(" + this.grammar.operators.size() + ");\n");
                for (int i = 0; i < this.grammar.ocount; ++i) {
                    Symbol symbol = this.grammar.getOperator(i);
                    this.pl("      newOperator(\"" + Misc.quotify(((Operator)symbol).name) + "\"," + ((Operator)symbol).category.index() + "," + ((Operator)symbol).precedence + "," + ((Operator)symbol).associativity + "," + ((Operator)symbol).fixity + ");");
                }
            }
            this.pl("    }\n");
            this.dumpCode(this.grammar.parserDeclarations, "  /* ************************* */\n  /* PARSER CLASS DECLARATIONS */\n  /* ************************* */");
            this.pl("  /* ********************** */");
            this.pl("  /* STATIC INITIALIZATIONS */");
            this.pl("  /* ********************** */");
            this.pl();
            this.pl("  static");
            this.pl("    {");
            this.pl("      initializeTerminals();");
            this.pl("      initializeNonTerminals();");
            this.pl("      initializeRules();");
            this.pl("      initializeParserActions();");
            this.pl("      initializeParserStates();");
            this.pl("      initializeActionTables();");
            this.pl("      initializeGotoTables();");
            this.pl("      initializeStateTables();");
            this.pl("    }\n");
            this.pl("  /* ********************* */");
            this.pl("  /* PARTIAL PARSE METHODS */");
            this.pl("  /* ********************* */");
            this.pl();
            for (Symbol symbol : this.grammar.roots.keySet()) {
                Object object2 = (Terminal)this.grammar.roots.get(symbol);
                iterator = Misc.capitalize(symbol.name());
                object = ((Symbol)object2).name().toUpperCase();
                this.pl("  final static ParseNode " + (String)object + " = new ParseNode(terminals[" + ((Indexed)object2).index() + "]);");
                this.pl();
                this.pl("  public final void parse" + (String)((Object)iterator) + " (String s) throws IOException");
                this.pl("    {");
                this.pl("      parse" + (String)((Object)iterator) + "(new StringReader(s));");
                this.pl("    }");
                this.pl();
                this.pl("  public final void parse" + (String)((Object)iterator) + " (Reader r) throws IOException");
                this.pl("    {");
                this.pl("      input.setReader(r);");
                this.pl("      errorManager().recoverFromErrors(false);");
                this.pl("      setSwitchToken(" + (String)object + ");");
                this.pl("      parse();");
                this.pl("    }");
                this.pl();
            }
            this.pl("  /* **************** */");
            this.pl("  /* SEMANTIC ACTIONS */");
            this.pl("  /* **************** */");
            this.pl();
            this.pl("  protected ParseNode semanticAction(ParserRule $rule$) throws IOException\n    {");
            this.pl("      ParseNode $head$ = new ParseNode($rule$.head);\n");
            ArrayList arrayList = new ArrayList();
            this.pl("      switch($rule$.index())\n        {");
            for (int i = 0; i < this.grammar.rcount; ++i) {
                rule = this.grammar.getRule(i);
                if (rule.action.equals("$empty$")) {
                    arrayList.add((Object)i);
                    continue;
                }
                if (rule.action.equals("$default$")) continue;
                this.pl("          case " + i + ":\n            {\n            " + rule.action.trim() + "\n            break;\n            }");
            }
            if (!arrayList.isEmpty()) {
                this.p("          ");
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    this.p("case " + (Integer)iterator2.next() + ": ");
                }
                this.pl("\n            break;");
            }
            this.pl("          default:\n            $head$ = $head$.copy(node($rule$,1));\n            break;");
            this.pl("        }\n      return $head$;\n    }");
            this.pl();
            if (this.grammar.isDynamic) {
                this.pl("  /* ********************* */");
                this.pl("  /* UNDO SEMANTIC ACTIONS */");
                this.pl("  /* ********************* */");
                this.pl();
                this.pl("  protected void undoSemanticAction(ParserRule $rule$,ParseNode $head$) throws IOException");
                this.pl("    {");
                this.pl("      switch($rule$.index())\n        {");
                for (int i = 0; i < this.grammar.rcount; ++i) {
                    rule = this.grammar.getRule(i);
                    if (rule.undoAction.equals("$empty$")) continue;
                    this.pl("          case " + i + ":\n            {\n            " + rule.undoAction.trim() + "\n            break;\n            }");
                }
                this.pl("        }\n      }");
                this.pl();
                this.pl("  /* *************************** */");
                this.pl("  /* OPERATOR DEFINITION METHODS */");
                this.pl("  /* *************************** */");
                this.pl();
                for (Object object2 : Grammar.operatorCategoryTable.keySet()) {
                    this.pl("  public final void " + (String)object2 + " (String o, String s, int p) throws NonFatalParseErrorException");
                    this.pl("    {");
                    this.pl("      defineOperator(\"" + Misc.quotify((String)object2) + "\",o,s,p);");
                    this.pl("    }");
                    this.pl();
                }
            }
            this.pl("  /* **************** */");
            this.pl("  /* TERMINAL SYMBOLS */");
            this.pl("  /* **************** */");
            this.pl();
            this.initContinuation = "initializeTerminals";
            this.initContinuationCount = 0;
            this.pl("  static void initializeTerminals ()");
            this.pl("    {");
            this.pl("      terminals = new ParserTerminal[" + this.grammar.tcount + "];\n");
            for (n2 = 0; n2 < this.grammar.tcount; ++n2) {
                this.testInitContinuation(n2);
                terminal = this.grammar.getTerminal(n2);
                this.pl("      newTerminal(" + n2 + ",\"" + Misc.quotify(terminal.name) + "\"," + terminal.precedence + "," + terminal.associativity + ");");
                if (terminal.xmlInfo() == null) continue;
                terminal.xmlInfo().generateTerminalXmlInfo(this, n2);
            }
            this.pl("    }");
            this.pl();
            this.pl("  /* ******************** */");
            this.pl("  /* NON-TERMINAL SYMBOLS */");
            this.pl("  /* ******************** */");
            this.pl();
            this.initContinuation = "initializeNonTerminals";
            this.initContinuationCount = 0;
            this.pl("  static void initializeNonTerminals ()");
            this.pl("    {");
            this.pl("      nonterminals = new ParserNonTerminal[" + this.grammar.ncount + "];\n");
            for (n2 = 0; n2 < this.grammar.ncount; ++n2) {
                this.testInitContinuation(n2);
                this.pl("      newNonTerminal(" + n2 + ",\"" + Misc.quotify(this.grammar.getNonTerminal((int)n2).name) + "\");");
            }
            this.pl("    }");
            this.pl();
            this.pl("  /* **************** */");
            this.pl("  /* PRODUCTION RULES */");
            this.pl("  /* **************** */");
            this.pl();
            this.initContinuation = "initializeRules";
            this.initContinuationCount = 0;
            this.pl("  static void initializeRules ()");
            this.pl("    {");
            this.pl("      rules = new ParserRule[" + this.grammar.rcount + "];");
            this.pl();
            for (n2 = 0; n2 < this.grammar.rcount; ++n2) {
                this.testInitContinuation(n2);
                rule = this.grammar.getRule(n2);
                if (rule.isOperator()) {
                    this.pl("      rules[" + n2 + "] = new ParserRule(" + rule.head().index() + "," + (rule.sequence.length - 1) + "," + n2 + "," + rule.tagPosition + ");");
                    continue;
                }
                this.pl("      rules[" + n2 + "] = new ParserRule(" + rule.head().index() + "," + (rule.sequence.length - 1) + "," + n2 + "," + rule.precedence() + "," + rule.associativity() + ");");
                if (rule.xmlInfo() == null) continue;
                rule.xmlInfo().generateRuleXmlInfo(this, n2);
            }
            this.pl("    }");
            this.pl();
            this.pl("  /* ************** */");
            this.pl("  /* PARSER ACTIONS */");
            this.pl("  /* ************** */");
            this.pl();
            this.initContinuation = "initializeParserActions";
            this.initContinuationCount = 0;
            this.pl("  static void initializeParserActions ()");
            this.pl("    {");
            this.pl("      actions = new ParserAction[" + acount + "];\n");
            for (n2 = 0; n2 < acount; ++n2) {
                this.testInitContinuation(n2);
                action = (Action)actions.get(n2);
                this.pl("      newAction(" + n2 + "," + action.type + "," + action.info + ");");
            }
            this.pl("    }");
            this.pl();
            this.pl("  /* ************* */");
            this.pl("  /* PARSER STATES */");
            this.pl("  /* ************* */");
            this.pl();
            this.pl("  static void initializeParserStates ()");
            this.pl("    {");
            this.pl("      states = new ParserState[" + this.grammar.scount + "];\n");
            this.pl("      for (int i=0; i<" + this.grammar.scount + "; i++) newState(i);");
            this.pl("    }");
            this.pl();
            this.pl("  /* ************* */");
            this.pl("  /* ACTION TABLES */");
            this.pl("  /* ************* */");
            this.pl();
            this.initContinuation = "initializeActionTables";
            this.initContinuationCount = 0;
            this.pl("  static void initializeActionTables ()");
            this.pl("    {");
            this.pl("      newActionTables(" + this.ac_count + ");\n");
            n2 = 0;
            for (n = 0; n < this.ac_count; ++n) {
                this.testInitContinuation(n2);
                map = (Map)this.ac_tables.get(n);
                this.pl("      newActionTable(" + n + "," + map.size() + ");");
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    this.testInitContinuation(n2);
                    terminal = (Terminal)iterator.next();
                    action = (Action)map.get(terminal);
                    this.pl("\tsetAction(" + n + "," + terminal.index() + "," + action.index() + ");");
                    ++n2;
                }
                this.pl();
            }
            this.pl("    }\n");
            this.pl("  /* *********** */");
            this.pl("  /* GOTO TABLES */");
            this.pl("  /* *********** */");
            this.pl();
            this.initContinuation = "initializeGotoTables";
            this.initContinuationCount = 0;
            this.pl("  static void initializeGotoTables ()");
            this.pl("    {");
            this.pl("      newGotoTables(" + this.gt_count + ");\n");
            n2 = 0;
            for (n = 0; n < this.gt_count; ++n) {
                this.testInitContinuation(n2);
                map = (Map)this.gt_tables.get(n);
                this.pl("      newGotoTable(" + n + "," + map.size() + ");");
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    this.testInitContinuation(n2);
                    NonTerminal nonTerminal = (NonTerminal)iterator.next();
                    state = (State)map.get(nonTerminal);
                    this.pl("\tsetGoto(" + n + "," + nonTerminal.index() + "," + state.index() + ");");
                    ++n2;
                }
                this.pl();
            }
            this.pl("    }\n");
            this.pl("  /* ************ */");
            this.pl("  /* STATE TABLES */");
            this.pl("  /* ************ */");
            this.pl();
            this.initContinuation = "initializeStateTables";
            this.initContinuationCount = 0;
            this.pl("  static void initializeStateTables ()");
            this.pl("    {");
            n2 = 0;
            for (n = 0; n < this.grammar.scount; ++n) {
                this.testInitContinuation(n2);
                state = (State)this.grammar.states.get(n);
                this.pl("      setTables(" + n + "," + state.ac_index + "," + state.gt_index + ");");
                if (state.dynamicActions.size() <= 0) continue;
                this.pl("//    Dynamic Actions in State " + n + ":");
                this.pl("\t newDynamicActionTable(" + n + "," + state.dynamicActions.size() + ");");
                ++n2;
                for (int i = 0; i < state.dynamicActions.size(); ++i) {
                    this.testInitContinuation(n2);
                    object = (ArrayList)state.dynamicActions.get(i);
                    this.pl("\t     newDynamicActions(" + n + "," + i + "," + ((ArrayList)object).size() + ");");
                    ++n2;
                    for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                        this.testInitContinuation(n2);
                        action = (Action)((ArrayList)object).get(j);
                        this.pl("\t      setDynamicAction(" + n + "," + i + "," + j + "," + action.index() + ");");
                        ++n2;
                    }
                }
            }
            this.pl("    }");
            this.pl("}");
            this.dumpCode(this.grammar.ancillaryClasses, "\n/* ***************** */\n/* ANCILLARY CLASSES */\n/* ***************** */\n");
            this.p_out.close();
            this.writePublicClasses();
        }
        catch (IOException iOException) {
            Grammar.warning("Something wrong happened while generating parser file(s) " + this.parserFile);
            this.err.println(iOException);
            return;
        }
        this.reportProgress_9();
    }

    private final void reportProgress_1() {
        startTime = System.currentTimeMillis();
        if (this.verbosity > 0) {
            this.out.println("*** Building parsing tables ... ");
        }
        tableBuildingStart = System.currentTimeMillis();
    }

    private final void reportProgress_2() {
        if (this.verbosity > 1) {
            this.out.println("***\t... in " + (System.currentTimeMillis() - tableBuildingStart) + " ms");
        }
        if (this.verbosity > 3) {
            this.grammar.showStates();
        }
        if (!Options.allowChoiceActions() && this.usrCount + this.rrCount > 0) {
            Object object = "unresolved conflicts: ";
            if (this.usrCount > 0) {
                object = (String)object + this.usrCount + " shift/reduce";
                if (this.rrCount > 0) {
                    object = (String)object + "; ";
                }
            }
            if (this.rrCount > 0) {
                object = (String)object + this.rrCount + " reduce/reduce";
            }
            Grammar.warning((String)object);
        }
    }

    private final void reportProgress_3() {
        if (this.verbosity > 3) {
            this.showTables();
        }
    }

    private final void reportProgress_4() {
        if (this.verbosity > 1) {
            this.out.println("*** Compressing parsing tables ... ");
        }
        compressionStart = System.currentTimeMillis();
    }

    private final void reportProgress_5() {
        if (this.verbosity > 1) {
            this.out.println("***\t" + this.ac_compression + " rows eliminated in action table");
            this.out.println("***\t" + this.gt_compression + " rows eliminated in goto table");
            this.out.println("*** Table compression completed in " + (System.currentTimeMillis() - compressionStart) + " ms");
        }
    }

    private final void reportProgress_6() {
        if (this.verbosity > 0) {
            this.out.print("***\tIncluding file " + this.usefile + "... ");
        }
    }

    private final void reportProgress_7() {
        if (this.verbosity > 0) {
            this.out.println("Done.");
        }
    }

    private final void reportProgress_8() {
        if (this.verbosity > 0) {
            this.out.println("*** Writing parser file " + this.fullParserFile);
        }
    }

    private final void reportProgress_9() {
        totalTime = System.currentTimeMillis() - startTime;
        if (this.verbosity > 0) {
            this.out.println("*** Parser generation completed in " + totalTime + " ms.");
            this.out.println("*** Total processing time: " + (Grammar.totalTime + totalTime) + " ms.\n");
        }
    }

    final void showTables() {
        NonTerminal nonTerminal;
        int n;
        State state;
        Terminal terminal;
        int n2;
        boolean bl = false;
        this.out.println("\n\nACTION TABLE:\n");
        for (n2 = 0; n2 < this.grammar.tcount; ++n2) {
            terminal = this.grammar.getTerminal(n2);
            if (terminal.isEmpty()) continue;
            this.out.print("\t[" + n2 + "]");
        }
        this.out.print("\n\t");
        for (n2 = 0; n2 < this.grammar.tcount - 1; ++n2) {
            this.out.print("________");
        }
        for (n2 = 0; n2 < this.grammar.scount; ++n2) {
            state = this.grammar.getState(n2);
            bl |= state.dynamicActions.size() > 0;
            this.out.print("\n[" + n2 + "]");
            for (n = 0; n < this.grammar.tcount; ++n) {
                terminal = this.grammar.getTerminal(n);
                if (terminal.isEmpty()) continue;
                this.out.print("\t");
                Action action = state.getAction(terminal);
                if (action == null) {
                    this.out.print(" - ");
                    continue;
                }
                this.out.print(" " + action);
            }
        }
        if (bl) {
            this.out.println("\n\n\nDYNAMIC ACTIONS:\n");
            for (n2 = 0; n2 < this.grammar.scount; ++n2) {
                state = this.grammar.getState(n2);
                if (state.dynamicActions.size() > 0) {
                    this.out.print("[" + n2 + "]");
                }
                for (n = 0; n < state.dynamicActions.size(); ++n) {
                    ArrayList arrayList = (ArrayList)state.dynamicActions.get(n);
                    this.out.print("\tD" + n + " -> { ");
                    for (int i = 0; i < arrayList.size(); ++i) {
                        this.out.print((Action)arrayList.get(i));
                        if (i < arrayList.size() - 1) {
                            this.out.print(", ");
                            continue;
                        }
                        this.out.print(" }");
                    }
                    this.out.print("\n");
                }
            }
        }
        this.out.println("\n\nGOTO TABLE:\n");
        for (n2 = 0; n2 < this.grammar.ncount; ++n2) {
            nonTerminal = this.grammar.getNonTerminal(n2);
            if (nonTerminal.isSTART()) continue;
            this.out.print("\t[" + n2 + "]");
        }
        this.out.print("\n\t");
        for (n2 = 0; n2 < this.grammar.ncount; ++n2) {
            this.out.print("_______");
        }
        for (n2 = 0; n2 < this.grammar.scount; ++n2) {
            state = this.grammar.getState(n2);
            this.out.print("\n[" + n2 + "]");
            for (n = 0; n < this.grammar.ncount; ++n) {
                nonTerminal = this.grammar.getNonTerminal(n);
                if (nonTerminal.isSTART()) continue;
                this.out.print("\t");
                State state2 = state.getGoto(nonTerminal);
                if (state2 == null) {
                    this.out.print(" - ");
                    continue;
                }
                this.out.print(" " + state2 + " ");
            }
        }
        this.out.println("\n");
    }

    static {
        actions = new ArrayList();
        actionTable = new HashMap();
        acount = 0;
    }
}

