/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.BadXmlAnnotationException;
import hlt.language.syntax.Grammar;
import hlt.language.syntax.GrammarSymbol;
import hlt.language.syntax.Item;
import hlt.language.syntax.NonTerminal;
import hlt.language.syntax.Options;
import hlt.language.syntax.Taggable;
import hlt.language.syntax.Terminal;
import hlt.language.syntax.XmlInfo;
import hlt.language.tools.Misc;
import hlt.language.util.AbstractListIndexed;
import hlt.language.util.SetOf;

public class Rule
extends AbstractListIndexed {
    GrammarSymbol[] sequence;
    String action;
    String undoAction;
    boolean nodeCast = false;
    StringBuilder doc;
    static final Grammar grammar = Grammar.currentGrammar;
    Taggable tag = Grammar.EMPTY;
    int tagPosition = -1;
    int[] items;
    int nullableIndex = 1;
    String refName;
    private XmlInfo _xmlInfo = null;

    Rule(GrammarSymbol[] grammarSymbolArray) {
        super(Rule.grammar.rules, Rule.grammar.rcount++);
        this.setupRule(grammarSymbolArray, "$empty$", "$empty$");
    }

    Rule(GrammarSymbol[] grammarSymbolArray, String string) {
        super(Rule.grammar.rules, Rule.grammar.rcount++);
        this.setupRule(grammarSymbolArray, string, "$empty$");
    }

    Rule(GrammarSymbol[] grammarSymbolArray, String string, String string2) {
        super(Rule.grammar.rules, Rule.grammar.rcount++);
        this.setupRule(grammarSymbolArray, string, string2);
    }

    Rule(GrammarSymbol[] grammarSymbolArray, String string, boolean bl) {
        super(Rule.grammar.rules, Rule.grammar.rcount++);
        this.setupRule(grammarSymbolArray, string, "$empty$");
        this.nodeCast = bl;
    }

    Rule(GrammarSymbol[] grammarSymbolArray, String string, String string2, boolean bl) {
        super(Rule.grammar.rules, Rule.grammar.rcount++);
        this.setupRule(grammarSymbolArray, string, string2);
        this.nodeCast = bl;
    }

    final int precedence() {
        return this.tag.precedence();
    }

    final int associativity() {
        return this.tag.associativity();
    }

    final boolean isOperator() {
        return this.tag.isOperator();
    }

    void setupRule(GrammarSymbol[] grammarSymbolArray, String string, String string2) {
        this.sequence = grammarSymbolArray;
        this.action = string;
        this.undoAction = string2;
        ((NonTerminal)grammarSymbolArray[0]).rules.add(this);
        for (int i = grammarSymbolArray.length - 1; i > 0; --i) {
            if (!(grammarSymbolArray[i] instanceof Terminal)) continue;
            this.tag = (Terminal)grammarSymbolArray[i];
            this.tagPosition = i;
            break;
        }
        this.generateItems();
    }

    final NonTerminal head() {
        return (NonTerminal)this.sequence[0];
    }

    final GrammarSymbol body(int n) {
        return this.sequence[n];
    }

    final SetOf suffixFirst() {
        return Rule.grammar.getItem((Rule)this, (int)1).suffixFirst;
    }

    final boolean suffixIsNullable() {
        return Rule.grammar.getItem((Rule)this, (int)1).isNullable;
    }

    final GrammarSymbol leftMost() {
        if (this.sequence.length == 1) {
            return Grammar.EMPTY;
        }
        return this.sequence[1];
    }

    void generateItems() {
        this.items = new int[this.sequence.length];
        for (int i = 0; i < this.sequence.length; ++i) {
            new Item(this, Rule.grammar.icount, i + 1);
            ++Rule.grammar.icount;
        }
    }

    final String refName() {
        this.refName = Options.getGrammarPrefix() + "_GR_" + Misc.zeroPaddedString(this.index(), Misc.numWidth(Rule.grammar.rcount));
        return this.refName;
    }

    final String htmlFileName() {
        return this.refName() + ".html";
    }

    @Override
    public String toString() {
        String string = "[" + this.index() + "]\t" + this.sequence[0] + " -->";
        for (int i = 1; i < this.sequence.length; ++i) {
            string = string + " " + this.sequence[i];
        }
        return string + "\n\tprecedence = " + this.tag.precedence() + (String)(this._xmlInfo == null ? "" : "\n\tXML form = " + this._xmlInfo);
    }

    XmlInfo xmlInfo() {
        return this._xmlInfo;
    }

    public boolean hasXmlInfo() {
        return this._xmlInfo != null;
    }

    Rule setXmlInfo(XmlInfo xmlInfo) throws BadXmlAnnotationException {
        if (xmlInfo != null) {
            xmlInfo.checkConsistency(this);
        }
        this._xmlInfo = xmlInfo;
        return this;
    }
}

