/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.Grammar;
import hlt.language.syntax.NonTerminal;
import hlt.language.syntax.Rule;
import hlt.language.util.ArrayList;
import hlt.language.util.Indexed;
import hlt.language.util.SetOf;

class RulePath {
    static final Grammar grammar = Grammar.currentGrammar;
    NonTerminal start;
    NonTerminal end;
    ArrayList rules;
    SetOf first;
    boolean isNullable;

    private RulePath(RulePath rulePath) {
        this.first = new SetOf(RulePath.grammar.terminals);
        this.isNullable = true;
        this.rules = rulePath.rules == null ? null : (ArrayList)rulePath.rules.clone();
        this.start = rulePath.start;
        this.end = rulePath.end;
        this.first = new SetOf(rulePath.first);
        this.isNullable = rulePath.isNullable;
    }

    RulePath(NonTerminal nonTerminal) {
        this.first = new SetOf(RulePath.grammar.terminals);
        this.isNullable = true;
        this.start = this.end = nonTerminal;
    }

    final void add(Rule rule) {
        this.start = rule.head();
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        this.rules.add(rule);
        if (this.isNullable) {
            this.first.union(rule.suffixFirst());
            this.isNullable = rule.suffixIsNullable();
        }
    }

    final RulePath prepend(Rule rule) {
        RulePath rulePath = new RulePath(this);
        rulePath.add(rule);
        return rulePath;
    }

    final boolean isEmpty() {
        if (this.rules == null) {
            return true;
        }
        return this.rules.size() == 0;
    }

    final int length() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.rules.size();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof RulePath)) {
            return false;
        }
        return this.isEqualTo((RulePath)object);
    }

    final boolean isEqualTo(RulePath rulePath) {
        if (this.length() != rulePath.length()) {
            return false;
        }
        if (this.start.index() != rulePath.start.index() || this.end.index() != rulePath.end.index()) {
            return false;
        }
        if (!this.first.isEqualTo(rulePath.first)) {
            return false;
        }
        if (this.rules == null || rulePath.rules == null) {
            return false;
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            if (((Indexed)this.rules.get(i)).index() == ((Indexed)rulePath.rules.get(i)).index()) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("[" + this.start + "-");
        if (this.rules != null) {
            for (int i = this.rules.size() - 1; i >= 0; --i) {
                stringBuilder.append(((Indexed)this.rules.get(i)).index() + "-");
            }
        }
        stringBuilder.append(this.end + "]");
        stringBuilder.append(" first = " + this.first);
        if (this.isNullable) {
            stringBuilder.append(" (nullable)");
        }
        return stringBuilder.toString();
    }
}

