/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.Grammar;
import hlt.language.syntax.NonFatalParseErrorException;
import hlt.language.syntax.Taggable;

class RuleTag
implements Taggable {
    private int _precedence = 1;
    private int _associativity = 2;
    private int _fixity = 2;

    RuleTag(int n, String string) throws NonFatalParseErrorException {
        this._precedence = n;
        this.decode(string);
    }

    @Override
    public final int precedence() {
        return this._precedence;
    }

    @Override
    public final int associativity() {
        return this._associativity;
    }

    public final int fixity() {
        return this._fixity;
    }

    @Override
    public final boolean isOperator() {
        return false;
    }

    private final void decode(String string) throws NonFatalParseErrorException {
        NonFatalParseErrorException nonFatalParseErrorException = new NonFatalParseErrorException("Bad operator specifier (" + string + ")");
        if (string.length() == 2) {
            if (string.indexOf(102) == 0) {
                this._fixity = 0;
                if (string.charAt(1) == 'y') {
                    this._associativity = 1;
                    return;
                }
                if (string.charAt(1) == 'x') {
                    this._associativity = 2;
                    return;
                }
                throw nonFatalParseErrorException;
            }
            if (string.indexOf(102) == 1) {
                this._fixity = 1;
                if (string.charAt(0) == 'y') {
                    this._associativity = 0;
                    return;
                }
                if (string.charAt(0) == 'x') {
                    this._associativity = 2;
                    return;
                }
            }
            throw nonFatalParseErrorException;
        }
        if (string.length() == 3 && string.indexOf(102) == 1) {
            this._fixity = 2;
            if (string.charAt(0) == 'y') {
                if (string.charAt(2) != 'x') {
                    throw nonFatalParseErrorException;
                }
                this._associativity = 0;
                return;
            }
            if (string.charAt(0) == 'x') {
                if (string.charAt(2) == 'y') {
                    this._associativity = 1;
                } else if (string.charAt(2) == 'x') {
                    this._associativity = 2;
                } else {
                    throw nonFatalParseErrorException;
                }
                return;
            }
        }
        throw nonFatalParseErrorException;
    }

    public final String specifier() {
        Object object = "";
        if (this._associativity == 0) {
            object = (String)object + "y";
        } else if (this._fixity != 0) {
            object = (String)object + "x";
        }
        object = (String)object + "f";
        if (this._associativity == 1) {
            object = (String)object + "y";
        } else if (this._fixity != 1) {
            object = (String)object + "x";
        }
        return object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RuleTag)) {
            return false;
        }
        RuleTag ruleTag = (RuleTag)object;
        return this._precedence == ruleTag.precedence() && this._associativity == ruleTag.associativity() && this._fixity == ruleTag.fixity();
    }

    public String toString() {
        return "<" + Grammar.prologPrecedence(this._precedence) + "," + this.specifier() + ">";
    }
}

