/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.Action;
import hlt.language.syntax.Follow;
import hlt.language.syntax.Grammar;
import hlt.language.syntax.GrammarSymbol;
import hlt.language.syntax.Item;
import hlt.language.syntax.NonTerminal;
import hlt.language.syntax.Rule;
import hlt.language.syntax.StateTransition;
import hlt.language.syntax.Terminal;
import hlt.language.util.AbstractListIndexed;
import hlt.language.util.ArrayList;
import hlt.language.util.Map;
import hlt.language.util.SetOf;
import hlt.language.util.Table;
import java.util.HashMap;
import java.util.Iterator;

class State
extends AbstractListIndexed {
    static final Grammar grammar = Grammar.currentGrammar;
    SetOf items;
    SetOf kernels;
    Table transitions;
    HashMap followTable;
    ArrayList conflicts;
    ArrayList dynamicActions;
    Map actionTable;
    int ac_index;
    Map gotoTable;
    int gt_index;

    State(int n) {
        super(State.grammar.states);
        this.items = new SetOf(State.grammar.items);
        this.kernels = new SetOf(State.grammar.items);
        this.transitions = new Table();
        this.dynamicActions = new ArrayList();
        this.actionTable = new Map();
        this.gotoTable = new Map();
        this.add(grammar.getItem(n));
    }

    State(Item item) {
        super(State.grammar.states);
        this.items = new SetOf(State.grammar.items);
        this.kernels = new SetOf(State.grammar.items);
        this.transitions = new Table();
        this.dynamicActions = new ArrayList();
        this.actionTable = new Map();
        this.gotoTable = new Map();
        this.add(item);
    }

    State(SetOf setOf) {
        super(State.grammar.states);
        this.items = new SetOf(State.grammar.items);
        this.kernels = new SetOf(State.grammar.items);
        this.transitions = new Table();
        this.dynamicActions = new ArrayList();
        this.actionTable = new Map();
        this.gotoTable = new Map();
        this.add(setOf);
    }

    final StateTransition getTransition(GrammarSymbol grammarSymbol) {
        return (StateTransition)this.transitions.get(grammarSymbol);
    }

    final void add(Item item) {
        GrammarSymbol grammarSymbol = item.marker();
        StateTransition stateTransition = this.getTransition(grammarSymbol);
        if (stateTransition == null) {
            stateTransition = new StateTransition(this, grammarSymbol, new SetOf(State.grammar.items));
            this.transitions.put(grammarSymbol, stateTransition);
        }
        stateTransition.items.add(item.index());
        this.items.add(item.index());
    }

    final void add(SetOf setOf) {
        Iterator iterator = setOf.iterator();
        while (iterator.hasNext()) {
            this.add((Item)iterator.next());
        }
    }

    void closure() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            GrammarSymbol grammarSymbol = item.marker();
            if (!(grammarSymbol instanceof NonTerminal)) continue;
            Iterator iterator2 = ((NonTerminal)grammarSymbol).LSet.iterator();
            while (iterator2.hasNext()) {
                NonTerminal nonTerminal = (NonTerminal)iterator2.next();
                Iterator iterator3 = nonTerminal.rules.iterator();
                while (iterator3.hasNext()) {
                    this.add(grammar.getItem((Rule)iterator3.next(), 1));
                }
            }
        }
    }

    void computeNextStates() {
        Iterator iterator = this.transitions.values().iterator();
        while (iterator.hasNext()) {
            ((StateTransition)iterator.next()).computeNextState();
        }
    }

    final void extractKernels() {
        this.kernels = new SetOf(State.grammar.items);
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (!item.isKernel()) continue;
            this.kernels.add(item.index());
        }
    }

    final boolean computePreds() {
        boolean bl = false;
        Iterator iterator = this.transitions.values().iterator();
        while (iterator.hasNext()) {
            bl |= ((StateTransition)iterator.next()).computePreds();
        }
        return bl;
    }

    final State next(GrammarSymbol grammarSymbol) {
        return this.getTransition((GrammarSymbol)grammarSymbol).next;
    }

    final SetOf follow(NonTerminal nonTerminal) {
        Follow follow;
        if (this.followTable == null || (follow = (Follow)this.followTable.get(nonTerminal)) == null) {
            return new SetOf(State.grammar.terminals);
        }
        return follow.follows;
    }

    final Follow getFollow(NonTerminal nonTerminal) {
        Follow follow;
        if (this.followTable == null) {
            this.followTable = new HashMap();
        }
        if ((follow = (Follow)this.followTable.get(nonTerminal)) == null) {
            follow = new Follow(this, nonTerminal);
            this.followTable.put(nonTerminal, follow);
            follow.add();
            ++State.grammar.fcount;
        }
        return follow;
    }

    void addConflict(String string) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList(5);
        }
        this.conflicts.add(string);
    }

    void showConflicts() {
        if (this.conflicts == null) {
            return;
        }
        Grammar.out.println("This state has conflicts:\n");
        Iterator iterator = this.conflicts.iterator();
        while (iterator.hasNext()) {
            Grammar.out.println(iterator.next());
        }
        Grammar.out.println("-----------------------------");
    }

    final Action getAction(Terminal terminal) {
        return (Action)this.actionTable.get(terminal);
    }

    final void setAction(Terminal terminal, Action action) {
        this.actionTable.put(terminal, action);
    }

    final State getGoto(NonTerminal nonTerminal) {
        return (State)this.gotoTable.get(nonTerminal);
    }

    final void setGoto(NonTerminal nonTerminal, State state) {
        this.gotoTable.put(nonTerminal, state);
    }

    String dynamicActionSet() {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n = this.dynamicActions.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(i + ":" + this.dynamicActions.get(i)).append(i == n - 1 ? "" : ",");
        }
        return stringBuilder.append("}").toString();
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof State) {
            return this.isEqualTo((State)object);
        }
        return false;
    }

    final boolean isEqualTo(State state) {
        return this.items.isEqualTo(state.items);
    }

    @Override
    public final int hashCode() {
        return this.items.hashCode();
    }

    void show() {
        Grammar.out.println();
        Grammar.out.println("=============================");
        Grammar.out.println("STATE NUMBER: " + this.index());
        Grammar.out.println("=============================");
        this.showConflicts();
        if (!this.dynamicActions.isEmpty()) {
            Grammar.out.println("This state has dynamic actions:\n\t");
            Grammar.out.println(this.dynamicActionSet());
            Grammar.out.println("-----------------------------");
        }
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Object object = (Item)iterator.next();
            Grammar.out.print(object);
            if (((Item)object).isKernel()) {
                Grammar.out.print("\n\tPreceding states: " + ((Item)object).pred(this));
                if (((Item)object).markerIsNonTerminal()) {
                    Grammar.out.print("\n\tFollow set: " + this.getFollow((NonTerminal)((NonTerminal)((Item)object).marker())).follows);
                }
            }
            if (((Item)object).isInitial()) {
                Grammar.out.print("\n\tPreceding states: " + ((Item)object).pred(this));
            }
            if (((Item)object).isFinal()) {
                Grammar.out.print("\n\tLookahead set: " + ((Item)object).getLookaheads(this));
            }
            Grammar.out.println();
        }
        Grammar.out.println("-----------------------------");
        for (Object object : this.transitions.values()) {
            if (((StateTransition)object).symbol.isEmpty()) continue;
            Grammar.out.println("With " + ((StateTransition)object).symbol + ", go to state " + ((StateTransition)object).next.index());
        }
    }
}

