/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.tools.Misc;
import hlt.language.util.AbstractListIndexed;
import hlt.language.util.Comparable;
import hlt.language.util.Named;
import java.util.AbstractList;

public class Symbol
extends AbstractListIndexed
implements Named,
Comparable {
    String name;
    String letterName;

    Symbol(String string, AbstractList abstractList) {
        super(abstractList);
        this.name = string.intern();
    }

    Symbol(String string, AbstractList abstractList, int n) {
        super(abstractList, n);
        this.name = string.intern();
    }

    @Override
    public String name() {
        return this.name;
    }

    final String letterName() {
        if (this.letterName == null) {
            this.letterName = Misc.letterSubstring(this.name);
        }
        return this.letterName;
    }

    final char initChar() {
        return Character.toUpperCase(this.letterName().charAt(0));
    }

    @Override
    public boolean lessThan(Comparable comparable) {
        String string = this.letterName();
        String string2 = ((Symbol)comparable).letterName();
        char c = string.charAt(0);
        char c2 = string2.charAt(0);
        if (Character.isLetter(c) || Character.isDigit(c)) {
            if (!Character.isLetter(c2) && !Character.isDigit(c2)) {
                return false;
            }
        } else if (Character.isLetter(c2) || Character.isDigit(c2)) {
            return true;
        }
        return string.compareToIgnoreCase(string2) < 0;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

