/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.BadXmlAnnotationException;
import hlt.language.syntax.Documentor;
import hlt.language.syntax.GrammarSymbol;
import hlt.language.syntax.Options;
import hlt.language.syntax.Rule;
import hlt.language.syntax.Taggable;
import hlt.language.syntax.XmlInfo;
import hlt.language.tools.Misc;
import hlt.language.util.SetOf;

public class Terminal
extends GrammarSymbol
implements Taggable {
    int precedence = 1;
    int associativity = 2;
    boolean isOperator = false;
    boolean isTag = false;
    private XmlInfo _xmlInfo = null;

    Terminal(String string) {
        super(string, Terminal.grammar.terminals, Terminal.grammar.tcount++);
    }

    Terminal(String string, boolean bl) {
        super(string, Terminal.grammar.terminals, Terminal.grammar.tcount++);
        this.isOperator = bl;
    }

    @Override
    public final int precedence() {
        return this.precedence;
    }

    @Override
    public final int associativity() {
        return this.associativity;
    }

    @Override
    public final boolean isOperator() {
        return this.isOperator;
    }

    final String htmlName() {
        return Misc.htmlString(this.name);
    }

    @Override
    final String label() {
        return "<TT><B>" + this.htmlName() + "</B></TT>";
    }

    @Override
    final void link(Rule rule) {
        Documentor.hasError = this.isError();
        if (this.ruleOccurrences == null) {
            this.ruleOccurrences = new SetOf(Terminal.grammar.rules);
        }
        this.ruleOccurrences.add(rule);
    }

    @Override
    final String refName() {
        if (this.refName == null) {
            this.refName = Options.getGrammarPrefix() + "_TT_" + Misc.zeroPaddedString(this.index(), Misc.numWidth(Terminal.grammar.tcount));
        }
        return this.refName;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Terminal)) {
            return false;
        }
        Terminal terminal = (Terminal)object;
        return this.index() == terminal.index();
    }

    @Override
    public String toString() {
        return "'" + this.name + "'";
    }

    public XmlInfo xmlInfo() {
        return this._xmlInfo;
    }

    public boolean hasXmlInfo() {
        return this._xmlInfo != null;
    }

    public Terminal setXmlInfo(XmlInfo xmlInfo) throws BadXmlAnnotationException {
        if (xmlInfo != null) {
            xmlInfo.checkConsistency(this);
        }
        this._xmlInfo = xmlInfo;
        return this;
    }
}

