/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.ParseNode;
import hlt.language.syntax.ParseTreeRenderer;
import hlt.language.util.Stack;
import java.awt.Component;
import java.awt.ScrollPane;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreeDisplay
extends JFrame {
    ImageIcon leafIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/arrows/triangles/right/blue.gif"));
    ImageIcon openIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/arrows/triangles/right/green.gif"));
    ImageIcon closedIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/arrows/triangles/right/red.gif"));
    DefaultMutableTreeNode root;
    JTree tree;
    DefaultTreeModel treeModel;

    public TreeDisplay(ParseNode parseNode) {
        this(parseNode, null);
    }

    public TreeDisplay(ParseNode parseNode, String string) {
        super(string == null ? "Parse Tree" : string);
        this.setSize(500, 5000);
        this.setContentPane(new ScrollPane());
        this.setDefaultCloseOperation(3);
        this.root = new DefaultMutableTreeNode(parseNode);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        ParseTreeRenderer parseTreeRenderer = new ParseTreeRenderer();
        parseTreeRenderer.setLeafIcon(this.leafIcon);
        parseTreeRenderer.setOpenIcon(this.openIcon);
        parseTreeRenderer.setClosedIcon(this.closedIcon);
        this.tree.setCellRenderer(parseTreeRenderer);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.fillTree();
        this.getContentPane().add((Component)this.tree, "Center");
        this.setVisible(true);
    }

    public void fillTree() {
        Stack stack = new Stack();
        stack.push(this.root);
        while (!stack.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)stack.pop();
            ParseNode parseNode = (ParseNode)defaultMutableTreeNode.getUserObject();
            this.tree.makeVisible(new TreePath(defaultMutableTreeNode.getPath()));
            if (parseNode.children() == null) continue;
            for (int i = 0; i < parseNode.children().size(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(parseNode.child(i + 1));
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
                stack.push(defaultMutableTreeNode2);
            }
        }
    }
}

