/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax;

import hlt.language.syntax.BadXmlAnnotationException;
import hlt.language.syntax.GenericParser;
import hlt.language.syntax.ParseNode;
import hlt.language.syntax.ParserGenerator;
import hlt.language.syntax.Rule;
import hlt.language.syntax.Terminal;
import hlt.language.syntax.XmlAttributeInfo;
import hlt.language.syntax.XmlTextInfo;
import hlt.language.syntax.XmlTextInfoArg;
import hlt.language.syntax.XmlWrapper;
import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;
import hlt.language.util.IntToIntMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlInfo {
    private boolean _isTerminal = false;
    private boolean _terminalValueFlag;
    private String _nsPrefix = "";
    private String _localName = null;
    private XmlAttributeInfo[] _attributes = null;
    private int[] _children;
    private int[][] _xmlPaths;
    private XmlWrapper[][] _wrapperPaths;
    private String[] _attributeRefs;
    private XmlTextInfo[][] _textInfos = null;
    static final String PREFIX_COLOR = "#226688";
    static final String NAME_COLOR = "BLUE";
    static final String ATTRIBUTE_COLOR = "#EE6622";
    static final String CHILDREN_COLOR = "BROWN";
    private ArrayList _legend;

    public XmlInfo(String string) {
        this._localName = string;
    }

    public XmlInfo(String string, String string2) {
        this._localName = string;
        this._nsPrefix = string2;
    }

    public XmlInfo(String string, String string2, XmlAttributeInfo[] xmlAttributeInfoArray, int[] nArray, int[][] nArray2, XmlWrapper[][] xmlWrapperArray, String[] stringArray, boolean bl, XmlTextInfo[][] xmlTextInfoArray) {
        this._localName = string;
        this._nsPrefix = string2;
        this._attributes = xmlAttributeInfoArray;
        this._children = nArray;
        this._xmlPaths = nArray2;
        this._wrapperPaths = xmlWrapperArray;
        this._attributeRefs = stringArray;
        this._terminalValueFlag = bl;
        this._textInfos = xmlTextInfoArray;
    }

    public final boolean terminalValueFlag() {
        return this._terminalValueFlag;
    }

    public XmlInfo setTerminalValueFlag(boolean bl) {
        this._terminalValueFlag = bl;
        return this;
    }

    public XmlInfo setTerminalValueFlag() {
        this._terminalValueFlag = true;
        return this;
    }

    public final boolean hasTerminalValue() {
        return this._terminalValueFlag;
    }

    public final boolean isTerminal() {
        return this._isTerminal;
    }

    public XmlInfo setIsTerminal(boolean bl) {
        this._isTerminal = bl;
        return this;
    }

    public XmlInfo setIsTerminal() {
        this._isTerminal = true;
        return this;
    }

    public final String nsPrefix() {
        return this._nsPrefix;
    }

    public final boolean hasNsPrefix() {
        return this._nsPrefix != "";
    }

    public XmlInfo setNsPrefix(String string) {
        this._nsPrefix = string;
        return this;
    }

    public final String localName() {
        return this._localName;
    }

    public XmlInfo setLocalName(String string) {
        this._localName = string;
        return this;
    }

    public final XmlAttributeInfo[] attributes() {
        return this._attributes;
    }

    public XmlInfo setAttributes(XmlAttributeInfo[] xmlAttributeInfoArray) {
        this._attributes = xmlAttributeInfoArray;
        return this;
    }

    public final boolean hasAttributes() {
        return this._attributes != null && this._attributes.length != 0;
    }

    public final int[] children() {
        return this._children;
    }

    public XmlInfo setChildren(int[] nArray) {
        this._children = nArray;
        return this;
    }

    public final boolean hasChildren() {
        return this._children != null && this._children.length != 0;
    }

    public final int[][] xmlPaths() {
        return this._xmlPaths;
    }

    public XmlInfo setXmlPaths(int[][] nArray) {
        this._xmlPaths = nArray;
        return this;
    }

    public final boolean hasXmlPaths() {
        if (this._xmlPaths == null || this._xmlPaths.length == 0) {
            return false;
        }
        for (int i = 0; i < this._xmlPaths.length; ++i) {
            if (this._xmlPaths[i] == null) continue;
            return true;
        }
        return false;
    }

    public final XmlWrapper[][] wrapperPaths() {
        return this._wrapperPaths;
    }

    public XmlInfo setWrapperPaths(XmlWrapper[][] xmlWrapperArray) {
        this._wrapperPaths = xmlWrapperArray;
        return this;
    }

    public final boolean hasWrapperPaths() {
        if (this._wrapperPaths == null || this._wrapperPaths.length == 0) {
            return false;
        }
        for (int i = 0; i < this._wrapperPaths.length; ++i) {
            if (this._wrapperPaths[i] == null) continue;
            return true;
        }
        return false;
    }

    public final String[] attributeRefs() {
        return this._attributeRefs;
    }

    public XmlInfo setAttributeRefs(String[] stringArray) {
        this._attributeRefs = stringArray;
        return this;
    }

    public String attributeRefs(int n) {
        return this._attributeRefs[n];
    }

    public final boolean hasAttributeRefs() {
        if (this._attributeRefs == null) {
            return false;
        }
        int n = this._attributeRefs.length;
        while (n-- > 0) {
            if (this._attributeRefs[n] == null) continue;
            return true;
        }
        return false;
    }

    public XmlInfo setTextInfos(XmlTextInfo[][] xmlTextInfoArray) {
        this._textInfos = xmlTextInfoArray;
        return this;
    }

    public final boolean hasTextInfos() {
        if (this._textInfos == null) {
            return false;
        }
        int n = this._textInfos.length;
        while (n-- > 0) {
            if (this._textInfos[n] == null) continue;
            return true;
        }
        return false;
    }

    public void checkConsistency(Rule rule) throws BadXmlAnnotationException {
    }

    public void checkConsistency(Terminal terminal) throws BadXmlAnnotationException {
    }

    public void generateTerminalXmlInfo(ParserGenerator parserGenerator, int n) throws IOException {
        int n2;
        parserGenerator.pl("      { // Code for XML serialization annotation:");
        parserGenerator.pl("        // " + this);
        parserGenerator.pl("        terminals[" + n + "].setXmlInfo(new XmlInfo(\"" + this._localName + "\"" + (String)(this._nsPrefix == "" ? "" : ",\"" + this._nsPrefix + "\"") + "));");
        if (this.hasAttributes()) {
            parserGenerator.pl("        XmlAttributeInfo[] xmlAttributes = new XmlAttributeInfo[" + this._attributes.length + "];");
            for (n2 = 0; n2 < this._attributes.length; ++n2) {
                this.generateAttributeInitializers(parserGenerator, n2, this._attributes[n2]);
            }
            parserGenerator.pl("        terminals[" + n + "].addXmlInfo(xmlAttributes);");
        }
        if (this.hasWrapperPaths()) {
            parserGenerator.pl("        XmlWrapper[][] paths = new XmlWrapper[" + this._wrapperPaths.length + "][];");
            parserGenerator.pl("        XmlWrapper[] path;");
            for (n2 = 0; n2 < this._wrapperPaths.length; ++n2) {
                if (this._wrapperPaths[n2] == null) continue;
                parserGenerator.pl("        path = new XmlWrapper[" + this._wrapperPaths[n2].length + "];");
                for (int i = 0; i < this._wrapperPaths[n2].length; ++i) {
                    parserGenerator.pl("        path[" + i + "] = new XmlWrapper(\"" + this._wrapperPaths[n2][i].getTag() + (this._wrapperPaths[n2][i].isStarred() ? "\",true" : "\"") + ");");
                }
                parserGenerator.pl("        paths[" + n2 + "] = path;");
            }
            parserGenerator.pl("        terminals[" + n + "].addXmlInfo(paths);");
        }
        if (this.isTerminal() && this.hasTerminalValue()) {
            parserGenerator.pl("        terminals[" + n + "].setTerminalValueFlag();");
        }
        parserGenerator.pl("      }");
    }

    public void generateRuleXmlInfo(ParserGenerator parserGenerator, int n) throws IOException {
        parserGenerator.pl("      { // Code for XML serialization annotation:");
        parserGenerator.pl("        // " + this);
        parserGenerator.pl("        rules[" + n + "].setXmlInfo(new XmlInfo(\"" + this._localName + "\"" + (String)(this._nsPrefix == "" ? "" : ",\"" + this._nsPrefix + "\"") + "));");
        if (this.hasAttributes() || this.hasChildren()) {
            int n2;
            if (this.hasAttributes()) {
                parserGenerator.pl("        XmlAttributeInfo[] xmlAttributes = new XmlAttributeInfo[" + this._attributes.length + "];");
                for (n2 = 0; n2 < this._attributes.length; ++n2) {
                    this.generateAttributeInitializers(parserGenerator, n2, this._attributes[n2]);
                }
                parserGenerator.pl("        rules[" + n + "].addXmlInfo(xmlAttributes);");
            }
            if (this.hasChildren()) {
                int n3;
                parserGenerator.pl("        int[] xmlChildren = " + Misc.arrayToString(this._children, "{", ",", "}") + ";");
                parserGenerator.pl("        rules[" + n + "].addXmlInfo(xmlChildren);");
                if (this.hasXmlPaths()) {
                    parserGenerator.pl("          {");
                    parserGenerator.pl("             int[][] paths = new int[" + this._xmlPaths.length + "][];");
                    parserGenerator.pl("             int[] path;");
                    for (n2 = 0; n2 < this._xmlPaths.length; ++n2) {
                        if (this._xmlPaths[n2] == null) continue;
                        parserGenerator.pl("             path = new int[" + this._xmlPaths[n2].length + "];");
                        for (n3 = 0; n3 < this._xmlPaths[n2].length; ++n3) {
                            parserGenerator.pl("             path[" + n3 + "] = " + this._xmlPaths[n2][n3] + ";");
                        }
                        parserGenerator.pl("             paths[" + n2 + "] = path;");
                    }
                    parserGenerator.pl("             rules[" + n + "].addXmlInfo(paths);");
                    parserGenerator.pl("          }");
                }
                if (this.hasWrapperPaths()) {
                    parserGenerator.pl("        XmlWrapper[][] paths = new XmlWrapper[" + this._wrapperPaths.length + "][];");
                    parserGenerator.pl("        XmlWrapper[] path;");
                    for (n2 = 0; n2 < this._wrapperPaths.length; ++n2) {
                        if (this._wrapperPaths[n2] == null) continue;
                        parserGenerator.pl("        path = new XmlWrapper[" + this._wrapperPaths[n2].length + "];");
                        for (n3 = 0; n3 < this._wrapperPaths[n2].length; ++n3) {
                            parserGenerator.pl("        path[" + n3 + "] = new XmlWrapper(\"" + this._wrapperPaths[n2][n3].getTag() + (this._wrapperPaths[n2][n3].isStarred() ? "\",true" : "\"") + ");");
                        }
                        parserGenerator.pl("        paths[" + n2 + "] = path;");
                    }
                    parserGenerator.pl("        rules[" + n + "].addXmlInfo(paths);");
                }
                if (this.hasAttributeRefs()) {
                    parserGenerator.pl("        String[] refs = new String[" + this._attributeRefs.length + "];");
                    for (n2 = 0; n2 < this._attributeRefs.length; ++n2) {
                        if (this._attributeRefs[n2] == null) continue;
                        parserGenerator.pl("        refs[" + n2 + "] = \"" + this._attributeRefs[n2] + "\";");
                    }
                    parserGenerator.pl("        rules[" + n + "].addXmlInfo(refs);");
                }
                if (this.hasTextInfos()) {
                    parserGenerator.pl("        XmlTextInfo[][] infos = new XmlTextInfo[" + this._textInfos.length + "][];");
                    for (n2 = 0; n2 < this._textInfos.length; ++n2) {
                        if (this._textInfos[n2] == null) continue;
                        parserGenerator.pl("        infos[" + n2 + "] = new XmlTextInfo[" + this._textInfos[n2].length + "];");
                        for (n3 = 0; n3 < this._textInfos[n2].length; ++n3) {
                            parserGenerator.pl("        infos[" + n2 + "][" + n3 + "] = new XmlTextInfo(" + (String)(this._textInfos[n2][n3].child() == 0 ? "" : this._textInfos[n2][n3].child() + ",") + "\"" + this._textInfos[n2][n3].text() + "\");");
                        }
                    }
                    parserGenerator.pl("        rules[" + n + "].addXmlInfo(infos);");
                }
            }
        }
        parserGenerator.pl("      }");
    }

    public void generateAttributeInitializers(ParserGenerator parserGenerator, int n, XmlAttributeInfo xmlAttributeInfo) throws IOException {
        if (xmlAttributeInfo.isSpecialForm()) {
            if (xmlAttributeInfo.hasTerminalValue()) {
                parserGenerator.pl("        xmlAttributes[" + n + "] = new XmlAttributeInfo(\"" + xmlAttributeInfo.name() + "\");");
                return;
            }
            XmlTextInfoArg[] xmlTextInfoArgArray = xmlAttributeInfo.value().specialForm().textArgs();
            parserGenerator.pl("        XmlTextInfoArg[] formArgs = new XmlTextInfoArg[" + xmlTextInfoArgArray.length + "];");
            for (int i = 0; i < xmlTextInfoArgArray.length; ++i) {
                parserGenerator.pl(this.makeTextInfoArg(xmlTextInfoArgArray[i], i));
            }
            parserGenerator.pl("        XmlSpecialForm textForm = new XmlSpecialForm(formArgs);");
            parserGenerator.pl("        xmlAttributes[" + n + "] = new XmlAttributeInfo(\"" + xmlAttributeInfo.name() + "\",textForm);");
            return;
        }
        if (xmlAttributeInfo.hasLiteralValue()) {
            parserGenerator.pl("        xmlAttributes[" + n + "] = XmlAttributeInfo.literalXmlAttributeInfo(\"" + xmlAttributeInfo.name() + "\",\"" + xmlAttributeInfo.value().text() + "\");");
            return;
        }
        if (xmlAttributeInfo.hasAttribute()) {
            parserGenerator.pl("        xmlAttributes[" + n + "] = XmlAttributeInfo.refXmlAttributeInfo(\"" + xmlAttributeInfo.name() + "\",\"" + xmlAttributeInfo.attributeNameRef() + "\");");
        } else {
            parserGenerator.pl("        xmlAttributes[" + n + "] = XmlAttributeInfo.eltXmlAttributeInfo(\"" + xmlAttributeInfo.name() + "\");");
        }
        if (xmlAttributeInfo.hasChild()) {
            parserGenerator.pl("        xmlAttributes[" + n + "].setChild(" + xmlAttributeInfo.child() + ");");
        }
        if (xmlAttributeInfo.hasPath()) {
            parserGenerator.pl("        {");
            parserGenerator.pl("           int[] path = " + Misc.arrayToString(xmlAttributeInfo.xmlPath(), "{", ",", "}") + ";");
            parserGenerator.pl("           xmlAttributes[" + n + "].setXmlPath(path);");
            parserGenerator.pl("        }");
        }
    }

    private final String makeTextInfoArg(XmlTextInfoArg xmlTextInfoArg, int n) {
        if (xmlTextInfoArg.isLiteral()) {
            return "        (formArgs[" + n + "] = new XmlTextInfoArg()).setText(\"" + xmlTextInfoArg.text() + "\");";
        }
        return "        formArgs[" + n + "] = new XmlTextInfoArg(" + xmlTextInfoArg.child() + "," + (String)(xmlTextInfoArg.path() != null ? xmlTextInfoArg.path() + "," : "") + "\"" + xmlTextInfoArg.attribute() + "\");";
    }

    public final Element createXmlForm(ParseNode parseNode, Element element) {
        Object object;
        Object object2;
        int n;
        Element element2 = new Element(this._localName);
        if (this._nsPrefix != "") {
            element2.setNamespace(element.getNamespace(this._nsPrefix));
        }
        ArrayList arrayList = new ArrayList();
        IntToIntMap intToIntMap = new IntToIntMap();
        int n2 = 0;
        if (this.hasChildren() && !this.isTerminal()) {
            for (n = 0; n < this._children.length; ++n) {
                if (intToIntMap.containsKey(this._children[n])) continue;
                object2 = parseNode.getChild(this._children[n] - 1);
                ArrayList arrayList2 = ((ParseNode)object2).xmlify(element);
                if (this.hasWrapperPaths()) {
                    object = this._wrapperPaths[n];
                    int n3 = ((XmlWrapper[])object).length;
                    while (n3-- > 0) {
                        if (object[n3].isStarred()) {
                            for (int i = 0; i < arrayList2.size(); ++i) {
                                arrayList2.set(i, new Element(((XmlWrapper)object[n3]).getTag()).addContent((Content)((Element)arrayList2.get(i))));
                            }
                            continue;
                        }
                        ArrayList arrayList3 = new ArrayList(1);
                        arrayList3.add(new Element(((XmlWrapper)object[n3]).getTag()).addContent((Collection)arrayList2));
                        arrayList2 = arrayList3;
                    }
                }
                arrayList.add(arrayList2);
                intToIntMap.put(this._children[n], n2++);
            }
        }
        if (this.hasAttributes()) {
            for (n = 0; n < this._attributes.length; ++n) {
                if (this._attributes[n].hasTextForm()) {
                    object2 = this._attributes[n].specialForm().textArgs();
                    for (int i = 0; i < ((XmlTextInfoArg[])object2).length; ++i) {
                        if (((XmlTextInfoArg)object2[i]).isLiteral() || intToIntMap.containsKey(((XmlTextInfoArg)object2[i]).child())) continue;
                        object = parseNode.getChild(((XmlTextInfoArg)object2[i]).child() - 1);
                        arrayList.add(((ParseNode)object).xmlify(element));
                        intToIntMap.put(((XmlTextInfoArg)object2[i]).child(), n2++);
                    }
                    continue;
                }
                if (!this._attributes[n].isDeepAttributeReference() || intToIntMap.containsKey(this._attributes[n].child())) continue;
                object2 = parseNode.getChild(this._attributes[n].child() - 1);
                arrayList.add(((ParseNode)object2).xmlify(element));
                intToIntMap.put(this._attributes[n].child(), n2++);
            }
        }
        if (this.hasAttributes()) {
            this.processAttributes(parseNode, element2, arrayList, intToIntMap);
        }
        if (this.isTerminal() && this.hasTerminalValue()) {
            this.processTerminal(parseNode, element2);
        } else if (this.hasChildren()) {
            this.processChildren(parseNode, element2, arrayList, intToIntMap);
        }
        return element2;
    }

    final void processAttributes(ParseNode parseNode, Element element, ArrayList arrayList, IntToIntMap intToIntMap) {
        for (int i = 0; i < this._attributes.length; ++i) {
            int n;
            XmlAttributeInfo xmlAttributeInfo = this._attributes[i];
            Object object = "";
            if (xmlAttributeInfo.isSpecialForm()) {
                if (xmlAttributeInfo.hasTerminalValue()) {
                    object = Misc.unquotify(parseNode.stringValue());
                } else {
                    XmlTextInfoArg[] xmlTextInfoArgArray = xmlAttributeInfo.specialForm().textArgs();
                    for (n = 0; n < xmlTextInfoArgArray.length; ++n) {
                        object = (String)object + xmlTextInfoArgArray[n].makeTextForm(arrayList, intToIntMap);
                    }
                }
                element.setAttribute(xmlAttributeInfo.name(), (String)object);
                continue;
            }
            if (xmlAttributeInfo.hasLiteralValue()) {
                element.setAttribute(xmlAttributeInfo.name(), xmlAttributeInfo.value().text());
                continue;
            }
            int n2 = xmlAttributeInfo.child();
            n = intToIntMap.get(n2);
            ArrayList arrayList2 = (ArrayList)arrayList.get(n);
            Element element2 = (Element)arrayList2.get(0);
            if (xmlAttributeInfo.hasPath()) {
                int[] nArray = xmlAttributeInfo.xmlPath();
                int n3 = 0;
                while (i < nArray.length) {
                    element2 = (Element)element2.getContent(nArray[n3] - 1);
                    ++n3;
                }
            }
            if (xmlAttributeInfo.hasAttribute()) {
                element.setAttribute(xmlAttributeInfo.name(), element2.getAttributeValue(xmlAttributeInfo.attributeNameRef()));
                continue;
            }
            element.setAttribute(xmlAttributeInfo.name(), element2.getText());
        }
    }

    final void processTerminal(ParseNode parseNode, Element element) {
        if (this.hasWrapperPaths()) {
            XmlWrapper[] xmlWrapperArray = this._wrapperPaths[0];
            Element element2 = new Element(xmlWrapperArray[xmlWrapperArray.length - 1].getTag()).addContent(parseNode.stringValue());
            int n = xmlWrapperArray.length;
            while (n-- > 0) {
                if (n == 0) {
                    element.addContent((Content)element2);
                    continue;
                }
                element2 = new Element(xmlWrapperArray[n - 1].getTag()).addContent((Content)element2);
            }
        } else {
            element.addContent(parseNode.stringValue());
        }
    }

    final void processChildren(ParseNode parseNode, Element element, ArrayList arrayList, IntToIntMap intToIntMap) {
        for (int i = 0; i < this._children.length; ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(intToIntMap.get(this._children[i]));
            for (Element element2 : arrayList2) {
                boolean bl = true;
                boolean bl2 = false;
                if (this.hasXmlPaths() && this._xmlPaths[i] != null) {
                    int[] nArray = this._xmlPaths[i];
                    for (int j = 0; j < nArray.length; ++j) {
                        List list = element2.getChildren();
                        if (list.isEmpty()) {
                            element.setText(Misc.unquotify(element2.getText()));
                            bl = false;
                            continue;
                        }
                        if (nArray[j] != 0) {
                            int n = nArray[j] - 1;
                            if (j == nArray.length - 1) {
                                Element element3 = new Element("_DUMMY_");
                                element2 = list.set(n, element3);
                                element3.setName(element3.getName() + element2.getName() + "_");
                                continue;
                            }
                            element2 = (Element)list.get(n);
                            continue;
                        }
                        bl2 = true;
                        while (list.size() > 0) {
                            element2 = ((Element)list.get(0)).detach();
                            element.addContent((Content)element2);
                        }
                    }
                }
                if (bl2) continue;
                if (this.hasAttributeRefs() && this._attributeRefs[i] != null) {
                    element.setText(element2.getAttributeValue(this._attributeRefs[i]));
                    bl = false;
                }
                if (!bl) continue;
                element.addContent((Content)element2);
            }
        }
    }

    final void showXmlElement(Element element, PrintStream printStream) throws IOException {
        if (element != null) {
            GenericParser.xmlWriter().output(element, (OutputStream)printStream);
        } else {
            printStream.println("null");
        }
    }

    final void showXmlElements(ArrayList arrayList, PrintStream printStream) throws IOException {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.showXmlElement((Element)iterator.next(), printStream);
        }
    }

    final String margin(int n) {
        return Misc.repeat(n, ' ');
    }

    static final String color(Object object, String string) {
        return "<SPAN STYLE=\"COLOR:" + string + "\">" + object + "</SPAN>";
    }

    final String colorPrefix() {
        return this.colorPrefix(true);
    }

    final String colorPrefix(boolean bl) {
        if (bl) {
            return XmlInfo.color(this._nsPrefix, PREFIX_COLOR);
        }
        return this._nsPrefix;
    }

    final String colorName() {
        return this.colorName(true);
    }

    final String colorName(boolean bl) {
        if (bl) {
            return XmlInfo.color(this._localName, NAME_COLOR);
        }
        return this._localName;
    }

    static final String colorName(Object object) {
        return XmlInfo.colorName(object, true);
    }

    static final String colorName(Object object, boolean bl) {
        if (bl) {
            return XmlInfo.color(object, NAME_COLOR);
        }
        return object.toString();
    }

    final String colorAttribute(Object object) {
        return XmlInfo.colorAttribute(object, true);
    }

    static final String colorAttribute(Object object, boolean bl) {
        if (bl) {
            return XmlInfo.color(object, ATTRIBUTE_COLOR);
        }
        return object.toString();
    }

    final String colorChild(Object object) {
        return this.colorChild(object, true);
    }

    final String colorChild(Object object, boolean bl) {
        if (bl) {
            return XmlInfo.color(object, CHILDREN_COLOR);
        }
        return object.toString();
    }

    final ArrayList legend() {
        return this._legend;
    }

    final boolean hasLegend() {
        return this._legend != null && this._legend.size() > 0;
    }

    final void resetLegend() {
        this._legend = new ArrayList();
    }

    final String ordinal(int n) {
        return n + "<SUP>" + Misc.ordinal(n) + "</SUP>";
    }

    final String formatAttributeRef(XmlAttributeInfo xmlAttributeInfo, int n, String string) {
        String string2 = this.colorAttribute(xmlAttributeInfo.name() + " = <TT><I>A<SUB>" + n + "</SUB></I></TT>");
        String string3 = xmlAttributeInfo.hasAttribute() ? "value of attribute <TT>\"" + this.colorAttribute(xmlAttributeInfo.attributeNameRef()) + "\"</TT>" : "XML node text content";
        StringBuilder stringBuilder = new StringBuilder(this.colorAttribute("<TT><I>A<SUB>" + n + "</SUB></I></TT>") + " is the " + string3);
        if (xmlAttributeInfo.hasPath()) {
            int[] nArray = xmlAttributeInfo.xmlPath();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuilder.append(" of the " + this.ordinal(nArray[i]) + " XML component");
            }
        }
        stringBuilder.append(" of the ").append(this.ordinal(xmlAttributeInfo.child())).append(" RHS symbol").append(" (").append(string).append(")");
        this._legend.add(stringBuilder.toString());
        return string2;
    }

    final String formatAttributeTextForm(XmlAttributeInfo xmlAttributeInfo, int n, Rule rule) {
        String string = this.colorAttribute(xmlAttributeInfo.name() + " = <TT><I>A<SUB>" + n + "</SUB></I></TT>");
        StringBuilder stringBuilder = new StringBuilder(this.colorAttribute("<TT><I>A<SUB>" + n + "</SUB></I></TT>"));
        stringBuilder.append(" is the concatenation of the following pieces of text:");
        stringBuilder.append("\n<UL>\n");
        XmlTextInfoArg[] xmlTextInfoArgArray = xmlAttributeInfo.specialForm().textArgs();
        for (int i = 0; i < xmlTextInfoArgArray.length; ++i) {
            if (xmlTextInfoArgArray[i].isLiteral()) {
                stringBuilder.append("<LI> the literal string: <TT>").append(this.colorAttribute(xmlTextInfoArgArray[i])).append("</TT>");
                continue;
            }
            stringBuilder.append("<LI> the value of the ");
            String string2 = rule.sequence[xmlTextInfoArgArray[i].child()].htmlRef();
            String string3 = xmlTextInfoArgArray[i].hasAttribute() ? "attribute <TT>" + this.colorAttribute(xmlTextInfoArgArray[i].attribute()) + "</TT>" : "XML node text content";
            stringBuilder.append(string3);
            if (xmlTextInfoArgArray[i].hasPath()) {
                int[] nArray = xmlTextInfoArgArray[i].path();
                for (int j = 0; j < nArray.length; ++j) {
                    stringBuilder.append(" of the ").append(this.colorAttribute(this.ordinal(nArray[j]))).append(" XML component");
                }
            }
            stringBuilder.append(" of the ").append(this.colorAttribute(this.ordinal(xmlTextInfoArgArray[i].child()))).append(" RHS symbol").append(" (").append(string2).append(")");
        }
        stringBuilder.append("\n</UL>\n");
        this._legend.add(stringBuilder.toString());
        return string;
    }

    final String childRef(int n, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                stringBuilder.append(" of the ").append(this.ordinal(nArray[i])).append(" XML component");
            }
        }
        stringBuilder.append(" of the ").append(this.ordinal(n)).append(" RHS symbol");
        return stringBuilder.toString();
    }

    public final String toString(int n, String string, boolean bl) {
        int n2;
        if (!bl) {
            string = "";
        }
        String string2 = bl ? "\t" : " ";
        String string3 = this.margin(n);
        StringBuilder stringBuilder = new StringBuilder(string3).append("[").append(string);
        String string4 = string3 = bl ? this.margin(n + 2) : " ";
        if (this._nsPrefix != "") {
            stringBuilder.append(string3).append("nsprefix").append(string2).append("= \"").append(this.colorPrefix(bl)).append("\"").append(string);
        }
        if (this._localName != null) {
            stringBuilder.append(string3).append("localname").append(string2).append("= \"").append(this.colorName(bl)).append("\"").append(string);
        }
        if (this.hasAttributes()) {
            stringBuilder.append(string3).append("attributes").append(string2).append("= { ");
            for (n2 = 0; n2 < this._attributes.length; ++n2) {
                if (bl) {
                    stringBuilder.append("\n                    ");
                }
                stringBuilder.append(XmlInfo.colorAttribute(this._attributes[n2].toString(), bl));
                if (bl) continue;
                stringBuilder.append(" ");
            }
            if (bl) {
                stringBuilder.append("\n                  ");
            }
            stringBuilder.append("}").append(string);
        }
        if (this.isTerminal() && this.hasTerminalValue()) {
            stringBuilder.append(string3).append("child").append(string2).append("= ( ");
            if (this.hasWrapperPaths()) {
                stringBuilder.append(Misc.arrayToString(this._wrapperPaths[0], "", "", ""));
            }
            stringBuilder.append(XmlInfo.colorAttribute("$VALUE", bl));
            stringBuilder.append(" )").append(string);
        } else if (this.hasChildren()) {
            stringBuilder.append(string3).append("children").append(string2).append("= ( ");
            for (n2 = 0; n2 < this._children.length; ++n2) {
                if (bl) {
                    stringBuilder.append("\n                    ");
                }
                if (this.hasWrapperPaths()) {
                    stringBuilder.append(this.colorChild(Misc.arrayToString(this._wrapperPaths[n2], "", "", ""), bl));
                }
                stringBuilder.append(this.colorChild(String.valueOf(this._children[n2]), bl));
                if (this.hasXmlPaths() && this._xmlPaths[n2] != null) {
                    stringBuilder.append(this.colorChild(Misc.arrayToString(this._xmlPaths[n2], "[", ".", "]"), bl));
                }
                if (this.hasAttributeRefs() && this._attributeRefs[n2] != null) {
                    stringBuilder.append("/").append(this.colorChild(this._attributeRefs[n2], bl));
                }
                if (bl) continue;
                stringBuilder.append(" ");
            }
            if (bl) {
                stringBuilder.append("\n                  ");
            }
            stringBuilder.append(")").append(string);
        }
        string3 = bl ? this.margin(n) : " ";
        return stringBuilder.append(string3).append("]").toString();
    }

    public final String toHtmlString(int n, String string) {
        return this.toString(n, string, true);
    }

    public final String toPrettyHtmlString(int n) {
        return this.toString(n, "\n", true);
    }

    public final String toString() {
        return this.toString(0, " ", false);
    }
}

