/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.syntax.xml;

import hlt.language.io.StreamTokenizer;
import hlt.language.syntax.ParseNode;
import hlt.language.syntax.Tokenizer;
import hlt.language.syntax.xml.XmlAnnotationParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class XmlAnnotationTokenizer
implements Tokenizer {
    public static final String nsPrefixKey = "nsprefix";
    public static final String localNameKey = "localname";
    public static final String attributesKey = "attributes";
    public static final String childrenKey = "children";
    int lineno;
    Reader reader;
    StreamTokenizer st;
    boolean hasNsPrefix = false;
    boolean hasLocalName = false;
    boolean hasAttributes = false;
    boolean hasChildren = false;

    public XmlAnnotationTokenizer(String string) {
        this.setInput(string);
    }

    public final void setInput(String string) {
        this.setReader(new StringReader(string));
    }

    @Override
    public final void setReader(Reader reader) {
        this.reader = reader;
        this.st = new StreamTokenizer(this.reader);
        this.st.parseDigitsOnly();
        this.st.ordinaryChars("?$+-.(){}[]<>:;,=!&|*%/");
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.wordChars("_@");
    }

    @Override
    public final Reader getReader() {
        return this.reader;
    }

    @Override
    public final int lineNumber() {
        return this.lineno;
    }

    final ParseNode locate(ParseNode parseNode) {
        return parseNode;
    }

    final ParseNode position() {
        return this.locate(XmlAnnotationParser.numberToken("POSITION", (int)this.st.nval));
    }

    final ParseNode symbol(String string) {
        return this.locate(XmlAnnotationParser.symbolToken("SYMBOL", string));
    }

    final ParseNode keyValSep() {
        return this.locate(XmlAnnotationParser.literalToken("KEYVALSEP"));
    }

    final ParseNode listSep() {
        return this.locate(XmlAnnotationParser.literalToken("LISTSEP"));
    }

    final ParseNode dot() {
        return this.locate(XmlAnnotationParser.literalToken("DOT"));
    }

    final ParseNode star() {
        return this.locate(XmlAnnotationParser.literalToken("STAR"));
    }

    final ParseNode slash() {
        return this.locate(XmlAnnotationParser.literalToken("SLASH"));
    }

    final ParseNode value() {
        return this.locate(XmlAnnotationParser.literalToken("VALUE"));
    }

    final ParseNode text() {
        return this.locate(XmlAnnotationParser.literalToken("TEXT"));
    }

    final ParseNode keywordOrSymbol(String string) {
        if (!this.hasNsPrefix && this.isPrefixOf(string, nsPrefixKey)) {
            this.hasNsPrefix = true;
            return this.literal("NSPREFIX");
        }
        if (!this.hasLocalName && this.isPrefixOf(string, localNameKey)) {
            this.hasLocalName = true;
            return this.literal("LOCALNAME");
        }
        if (!this.hasAttributes && this.isPrefixOf(string, attributesKey)) {
            this.hasAttributes = true;
            return this.literal("ATTRIBUTES");
        }
        if (!this.hasChildren && this.isPrefixOf(string, childrenKey)) {
            this.hasChildren = true;
            return this.literal("CHILDREN");
        }
        return this.symbol(string);
    }

    final boolean isPrefixOf(String string, String string2) {
        return string == string2 || string.length() != 0 && string2.toLowerCase().startsWith(string.toLowerCase());
    }

    final ParseNode literal(int n) {
        return this.locate(XmlAnnotationParser.literalToken(String.valueOf((char)n)));
    }

    final ParseNode literal(String string) {
        return this.locate(XmlAnnotationParser.literalToken(string));
    }

    @Override
    public final ParseNode nextToken() throws IOException {
        ParseNode parseNode = null;
        int n = this.st.nextToken();
        int n2 = this.st.peek();
        this.lineno = this.st.lineno();
        switch (n) {
            case -7: {
                return this.nextToken();
            }
            case -1: {
                parseNode = this.locate(XmlAnnotationParser.eoi());
                break;
            }
            case -5: {
                parseNode = this.position();
                break;
            }
            case -4: {
                parseNode = this.keywordOrSymbol(this.st.sval);
                break;
            }
            case 34: 
            case 39: {
                parseNode = this.symbol(this.st.sval);
                break;
            }
            case 36: {
                if (this.st.nextToken() != -4) break;
                if (this.st.sval == "value" || this.st.sval == "VALUE") {
                    parseNode = this.value();
                    break;
                }
                if (this.st.sval == "text" || this.st.sval == "TEXT") {
                    parseNode = this.text();
                    break;
                }
                this.st.pushBack();
                parseNode = this.literal(n);
                break;
            }
            case 58: {
                parseNode = this.keyValSep();
                break;
            }
            case 61: {
                if (this.st.peek() == 62) {
                    parseNode = this.keyValSep();
                    this.st.nextToken();
                    break;
                }
                parseNode = this.keyValSep();
                break;
            }
            case 45: {
                if (this.st.peek() == 62) {
                    parseNode = this.keyValSep();
                    this.st.nextToken();
                    break;
                }
            }
            case 46: {
                parseNode = this.dot();
                break;
            }
            case 42: {
                parseNode = this.star();
                break;
            }
            case 47: {
                parseNode = this.slash();
                break;
            }
            case 44: 
            case 59: {
                parseNode = this.listSep();
                break;
            }
            default: {
                parseNode = this.literal(n);
            }
        }
        return parseNode;
    }
}

