/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.tools;

import hlt.language.io.FileTools;
import hlt.language.tools.CommandException;
import java.util.HashMap;

public class Command {
    private static HashMap optionTable = new HashMap();
    private static String[] arguments = null;
    private static String defaultArgument = null;
    private static int optionWidth = " Option".length();
    private static int defaultWidth = "(Default)".length();
    private static String usage = null;

    public static final void optionalArgument(String string) {
        defaultArgument = string;
    }

    private static final void checkOption(String string) {
        for (OptionEntry optionEntry : optionTable.values()) {
            if (!optionEntry.name.startsWith(string) && !string.startsWith(optionEntry.name)) continue;
            throw new CommandException("\nAttempt to define option '" + string + "' which conflicts with defined option '" + optionEntry.name + "'");
        }
    }

    public static final void defineOption(String string, String string2) {
        Command.checkOption(string);
        optionTable.put(string, new OptionEntry(string, string2));
        optionWidth = Math.max(optionWidth, string.length() + 1);
        defaultWidth = Math.max(defaultWidth, string2.length() + 2);
    }

    public static final void defineOption(String string, String string2, String string3) {
        Command.checkOption(string);
        optionTable.put(string, new OptionEntry(string, string2, string3));
        optionWidth = Math.max(optionWidth, string.length() + 1);
        defaultWidth = Math.max(defaultWidth, string2.length() + 2);
    }

    public static final String getOption(String string) {
        OptionEntry optionEntry = (OptionEntry)optionTable.get(string);
        if (optionEntry == null) {
            throw new CommandException("Unknown command option (" + string + ")");
        }
        if (optionEntry.value == null) {
            return optionEntry.defaultValue;
        }
        return optionEntry.value;
    }

    public static final boolean optionIsPresent(String string) {
        OptionEntry optionEntry = (OptionEntry)optionTable.get(string);
        if (optionEntry == null) {
            throw new CommandException("Unknown command option (" + string + ")");
        }
        return optionEntry.value != null;
    }

    public static final String getArgument() {
        if (arguments == null) {
            return defaultArgument;
        }
        return arguments[0];
    }

    public static final String[] getArguments() {
        if (arguments == null) {
            String[] stringArray = new String[]{defaultArgument};
            return stringArray;
        }
        return arguments;
    }

    public static final boolean argumentIsPresent() {
        return arguments != null;
    }

    public static final String fullFileNamePrefix(String string) {
        return FileTools.fullPrefix(string);
    }

    public static final String fileNamePrefix(String string) {
        return FileTools.prefix(string);
    }

    public static final String fileNameDir(String string) {
        return FileTools.dir(string);
    }

    public static final String fileNameSuffix(String string) {
        return FileTools.suffix(string);
    }

    public static final String completeFileName(String string, String string2) {
        String string3 = "." + string2;
        if (string.endsWith(string3)) {
            return string;
        }
        return string + string3;
    }

    private static void padWrite(String string, int n) {
        System.err.print(string);
        for (int i = string.length(); i <= n; ++i) {
            System.err.print(" ");
        }
    }

    private static void printHelpLine(String string, String string2, String string3) {
        Command.padWrite(string, optionWidth);
        Command.padWrite(string2, defaultWidth);
        System.err.println(string3);
    }

    public static String getUsage() {
        return usage;
    }

    public static void setUsage(String string) {
        usage = string;
    }

    public static void printUsage() {
        if (usage != null) {
            System.err.println(usage);
        }
    }

    public static final void printHelp() {
        Command.printUsage();
        if (optionTable.size() == 0) {
            System.err.println("Sorry - no help available!");
        } else {
            Command.printHelpLine("Option ", "(Default)", "Description");
            Command.printHelpLine("------ ", "---------", "-----------");
            for (OptionEntry optionEntry : optionTable.values()) {
                Command.printHelpLine("-" + optionEntry.name, "(" + optionEntry.defaultValue + ")", optionEntry.help);
            }
            System.err.println();
        }
    }

    public static final boolean parseCommandLine(String[] stringArray) {
        OptionEntry optionEntry2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-') {
                boolean bl = false;
                boolean bl2 = false;
                stringArray[n] = stringArray[n].substring(1);
                int n2 = stringArray[n].length();
                if (n2 > 0) {
                    for (OptionEntry optionEntry2 : optionTable.values()) {
                        if (!stringArray[n].startsWith(optionEntry2.name)) continue;
                        int n3 = optionEntry2.name.length();
                        bl2 = n3 < n2;
                        if (bl2) {
                            optionEntry2.value = stringArray[n].substring(n3, n2);
                        }
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    Command.printHelp();
                    return false;
                }
                if (bl2) {
                    ++n;
                    continue;
                }
                if (n < stringArray.length - 1 && stringArray[n + 1].charAt(0) != '-' && optionEntry2.defaultValue.length() > 0) {
                    optionEntry2.value = stringArray[n + 1];
                    n += 2;
                    continue;
                }
                if (optionEntry2.value == null && optionEntry2.defaultValue.length() == 0) {
                    optionEntry2.value = "";
                }
                ++n;
                continue;
            }
            arguments = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, arguments, 0, stringArray.length - n);
            break;
        }
        return true;
    }

    static class OptionEntry {
        String name;
        String value;
        String defaultValue;
        String help = "";

        OptionEntry(String string, String string2) {
            this.name = string;
            this.defaultValue = string2;
        }

        OptionEntry(String string, String string2, String string3) {
            this.name = string;
            this.defaultValue = string2;
            this.help = string3;
        }
    }
}

