/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.tools;

import hlt.language.io.FileTools;
import hlt.language.tools.Command;
import hlt.language.tools.GenericHilite;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class GenericHiliteCommand
extends Command {
    static BufferedWriter index;

    private static void helpAndExit() {
        GenericHiliteCommand.printHelp();
        System.exit(1);
    }

    static final void w(String string) throws IOException {
        index.write(string);
    }

    static final void wl(String string) throws IOException {
        index.write(string + "\n");
    }

    public static void main(String[] stringArray) {
        String string = ".java";
        GenericHiliteCommand.defineOption("c", "Hilite.Configuration", "configuration file");
        GenericHiliteCommand.defineOption("d", ".", "target directory");
        GenericHiliteCommand.defineOption("o", "output.html", "HTML output file");
        GenericHiliteCommand.defineOption("!", "", "overwrite existing files");
        GenericHiliteCommand.defineOption("s", File.separator, "file separator character");
        try {
            GenericHiliteCommand.defineOption("p", new File("").getCanonicalPath(), "package or directory");
        }
        catch (IOException iOException) {
            System.err.println("*** Can't access current directory");
        }
        GenericHiliteCommand.setUsage("\nUsage: hl [options] sourcefile\n");
        if (GenericHiliteCommand.parseCommandLine(stringArray)) {
            FileTools.setSeparator(GenericHiliteCommand.getOption("s"));
            try {
                boolean bl;
                if (!GenericHiliteCommand.argumentIsPresent()) {
                    GenericHiliteCommand.helpAndExit();
                }
                String[] stringArray2 = GenericHiliteCommand.getArguments();
                String string2 = GenericHiliteCommand.optionIsPresent("d") || GenericHiliteCommand.fileNameDir(stringArray2[0]).length() == 0 ? GenericHiliteCommand.getOption("d") + GenericHiliteCommand.getOption("s") : GenericHiliteCommand.fileNameDir(stringArray2[0]) + GenericHiliteCommand.getOption("s");
                boolean bl2 = bl = stringArray2.length > 1;
                if (bl) {
                    String string3 = "Source files in " + GenericHiliteCommand.getOption("p");
                    index = new BufferedWriter(new FileWriter(string2 + "index.html"));
                    GenericHiliteCommand.wl("<HTML>");
                    GenericHiliteCommand.wl("<HEAD>");
                    GenericHiliteCommand.wl("<TITLE>");
                    GenericHiliteCommand.wl(string3);
                    GenericHiliteCommand.wl("</TITLE>");
                    GenericHiliteCommand.wl("</HEAD>");
                    GenericHiliteCommand.wl("<BODY BGCOLOR=\"#DDDDDD\">");
                    GenericHiliteCommand.wl("<CENTER>");
                    GenericHiliteCommand.wl("<TABLE BGCOLOR=\"WHITE\" WIDTH=50% BORDER=5 CELLPADDING=20>");
                    GenericHiliteCommand.wl("<TR><TD ALIGN=CENTER>");
                    GenericHiliteCommand.wl("<SPAN STYLE=\"FONT-SIZE=\"X-LARGE\"><B>" + string3 + "</B></SPAN>");
                    GenericHiliteCommand.wl("<P>");
                    GenericHiliteCommand.wl("</TD></TR>");
                    GenericHiliteCommand.wl("</TABLE>");
                    GenericHiliteCommand.wl("</CENTER>");
                    GenericHiliteCommand.wl("<P>");
                    GenericHiliteCommand.wl("<OL>");
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string4 = stringArray2[i];
                    String string5 = GenericHiliteCommand.fileNameDir(string4);
                    String string6 = GenericHiliteCommand.fileNamePrefix(string4);
                    Object object = GenericHiliteCommand.fileNameSuffix(string4);
                    String string7 = (String)(string5.length() > 0 ? string5 + GenericHiliteCommand.getOption("s") : "") + string6;
                    String string8 = GenericHiliteCommand.getOption("c");
                    Object object2 = GenericHiliteCommand.getOption("o");
                    if (((String)object).length() == 0) {
                        if (!new File(string7).exists()) {
                            object = string;
                        }
                    } else {
                        object = "." + (String)object;
                    }
                    if (!GenericHiliteCommand.optionIsPresent("o")) {
                        object2 = string6;
                    }
                    if (GenericHiliteCommand.fileNameSuffix((String)object2).length() == 0) {
                        object2 = (String)object2 + ".html";
                    }
                    new GenericHilite(string7 + (String)object, string8, (String)object2, string2, GenericHiliteCommand.optionIsPresent("!"));
                    if (!bl) continue;
                    GenericHiliteCommand.w("<LI><A HREF=\"" + (String)object2 + "\">");
                    GenericHiliteCommand.wl("<TT><B>" + string6 + (String)object + "</B></TT></A>");
                }
                if (bl) {
                    GenericHiliteCommand.wl("</OL>");
                    GenericHiliteCommand.wl("<P>");
                    GenericHiliteCommand.wl("<HR>");
                    GenericHiliteCommand.wl("<P ALIGN=\"RIGHT\">");
                    GenericHiliteCommand.wl("<SPAN STYLE=\"COLOR:#F07070\"><EM>\nThis file was generated on " + new Date() + "<BR>by the <SPAN STYLE=\"COLOR:BROWN\"><TT>hlt.language.tools.GenericHiliteCommand</TT></SPAN> Java tool written by <A HREF=\"http://hassan-ait-kaci.net\">Hassan A&iuml;t-Kaci</A></EM></SPAN>");
                    GenericHiliteCommand.wl("<P>");
                    GenericHiliteCommand.wl("<HR>");
                    GenericHiliteCommand.wl("</BODY>");
                    GenericHiliteCommand.wl("</HTML>");
                    index.close();
                    System.out.println("*** Wrote file index.html in " + string2);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.err.println("\n*** Couldn't create HTML files");
            }
        }
    }
}

