/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.tools;

import hlt.language.io.FileTools;
import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class Hilite {
    String inputFileName;
    File inputFile;
    PushbackReader input;
    String outputFileName;
    String outputDir;
    BufferedWriter output;
    static final String MODIFIER = "modifier";
    static final String TYPE = "type";
    static final String CONTROL = "control";
    static final String DECLARE = "declare";
    static final String LITERAL = "literal";
    static final String OTHER = "other";
    static final HashMap javaWords = new HashMap();
    String FONT_SIZE;
    String BACKGROUND_COLOR;
    String JAVADOC_BG_COLOR;
    String JAVADOC_TEXT_COLOR;
    String COMMENT_COLOR;
    String BRACKET_COLOR;
    String KEYWORD_COLOR;
    String MODIFIER_COLOR;
    String TYPE_COLOR;
    String CONTROL_COLOR;
    String DECLARE_COLOR;
    String LITERAL_COLOR;
    String OTHER_COLOR;
    String CLASS_COLOR;
    String CONSTANT_COLOR;
    String NUMBER_COLOR;
    String STRING_COLOR;
    String TEXT_COLOR;
    String ANNOTATE_COLOR;
    String ANNOTATE_TAG_COLOR;
    String COMMENT_STYLE;
    String BRACKET_STYLE;
    String KEYWORD_STYLE;
    String MODIFIER_STYLE;
    String TYPE_STYLE;
    String CONTROL_STYLE;
    String DECLARE_STYLE;
    String LITERAL_STYLE;
    String OTHER_STYLE;
    String CLASS_STYLE;
    String CONSTANT_STYLE;
    String NUMBER_STYLE;
    String STRING_STYLE;
    String PLAIN_STYLE;
    String ANNOTATE_STYLE;
    String ANNOTATE_TAG;
    String styleFileName = "style.css";
    String configurationFileName = "Hilite.Configuration";
    Properties configuration = new Properties();
    static final int EOF = -1;
    static final int PLAINCHAR = 0;
    static final int BRACKET = 1;
    static final int COMMENT = 2;
    static final int NUMBER = 3;
    static final int STRING = 4;
    static final int CLASS = 5;
    static final int CONSTANT = 6;
    static final int KEYWORD = 7;
    static final int PLAINTEXT = 8;
    static final int JAVADOC = 9;
    boolean isClassIdentifier;
    boolean isConstantIdentifier;
    StringBuilder tokenWord;
    String keywordType;
    int tokenChar;
    int tokenType;
    int annotateChar = 36;
    boolean annotateMode = false;
    String annotateTag;
    boolean formatJavadocComments = true;
    HashMap javadocTags;
    static HashMap javadocTagsLabels = new HashMap();

    public Hilite(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.inputFileName = string;
        this.configurationFileName = string2;
        this.styleFileName = string3;
        this.outputFileName = string4;
        this.outputDir = string5;
        this.hilite(bl);
    }

    public Hilite(String string, boolean bl) {
        this.inputFileName = string;
        this.outputFileName = FileTools.prefix(string) + ".html";
        this.hilite(bl);
    }

    public Hilite(String string) {
        this.inputFileName = string;
        this.outputFileName = FileTools.prefix(string) + ".html";
        this.hilite(false);
    }

    String dir() {
        if (this.outputDir == null) {
            return "";
        }
        return this.outputDir;
    }

    void hilite(boolean bl) {
        this.inputFile = new File(this.inputFileName);
        if (this.inputFile.exists()) {
            try {
                this.input = new PushbackReader(new BufferedReader(new FileReader(this.inputFile)));
                File file = new File(this.dir() + this.outputFileName);
                if (!bl && file.exists() && !Misc.askYesNo("*** File " + this.dir() + this.outputFileName + " already exists; overwrite anyway")) {
                    throw new IOException("Aborting hiliting file " + this.inputFileName);
                }
                try {
                    this.output = new BufferedWriter(new FileWriter(file));
                }
                catch (IOException iOException) {
                    this.output = new BufferedWriter(new FileWriter(file));
                }
                this.configure();
                this.hiliteFile();
            }
            catch (IOException iOException) {
                System.err.println("*** " + iOException.getMessage());
            }
        } else {
            Misc.beep();
            System.err.println("*** File " + this.inputFileName + " not found!");
        }
    }

    static final void jkw_m(String string) {
        javaWords.put(string, MODIFIER);
    }

    static final void jkw_t(String string) {
        javaWords.put(string, TYPE);
    }

    static final void jkw_c(String string) {
        javaWords.put(string, CONTROL);
    }

    static final void jkw_d(String string) {
        javaWords.put(string, DECLARE);
    }

    static final void jkw_l(String string) {
        javaWords.put(string, LITERAL);
    }

    static final void jkw_o(String string) {
        javaWords.put(string, OTHER);
    }

    final String configure(String string) {
        return this.configuration.getProperty(string);
    }

    final String configure(String string, String string2) {
        String string3 = this.configuration.getProperty(string);
        return string3 == null ? string2 : (string3.equals("*") ? null : string3);
    }

    final void configure() {
        File file = new File(this.configurationFileName);
        if (file.exists()) {
            try {
                this.configuration.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                System.err.println(iOException + this.configurationFileName);
            }
        } else {
            System.err.println("*** File " + this.configurationFileName + " not found (using defaults)");
        }
        this.configureValues();
    }

    final void configureValues() {
        this.FONT_SIZE = this.configure("FONT_SIZE");
        this.BACKGROUND_COLOR = this.configure("BACKGROUND_COLOR", "#CCCFF");
        this.JAVADOC_BG_COLOR = this.configure("JAVADOC_BG_COLOR", "WHITE");
        this.JAVADOC_TEXT_COLOR = this.configure("JAVADOC_TEXT_COLOR", "BLACK");
        this.COMMENT_COLOR = this.configure("COMMENT_COLOR", "#777777");
        this.BRACKET_COLOR = this.configure("BRACKET_COLOR", "GRAY");
        this.KEYWORD_COLOR = this.configure("KEYWORD_COLOR", "BLUE");
        this.MODIFIER_COLOR = this.configure("MODIFIER_COLOR", "PURPLE");
        this.TYPE_COLOR = this.configure("TYPE_COLOR", "BLUE");
        this.CONTROL_COLOR = this.configure("CONTROL_COLOR", "BROWN");
        this.DECLARE_COLOR = this.configure("DECLARE_COLOR", "RED");
        this.LITERAL_COLOR = this.configure("LITERAL_COLOR", "GREEN");
        this.OTHER_COLOR = this.configure("OTHER_COLOR", this.KEYWORD_COLOR);
        this.CLASS_COLOR = this.configure("CLASS_COLOR", "BLUE");
        this.CONSTANT_COLOR = this.configure("CONSTANT_COLOR", "#009900");
        this.NUMBER_COLOR = this.configure("NUMBER_COLOR", this.LITERAL_COLOR);
        this.STRING_COLOR = this.configure("STRING_COLOR", this.LITERAL_COLOR);
        this.TEXT_COLOR = this.configure("TEXT_COLOR");
        this.ANNOTATE_COLOR = this.configure("ANNOTATE_COLOR", "YELLOW");
        this.ANNOTATE_TAG_COLOR = this.configure("ANNOTATE_TAG_COLOR", "RED");
        this.COMMENT_STYLE = this.configure("COMMENT_STYLE", "EM");
        this.BRACKET_STYLE = this.configure("BRACKET_STYLE");
        this.KEYWORD_STYLE = this.configure("KEYWORD_STYLE", "STRONG");
        this.MODIFIER_STYLE = this.configure("MODIFIER_STYLE", this.KEYWORD_STYLE);
        this.TYPE_STYLE = this.configure("TYPE_STYLE", this.KEYWORD_STYLE);
        this.CONTROL_STYLE = this.configure("CONTROL_STYLE", this.KEYWORD_STYLE);
        this.DECLARE_STYLE = this.configure("DECLARE_STYLE", this.KEYWORD_STYLE);
        this.LITERAL_STYLE = this.configure("LITERAL_STYLE");
        this.OTHER_STYLE = this.configure("OTHER_STYLE", this.KEYWORD_STYLE);
        this.CLASS_STYLE = this.configure("CLASS_STYLE", this.KEYWORD_STYLE);
        this.CONSTANT_STYLE = this.configure("CONSTANT_STYLE");
        this.NUMBER_STYLE = this.configure("NUMBER_STYLE");
        this.STRING_STYLE = this.configure("STRING_STYLE");
        this.PLAIN_STYLE = this.configure("PLAIN_STYLE");
        this.ANNOTATE_STYLE = this.configure("ANNOTATE_STYLE");
        this.ANNOTATE_TAG = this.configure("ANNOTATE_TAG", "PLEASE READ");
        this.annotateTag = "<BLINK><SPAN STYLE=\"COLOR:" + this.ANNOTATE_TAG_COLOR + "\" SIZE=-1><B>" + this.ANNOTATE_TAG + "</B></SPAN></BLINK>/";
    }

    final String keywordColor() {
        if (this.keywordType == MODIFIER) {
            return this.MODIFIER_COLOR;
        }
        if (this.keywordType == TYPE) {
            return this.TYPE_COLOR;
        }
        if (this.keywordType == CONTROL) {
            return this.CONTROL_COLOR;
        }
        if (this.keywordType == DECLARE) {
            return this.DECLARE_COLOR;
        }
        if (this.keywordType == LITERAL) {
            return this.LITERAL_COLOR;
        }
        if (this.keywordType == OTHER) {
            return this.OTHER_COLOR;
        }
        return this.KEYWORD_COLOR;
    }

    final String keywordStyle() {
        if (this.keywordType == MODIFIER) {
            return this.MODIFIER_STYLE;
        }
        if (this.keywordType == TYPE) {
            return this.TYPE_STYLE;
        }
        if (this.keywordType == CONTROL) {
            return this.CONTROL_STYLE;
        }
        if (this.keywordType == DECLARE) {
            return this.DECLARE_STYLE;
        }
        if (this.keywordType == LITERAL) {
            return this.LITERAL_STYLE;
        }
        if (this.keywordType == OTHER) {
            return this.OTHER_STYLE;
        }
        return this.KEYWORD_STYLE;
    }

    final boolean isAnnotateChar() {
        return this.tokenChar == this.annotateChar;
    }

    static final boolean isBracket(int n) {
        switch (n) {
            case 40: 
            case 41: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    static final boolean isQuote(int n) {
        switch (n) {
            case 34: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    final boolean isKeyword() {
        this.keywordType = (String)javaWords.get(this.tokenWord.toString());
        return this.keywordType != null;
    }

    final boolean isIdentifierStart(int n) {
        return Character.isJavaIdentifierStart((char)n);
    }

    final boolean isIdentifierPart(int n) {
        return Character.isJavaIdentifierPart((char)n);
    }

    final boolean isDigit(int n) {
        return Character.isDigit((char)n);
    }

    final boolean isLetter(int n) {
        return Character.isLetter((char)n);
    }

    final boolean isUpperCase(int n) {
        return Character.isUpperCase((char)n);
    }

    final boolean isLowerCase(int n) {
        return Character.isLowerCase((char)n);
    }

    final String htmlCodeString(int n) {
        switch (n) {
            case 60: {
                return "&lt;";
            }
            case 62: {
                return "&gt;";
            }
            case 38: {
                return "&amp;";
            }
        }
        return String.valueOf((char)n);
    }

    final void writeTokenChar() throws IOException {
        this.output.write(this.htmlCodeString(this.tokenChar));
    }

    final int nextChar() throws EOFException, IOException {
        int n = this.input.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    final void readIdentifier() throws IOException {
        this.tokenWord = new StringBuilder(String.valueOf((char)this.tokenChar));
        this.isConstantIdentifier = this.isClassIdentifier = this.isUpperCase(this.tokenChar);
        while (true) {
            this.tokenChar = this.nextChar();
            if (!this.isIdentifierPart(this.tokenChar)) break;
            this.tokenWord.append((char)this.tokenChar);
            this.isConstantIdentifier &= !this.isLetter(this.tokenChar) || !this.isLowerCase(this.tokenChar);
        }
        this.input.unread(this.tokenChar);
    }

    final void readNumber() throws IOException {
        this.tokenWord = new StringBuilder(String.valueOf((char)this.tokenChar));
        while (true) {
            this.tokenChar = this.nextChar();
            if (!this.isDigit(this.tokenChar)) break;
            this.tokenWord.append((char)this.tokenChar);
        }
        this.input.unread(this.tokenChar);
    }

    final void checkAnnotate() throws IOException {
        this.tokenChar = this.nextChar();
        this.annotateMode = this.isAnnotateChar();
        if (this.annotateMode) {
            this.tokenWord.append(this.annotateTag);
        } else {
            this.input.unread(this.tokenChar);
        }
    }

    final void readSlashSlashComment() throws IOException {
        this.tokenWord = new StringBuilder("//");
        this.checkAnnotate();
        do {
            try {
                this.tokenChar = this.nextChar();
            }
            catch (EOFException eOFException) {
                return;
            }
            this.tokenWord.append(this.htmlCodeString(this.tokenChar));
        } while (this.tokenChar != 10);
    }

    final void readSlashStarComment() throws IOException {
        if (this.formatJavadocComments && this.isJavadocComment()) {
            this.formatJavadocComment();
            return;
        }
        this.tokenWord = new StringBuilder("/*");
        this.checkAnnotate();
        while (true) {
            this.tokenChar = this.nextChar();
            this.tokenWord.append(this.htmlCodeString(this.tokenChar));
            if (this.tokenChar != 42) continue;
            int n = this.nextChar();
            if (n == 47) {
                this.tokenWord.append("/");
                return;
            }
            this.tokenWord.append(this.htmlCodeString(n));
        }
    }

    final boolean isJavadocComment() throws IOException {
        this.tokenChar = this.nextChar();
        if (this.tokenChar != 42) {
            this.input.unread(this.tokenChar);
            return false;
        }
        this.tokenType = 9;
        return true;
    }

    final void formatJavadocComment() throws IOException {
        boolean bl;
        this.javadocTags = new HashMap();
        this.output.write("</PRE>\n<HR>\n<CENTER>\n<TABLE BGCOLOR=\"" + this.JAVADOC_BG_COLOR + "\" WIDTH=90% BORDER=1 CELLPADDING=10>\n<TR><TD><SPAN STYLE=\"COLOR:" + this.JAVADOC_TEXT_COLOR + "\">\n");
        block0: do {
            this.tokenChar = this.nextChar();
            while (this.tokenChar == 42) {
                this.tokenChar = this.nextChar();
                if (this.tokenChar != 47) continue;
                break block0;
            }
            if (this.tokenChar == 92) {
                this.tokenChar = this.nextChar();
            }
            bl = false;
            if (this.tokenChar == 64) {
                bl = this.recordJavadocTag();
                continue;
            }
            this.output.write(this.tokenChar);
        } while (!bl);
        if (!this.javadocTags.isEmpty()) {
            this.formatJavadocTags();
        }
        this.output.write("\n</SPAN></TD></TR>\n</TABLE>\n</CENTER>\n<P>\n<PRE>");
    }

    final boolean recordJavadocTag() throws IOException {
        boolean bl = false;
        this.tokenChar = this.nextChar();
        if (!this.isLetter(this.tokenChar)) {
            this.output.write(64);
            this.output.write(this.tokenChar);
            return bl;
        }
        this.tokenWord = new StringBuilder();
        do {
            this.tokenWord.append((char)this.tokenChar);
        } while (this.isLetter(this.tokenChar = this.nextChar()));
        ArrayList arrayList = (ArrayList)this.javadocTags.get(this.tokenWord.toString());
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.javadocTags.put(this.tokenWord.toString(), arrayList);
        }
        if (this.tokenChar == 10) {
            return bl;
        }
        this.tokenWord = new StringBuilder();
        this.tokenChar = this.nextChar();
        while (this.tokenChar != 10) {
            if (this.tokenChar == 42) {
                int n = this.nextChar();
                if (n == 47) {
                    bl = true;
                    break;
                }
                this.tokenWord.append((char)this.tokenChar);
                this.tokenWord.append((char)n);
            } else {
                this.tokenWord.append((char)this.tokenChar);
            }
            this.tokenChar = this.nextChar();
        }
        arrayList.add(this.tokenWord.toString().trim());
        return bl;
    }

    final void formatJavadocTags() throws IOException {
        this.output.write("\n<P><TABLE>");
        for (String string : this.javadocTags.keySet()) {
            this.output.write("\n<TR><TD VALIGN=TOP><STRONG>" + this.javadocTagFormat(string) + "</STRONG></TD>");
            this.output.write("<TD>&nbsp;</TD>");
            ArrayList arrayList = (ArrayList)this.javadocTags.get(string);
            if (arrayList.isEmpty()) continue;
            boolean bl = true;
            boolean bl2 = string.equalsIgnoreCase("param");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    this.output.write("\n<TD>");
                    bl = false;
                    if (bl2) {
                        this.output.write("<TABLE>\n");
                    }
                } else {
                    this.output.write(bl2 ? "\n" : ", ");
                }
                this.output.write(this.javadocTagDefFormat(string, (String)iterator.next()));
            }
            if (bl2) {
                this.output.write("\n</TABLE>");
            }
            this.output.write("\n</TD></tr>");
        }
        this.output.write("\n</TABLE>\n");
    }

    final String javadocTagFormat(String string) {
        Object object = (String)javadocTagsLabels.get(string);
        if (object != null) {
            return object;
        }
        object = String.valueOf(Character.toUpperCase(string.charAt(0))) + string.toLowerCase().substring(1) + ":";
        return object;
    }

    final String javadocTagDefFormat(String string, String string2) {
        if (string.equalsIgnoreCase("param")) {
            int n = string2.indexOf(32);
            int n2 = string2.indexOf(9);
            n = n >= 0 && n2 >= 0 ? Math.min(n, n2) : Math.max(n, n2);
            return "<TR><TD VALIGN=BASELINE><SPAN STYLE=\"COLOR:" + this.JAVADOC_TEXT_COLOR + "\"><TT>" + (n >= 0 ? string2.substring(0, n) : string2) + "&nbsp;</TT></SPAN></TD><TD><SPAN STYLE=\"COLOR:" + this.JAVADOC_TEXT_COLOR + "\">- " + (n >= 0 ? string2.substring(n) : string2) + "</SPAN></TD></TR>";
        }
        if (!string.equalsIgnoreCase("see") || string2.regionMatches(true, 0, "<A HREF", 0, 7)) {
            return string2;
        }
        int n = string2.lastIndexOf(35);
        String string3 = n < 0 ? string2 : string2.substring(0, n);
        String string4 = n < 0 ? "" : string2.substring(n);
        return "<A HREF=\"" + string3 + (string3.length() > 0 ? ".html" : "") + string4 + "\">" + (n < 0 ? string3.substring(string3.lastIndexOf(46) + 1) : string4.substring(1)) + "</A>";
    }

    final void readQuotedWord() throws IOException {
        block1: {
            this.tokenWord = new StringBuilder(String.valueOf((char)this.tokenChar));
            int n = this.tokenChar;
            int n2 = 0;
            while (true) {
                int n3 = n2;
                n2 = this.tokenChar;
                this.tokenChar = this.nextChar();
                this.tokenWord.append(this.htmlCodeString(this.tokenChar));
                if (this.tokenChar != n) continue;
                if (n2 != 92) break block1;
                if (n3 == 92) break;
            }
            return;
        }
    }

    final int nextToken() throws IOException {
        this.tokenChar = this.input.read();
        if (this.tokenChar == -1) {
            this.tokenType = -1;
            return -1;
        }
        if (this.isIdentifierStart(this.tokenChar)) {
            this.readIdentifier();
            if (this.isConstantIdentifier) {
                this.tokenType = 6;
                return 6;
            }
            if (this.isClassIdentifier) {
                this.tokenType = 5;
                return 5;
            }
            if (this.isKeyword()) {
                this.tokenType = 7;
                return 7;
            }
            this.tokenType = 8;
            return 8;
        }
        if (this.isDigit(this.tokenChar)) {
            this.readNumber();
            this.tokenType = 3;
            return 3;
        }
        if (this.tokenChar == 47) {
            int n = this.nextChar();
            if (n == 47 || n == 42) {
                this.tokenType = 2;
                if (n == 47) {
                    this.readSlashSlashComment();
                    return this.tokenType;
                }
                this.readSlashStarComment();
                return this.tokenType;
            }
            this.output.write(this.tokenChar);
            this.input.unread(n);
            return this.nextToken();
        }
        if (Hilite.isQuote(this.tokenChar)) {
            this.readQuotedWord();
            this.tokenType = 4;
            return 4;
        }
        if (Hilite.isBracket(this.tokenChar)) {
            this.tokenWord = new StringBuilder(String.valueOf((char)this.tokenChar));
            this.tokenType = 1;
            return 1;
        }
        this.tokenType = 0;
        return 0;
    }

    final void hiliteFile() throws IOException {
        System.out.println("*** Hiliting file:\t" + FileTools.simpleName(this.inputFileName));
        this.preamble();
        block6: while (true) {
            switch (this.nextToken()) {
                case -1: {
                    this.input.close();
                    break block6;
                }
                case 0: {
                    this.writeTokenChar();
                    continue block6;
                }
                case 8: {
                    this.output.write(this.tokenWord.toString());
                    continue block6;
                }
                case 9: {
                    continue block6;
                }
                default: {
                    this.hiliteTokenWord();
                    continue block6;
                }
            }
            break;
        }
        this.postamble();
    }

    final void preamble() throws IOException {
        String string = this.BACKGROUND_COLOR == null ? "" : " BGCOLOR=\"" + this.BACKGROUND_COLOR + "\"";
        String string2 = this.TEXT_COLOR == null ? "" : " TEXT=\"" + this.TEXT_COLOR + "\"";
        String string3 = this.FONT_SIZE == null ? "" : " SIZE=\"" + this.FONT_SIZE + "\"";
        this.output.write("<HTML>\n<HEAD>\n<TITLE>\n" + this.outputFileName + "\n</TITLE>\n<LINK REL=\"STYLESHEET\" TYPE=\"text/css\" HREF=\"" + this.styleFileName + "\">\n</HEAD>\n<BODY" + string + string2 + string3 + ">\n<CENTER>\n<TABLE BGCOLOR=white WIDTH=50% BORDER=5 CELLPADDING=20>\n<TR><TD ALIGN=CENTER>\n<SPAN STYLE=\"FONT-SIZE:XX-LARGE\"><TT><B>" + FileTools.simpleName(this.inputFileName) + "</B></TT></SPAN>\n<P>\n</TD></TR>\n</TABLE>\n</CENTER>\n<PRE>\n");
    }

    final void postamble() throws IOException {
        this.output.write("\n</PRE>\n<P>\n<HR>\n<P ALIGN=\"RIGHT\"><SPAN STYLE=\"COLOR:#F07070\"><EM>\nThis file was generated on " + new Date() + " from file <SPAN STYLE=\"COLOR:BROWN\"><KBD>" + FileTools.simpleName(this.inputFileName) + "</KBD></SPAN><BR>by the <SPAN STYLE=\"COLOR:BROWN\"><KBD>hlt.language.tools.Hilite</KBD></SPAN> Java tool written by <A HREF=\"http://hassan-ait-kaci.net\">Hassan A&iuml;t-Kaci</A></EM></SPAN>\n<P>\n<HR>\n</BODY>\n</HTML>");
        this.output.close();
        System.out.println("*** Wrote hilited file:\t" + this.outputFileName);
    }

    final void hiliteTokenWord() throws IOException {
        String string = null;
        String string2 = null;
        switch (this.tokenType) {
            case 1: {
                string = this.BRACKET_COLOR;
                string2 = this.BRACKET_STYLE;
                break;
            }
            case 2: {
                string = this.annotateMode ? this.ANNOTATE_COLOR : this.COMMENT_COLOR;
                string2 = this.annotateMode ? this.ANNOTATE_STYLE : this.COMMENT_STYLE;
                break;
            }
            case 3: {
                string = this.NUMBER_COLOR;
                string2 = this.NUMBER_STYLE;
                break;
            }
            case 4: {
                string = this.STRING_COLOR;
                string2 = this.STRING_STYLE;
                break;
            }
            case 7: {
                string = this.keywordColor();
                string2 = this.keywordStyle();
                break;
            }
            case 5: {
                string = this.CLASS_COLOR;
                string2 = this.CLASS_STYLE;
                break;
            }
            case 6: {
                string = this.CONSTANT_COLOR;
                string2 = this.CONSTANT_STYLE;
            }
        }
        if (string2 != null) {
            this.tokenWord.insert(0, "<" + string2 + ">").append("</" + string2 + ">");
        }
        if (string != null) {
            this.tokenWord.insert(0, "<SPAN STYLE=\"COLOR:" + string + "\">").append("</SPAN>");
        }
        this.output.write(this.tokenWord.toString());
    }

    static {
        Hilite.jkw_m("abstract");
        Hilite.jkw_t("boolean");
        Hilite.jkw_c("break");
        Hilite.jkw_t("byte");
        Hilite.jkw_c("case");
        Hilite.jkw_c("catch");
        Hilite.jkw_t("char");
        Hilite.jkw_d("class");
        Hilite.jkw_d("const");
        Hilite.jkw_c("continue");
        Hilite.jkw_c("default");
        Hilite.jkw_c("do");
        Hilite.jkw_t("double");
        Hilite.jkw_c("else");
        Hilite.jkw_d("extends");
        Hilite.jkw_m("final");
        Hilite.jkw_c("finally");
        Hilite.jkw_t("float");
        Hilite.jkw_c("for");
        Hilite.jkw_c("goto");
        Hilite.jkw_c("if");
        Hilite.jkw_d("implements");
        Hilite.jkw_d("import");
        Hilite.jkw_o("instanceof");
        Hilite.jkw_t("int");
        Hilite.jkw_d("interface");
        Hilite.jkw_t("long");
        Hilite.jkw_m("native");
        Hilite.jkw_o("new");
        Hilite.jkw_d("package");
        Hilite.jkw_m("private");
        Hilite.jkw_m("protected");
        Hilite.jkw_m("public");
        Hilite.jkw_c("return");
        Hilite.jkw_t("short");
        Hilite.jkw_m("static");
        Hilite.jkw_o("super");
        Hilite.jkw_c("switch");
        Hilite.jkw_m("synchronized");
        Hilite.jkw_o("this");
        Hilite.jkw_c("throw");
        Hilite.jkw_d("throws");
        Hilite.jkw_m("transient");
        Hilite.jkw_c("try");
        Hilite.jkw_t("void");
        Hilite.jkw_m("volatile");
        Hilite.jkw_c("while");
        Hilite.jkw_l("null");
        Hilite.jkw_l("true");
        Hilite.jkw_l("false");
        javadocTagsLabels.put("deprecated", "<BLINK>Deprecated!</BLINK>");
        javadocTagsLabels.put("exception", "Throws:");
        javadocTagsLabels.put("param", "Parameters:");
        javadocTagsLabels.put("return", "Returns:");
        javadocTagsLabels.put("see", "See also:");
        javadocTagsLabels.put("since", "Since:");
        javadocTagsLabels.put("version", "Version:");
    }
}

