/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.tools;

import hlt.language.io.FileTools;
import hlt.language.tools.Command;
import hlt.language.tools.Hilite;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class HiliteCommand
extends Command {
    static BufferedWriter index;

    private static void helpAndExit() {
        HiliteCommand.printHelp();
        System.exit(1);
    }

    static final void w(String string) throws IOException {
        index.write(string);
    }

    static final void wl(String string) throws IOException {
        index.write(string + "\n");
    }

    public static void main(String[] stringArray) {
        String string = ".java";
        HiliteCommand.defineOption("con", "Hilite.Configuration", "configuration file");
        HiliteCommand.defineOption("css", "style.css", "CSS style file");
        HiliteCommand.defineOption("d", ".", "target directory");
        HiliteCommand.defineOption("o", "output.html", "HTML output file");
        HiliteCommand.defineOption("!", "", "overwrite existing files");
        HiliteCommand.defineOption("s", File.separator, "file separator character");
        try {
            HiliteCommand.defineOption("p", new File("").getCanonicalPath(), "package or directory");
        }
        catch (IOException iOException) {
            System.err.println("*** Can't access current directory");
        }
        HiliteCommand.setUsage("\nUsage: hl [options] sourcefile\n");
        if (HiliteCommand.parseCommandLine(stringArray)) {
            FileTools.setSeparator(HiliteCommand.getOption("s"));
            try {
                boolean bl;
                if (!HiliteCommand.argumentIsPresent()) {
                    HiliteCommand.helpAndExit();
                }
                String[] stringArray2 = HiliteCommand.getArguments();
                String string2 = HiliteCommand.optionIsPresent("d") || HiliteCommand.fileNameDir(stringArray2[0]).length() == 0 ? HiliteCommand.getOption("d") + HiliteCommand.getOption("s") : HiliteCommand.fileNameDir(stringArray2[0]) + HiliteCommand.getOption("s");
                boolean bl2 = bl = stringArray2.length > 1;
                if (bl) {
                    String string3 = "Source files in " + HiliteCommand.getOption("p");
                    index = new BufferedWriter(new FileWriter(string2 + "index.html"));
                    HiliteCommand.wl("<HTML>");
                    HiliteCommand.wl("<HEAD>");
                    HiliteCommand.wl("<TITLE>");
                    HiliteCommand.wl(string3);
                    HiliteCommand.wl("</TITLE>");
                    HiliteCommand.wl("</HEAD>");
                    HiliteCommand.wl("<BODY BGCOLOR=\"#DDDDDD\">");
                    HiliteCommand.wl("<CENTER>");
                    HiliteCommand.wl("<TABLE BGCOLOR=white WIDTH=50% BORDER=5 CELLPADDING=20>");
                    HiliteCommand.wl("<TR><TD ALIGN=CENTER>");
                    HiliteCommand.wl("<SPAN STYLE=\"FONT-SIZE:X-LARGE\"><B>" + string3 + "</B></SPAN>");
                    HiliteCommand.wl("<P>");
                    HiliteCommand.wl("</TD></TR>");
                    HiliteCommand.wl("</TABLE>");
                    HiliteCommand.wl("</CENTER>");
                    HiliteCommand.wl("<P>");
                    HiliteCommand.wl("<OL>");
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string4 = stringArray2[i];
                    String string5 = HiliteCommand.fileNameDir(string4);
                    String string6 = HiliteCommand.fileNamePrefix(string4);
                    Object object = HiliteCommand.fileNameSuffix(string4);
                    String string7 = (String)(string5.length() > 0 ? string5 + HiliteCommand.getOption("s") : "") + string6;
                    String string8 = HiliteCommand.getOption("con");
                    String string9 = HiliteCommand.getOption("css");
                    Object object2 = HiliteCommand.getOption("o");
                    if (((String)object).length() == 0) {
                        if (!new File(string7).exists()) {
                            object = string;
                        }
                    } else {
                        object = "." + (String)object;
                    }
                    if (!HiliteCommand.optionIsPresent("o")) {
                        object2 = string6;
                    }
                    if (HiliteCommand.fileNameSuffix((String)object2).length() == 0) {
                        object2 = (String)object2 + ".html";
                    }
                    new Hilite(string7 + (String)object, string8, string9, (String)object2, string2, HiliteCommand.optionIsPresent("!"));
                    if (!bl) continue;
                    HiliteCommand.w("<LI><A HREF=\"" + (String)object2 + "\">");
                    HiliteCommand.wl("<TT><B>" + string6 + (String)object + "</B></TT></A>");
                }
                if (bl) {
                    HiliteCommand.wl("</OL>");
                    HiliteCommand.wl("<P>");
                    HiliteCommand.wl("<HR>");
                    HiliteCommand.wl("<P ALIGN=\"RIGHT\">");
                    HiliteCommand.wl("<SPAN STYLE=\"COLOR:#F07070\"><EM>\nThis file was generated on " + new Date() + "<BR>by the <SPAN STYLE=\"COLOR:BROWN\"><TT>hlt.language.tools.HiliteCommand</TT></SPAN> Java tool written by <A HREF=\"http://hassan-ait-kaci.net\">Hassan A&iuml;t-Kaci</A></EM></SPAN>");
                    HiliteCommand.wl("<P>");
                    HiliteCommand.wl("<HR>");
                    HiliteCommand.wl("</BODY>");
                    HiliteCommand.wl("</HTML>");
                    index.close();
                    System.out.println("*** Wrote file index.html in " + string2);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.err.println("\n*** Couldn't create HTML files");
            }
        }
    }
}

