/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.tools;

import hlt.language.io.FileTools;
import hlt.language.util.ArrayList;
import hlt.language.util.Comparable;
import hlt.language.util.IntStack;
import hlt.language.util.Locatable;
import hlt.language.util.Location;
import hlt.language.util.Queue;
import hlt.language.util.ViewableStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Iterator;

public class Misc {
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public static String ordinal(int n) {
        switch (n) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public static Calendar now() {
        return Calendar.getInstance();
    }

    public static int currentYear() {
        return Misc.now().get(1) - 1900;
    }

    public static String repeat(int n, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        while (n2-- > 0) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String title(String string, char c, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n;
        while (n3-- > 0) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        n3 = n2 - n - string.length();
        while (n3-- > 0) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static final String minsec(long l) {
        int n = (int)((l /= 1000L) / 60L);
        int n2 = (int)(l % 60L);
        return n + " minute" + (n > 1 ? "s " : " ") + n2 + " second" + (n2 > 1 ? "s" : "");
    }

    public static final String view(ViewableStack viewableStack, String string, int n, int n2) {
        if (viewableStack == null) {
            return "null";
        }
        int n3 = n + string.length() + 5;
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = n3;
        while (n4-- > 0) {
            stringBuilder.append(' ');
        }
        StringBuilder stringBuilder2 = new StringBuilder(n2);
        int n5 = n2;
        while (n5-- > 0) {
            stringBuilder2.append('-');
        }
        StringBuilder stringBuilder3 = new StringBuilder(viewableStack.size() * (n3 + n2 + 1)).append('\n');
        stringBuilder3.append((CharSequence)stringBuilder).append((CharSequence)stringBuilder2).append('\n');
        stringBuilder3.append(stringBuilder.substring(0, n)).append(string).append(" ==> ");
        Iterator iterator = viewableStack.iterator();
        if (iterator.hasNext()) {
            stringBuilder3.append(Misc.etc(n2, iterator.next()));
        }
        stringBuilder3.append('\n');
        while (iterator.hasNext()) {
            stringBuilder3.append((CharSequence)stringBuilder).append(Misc.etc(n2, iterator.next())).append('\n');
        }
        stringBuilder3.append((CharSequence)stringBuilder).append((CharSequence)stringBuilder2).append('\n');
        return stringBuilder3.toString();
    }

    public static final String view(Queue queue, String string, int n, int n2) {
        if (queue == null) {
            return "null";
        }
        int n3 = n + string.length() + 5;
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = n3;
        while (n4-- > 0) {
            stringBuilder.append(' ');
        }
        StringBuilder stringBuilder2 = new StringBuilder(n2);
        int n5 = n2;
        while (n5-- > 0) {
            stringBuilder2.append('-');
        }
        StringBuilder stringBuilder3 = new StringBuilder(queue.size() * (n3 + n2 + 1)).append('\n');
        stringBuilder3.append((CharSequence)stringBuilder).append((CharSequence)stringBuilder2).append('\n');
        stringBuilder3.append(stringBuilder.substring(0, n)).append(string).append(" ==> ");
        Iterator iterator = queue.iterator();
        if (iterator.hasNext()) {
            stringBuilder3.append(Misc.etc(n2, iterator.next()));
        }
        stringBuilder3.append('\n');
        while (iterator.hasNext()) {
            stringBuilder3.append((CharSequence)stringBuilder).append(Misc.etc(n2, iterator.next())).append('\n');
        }
        stringBuilder3.append((CharSequence)stringBuilder).append((CharSequence)stringBuilder2).append('\n');
        return stringBuilder3.toString();
    }

    public static final String unquotify(String string) {
        if (string.length() < 1) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return Misc.unquotify(string.substring(1, string.length() - 1));
        }
        return string;
    }

    public static final String etc(int n, Object object) {
        if (object == null) {
            return "null";
        }
        String string = Misc.stringify(object.toString(), '\\', '\\');
        return string.length() <= n ? string : string.substring(0, Math.min(n - 4, string.length())) + " ...";
    }

    public static final String arrayToString(int[] nArray, String string, String string2, String string3) {
        if (nArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i] + (i == nArray.length - 1 ? "" : string2));
        }
        return stringBuilder.append(string3).toString();
    }

    public static final String arrayToString(int[] nArray) {
        return Misc.arrayToString(nArray, "[", ",", "]");
    }

    public static final String arrayToString(double[] dArray, String string, String string2, String string3) {
        if (dArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(dArray[i] + (i == dArray.length - 1 ? "" : string2));
        }
        return stringBuilder.append(string3).toString();
    }

    public static final String arrayToString(double[] dArray) {
        return Misc.arrayToString(dArray, "[", ",", "]");
    }

    public static final String arrayToString(Object[] objectArray, String string, String string2, String string3) {
        if (objectArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            String string4 = object == null ? "null" : (object instanceof int[] ? Misc.arrayToString((int[])object, string, string2, string3) : (object instanceof double[] ? Misc.arrayToString((double[])object, string, string2, string3) : (object instanceof Object[] ? Misc.arrayToString((Object[])object, string, string2, string3) : (object instanceof String ? "\"" + object.toString() + "\"" : object.toString()))));
            stringBuilder.append(string4 + (i == objectArray.length - 1 ? "" : string2));
        }
        return stringBuilder.append(string3).toString();
    }

    public static final String arrayToString(Object[] objectArray) {
        return Misc.arrayToString(objectArray, "[", ",", "]");
    }

    public static final boolean equal(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2 == null;
        }
        if (nArray2 == null) {
            return false;
        }
        if (nArray == nArray2) {
            return true;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equal(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            return dArray2 == null;
        }
        if (dArray2 == null) {
            return false;
        }
        if (dArray == dArray2) {
            return true;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == dArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equal(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof int[] && objectArray2[i] instanceof int[] ? !Misc.equal((int[])objectArray[i], (int[])objectArray2[i]) : (objectArray[i] instanceof double[] && objectArray2[i] instanceof double[] ? !Misc.equal((double[])objectArray[i], (double[])objectArray2[i]) : (objectArray[i] instanceof Object[] && objectArray2[i] instanceof Object[] ? !Misc.equal((Object[])objectArray[i], (Object[])objectArray2[i]) : !objectArray[i].equals(objectArray2[i]))))) continue;
            return false;
        }
        return true;
    }

    public static final String className(Object object) {
        return object.getClass().toString().substring(6);
    }

    public static final String simpleClassName(Object object) {
        return FileTools.suffixIfDot(Misc.className(object));
    }

    public static final ArrayList list(Object[] objectArray) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public static final boolean sameLocation(Location location, Location location2) {
        if (location == location2) {
            return true;
        }
        if (location == null) {
            return location2 == null;
        }
        if (location2 == null) {
            return false;
        }
        return location.getFile() == location2.getFile() && location.getLine() == location2.getLine() && location.getColumn() == location2.getColumn();
    }

    public static final boolean sameExtent(Locatable locatable, Locatable locatable2) {
        if (locatable == locatable2) {
            return true;
        }
        if (locatable == null) {
            return locatable2 == null;
        }
        if (locatable2 == null) {
            return false;
        }
        return Misc.sameLocation(locatable.getStart(), locatable.getEnd()) && Misc.sameLocation(locatable2.getStart(), locatable2.getEnd());
    }

    public static final boolean precedes(Locatable locatable, Locatable locatable2) {
        if (locatable == null) {
            return true;
        }
        if (locatable2 == null) {
            return true;
        }
        if (locatable.getStart() == null || locatable.getEnd() == null) {
            return true;
        }
        if (locatable2.getStart() == null || locatable2.getEnd() == null) {
            return true;
        }
        return locatable.getEnd().precedes(locatable2.getStart()) || locatable.getStart().precedes(locatable2.getStart()) && locatable2.getEnd().precedes(locatable.getEnd());
    }

    public static final Locatable latestExtent(Locatable locatable, Locatable locatable2) {
        if (locatable == null) {
            return locatable2;
        }
        if (locatable2 == null) {
            return locatable;
        }
        return Misc.precedes(locatable, locatable2) ? locatable2 : locatable;
    }

    public static final String locationString(Locatable locatable) {
        Object object = "<unlocated>";
        if (locatable != null) {
            Location location = locatable.getStart();
            Location location2 = locatable.getEnd();
            if (location == null) {
                if (location2 != null) {
                    object = Misc.locationString(location2);
                }
            } else {
                object = location2 == null || location.equals(location2) ? Misc.locationString(location) : (location.getFile() == location2.getFile() ? (location.getLine() == location2.getLine() ? location.getFile() + " (line " + location.getLine() + ", columns " + location.getColumn() + ".." + location2.getColumn() + ")" : Misc.locationString(location) + ".. (line " + location2.getLine() + ", column " + location2.getColumn() + ")") : Misc.locationString(location) + ".." + Misc.locationString(location2));
            }
        }
        return object;
    }

    public static final String locationString(Location location) {
        return location.getFile() + " (line " + location.getLine() + ", column " + location.getColumn() + ")";
    }

    public static final void beep() {
        System.err.print('\u0007');
        System.err.flush();
    }

    public static final String stringify(String string) {
        return Misc.stringify(string, '\"', '\\');
    }

    public static final String stringify(String string, char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c3 = string.charAt(i);
            if (c3 == c || c3 == c2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(Misc.pform(c3));
        }
        return stringBuilder.toString();
    }

    public static final String quotify(String string) {
        return Misc.quotify(string, '\"', '\\');
    }

    public static final String quotify(String string, char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c3 = string.charAt(i);
            if (c3 == c || c3 == c2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.toString();
    }

    public static final String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static final boolean isLowerCase(String string) {
        boolean bl = false;
        int n = string.length();
        while (n-- > 0) {
            char c = string.charAt(n);
            bl |= Character.isLetter(c);
            if (!Character.isUpperCase(c)) continue;
            return false;
        }
        return bl;
    }

    public static final boolean isUpperCase(String string) {
        boolean bl = false;
        int n = string.length();
        while (n-- > 0) {
            char c = string.charAt(n);
            bl |= Character.isLetter(c);
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return bl;
    }

    public static final String htmlString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(Misc.htmlCode(string.charAt(i)));
        }
        return stringBuilder.toString();
    }

    public static final String htmlCode(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return String.valueOf(c);
    }

    public static final boolean askYesNo(String string) {
        return Misc.askYesNo(string, true);
    }

    public static final void ln() {
        System.out.println();
    }

    public static final void ln(int n) {
        for (int i = 0; i < n; ++i) {
            Misc.ln();
        }
    }

    public static final void jot(String string) {
        System.out.print(string);
    }

    public static final void say(String string) {
        System.out.println(string);
    }

    public static final void sln(String string) {
        System.out.println(string + "\n");
    }

    public static final boolean askYesNo(String string, boolean bl) {
        return Misc.askYesNo(System.out, System.in, System.err, string, bl);
    }

    public static final boolean askYesNo(PrintStream printStream, InputStream inputStream, PrintStream printStream2, String string, boolean bl) {
        printStream.print(string + "? (y/n) [" + (bl ? "y" : "n") + "] > ");
        printStream.flush();
        try {
            switch (inputStream.read()) {
                case 10: {
                    return bl;
                }
                case 89: 
                case 121: {
                    while (inputStream.read() != 10) {
                    }
                    return true;
                }
                case 78: 
                case 110: {
                    while (inputStream.read() != 10) {
                    }
                    return false;
                }
            }
            while (inputStream.read() != 10) {
            }
        }
        catch (IOException iOException) {
            printStream2.println("*** IO Exception when asking: \"" + string + "\"");
            iOException.printStackTrace();
        }
        printStream.println("Please answer yes or no!...");
        return Misc.askYesNo(string, bl);
    }

    public static final String prompt(String string, PrintStream printStream) {
        printStream.print(string + " ");
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = System.in.read()) != 10) {
                stringBuilder.append((char)n);
            }
        }
        catch (IOException iOException) {
            System.err.println("*** IO Exception when prompting: \"" + string + "\"");
            iOException.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public static final String prompt(String string) {
        return Misc.prompt(string, System.out);
    }

    public static final String spaces(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n-- > 0) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static final void printErase(String string) {
        System.out.print(string);
        for (int i = 0; i < string.length(); ++i) {
            System.out.print("\b");
        }
    }

    public static final String letterSubstring(String string) {
        int n;
        for (n = 0; n < string.length() && !Character.isLetter(string.charAt(n)); ++n) {
        }
        if (n == string.length()) {
            return string;
        }
        return string.substring(n);
    }

    public static final String pform(int n) {
        switch (n) {
            case -1: {
                return "EOF";
            }
            case -2: {
                return "EOI";
            }
            case -3: {
                return "SOI";
            }
            case -4: {
                return "WRD";
            }
            case -5: {
                return "NUM";
            }
            case -6: {
                return "NTG";
            }
            case -7: {
                return "SPL";
            }
            case 7: {
                return "BIP";
            }
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 92: {
                return "\\";
            }
            case 39: {
                return "'";
            }
            case 34: {
                return "\"";
            }
            case 96: {
                return "`";
            }
        }
        return String.valueOf((char)n);
    }

    public static final String numberString(long l, int n, char c) {
        int n2 = Misc.numWidth(l);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n - n2; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(l);
        return stringBuilder.toString();
    }

    public static final String numberString(long l, int n) {
        return Misc.numberString(l, n, ' ');
    }

    public static final String zeroPaddedString(int n, int n2) {
        if (n < 0) {
            return "-" + Misc.zeroPaddedString(-n, n2);
        }
        return Misc.numberString(n, n2, '0');
    }

    public static final int numWidth(long l) {
        if (l < 0L) {
            return 1 + Misc.numWidth(-l);
        }
        int n = 1;
        while ((l /= 10L) != 0L) {
            ++n;
        }
        return n;
    }

    public static final boolean booleanValueOf(String string) {
        return string != null && (string.toLowerCase().equals("t") || string.toLowerCase().equals("true") || string.toLowerCase().equals("y") || string.toLowerCase().equals("yes"));
    }

    public static final String valueInRadix(int n, int n2) {
        if (n2 < 1 || n2 > 36) {
            System.err.println("Cannot handle radix: " + n2 + " (must be between 1 and 36)");
            throw new NumberFormatException();
        }
        if (n < 0) {
            return "-" + Misc.valueInRadix(-n, n2);
        }
        if (n2 == 1) {
            return Misc.ones(n);
        }
        Object object = "";
        do {
            object = Misc.digit(n % n2) + (String)object;
        } while ((n /= n2) != 0);
        return object;
    }

    private static final char digit(int n) {
        if (n >= 0 && n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + n - 10);
    }

    private static final String ones(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("1");
        }
        return stringBuilder.toString();
    }

    public static final void forceGC() {
        Misc.forceGC(false);
    }

    public static final void forceGC(boolean bl) {
        Misc.forceGC(bl, System.err);
    }

    public static final void forceGC(boolean bl, PrintStream printStream) {
        long l;
        int n;
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = runtime.freeMemory();
        long l4 = l2 - l3;
        long l5 = l3;
        if (bl) {
            n = Math.max(Misc.numWidth(l4), Math.max(Misc.numWidth(l3), Misc.numWidth(l2)));
            printStream.println("*** Memory usage before garbage collection:");
            printStream.println("\t" + Misc.numberString(l2, n) + " bytes total");
            printStream.println("\t" + Misc.numberString(l4, n) + " bytes used");
            printStream.println("\t" + Misc.numberString(l3, n) + " bytes available");
        }
        long l6 = System.currentTimeMillis();
        do {
            runtime.runFinalization();
            runtime.gc();
            l = l3;
        } while ((l3 = runtime.freeMemory()) > l);
        l6 = System.currentTimeMillis() - l6;
        if (bl) {
            long l7 = l3 - l5;
            l4 = l2 - l3;
            n = Math.max(Misc.numWidth(l4), Math.max(Misc.numWidth(l3), Misc.numWidth(l7)));
            printStream.println("*** Garbage collection done in " + l6 + " ms");
            printStream.println("*** Memory usage after garbage collection:");
            printStream.println("\t" + Misc.numberString(l7, n) + " bytes reclaimed");
            printStream.println("\t" + Misc.numberString(l4, n) + " bytes used");
            printStream.println("\t" + Misc.numberString(l3, n) + " bytes available");
        }
    }

    public static final Comparable[] sort(Comparable[] comparableArray) {
        return Misc.sort(comparableArray, 0, comparableArray.length - 1);
    }

    public static final Comparable[] sort(Comparable[] comparableArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        IntStack intStack = new IntStack();
        intStack.push(n4);
        intStack.push(n3);
        do {
            n3 = intStack.pop();
            n4 = intStack.pop();
            while (n3 < n4) {
                int n5 = n3;
                int n6 = n4;
                Comparable comparable = comparableArray[n3 + (n4 - n3) / 2];
                while (true) {
                    if (n5 < comparableArray.length && comparableArray[n5].lessThan(comparable)) {
                        ++n5;
                        continue;
                    }
                    while (n6 >= 0 && comparable.lessThan(comparableArray[n6])) {
                        --n6;
                    }
                    if (n5 <= n6) {
                        if (n5 != n6) {
                            Comparable comparable2 = comparableArray[n5];
                            comparableArray[n5] = comparableArray[n6];
                            comparableArray[n6] = comparable2;
                        }
                        ++n5;
                        --n6;
                    }
                    if (n5 > n6) break;
                }
                if (n5 < n4) {
                    intStack.push(n4);
                    intStack.push(n5);
                }
                n4 = n6;
            }
        } while (!intStack.isEmpty());
        return comparableArray;
    }

    public static final AbstractList sort(AbstractList abstractList) {
        return Misc.sort(abstractList, 0, abstractList.size() - 1);
    }

    public static final AbstractList sort(AbstractList abstractList, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        IntStack intStack = new IntStack();
        intStack.push(n4);
        intStack.push(n3);
        do {
            n3 = intStack.pop();
            n4 = intStack.pop();
            while (n3 < n4) {
                int n5 = n3;
                int n6 = n4;
                Comparable comparable = (Comparable)abstractList.get(n3 + (n4 - n3) / 2);
                while (true) {
                    if (n5 < abstractList.size() && ((Comparable)abstractList.get(n5)).lessThan(comparable)) {
                        ++n5;
                        continue;
                    }
                    while (n6 >= 0 && comparable.lessThan((Comparable)abstractList.get(n6))) {
                        --n6;
                    }
                    if (n5 <= n6) {
                        if (n5 != n6) {
                            Object e = abstractList.get(n5);
                            abstractList.set(n5, abstractList.get(n6));
                            abstractList.set(n6, e);
                        }
                        ++n5;
                        --n6;
                    }
                    if (n5 > n6) break;
                }
                if (n5 < n4) {
                    intStack.push(n4);
                    intStack.push(n5);
                }
                n4 = n6;
            }
        } while (!intStack.isEmpty());
        return abstractList;
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        @Override
        public final boolean hasNext() {
            return false;
        }

        public final Object next() {
            return null;
        }

        @Override
        public final void remove() {
        }
    }
}

