/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.IntArrayList;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;

public class ArrayList
extends AbstractList
implements Collection {
    protected Object[] _elementData;
    protected int _size;
    protected int capacityIncrement;
    protected float incrementFactor = 2.0f;

    public ArrayList(int n, int n2) {
        this(n);
        this.capacityIncrement = n2;
    }

    public ArrayList(int n) {
        this._elementData = new Object[n];
    }

    public ArrayList() {
        this(10);
    }

    public ArrayList(Object[] objectArray) {
        this._elementData = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this._elementData[this._size++] = objectArray[i];
        }
    }

    public ArrayList(Collection collection) {
        this._elementData = new Object[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this._elementData[this._size++] = iterator.next();
        }
    }

    public final void copyInto(Object[] objectArray) {
        for (int i = 0; i < this._size; ++i) {
            objectArray[i] = this._elementData[i];
        }
    }

    public final void trimToSize() {
        if (this._size == this._elementData.length) {
            return;
        }
        Object[] objectArray = new Object[this._size];
        for (int i = 0; i < this._size; ++i) {
            objectArray[i] = this._elementData[i];
        }
        this._elementData = objectArray;
    }

    public final void ensureCapacity(int n) {
        if (this._elementData.length >= n) {
            return;
        }
        Object[] objectArray = new Object[Math.max(n, this._increasedCapacity())];
        for (int i = 0; i < this._elementData.length; ++i) {
            objectArray[i] = this._elementData[i];
        }
        this._elementData = objectArray;
    }

    public final void setSize(int n) {
        this.ensureCapacity(n);
        while (this._size > n) {
            this._elementData[--this._size] = null;
        }
    }

    public final int capacity() {
        return this._elementData.length;
    }

    @Override
    public final int size() {
        return this._size;
    }

    public final boolean hasGaps() {
        int n = this._size;
        while (n-- > 0) {
            if (this._elementData[n] != null) continue;
            return true;
        }
        return false;
    }

    public final void removeGaps() {
        Object[] objectArray = new Object[this._elementData.length];
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            if (this._elementData[i] == null) continue;
            objectArray[n++] = this._elementData[i];
        }
        this._elementData = objectArray;
        this._size = n;
    }

    @Override
    public final boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public final boolean contains(Object object) {
        int n = this._size;
        while (n-- > 0) {
            if (!this._elementData[n].equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int indexOf(Object object) {
        for (int i = 0; i < this._size; ++i) {
            if (!this._elementData[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(Object object, int n) {
        for (int i = n; i < this._size; ++i) {
            if (!this._elementData[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        int n = this._size;
        while (n-- > 0) {
            if (!this._elementData[n].equals(object)) continue;
            return n;
        }
        return -1;
    }

    public final int lastIndexOf(Object object, int n) {
        for (int i = n; i >= 0; --i) {
            if (!this._elementData[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public final Object elementAt(int n) {
        return this._elementData[n];
    }

    public final Object firstElement() {
        return this._elementData[0];
    }

    public final Object lastElement() {
        return this._elementData[this._size - 1];
    }

    public final void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public final void removeElementAt(int n) {
        this.remove(n);
    }

    public final void insertElementAt(Object object, int n) {
        this.add(n, object);
    }

    public final void addElement(Object object) {
        this.add(object);
    }

    public final void removeAllElements() {
        this._size = 0;
    }

    public final Object clone() {
        Object[] objectArray = new Object[this._elementData.length];
        for (int i = 0; i < this._elementData.length; ++i) {
            objectArray[i] = this._elementData[i];
        }
        return new ArrayList(objectArray, this._size, this.capacityIncrement, this.incrementFactor);
    }

    @Override
    public final Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        int n = this._size;
        while (n-- > 0) {
            objectArray[n] = this._elementData[n];
        }
        return objectArray;
    }

    public final String[] toStringArray() {
        String[] stringArray = new String[this._size];
        int n = this._size;
        while (n-- > 0) {
            stringArray[n] = this._elementData[n].toString();
        }
        return stringArray;
    }

    @Override
    public final Object get(int n) {
        return this._elementData[n];
    }

    @Override
    public final Object set(int n, Object object) {
        Object object2 = this._elementData[n];
        this._elementData[n] = object;
        this._size = Math.max(this._size, n + 1);
        return object2;
    }

    public final Object secureSet(int n, Object object) {
        this.ensureCapacity(n + 1);
        Object object2 = this._elementData[n];
        this._elementData[n] = object;
        this._size = Math.max(this._size, n + 1);
        return object2;
    }

    public final Object setLast(Object object) {
        int n = this._size - 1;
        Object object2 = this._elementData[n];
        this._elementData[n] = object;
        return object2;
    }

    @Override
    public final boolean add(Object object) {
        if (this._size == this._elementData.length) {
            this._grow();
        }
        this._elementData[this._size++] = object;
        return true;
    }

    public final ArrayList include(Object object) {
        if (this._size == this._elementData.length) {
            this._grow();
        }
        this._elementData[this._size++] = object;
        return this;
    }

    @Override
    public final boolean remove(Object object) {
        int n = 0;
        for (n = 0; n < this._size && !this._elementData[n].equals(object); ++n) {
        }
        if (n == this._size) {
            return false;
        }
        while (n < this._size - 1) {
            this._elementData[n] = this._elementData[n + 1];
            ++n;
        }
        --this._size;
        return true;
    }

    public final boolean removeElement(Object object) {
        return this.remove(object);
    }

    @Override
    public final void add(int n, Object object) {
        this.ensureCapacity(this._size++);
        for (int i = this._size - 1; i > n; --i) {
            this._elementData[i] = this._elementData[i - 1];
        }
        this._elementData[n] = object;
    }

    @Override
    public final Object remove(int n) {
        Object object = this._elementData[n];
        for (int i = n; i < this._size - 1; ++i) {
            this._elementData[i] = this._elementData[i + 1];
        }
        --this._size;
        return object;
    }

    @Override
    public final void clear() {
        this._size = 0;
    }

    public final boolean containsAll(Object[] objectArray) {
        int n = objectArray.length;
        while (n-- > 0) {
            if (this.contains(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(ArrayList arrayList) {
        int n = arrayList.size();
        while (n-- > 0) {
            if (this.contains(arrayList.get(n))) continue;
            return false;
        }
        return true;
    }

    public final boolean addAll(Object[] objectArray) {
        this.ensureCapacity(this._size + objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this._elementData[this._size++] = objectArray[i];
        }
        return true;
    }

    public final boolean addAll(ArrayList arrayList) {
        int n = arrayList.size();
        this.ensureCapacity(this._size + n);
        for (int i = 0; i < n; ++i) {
            this.add(arrayList.get(i));
        }
        return true;
    }

    public final boolean removeAll(Object[] objectArray) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < this._size; ++j) {
                if (!objectArray[i].equals(this._elementData[j])) continue;
                intArrayList.add(j);
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean removeAll(ArrayList arrayList) {
        IntArrayList intArrayList = new IntArrayList();
        int n = arrayList.size();
        while (n-- > 0) {
            int n2 = this._size;
            while (n2-- > 0) {
                if (!arrayList.get(n).equals(this._elementData[n2])) continue;
                intArrayList.add(n2);
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean removeAllFirst(Object[] objectArray) {
        IntArrayList intArrayList = new IntArrayList();
        block0: for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < this._size; ++j) {
                if (!objectArray[i].equals(this._elementData[j])) continue;
                intArrayList.add(j);
                continue block0;
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean removeAllFirst(ArrayList arrayList) {
        IntArrayList intArrayList = new IntArrayList();
        int n = arrayList.size();
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this._size; ++j) {
                if (!arrayList.get(i).equals(this._elementData[j])) continue;
                intArrayList.add(j);
                continue block0;
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean retainAll(ArrayList arrayList) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this._size; ++i) {
            if (arrayList.contains(this._elementData[i])) continue;
            intArrayList.add(i);
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final void addAll(int n, Object[] objectArray) {
        int n2;
        if (this._size + objectArray.length < this._elementData.length) {
            int n3;
            for (n3 = n; n3 < this._size; ++n3) {
                this._elementData[n3 + objectArray.length] = this._elementData[n3];
            }
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                this._elementData[n + n3] = objectArray[n3];
            }
            this._size += objectArray.length;
            return;
        }
        Object[] objectArray2 = new Object[this._increasedCapacity(this._size + objectArray.length)];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = this._elementData[n2];
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray2[n + n2] = objectArray[n2];
        }
        for (n2 = n + objectArray.length; n2 < this._size + objectArray.length; ++n2) {
            objectArray2[n2] = this._elementData[n2 - objectArray.length];
        }
        this._elementData = objectArray2;
        this._size += objectArray.length;
    }

    public final void addAll(int n, ArrayList arrayList) {
        int n2;
        int n3 = arrayList.size();
        if (this._size + n3 < this._elementData.length) {
            int n4;
            for (n4 = n; n4 < this._size; ++n4) {
                this._elementData[n4 + n3] = this._elementData[n4];
            }
            for (n4 = 0; n4 < n3; ++n4) {
                this._elementData[n + n4] = arrayList.get(n4);
            }
            this._size += n3;
            return;
        }
        Object[] objectArray = new Object[this._increasedCapacity(this._size + n3)];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = this._elementData[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray[n + n2] = arrayList.get(n2);
        }
        for (n2 = n + n3; n2 < this._size + n3; ++n2) {
            objectArray[n2] = this._elementData[n2 - n3];
        }
        this._elementData = objectArray;
        this._size += n3;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayList)) {
            return false;
        }
        ArrayList arrayList = (ArrayList)object;
        if (arrayList.size() != this._size) {
            return false;
        }
        for (int i = 0; i < this._size; ++i) {
            if (arrayList.get(i).equals(this._elementData[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        long l = this._size;
        int n = 1;
        for (int i = 0; i < this._size; i += Math.max(1, this._size / 4)) {
            l = n > 0 ? (l <<= 1) : (l >>= 1);
            l ^= (long)this._elementData[i].hashCode();
            n = -n;
        }
        return (int)l;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append("]").toString();
    }

    @Override
    public void removeRange(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        n2 = Math.min(n2, this._size);
        int n3 = n2 - n;
        for (int i = n; i < n2; ++i) {
            this._elementData[i] = this._elementData[i + n3];
        }
        this._size -= n3;
    }

    public final void setIncrementFactor(float f) {
        if ((double)f < 1.1 || (double)f > 5.0) {
            throw new IllegalArgumentException("Increment factor " + f + " must be in [1.1,5.0] range");
        }
        this.incrementFactor = f;
    }

    public final void clear(int n) {
        this._size = n < 0 || n >= this._size ? 0 : n;
    }

    private ArrayList(Object[] objectArray, int n, int n2, float f) {
        this._elementData = objectArray;
        this._size = n;
        this.capacityIncrement = n2;
        this.incrementFactor = f;
    }

    private final void _grow() {
        Object[] objectArray = new Object[this._increasedCapacity()];
        for (int i = 0; i < this._size; ++i) {
            objectArray[i] = this._elementData[i];
        }
        this._elementData = objectArray;
    }

    private final int _increasedCapacity() {
        if (this.capacityIncrement <= 0) {
            int n = this._elementData.length == 0 ? 1 : this._elementData.length;
            return (int)Math.floor((float)n * this.incrementFactor + 1.0f);
        }
        return this._elementData.length + this.capacityIncrement;
    }

    private final int _increasedCapacity(int n) {
        if (this.capacityIncrement <= 0) {
            int n2 = this._elementData.length == 0 ? 1 : this._elementData.length;
            return Math.max(n, (int)Math.floor((float)n2 * this.incrementFactor));
        }
        return Math.max(n, this._elementData.length + this.capacityIncrement);
    }

    private final void removeAllIndices(IntArrayList intArrayList) {
        int n = intArrayList.size();
        for (int i = 1; i <= n; ++i) {
            int n2 = intArrayList.get(i - 1);
            int n3 = i < n ? intArrayList.get(i) : this._size;
            for (int j = n2 + 1; j < n3; ++j) {
                this._elementData[j - i] = this._elementData[j];
            }
        }
        this._size -= n;
    }

    @Override
    public Iterator iterator() {
        return new ArrayListIterator(this._elementData, this._size);
    }

    private static class ArrayListIterator
    implements Iterator {
        private Object[] _data;
        private int _count;
        private int _current;

        ArrayListIterator(Object[] objectArray, int n) {
            this._data = objectArray;
            this._count = n;
        }

        @Override
        public final boolean hasNext() {
            return this._current < this._count;
        }

        public final Object next() {
            return this._data[this._current++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

