/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.DoubleArrayListIterator;
import hlt.language.util.DoubleIterator;
import hlt.language.util.IntArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DoubleArrayList {
    protected double[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    protected float incrementFactor = 2.0f;

    public DoubleArrayList(int n, int n2) {
        this(n);
        this.capacityIncrement = n2;
    }

    public DoubleArrayList(int n) {
        this.elementData = new double[n];
    }

    public DoubleArrayList() {
        this(10);
    }

    public DoubleArrayList(double[] dArray) {
        this.elementData = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.elementData[this.elementCount++] = dArray[i];
        }
    }

    public DoubleArrayList(Collection collection) {
        this.elementData = new double[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.elementData[this.elementCount++] = ((Number)iterator.next()).doubleValue();
        }
    }

    public final DoubleIterator iterator() {
        return new DoubleArrayListIterator(this);
    }

    public final void copyInto(double[] dArray) {
        for (int i = 0; i < this.elementCount; ++i) {
            dArray[i] = this.elementData[i];
        }
    }

    public final void trimToSize() {
        if (this.elementCount == this.elementData.length) {
            return;
        }
        double[] dArray = new double[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            dArray[i] = this.elementData[i];
        }
        this.elementData = dArray;
    }

    public final void ensureCapacity(int n) {
        if (this.elementData.length > n + 1) {
            return;
        }
        double[] dArray = new double[Math.max(n, this._increasedCapacity())];
        for (int i = 0; i < this.elementCount; ++i) {
            dArray[i] = this.elementData[i];
        }
        this.elementData = dArray;
    }

    public final void setSize(int n) {
        this.elementCount = n;
        this.ensureCapacity(this.elementCount);
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(double d) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] != d) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(double d) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] != d) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(double d, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (this.elementData[i] != d) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(double d) {
        int n = this.elementCount;
        while (n-- > 0) {
            if (this.elementData[n] != d) continue;
            return n;
        }
        return -1;
    }

    public final int lastIndexOf(double d, int n) {
        for (int i = n; i >= 0; --i) {
            if (this.elementData[i] != d) continue;
            return i;
        }
        return -1;
    }

    public final double elementAt(int n) {
        return this.get(n);
    }

    public final double firstElement() {
        return this.elementData[0];
    }

    public final double lastElement() {
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(double d, int n) {
        this.set(n, d);
    }

    public final void removeElementAt(int n) {
        this.remove(n);
    }

    public final void insertElementAt(double d, int n) {
        this.add(n, d);
    }

    public final void addElement(double d) {
        this.add(d);
    }

    public final void removeAllElements() {
        this.elementCount = 0;
    }

    public final Object clone() {
        double[] dArray = new double[this.elementData.length];
        for (int i = 0; i < this.elementData.length; ++i) {
            dArray[i] = this.elementData[i];
        }
        return new DoubleArrayList(dArray, this.elementCount, this.capacityIncrement, this.incrementFactor);
    }

    public final double[] toArray() {
        double[] dArray = new double[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            dArray[i] = this.elementData[i];
        }
        return dArray;
    }

    public final double get(int n) {
        return this.elementData[n];
    }

    public final double set(int n, double d) {
        double d2 = this.elementData[n];
        this.elementData[n] = d;
        return d2;
    }

    public final void setLast(double d) {
        this.elementData[this.elementCount - 1] = d;
    }

    public final boolean add(double d) {
        if (this.elementCount == this.elementData.length) {
            this._grow();
        }
        this.elementData[this.elementCount++] = d;
        return true;
    }

    public final boolean remove(double d) {
        int n = 0;
        for (n = 0; n < this.elementCount && this.elementData[n] != d; ++n) {
        }
        if (n == this.elementCount) {
            return false;
        }
        while (n < this.elementCount - 1) {
            this.elementData[n] = this.elementData[n + 1];
            ++n;
        }
        --this.elementCount;
        return true;
    }

    public final boolean removeElement(double d) {
        return this.remove(d);
    }

    public final void add(int n, double d) {
        this.ensureCapacity(this.elementCount++);
        for (int i = this.elementCount - 1; i > n; --i) {
            this.elementData[i] = this.elementData[i - 1];
        }
        this.elementData[n] = d;
    }

    public final double remove(int n) {
        double d = this.elementData[n];
        for (int i = n; i < this.elementCount - 1; ++i) {
            this.elementData[i] = this.elementData[i + 1];
        }
        --this.elementCount;
        return d;
    }

    public final void clear() {
        this.elementCount = 0;
    }

    public final boolean containsAll(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (this.contains(dArray[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        while (n-- > 0) {
            if (this.contains(doubleArrayList.get(n))) continue;
            return false;
        }
        return true;
    }

    public final boolean addAll(double[] dArray) {
        this.ensureCapacity(this.elementCount + dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.add(dArray[i]);
        }
        return true;
    }

    public final boolean addAll(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        this.ensureCapacity(this.elementCount + n);
        for (int i = 0; i < n; ++i) {
            this.add(doubleArrayList.get(i));
        }
        return true;
    }

    public final boolean removeAll(double[] dArray) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < this.elementCount; ++j) {
                if (dArray[i] != this.elementData[j]) continue;
                intArrayList.add(j);
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean removeAll(DoubleArrayList doubleArrayList) {
        IntArrayList intArrayList = new IntArrayList();
        int n = doubleArrayList.size();
        while (n-- > 0) {
            int n2 = this.elementCount;
            while (n2-- > 0) {
                if (doubleArrayList.get(n) != this.elementData[n2]) continue;
                intArrayList.add(n2);
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean removeAllFirst(double[] dArray) {
        IntArrayList intArrayList = new IntArrayList();
        block0: for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < this.elementCount; ++j) {
                if (dArray[i] != this.elementData[j]) continue;
                intArrayList.add(j);
                continue block0;
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean removeAllFirst(DoubleArrayList doubleArrayList) {
        IntArrayList intArrayList = new IntArrayList();
        int n = doubleArrayList.size();
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.elementCount; ++j) {
                if (doubleArrayList.get(i) != this.elementData[j]) continue;
                intArrayList.add(j);
                continue block0;
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean retainAll(DoubleArrayList doubleArrayList) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.elementCount; ++i) {
            if (doubleArrayList.contains(this.elementData[i])) continue;
            intArrayList.add(i);
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final void addAll(int n, double[] dArray) {
        int n2;
        if (this.elementCount + dArray.length < this.elementData.length) {
            int n3;
            for (n3 = n; n3 < this.elementCount; ++n3) {
                this.elementData[n3 + dArray.length] = this.elementData[n3];
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                this.elementData[n + n3] = dArray[n3];
            }
            this.elementCount += dArray.length;
            return;
        }
        double[] dArray2 = new double[this._increasedCapacity(this.elementCount + dArray.length)];
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = this.elementData[n2];
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray2[n + n2] = dArray[n2];
        }
        for (n2 = n + dArray.length; n2 < this.elementCount + dArray.length; ++n2) {
            dArray2[n2] = this.elementData[n2 - dArray.length];
        }
        this.elementData = dArray2;
        this.elementCount += dArray.length;
    }

    public final void addAll(int n, DoubleArrayList doubleArrayList) {
        int n2;
        int n3 = doubleArrayList.size();
        if (this.elementCount + n3 < this.elementData.length) {
            int n4;
            for (n4 = n; n4 < this.elementCount; ++n4) {
                this.elementData[n4 + n3] = this.elementData[n4];
            }
            for (n4 = 0; n4 < n3; ++n4) {
                this.elementData[n + n4] = doubleArrayList.get(n4);
            }
            this.elementCount += n3;
            return;
        }
        double[] dArray = new double[this._increasedCapacity(this.elementCount + n3)];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.elementData[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n + n2] = doubleArrayList.get(n2);
        }
        for (n2 = n + n3; n2 < this.elementCount + n3; ++n2) {
            dArray[n2] = this.elementData[n2 - n3];
        }
        this.elementData = dArray;
        this.elementCount += n3;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DoubleArrayList)) {
            return false;
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)object;
        if (doubleArrayList.size() != this.elementCount) {
            return false;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (doubleArrayList.get(i) == this.elementData[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long l = this.elementCount;
        int n = 1;
        for (int i = 0; i < this.elementCount; i += Math.max(1, this.elementCount / 4)) {
            l = n > 0 ? (l <<= 1) : (l >>= 1);
            l ^= Double.doubleToLongBits(this.elementData[i]);
            n = -n;
        }
        return (int)l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.elementCount; ++i) {
            stringBuilder.append(this.elementData[i] + (i == this.elementCount - 1 ? "" : ","));
        }
        return stringBuilder.append("]").toString();
    }

    public void removeRange(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        n2 = Math.min(n2, this.elementCount);
        int n3 = n2 - n;
        for (int i = n; i < n2; ++i) {
            this.elementData[i] = this.elementData[i + n3];
        }
        this.elementCount -= n3;
    }

    public final void setIncrementFactor(float f) {
        if ((double)f < 1.1 || (double)f > 5.0) {
            throw new IllegalArgumentException("Increment factor " + f + " must be in [1.1,5.0] range");
        }
        this.incrementFactor = f;
    }

    public final void clear(int n) {
        this.elementCount = n < 0 || n >= this.elementCount ? 0 : n;
    }

    private DoubleArrayList(double[] dArray, int n, int n2, float f) {
        this.elementData = dArray;
        this.elementCount = n;
        this.capacityIncrement = n2;
        this.incrementFactor = f;
    }

    private final void _grow() {
        double[] dArray = new double[this._increasedCapacity()];
        for (int i = 0; i < this.elementCount; ++i) {
            dArray[i] = this.elementData[i];
        }
        this.elementData = dArray;
    }

    private final int _increasedCapacity() {
        if (this.capacityIncrement <= 0) {
            int n = this.elementData.length == 0 ? 1 : this.elementData.length;
            return (int)Math.floor((float)n * this.incrementFactor + 1.0f);
        }
        return this.elementData.length + this.capacityIncrement;
    }

    private final int _increasedCapacity(int n) {
        if (this.capacityIncrement <= 0) {
            int n2 = this.elementData.length == 0 ? 1 : this.elementData.length;
            return Math.max(n, (int)Math.floor((float)n2 * this.incrementFactor));
        }
        return Math.max(n, this.elementData.length + this.capacityIncrement);
    }

    private final void removeAllIndices(IntArrayList intArrayList) {
        int n = intArrayList.size();
        for (int i = 1; i <= n; ++i) {
            int n2 = intArrayList.get(i - 1);
            int n3 = i < n ? intArrayList.get(i) : this.elementCount;
            for (int j = n2 + 1; j < n3; ++j) {
                this.elementData[j - i] = this.elementData[j];
            }
        }
        this.elementCount -= n;
    }
}

