/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.ViewableStack;
import java.util.Iterator;

public class FiniteStack
implements ViewableStack {
    protected Object[] container;
    protected int capacity = 21;
    protected int free;
    protected int latest = this.free = 0;
    protected int oldest = this.free;

    public FiniteStack() {
        this.container = new Object[this.capacity];
    }

    public FiniteStack(int n) {
        this.capacity = n + 1;
        this.container = new Object[this.capacity];
    }

    protected final int prec(int n) {
        return (n + this.capacity - 1) % this.capacity;
    }

    protected final int succ(int n) {
        return (n + 1) % this.capacity;
    }

    @Override
    public final boolean isEmpty() {
        return this.latest == this.free;
    }

    public final int capacity() {
        return this.capacity - 1;
    }

    @Override
    public final int size() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = this.latest - this.oldest + 1;
        return n >= 0 ? n : this.capacity + n;
    }

    public final boolean isFull() {
        return this.free == this.prec(this.oldest);
    }

    public final void flush() {
        while (!this.isEmpty()) {
            this.pop();
        }
        this.free = 0;
        this.latest = 0;
        this.oldest = 0;
    }

    @Override
    public final Object peek() {
        return this.latest();
    }

    public final Object latest() {
        return this.isEmpty() ? null : this.container[this.latest];
    }

    public final Object oldest() {
        return this.isEmpty() ? null : this.container[this.oldest];
    }

    public final int latestIndex() {
        return this.isEmpty() ? -1 : this.latest;
    }

    public final int oldestIndex() {
        return this.isEmpty() ? -1 : this.oldest;
    }

    protected final boolean isValidIndex(int n) {
        if (this.isEmpty() || n < 0 || n >= this.capacity) {
            return false;
        }
        if (this.oldest <= this.latest) {
            return this.oldest <= n && n <= this.latest;
        }
        return this.free >= n || n >= this.oldest;
    }

    @Override
    public final Object get(int n) {
        return this.container[(this.oldest + n) % this.capacity];
    }

    public final Object pop() {
        if (this.isEmpty()) {
            return null;
        }
        Object object = this.container[this.latest];
        this.container[this.latest] = null;
        this.free = this.latest;
        if (this.latest != this.oldest) {
            this.latest = this.prec(this.latest);
        }
        return object;
    }

    public final Object drop() {
        if (this.isEmpty()) {
            return null;
        }
        Object object = this.container[this.oldest];
        this.container[this.oldest] = null;
        if (this.oldest == this.latest) {
            this.free = this.oldest;
        } else {
            this.oldest = this.succ(this.oldest);
        }
        return object;
    }

    public final Object push(Object object) {
        Object object2 = null;
        if (this.isFull()) {
            object2 = this.container[this.oldest];
            this.oldest = this.succ(this.oldest);
        }
        this.latest = this.free;
        this.container[this.latest] = object;
        this.free = this.succ(this.free);
        return object2;
    }

    public final void setCapacity(int n) {
        Object[] objectArray = new Object[n + 1];
        int n2 = Math.min(this.size(), n);
        int n3 = this.latest;
        for (int i = n2 - 1; i >= 0; --i) {
            objectArray[i] = this.container[n3];
            n3 = this.prec(n3);
        }
        this.container = objectArray;
        this.capacity = n + 1;
        this.oldest = 0;
        this.latest = n2 - 1;
        this.free = n2;
    }

    public final void setToSize() {
        if (this.isEmpty() || this.isFull()) {
            return;
        }
        this.setCapacity(this.size());
    }

    @Override
    public final Iterator iterator() {
        return new FiniteStackIterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private class FiniteStackIterator
    implements Iterator {
        int nextIndex;

        private FiniteStackIterator() {
            this.nextIndex = FiniteStack.this.latest;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != FiniteStack.this.free && FiniteStack.this.container[this.nextIndex] != null;
        }

        public Object next() {
            Object object = FiniteStack.this.container[this.nextIndex];
            this.nextIndex = FiniteStack.this.prec(this.nextIndex);
            return object;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

