/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.IntArrayListIterator;
import hlt.language.util.IntIterator;
import java.util.Collection;
import java.util.Iterator;

public class IntArrayList {
    protected int[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    protected float incrementFactor = 2.0f;

    public IntArrayList(int n, int n2) {
        this(n);
        this.capacityIncrement = n2;
    }

    public IntArrayList(int n) {
        this.elementData = new int[n];
    }

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int[] nArray) {
        this.elementData = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.elementData[this.elementCount++] = nArray[i];
        }
    }

    public IntArrayList(Collection collection) {
        this.elementData = new int[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.elementData[this.elementCount++] = ((Number)iterator.next()).intValue();
        }
    }

    public final IntIterator iterator() {
        return new IntArrayListIterator(this);
    }

    public final void copyInto(int[] nArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            nArray[n] = this.elementData[n];
        }
    }

    public final void trimToSize() {
        if (this.elementCount == this.elementData.length) {
            return;
        }
        int[] nArray = new int[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            nArray[i] = this.elementData[i];
        }
        this.elementData = nArray;
    }

    public final void ensureCapacity(int n) {
        if (this.elementData.length >= n) {
            return;
        }
        int n2 = Math.max(n, this._increasedCapacity());
        int[] nArray = new int[n2];
        for (int i = 0; i < this.elementCount; ++i) {
            nArray[i] = this.elementData[i];
        }
        this.elementData = nArray;
    }

    public final void setSize(int n) {
        this.elementCount = n;
        this.ensureCapacity(this.elementCount);
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(int n) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] != n) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(int n) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] != n) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(int n, int n2) {
        for (int i = n2; i < this.elementCount; ++i) {
            if (this.elementData[i] != n) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(int n) {
        int n2 = this.elementCount;
        while (n2-- > 0) {
            if (this.elementData[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    public final int lastIndexOf(int n, int n2) {
        int n3 = n2;
        while (n3-- > 0) {
            if (this.elementData[n3] != n) continue;
            return n3;
        }
        return -1;
    }

    public final int elementAt(int n) {
        return this.get(n);
    }

    public final int firstElement() {
        return this.elementData[0];
    }

    public final int lastElement() {
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(int n, int n2) {
        this.set(n2, n);
    }

    public final void removeElementAt(int n) {
        this.removeIndex(n);
    }

    public final void insertElementAt(int n, int n2) {
        this.add(n2, n);
    }

    public final void addElement(int n) {
        this.add(n);
    }

    public final void removeAllElements() {
        this.elementCount = 0;
    }

    public final Object clone() {
        int[] nArray = new int[this.elementData.length];
        for (int i = 0; i < this.elementData.length; ++i) {
            nArray[i] = this.elementData[i];
        }
        return new IntArrayList(nArray, this.elementCount, this.capacityIncrement, this.incrementFactor);
    }

    public final int[] toArray() {
        int[] nArray = new int[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            nArray[i] = this.elementData[i];
        }
        return nArray;
    }

    public final int get(int n) {
        return this.elementData[n];
    }

    public final int set(int n, int n2) {
        int n3 = this.elementData[n];
        this.elementData[n] = n2;
        return n3;
    }

    public final void setLast(int n) {
        this.elementData[this.elementCount - 1] = n;
    }

    public final boolean add(int n) {
        if (this.elementCount == this.elementData.length) {
            this._grow();
        }
        this.elementData[this.elementCount++] = n;
        return true;
    }

    public final boolean removeElement(int n) {
        int n2 = 0;
        for (n2 = 0; n2 < this.elementCount && this.elementData[n2] != n; ++n2) {
        }
        if (n2 == this.elementCount) {
            return false;
        }
        while (n2 < this.elementCount - 1) {
            this.elementData[n2] = this.elementData[n2 + 1];
            ++n2;
        }
        --this.elementCount;
        return true;
    }

    public final void add(int n, int n2) {
        ++this.elementCount;
        this.ensureCapacity(this.elementCount);
        for (int i = this.elementCount - 1; i > n; --i) {
            this.elementData[i] = this.elementData[i - 1];
        }
        this.elementData[n] = n2;
    }

    public final int removeIndex(int n) {
        int n2 = this.elementData[n];
        for (int i = n; i < this.elementCount - 1; ++i) {
            this.elementData[i] = this.elementData[i + 1];
        }
        --this.elementCount;
        return n2;
    }

    public final void clear() {
        this.elementCount = 0;
    }

    public final boolean containsAll(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (this.contains(nArray[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(IntArrayList intArrayList) {
        int n = intArrayList.size();
        while (n-- > 0) {
            if (this.contains(intArrayList.get(n))) continue;
            return false;
        }
        return true;
    }

    public final boolean addAll(int[] nArray) {
        this.ensureCapacity(this.elementCount + nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.add(nArray[i]);
        }
        return true;
    }

    public final boolean addAll(IntArrayList intArrayList) {
        int n = intArrayList.size();
        this.ensureCapacity(this.elementCount + n);
        for (int i = 0; i < n; ++i) {
            this.add(intArrayList.get(i));
        }
        return true;
    }

    public final boolean removeAll(int[] nArray) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.elementCount; ++j) {
                if (nArray[i] != this.elementData[j]) continue;
                intArrayList.add(j);
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean removeAll(IntArrayList intArrayList) {
        IntArrayList intArrayList2 = new IntArrayList();
        int n = intArrayList.size();
        while (n-- > 0) {
            int n2 = this.elementCount;
            while (n2-- > 0) {
                if (intArrayList.get(n) != this.elementData[n2]) continue;
                intArrayList2.add(n2);
            }
        }
        this.removeAllIndices(intArrayList2);
        return !intArrayList2.isEmpty();
    }

    public final boolean removeAllFirst(int[] nArray) {
        IntArrayList intArrayList = new IntArrayList();
        block0: for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.elementCount; ++j) {
                if (nArray[i] != this.elementData[j]) continue;
                intArrayList.add(j);
                continue block0;
            }
        }
        this.removeAllIndices(intArrayList);
        return !intArrayList.isEmpty();
    }

    public final boolean removeAllFirst(IntArrayList intArrayList) {
        IntArrayList intArrayList2 = new IntArrayList();
        int n = intArrayList.size();
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.elementCount; ++j) {
                if (intArrayList.get(i) != this.elementData[j]) continue;
                intArrayList2.add(j);
                continue block0;
            }
        }
        this.removeAllIndices(intArrayList2);
        return !intArrayList2.isEmpty();
    }

    public final boolean retainAll(IntArrayList intArrayList) {
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < this.elementCount; ++i) {
            if (intArrayList.contains(this.elementData[i])) continue;
            intArrayList2.add(i);
        }
        this.removeAllIndices(intArrayList2);
        return !intArrayList2.isEmpty();
    }

    public final void addAll(int n, int[] nArray) {
        int n2;
        if (this.elementCount + nArray.length < this.elementData.length) {
            int n3;
            for (n3 = n; n3 < this.elementCount; ++n3) {
                this.elementData[n3 + nArray.length] = this.elementData[n3];
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                this.elementData[n + n3] = nArray[n3];
            }
            this.elementCount += nArray.length;
            return;
        }
        int[] nArray2 = new int[this._increasedCapacity(this.elementCount + nArray.length)];
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[n2] = this.elementData[n2];
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[n + n2] = nArray[n2];
        }
        for (n2 = n + nArray.length; n2 < this.elementCount + nArray.length; ++n2) {
            nArray2[n2] = this.elementData[n2 - nArray.length];
        }
        this.elementData = nArray2;
        this.elementCount += nArray.length;
    }

    public final void addAll(int n, IntArrayList intArrayList) {
        int n2;
        int n3 = intArrayList.size();
        if (this.elementCount + n3 < this.elementData.length) {
            int n4;
            for (n4 = n; n4 < this.elementCount; ++n4) {
                this.elementData[n4 + n3] = this.elementData[n4];
            }
            for (n4 = 0; n4 < n3; ++n4) {
                this.elementData[n + n4] = intArrayList.get(n4);
            }
            this.elementCount += n3;
            return;
        }
        int[] nArray = new int[this._increasedCapacity(this.elementCount + n3)];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = this.elementData[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n + n2] = intArrayList.get(n2);
        }
        for (n2 = n + n3; n2 < this.elementCount + n3; ++n2) {
            nArray[n2] = this.elementData[n2 - n3];
        }
        this.elementData = nArray;
        this.elementCount += n3;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntArrayList)) {
            return false;
        }
        IntArrayList intArrayList = (IntArrayList)object;
        if (intArrayList.size() != this.elementCount) {
            return false;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (intArrayList.get(i) == this.elementData[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.elementCount;
        int n2 = 1;
        for (int i = 0; i < this.elementCount; i += Math.max(1, this.elementCount / 4)) {
            n = n2 > 0 ? (n <<= 1) : (n >>= 1);
            n ^= this.elementData[i];
            n2 = -n2;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.elementCount; ++i) {
            stringBuilder.append(this.elementData[i] + (i == this.elementCount - 1 ? "" : ","));
        }
        return stringBuilder.append("]").toString();
    }

    public void removeRange(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        n2 = Math.min(n2, this.elementCount);
        int n3 = n2 - n;
        for (int i = n; i < n2; ++i) {
            this.elementData[i] = this.elementData[i + n3];
        }
        this.elementCount -= n3;
    }

    public final void setIncrementFactor(float f) {
        if ((double)f < 1.1 || (double)f > 5.0) {
            throw new IllegalArgumentException("Increment factor " + f + " must be in [1.1,5.0] range");
        }
        this.incrementFactor = f;
    }

    public final void clear(int n) {
        this.elementCount = n < 0 || n >= this.elementCount ? 0 : n;
    }

    private IntArrayList(int[] nArray, int n, int n2, float f) {
        this.elementData = nArray;
        this.elementCount = n;
        this.capacityIncrement = n2;
        this.incrementFactor = f;
    }

    private final void _grow() {
        int[] nArray = new int[this._increasedCapacity()];
        for (int i = 0; i < this.elementCount; ++i) {
            nArray[i] = this.elementData[i];
        }
        this.elementData = nArray;
    }

    private final int _increasedCapacity() {
        if (this.capacityIncrement <= 0) {
            int n = this.elementData.length == 0 ? 1 : this.elementData.length;
            return (int)Math.floor((float)n * this.incrementFactor + 1.0f);
        }
        return this.elementData.length + this.capacityIncrement;
    }

    private final int _increasedCapacity(int n) {
        if (this.capacityIncrement <= 0) {
            int n2 = this.elementData.length == 0 ? 1 : this.elementData.length;
            return Math.max(n, (int)Math.floor((float)n2 * this.incrementFactor));
        }
        return Math.max(n, this.elementData.length + this.capacityIncrement);
    }

    private final void removeAllIndices(IntArrayList intArrayList) {
        int n = intArrayList.size();
        for (int i = 1; i <= n; ++i) {
            int n2 = intArrayList.get(i - 1);
            int n3 = i < n ? intArrayList.get(i) : this.elementCount;
            for (int j = n2 + 1; j < n3; ++j) {
                this.elementData[j - i] = this.elementData[j];
            }
        }
        this.elementCount -= n;
    }
}

