/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.IntIterator;
import hlt.language.util.ToIntMap;
import java.util.Iterator;

public class IntToIntMap
extends ToIntMap {
    public IntToIntMap() {
        this(11);
    }

    public IntToIntMap(int n) {
        this(n, 0.75f);
    }

    public IntToIntMap(int n, float f) {
        this._table = new Entry[this._setThreshold(n, f)];
    }

    public IntToIntMap(IntToIntMap intToIntMap) {
        this(Math.max(2 * intToIntMap.size(), 11));
        this.include(intToIntMap);
    }

    private final Entry _entry(int n) {
        return (Entry)this._table[n];
    }

    private final Entry _next(Entry entry) {
        return (Entry)entry.next;
    }

    public final boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._entry(n2);
        while (entry != null) {
            if (entry.key == n) {
                return true;
            }
            entry = this._next(entry);
        }
        return false;
    }

    public final boolean containsEntry(int n, int n2) {
        return this.containsEntry(new Entry(n, n2));
    }

    @Override
    public final boolean containsEntry(ToIntMap.Entry entry) {
        Entry entry2 = (Entry)entry;
        int n = (entry2.key & Integer.MAX_VALUE) % this._table.length;
        Entry entry3 = this._entry(n);
        while (entry3 != null) {
            if (entry3.key == entry2.key) {
                return entry3.value == entry2.value;
            }
            entry3 = this._next(entry3);
        }
        return false;
    }

    public final int get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._entry(n2);
        while (entry != null) {
            if (entry.key == n) {
                return entry.value;
            }
            entry = this._next(entry);
        }
        return Integer.MIN_VALUE;
    }

    public final int add(int n) {
        this.put(n, this._size);
        return this._size - 1;
    }

    public final int put(int n, int n2) {
        int n3 = (n & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._entry(n3);
        while (entry != null) {
            if (entry.key == n) {
                int n4 = entry.value;
                entry.value = n2;
                return n4;
            }
            entry = this._next(entry);
        }
        if (this._size >= this._threshold) {
            this._rehash();
            n3 = (n & Integer.MAX_VALUE) % this._table.length;
        }
        this._table[n3] = new Entry(n, n2, this._entry(n3));
        ++this._size;
        return n2;
    }

    public final int remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this._table.length;
        Entry entry = null;
        Entry entry2 = this._entry(n2);
        while (entry2 != null) {
            if (entry2.key == n) {
                if (entry != null) {
                    entry.next = entry2.next;
                } else {
                    this._table[n2] = entry2.next;
                }
                --this._size;
                return entry2.value;
            }
            entry = entry2;
            entry2 = this._next(entry2);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public final int put(ToIntMap.Entry entry) {
        Entry entry2 = (Entry)entry;
        return this.put(entry2.key, entry2.value);
    }

    public final IntIterator keys() {
        return new IntValueIterator(this.iterator(), true);
    }

    @Override
    public final IntIterator values() {
        return new IntValueIterator(this.iterator(), false);
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntToIntMap)) {
            return false;
        }
        return this.isEqualTo((IntToIntMap)object);
    }

    private static class IntValueIterator
    implements IntIterator {
        private Iterator _entries;
        private boolean _isKeyIterator;

        IntValueIterator(Iterator iterator, boolean bl) {
            this._entries = iterator;
            this._isKeyIterator = bl;
        }

        @Override
        public final boolean hasNext() {
            return this._entries.hasNext();
        }

        @Override
        public final int next() {
            return this._isKeyIterator ? ((Entry)this._entries.next()).key : ((Entry)this._entries.next()).value;
        }
    }

    public static class Entry
    extends ToIntMap.Entry {
        int key;

        Entry(int n, int n2) {
            this.key = n;
            this.value = n2;
        }

        Entry(int n, int n2, Entry entry) {
            this.key = n;
            this.value = n2;
            this.next = entry;
        }

        public final int key() {
            return this.key;
        }

        @Override
        public final int hash() {
            return this.key;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.key == entry.key && this.value == entry.value;
        }

        public final int hashCode() {
            return this.key ^ this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

