/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.DoubleIterator;
import hlt.language.util.EmptyStackException;
import hlt.language.util.LinkedStack;
import hlt.language.util.StackPeekException;

public class LinkedDoubleStack
extends LinkedStack {
    public final void push(double d) {
        Cell cell = new Cell(d);
        cell.next = this._top;
        this._top = cell;
    }

    public final double pop() {
        if (this._top == null) {
            throw new EmptyStackException();
        }
        double d = ((Cell)this._top).contents;
        this._top = this._top.next;
        return d;
    }

    public final double peek() {
        if (this._top == null) {
            throw new EmptyStackException();
        }
        return ((Cell)this._top).contents;
    }

    public final double peek(int n) {
        if (n < 0) {
            throw new StackPeekException("`negative index: " + n);
        }
        LinkedStack.Cell cell = this._top;
        int n2 = n;
        while (true) {
            if (cell == null) {
                throw new EmptyStackException();
            }
            if (n2 == 0) {
                return ((Cell)cell).contents;
            }
            --n2;
            cell = cell.next;
        }
    }

    public final DoubleIterator iterator() {
        return new LinkedDoubleStackIterator((Cell)this._top);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            stringBuilder.append(doubleIterator.next());
            if (!doubleIterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append("]").toString();
    }

    private static class LinkedDoubleStackIterator
    implements DoubleIterator {
        private Cell _current;

        public LinkedDoubleStackIterator(Cell cell) {
            this._current = cell;
        }

        @Override
        public final boolean hasNext() {
            return this._current != null;
        }

        @Override
        public final double next() {
            double d = this._current.contents;
            this._current = (Cell)this._current.next;
            return d;
        }
    }

    public static class Cell
    extends LinkedStack.Cell {
        double contents;

        Cell(double d) {
            this.contents = d;
        }
    }
}

