/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.EmptyStackException;
import hlt.language.util.IntIterator;
import hlt.language.util.LinkedStack;
import hlt.language.util.StackPeekException;

public class LinkedIntStack
extends LinkedStack {
    public final void push(int n) {
        Cell cell = new Cell(n);
        cell.next = this._top;
        this._top = cell;
    }

    public final int pop() {
        if (this._top == null) {
            throw new EmptyStackException();
        }
        int n = ((Cell)this._top).contents;
        this._top = this._top.next;
        return n;
    }

    public final int peek() {
        if (this._top == null) {
            throw new EmptyStackException();
        }
        return ((Cell)this._top).contents;
    }

    public final int peek(int n) {
        if (n < 0) {
            throw new StackPeekException("`negative index: " + n);
        }
        LinkedStack.Cell cell = this._top;
        int n2 = n;
        while (true) {
            if (cell == null) {
                throw new EmptyStackException();
            }
            if (n2 == 0) {
                return ((Cell)cell).contents;
            }
            --n2;
            cell = cell.next;
        }
    }

    public final IntIterator iterator() {
        return new LinkedIntStackIterator((Cell)this._top);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next());
            if (!intIterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append("]").toString();
    }

    private static class LinkedIntStackIterator
    implements IntIterator {
        private Cell _current;

        public LinkedIntStackIterator(Cell cell) {
            this._current = cell;
        }

        @Override
        public final boolean hasNext() {
            return this._current != null;
        }

        @Override
        public final int next() {
            int n = this._current.contents;
            this._current = (Cell)this._current.next;
            return n;
        }
    }

    public static class Cell
    extends LinkedStack.Cell {
        int contents;

        Cell(int n) {
            this.contents = n;
        }
    }
}

