/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.EmptyStackException;
import hlt.language.util.LinkedStack;
import hlt.language.util.StackPeekException;
import java.util.Iterator;

public class LinkedObjectStack
extends LinkedStack {
    public final void push(Object object) {
        Cell cell = new Cell(object);
        cell.next = this._top;
        this._top = cell;
    }

    public final Object pop() {
        if (this._top == null) {
            throw new EmptyStackException();
        }
        Object object = ((Cell)this._top).contents;
        this._top = this._top.next;
        return object;
    }

    public final Object peek() {
        if (this._top == null) {
            throw new EmptyStackException();
        }
        return ((Cell)this._top).contents;
    }

    public final Object peek(int n) {
        if (n < 0) {
            throw new StackPeekException("`negative index: " + n);
        }
        LinkedStack.Cell cell = this._top;
        int n2 = n;
        while (true) {
            if (cell == null) {
                throw new EmptyStackException();
            }
            if (n2 == 0) {
                return ((Cell)cell).contents;
            }
            --n2;
            cell = cell.next;
        }
    }

    public final Iterator iterator() {
        return new LinkedObjectStackIterator((Cell)this._top);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append("]").toString();
    }

    private static class LinkedObjectStackIterator
    implements Iterator {
        private Cell _current;

        public LinkedObjectStackIterator(Cell cell) {
            this._current = cell;
        }

        @Override
        public final boolean hasNext() {
            return this._current != null;
        }

        public final Object next() {
            Object object = this._current.contents;
            this._current = (Cell)this._current.next;
            return object;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Cell
    extends LinkedStack.Cell {
        Object contents;

        Cell(Object object) {
            this.contents = object;
        }
    }
}

