/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.EmptyStackException;
import hlt.language.util.StackPeekException;

public abstract class LinkedStack {
    protected Cell _top;

    public final void set(Cell cell) {
        this._top = cell;
    }

    public final Cell top() {
        return this._top;
    }

    public final Cell top(int n) {
        if (n < 0) {
            throw new StackPeekException("`negative index: " + n);
        }
        Cell cell = this._top;
        int n2 = n;
        while (true) {
            if (cell == null) {
                throw new EmptyStackException();
            }
            if (n2 == 0) {
                return cell;
            }
            --n2;
            cell = cell.next;
        }
    }

    public final boolean isEmpty() {
        return this._top == null;
    }

    public final void clear() {
        this._top = null;
    }

    protected static abstract class Cell {
        Cell next;

        protected Cell() {
        }
    }
}

