/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

public class Location {
    private String _file = "";
    private int _line;
    private int _column;

    public Location() {
    }

    public Location(int n, int n2) {
        this._line = n;
        this._column = n2;
    }

    public Location(String string, int n, int n2) {
        this.setFile(string);
        this._line = n;
        this._column = n2;
    }

    public final Location setFile(String string) {
        if (string != null) {
            this._file = string.intern();
        }
        return this;
    }

    public final String getFile() {
        return this._file;
    }

    public final Location setLine(int n) {
        this._line = n;
        return this;
    }

    public final int getLine() {
        return this._line;
    }

    public final Location setColumn(int n) {
        this._column = n;
        return this;
    }

    public final int getColumn() {
        return this._column;
    }

    public final boolean precedes(Location location) {
        if (location == null) {
            throw new RuntimeException("Can't compare a null location");
        }
        return this.getLine() == location.getLine() && this.getColumn() < location.getColumn() || this.getLine() < location.getLine();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Location)) {
            return false;
        }
        return this._file == ((Location)object).getFile() && this._line == ((Location)object).getLine() && this._column == ((Location)object).getColumn();
    }

    public final String toString() {
        return this._file + "(" + this._line + "," + this._column + ")";
    }
}

