/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.IntIterator;
import hlt.language.util.Misc;
import hlt.language.util.ToIntMap;
import java.util.Iterator;

public class ObjectToIntMap
extends ToIntMap {
    public ObjectToIntMap() {
        this(11);
    }

    public ObjectToIntMap(int n) {
        this(n, 0.75f);
    }

    public ObjectToIntMap(int n, float f) {
        this._table = new Entry[this._setThreshold(n, f)];
    }

    public ObjectToIntMap(ObjectToIntMap objectToIntMap) {
        this(Math.max(2 * objectToIntMap.size(), 11));
        this.include(objectToIntMap);
    }

    private final Entry _entry(int n) {
        return (Entry)this._table[n];
    }

    private final Entry _next(Entry entry) {
        return (Entry)entry.next;
    }

    public final boolean containsKey(Object object) {
        int n = (Misc.hashCode(object) & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._entry(n);
        while (entry != null) {
            if (Misc.equals(entry.key, object)) {
                return true;
            }
            entry = this._next(entry);
        }
        return false;
    }

    public final boolean containsEntry(Object object, int n) {
        return this.containsEntry(new Entry(object, n));
    }

    @Override
    public final boolean containsEntry(ToIntMap.Entry entry) {
        Entry entry2 = (Entry)entry;
        int n = (Misc.hashCode(entry2.key) & Integer.MAX_VALUE) % this._table.length;
        Entry entry3 = this._entry(n);
        while (entry3 != null) {
            if (Misc.equals(entry3.key, entry2.key)) {
                return entry3.value == entry2.value;
            }
            entry3 = this._next(entry3);
        }
        return false;
    }

    public final int get(Object object) {
        int n = (Misc.hashCode(object) & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._entry(n);
        while (entry != null) {
            if (Misc.equals(entry.key, object)) {
                return entry.value;
            }
            entry = this._next(entry);
        }
        return Integer.MIN_VALUE;
    }

    public final int add(Object object) {
        this.put(object, this._size);
        return this._size - 1;
    }

    public final int put(Object object, int n) {
        int n2 = (Misc.hashCode(object) & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._entry(n2);
        while (entry != null) {
            if (Misc.equals(entry.key, object)) {
                int n3 = entry.value;
                entry.value = n;
                return n3;
            }
            entry = this._next(entry);
        }
        if (this._size >= this._threshold) {
            this._rehash();
            n2 = (Misc.hashCode(object) & Integer.MAX_VALUE) % this._table.length;
        }
        this._table[n2] = new Entry(object, n, this._entry(n2));
        ++this._size;
        return n;
    }

    public final double remove(Object object) {
        int n = (Misc.hashCode(object) & Integer.MAX_VALUE) % this._table.length;
        Entry entry = null;
        Entry entry2 = this._entry(n);
        while (entry2 != null) {
            if (Misc.equals(entry2.key, object)) {
                if (entry != null) {
                    entry.next = entry2.next;
                } else {
                    this._table[n] = entry2.next;
                }
                --this._size;
                return entry2.value;
            }
            entry = entry2;
            entry2 = this._next(entry2);
        }
        return -2.147483648E9;
    }

    @Override
    public final int put(ToIntMap.Entry entry) {
        Entry entry2 = (Entry)entry;
        return this.put(entry2.key, entry2.value);
    }

    public final Iterator keys() {
        return new KeyIterator(this.iterator());
    }

    @Override
    public final IntIterator values() {
        return new ToIntMap.ValueIterator(this.iterator());
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectToIntMap)) {
            return false;
        }
        return this.isEqualTo((ObjectToIntMap)object);
    }

    private static class KeyIterator
    implements Iterator {
        private Iterator _entries;

        KeyIterator(Iterator iterator) {
            this._entries = iterator;
        }

        @Override
        public final boolean hasNext() {
            return this._entries.hasNext();
        }

        public final Object next() {
            return ((Entry)this._entries.next()).key;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry
    extends ToIntMap.Entry {
        Object key;

        Entry(Object object, int n) {
            this.key = object;
            this.value = n;
        }

        Entry(Object object, int n, Entry entry) {
            this.key = object;
            this.value = n;
            this.next = entry;
        }

        public final Object key() {
            return this.key;
        }

        @Override
        public final int hash() {
            return Misc.hashCode(this.key);
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return Misc.equals(this.key, entry.key) && this.value == entry.value;
        }

        public final int hashCode() {
            return Misc.hashCode(this.key) ^ this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

