/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.EmptyQueueException;
import java.util.Collection;
import java.util.Iterator;

public class Queue {
    private QueueElement oldest = null;
    private QueueElement newest = null;
    private int size = 0;

    public Queue() {
    }

    public Queue(Object object) {
        this.push(object);
    }

    public Queue(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.push(objectArray[i]);
        }
    }

    public Queue(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.push(iterator.next());
        }
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public final void enqueue(Object object) {
        this.push(object);
    }

    public final void push(Object object) {
        QueueElement queueElement = new QueueElement(object);
        queueElement.succ = this.newest;
        if (this.newest != null) {
            this.newest.pred = queueElement;
        }
        this.newest = queueElement;
        if (this.size == 0) {
            this.oldest = this.newest;
        }
        ++this.size;
    }

    public final void rush(Object object) {
        QueueElement queueElement = new QueueElement(object);
        queueElement.pred = this.oldest;
        if (this.oldest != null) {
            this.oldest.succ = queueElement;
        }
        this.oldest = queueElement;
        if (this.size == 0) {
            this.newest = this.oldest;
        }
        ++this.size;
    }

    public final Object dequeue() {
        return this.pop();
    }

    public final Object pop() {
        if (this.isEmpty()) {
            throw new EmptyQueueException();
        }
        Object object = this.oldest.element;
        this.oldest = this.oldest.pred;
        if (this.oldest != null) {
            this.oldest.succ = null;
        }
        --this.size;
        return object;
    }

    public final Object chop() {
        if (this.isEmpty()) {
            throw new EmptyQueueException();
        }
        Object object = this.newest.element;
        this.newest = this.newest.succ;
        if (this.newest != null) {
            this.newest.pred = null;
        }
        --this.size;
        return object;
    }

    public final Iterator iterator() {
        return new QueueIterator(this);
    }

    public final Object peek() {
        if (this.isEmpty()) {
            throw new EmptyQueueException();
        }
        return this.oldest.element;
    }

    public final Queue reverse() {
        QueueElement queueElement = this.newest;
        while (queueElement != null) {
            QueueElement queueElement2 = queueElement.succ;
            queueElement.succ = queueElement.pred;
            queueElement.pred = queueElement2;
            queueElement = queueElement2;
        }
        queueElement = this.oldest;
        this.oldest = this.newest;
        this.newest = queueElement;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(">> ");
        QueueElement queueElement = this.newest;
        while (queueElement != null) {
            stringBuilder.append(queueElement.element);
            queueElement = queueElement.succ;
            if (queueElement == null) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" >>");
        return stringBuilder.toString();
    }

    private static class QueueIterator
    implements Iterator {
        private QueueElement current;

        QueueIterator(Queue queue) {
            if (!queue.isEmpty()) {
                this.current = queue.oldest;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.current != null;
        }

        public final Object next() {
            if (this.current == null) {
                return null;
            }
            Object object = this.current.element;
            this.current = this.current.pred;
            return object;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class QueueElement {
        Object element;
        QueueElement succ;
        QueueElement pred;

        QueueElement(Object object) {
            this.element = object;
        }
    }
}

