/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.tools.Misc;
import hlt.language.util.RegExpChoice;
import hlt.language.util.RegExpConcat;
import hlt.language.util.RegExpOne;
import hlt.language.util.RegExpOption;
import hlt.language.util.RegExpPlus;
import hlt.language.util.RegExpPower;
import hlt.language.util.RegExpPowerRange;
import hlt.language.util.RegExpStar;
import hlt.language.util.RegExpSymbol;
import hlt.language.util.RegExpTwo;

public abstract class RegExp {
    protected RegExp _normalForm = null;
    public static final int EMPTY_EXP = 1;
    public static final int SYMBOL_EXP = 2;
    public static final int OPTION_EXP = 4;
    public static final int PLUS_EXP = 8;
    public static final int STAR_EXP = 16;
    public static final int POWER_EXP = 32;
    public static final int RANGE_EXP = 64;
    public static final int CHOICE_EXP = 128;
    public static final int CONCAT_EXP = 256;
    public static final int UNARY_EXP = 124;
    public static final int BINARY_EXP = 384;
    protected static int OMEGA = Integer.MAX_VALUE;
    private static boolean _tracing = false;

    public static final RegExpSymbol empty() {
        return RegExpSymbol.EMPTY;
    }

    public final RegExp normalForm() {
        if (this._normalForm == null) {
            this.normalize();
        }
        return this._normalForm;
    }

    protected final void checkNormalForm() {
        this._normalForm = this._normalForm == null ? this : this._normalForm.normalForm();
    }

    public final boolean inNormalForm() {
        return this == this.normalForm();
    }

    public abstract void normalize();

    public final boolean normEquals(RegExp regExp) {
        return this.normalForm().equals(regExp.normalForm());
    }

    public abstract RegExp shallowCopy();

    public abstract RegExp deepCopy();

    public final RegExp cleanup(RegExp regExp) {
        return regExp == null ? RegExpSymbol.EMPTY : regExp;
    }

    public abstract int type();

    public final String tag() {
        switch (this.type()) {
            case 1: {
                return "Empty";
            }
            case 2: {
                return "Symbol";
            }
            case 128: {
                return "Choice";
            }
            case 256: {
                return "Concat";
            }
            case 4: {
                return "Option";
            }
            case 8: {
                return "Plus";
            }
            case 32: {
                return "Power";
            }
            case 64: {
                return "PowerRange";
            }
            case 16: {
                return "Star";
            }
        }
        return "Unknown";
    }

    public final boolean isEmpty() {
        return this == RegExpSymbol.EMPTY;
    }

    public final boolean isSymbol() {
        return this.type() == 2;
    }

    public final boolean isChoice() {
        return this.type() == 128;
    }

    public final boolean isConcat() {
        return this.type() == 256;
    }

    public final boolean isOption() {
        return this.type() == 4;
    }

    public final boolean isPlus() {
        return this.type() == 8;
    }

    public final boolean isPower() {
        return this.type() == 32;
    }

    public final boolean isRange() {
        return this.type() == 64;
    }

    public final boolean isStar() {
        return this.type() == 16;
    }

    public final boolean isUnary() {
        return (this.type() & 0x7C) == this.type();
    }

    public final boolean isBinary() {
        return (this.type() & 0x180) == this.type();
    }

    protected final RegExpOption option(RegExp regExp) {
        return new RegExpOption(regExp);
    }

    protected final RegExpPlus plus(RegExp regExp) {
        return new RegExpPlus(regExp);
    }

    protected final RegExpStar star(RegExp regExp) {
        return new RegExpStar(regExp);
    }

    protected final RegExpPower power(RegExp regExp, int n) {
        return new RegExpPower(regExp, n);
    }

    protected final RegExpPowerRange range(RegExp regExp, int n, int n2) {
        return new RegExpPowerRange(regExp, n, n2);
    }

    protected final RegExpPowerRange range(RegExp regExp, int n) {
        return new RegExpPowerRange(regExp, n);
    }

    protected final RegExpConcat concat(RegExp regExp, RegExp regExp2) {
        return new RegExpConcat(regExp, regExp2);
    }

    protected final RegExpChoice choice(RegExp regExp, RegExp regExp2) {
        return new RegExpChoice(regExp, regExp2);
    }

    protected final RegExp arg() {
        return ((RegExpOne)this).getArg();
    }

    protected final RegExp narg() {
        return ((RegExpOne)this).normalArg();
    }

    protected final RegExp left() {
        return ((RegExpTwo)this).getLeft();
    }

    protected final RegExp nleft() {
        return ((RegExpTwo)this).normalLeft();
    }

    protected final RegExp right() {
        return ((RegExpTwo)this).getRight();
    }

    protected final RegExp nright() {
        return ((RegExpTwo)this).normalRight();
    }

    protected final int power() {
        return ((RegExpPower)this).getPower();
    }

    protected final int lower() {
        return ((RegExpPowerRange)this).getLower();
    }

    protected final int upper() {
        return ((RegExpPowerRange)this).getUpper();
    }

    protected final int plus(int n, int n2) {
        if (n <= OMEGA && n2 <= OMEGA - n) {
            return n + n2;
        }
        return OMEGA;
    }

    protected final int times(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n <= OMEGA && n2 <= OMEGA / n) {
            return n * n2;
        }
        return OMEGA;
    }

    public abstract String toNormalString();

    public final boolean isLexLess(RegExp regExp) {
        return this.toString().compareTo(regExp.toString()) < 0;
    }

    protected final void traceRule(String string) {
        if (RegExp.tracing() && string != null) {
            System.err.println(Misc.repeat(70, '-'));
            System.err.println(this.tag() + " Rule: " + string + "\n\n\t" + this + " --> " + this._normalForm + "\n");
        }
    }

    public static final boolean tracing() {
        return _tracing;
    }

    public static final void trace() {
        _tracing = true;
    }

    public static final void noTrace() {
        _tracing = false;
    }

    public static final void toggleTrace() {
        _tracing = !_tracing;
    }
}

