/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.ArrayList;
import hlt.language.util.RegExp;
import hlt.language.util.RegExpSymbol;
import hlt.language.util.RegExpTwo;
import java.util.Iterator;

public class RegExpConcat
extends RegExpTwo {
    public RegExpConcat(RegExp regExp, RegExp regExp2) {
        super(regExp, regExp2);
    }

    @Override
    public final RegExp shallowCopy() {
        return this.concat(this._left, this._right);
    }

    @Override
    public final RegExp deepCopy() {
        return this.concat(this._left.deepCopy(), this._right.deepCopy());
    }

    @Override
    public final int type() {
        return 256;
    }

    @Override
    public void normalize() {
        String string = null;
        RegExp regExp = this.left();
        RegExp regExp2 = this.right();
        if (regExp.isEmpty()) {
            string = "[CO:E_] ().X --> X";
            this._normalForm = regExp2;
        } else if (regExp2.isEmpty()) {
            string = "[CO:_E] X.() --> X";
            this._normalForm = regExp;
        } else if (regExp.isConcat()) {
            string = "[CO:_A] (X.Y).Z --> X.(Y.Z)";
            this._normalForm = this.concat(regExp.left(), this.concat(regExp.right(), regExp2));
        } else if (regExp.isChoice()) {
            string = "[CO:D_] (X | Y).Z --> X.Z | Y.Z";
            this._normalForm = this.choice(this.concat(regExp.left(), regExp2), this.concat(regExp.right(), regExp2));
        } else if (regExp2.isChoice()) {
            string = "[CO:_D] X.(Y | Z) --> X.Y | X.Z";
            this._normalForm = this.choice(this.concat(regExp, regExp2.left()), this.concat(regExp, regExp2.right()));
        } else {
            block0 : switch (this.matchingPairCode()) {
                case 1: {
                    string = "[CO:XX1] X.X --> X^2";
                    RegExp regExp3 = regExp;
                    this._normalForm = this.power(regExp3, 2);
                    break;
                }
                case 2: {
                    string = "[CO:XO1] X.X? --> X_1^2";
                    RegExp regExp4 = regExp;
                    this._normalForm = this.range(regExp4, 1, 2);
                    break;
                }
                case 3: {
                    string = "[CO:XP1] X.X+ --> X_2~";
                    RegExp regExp5 = regExp;
                    this._normalForm = this.range(regExp5, 2);
                    break;
                }
                case 4: {
                    string = "[CO:XS1] X.X* --> X+";
                    RegExp regExp6 = regExp;
                    this._normalForm = this.plus(regExp6);
                    break;
                }
                case 5: {
                    string = "[CO:XN1] X.X^q --> X^q+1";
                    RegExp regExp7 = regExp;
                    int n = regExp2.power();
                    this._normalForm = this.power(regExp7, this.plus(n, 1));
                    break;
                }
                case 6: {
                    string = "[CO:XR1] X.X_p^q --> X_p+1^q+1";
                    RegExp regExp8 = regExp;
                    int n = regExp2.lower();
                    int n2 = regExp2.upper();
                    this._normalForm = this.range(regExp, this.plus(n, 1), this.plus(n2, 1));
                    break;
                }
                case 7: {
                    string = "[CO:OX1] X?.X --> X_1^2";
                    RegExp regExp9 = regExp2;
                    this._normalForm = this.range(regExp9, 1, 2);
                    break;
                }
                case 8: {
                    string = "[CO:OO1] X?.X? --> X_0^2";
                    RegExp regExp10 = regExp.arg();
                    this._normalForm = this.range(regExp10, 0, 2);
                    break;
                }
                case 9: {
                    string = "[CO:OP1] X?.X+ --> X+";
                    this._normalForm = regExp2;
                    break;
                }
                case 10: {
                    string = "[CO:OS1] X?.X* --> X*";
                    this._normalForm = regExp2;
                    break;
                }
                case 11: {
                    string = "[CO:ON1] X?.X^q --> X_q^q+1";
                    RegExp regExp11 = regExp.arg();
                    int n = regExp2.power();
                    this._normalForm = this.range(regExp11, n, this.plus(n, 1));
                    break;
                }
                case 12: {
                    string = "[CO:OR1] X?.X_p^q --> X_p^q+1";
                    RegExp regExp12 = regExp.arg();
                    int n = regExp2.lower();
                    int n3 = regExp2.upper();
                    this._normalForm = this.range(regExp12, n, this.plus(n3, 1));
                    break;
                }
                case 13: {
                    string = "[CO:PX1] X+.X --> X_2~";
                    RegExp regExp13 = regExp2;
                    this._normalForm = this.range(regExp13, 2);
                    break;
                }
                case 14: {
                    string = "[CO:PO1] X+.X? --> X+";
                    this._normalForm = regExp;
                    break;
                }
                case 15: {
                    string = "[CO:PP1] X+.X+ --> X_2~";
                    RegExp regExp14 = regExp.arg();
                    this._normalForm = this.range(regExp14, 2);
                    break;
                }
                case 16: {
                    string = "[CO:PS1] X+.X* --> X+";
                    this._normalForm = regExp;
                    break;
                }
                case 17: {
                    string = "[CO:PN1] X+.X^q --> X_q+1~";
                    RegExp regExp15 = regExp.arg();
                    int n = regExp2.power();
                    this._normalForm = this.range(regExp15, this.plus(n, 1));
                    break;
                }
                case 18: {
                    string = "[CO:PR1] X+.X_p^q --> X_p+1~";
                    RegExp regExp16 = regExp.arg();
                    int n = regExp2.lower();
                    int n4 = regExp2.upper();
                    this._normalForm = this.range(regExp16, this.plus(n, 1));
                    break;
                }
                case 19: {
                    string = "[CO:SX1] X*.X --> X+";
                    RegExp regExp17 = regExp2;
                    this._normalForm = this.plus(regExp17);
                    break;
                }
                case 20: {
                    string = "[CO:SO1] X*.X? --> X*";
                    this._normalForm = regExp;
                    break;
                }
                case 21: {
                    string = "[CO:SP] X*.X+ --> X+";
                    this._normalForm = regExp2;
                    break;
                }
                case 22: {
                    string = "[CO:SS1] X*.X* --> X*";
                    this._normalForm = regExp;
                    break;
                }
                case 23: {
                    string = "[CO:SN] X*.X^q --> X_q~";
                    RegExp regExp18 = regExp.arg();
                    int n = regExp2.power();
                    this._normalForm = this.range(regExp18, n);
                    break;
                }
                case 24: {
                    string = "[CO:SR1] X*.X_p^q --> X_p~";
                    RegExp regExp19 = regExp.arg();
                    int n = regExp2.lower();
                    this._normalForm = this.range(regExp19, n);
                    break;
                }
                case 25: {
                    string = "[CO:NX1] X^n.X --> X^n+1";
                    RegExp regExp20 = regExp2;
                    int n = regExp.power();
                    this._normalForm = this.power(regExp20, this.plus(n, 1));
                    break;
                }
                case 26: {
                    string = "[CO:NO1] X^n.X? --> X_n^n+1";
                    RegExp regExp21 = regExp.arg();
                    int n = regExp.power();
                    this._normalForm = this.range(regExp21, n, this.plus(n, 1));
                    break;
                }
                case 27: {
                    string = "[CO:NP1] X^n.X+ --> X_n+1~";
                    RegExp regExp22 = regExp.arg();
                    int n = regExp.power();
                    this._normalForm = this.range(regExp22, this.plus(n, 1));
                    break;
                }
                case 28: {
                    string = "[CO:NS1] X^n.X* --> X_n~";
                    RegExp regExp23 = regExp.arg();
                    int n = regExp.power();
                    this._normalForm = this.range(regExp23, n);
                    break;
                }
                case 29: {
                    string = "[CO:NN1] X^n.X^q --> X^n+q";
                    RegExp regExp24 = regExp.arg();
                    int n = regExp.power();
                    int n5 = regExp2.power();
                    this._normalForm = this.power(regExp24, this.plus(n, n5));
                    break;
                }
                case 30: {
                    string = "[CO:NR1] X^n.X_p^q --> X_n+p^n+q";
                    RegExp regExp25 = regExp.arg();
                    int n = regExp.power();
                    int n6 = regExp2.lower();
                    int n7 = regExp2.upper();
                    this._normalForm = this.range(regExp25, this.plus(n, n6), this.plus(n, n7));
                    break;
                }
                case 31: {
                    string = "[CO:RX1] X_m^n.X --> X_m+1^n+1";
                    RegExp regExp26 = regExp2;
                    int n = regExp.lower();
                    int n8 = regExp.upper();
                    this._normalForm = this.range(regExp26, this.plus(n, 1), this.plus(n8, 1));
                    break;
                }
                case 32: {
                    string = "[CO:RO1] X_m^n.X? --> X_m^n+1";
                    RegExp regExp27 = regExp.arg();
                    int n = regExp.lower();
                    int n9 = regExp.upper();
                    this._normalForm = this.range(regExp27, n, this.plus(n9, 1));
                    break;
                }
                case 33: {
                    string = "[CO:RP1] X_m^n.X+ --> X_m+1~";
                    RegExp regExp28 = regExp.arg();
                    int n = regExp.lower();
                    int n10 = regExp.upper();
                    this._normalForm = this.range(regExp28, this.plus(n, 1));
                    break;
                }
                case 34: {
                    string = "[CO:RS1] X_m^n.X* --> X_m~";
                    RegExp regExp29 = regExp.arg();
                    int n = regExp.lower();
                    int n11 = regExp.upper();
                    this._normalForm = this.range(regExp29, n);
                    break;
                }
                case 35: {
                    string = "[CO:RN1] X_m^n.X^q --> X_m+q^n+q";
                    RegExp regExp30 = regExp.arg();
                    int n = regExp.lower();
                    int n12 = regExp.upper();
                    int n13 = regExp2.power();
                    this._normalForm = this.range(regExp30, this.plus(n, n13), this.plus(n12, n13));
                    break;
                }
                case 36: {
                    string = "[CO:RR1] X_m^n.X_p^q --> X_m+p^n+q";
                    RegExp regExp31 = regExp.arg();
                    int n = regExp.lower();
                    int n14 = regExp.upper();
                    int n15 = regExp2.lower();
                    int n16 = regExp2.upper();
                    this._normalForm = this.range(regExp31, this.plus(n, n15), this.plus(n14, n16));
                    break;
                }
                default: {
                    switch (this.matchingArgsCode()) {
                        case 1: {
                            string = "[CO:XX2] X.(X.Y) --> X^2.Y";
                            RegExp regExp32 = regExp;
                            RegExp regExp33 = regExp2.right();
                            this._normalForm = this.concat(this.power(regExp32, 2), regExp33);
                            break block0;
                        }
                        case 2: {
                            string = "[CO:XO2] X.(X?.Y) --> X_1^2.Y";
                            RegExp regExp34 = regExp;
                            RegExp regExp35 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp34, 1, 2), regExp35);
                            break block0;
                        }
                        case 3: {
                            string = "[CO:XP2] X.(X+.Y) --> X_2~.Y";
                            RegExp regExp36 = regExp;
                            RegExp regExp37 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp36, 2), regExp37);
                            break block0;
                        }
                        case 4: {
                            string = "[CO:XS2] X.(X*.Y) --> X+.Y";
                            RegExp regExp38 = regExp;
                            RegExp regExp39 = regExp2.right();
                            this._normalForm = this.concat(this.plus(regExp38), regExp39);
                            break block0;
                        }
                        case 5: {
                            string = "[CO:XN2] X.(X^q.Y) --> X^q+1.Y";
                            RegExp regExp40 = regExp;
                            int n = regExp2.left().power();
                            RegExp regExp41 = regExp2.right();
                            this._normalForm = this.concat(this.power(regExp40, this.plus(n, 1)), regExp41);
                            break block0;
                        }
                        case 6: {
                            string = "[CO:XR2] X.(X_p^q.Y) --> X_p+1^q+1.Y";
                            RegExp regExp42 = regExp;
                            int n = regExp2.left().lower();
                            int n17 = regExp2.left().upper();
                            RegExp regExp43 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp, this.plus(n, 1), this.plus(n17, 1)), regExp43);
                            break block0;
                        }
                        case 7: {
                            string = "[CO:OX2] X?.(X.Y) --> X_1^2.Y";
                            RegExp regExp44 = regExp2.left();
                            RegExp regExp45 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp44, 1, 2), regExp45);
                            break block0;
                        }
                        case 8: {
                            string = "[CO:OO2] X?.(X?.Y) --> X_0^2.Y";
                            RegExp regExp46 = regExp.arg();
                            RegExp regExp47 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp46, 0, 2), regExp47);
                            break block0;
                        }
                        case 9: {
                            string = "[CO:OP2] X?.(X+.Y) --> X+.Y";
                            this._normalForm = regExp2;
                            break block0;
                        }
                        case 10: {
                            string = "[CO:OS2] X?.(X*.Y) --> X*.Y";
                            this._normalForm = regExp2;
                            break block0;
                        }
                        case 11: {
                            string = "[CO:ON2] X?.(X^q.Y) --> X_q^q+1.Y";
                            RegExp regExp48 = regExp.arg();
                            int n = regExp2.left().power();
                            RegExp regExp49 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp48, n, this.plus(n, 1)), regExp49);
                            break block0;
                        }
                        case 12: {
                            string = "[CO:OR2] X?.(X_p^q.Y) --> X_p^q+1.Y";
                            RegExp regExp50 = regExp.arg();
                            int n = regExp2.left().lower();
                            int n18 = regExp2.left().upper();
                            RegExp regExp51 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp50, n, this.plus(n18, 1)), regExp51);
                            break block0;
                        }
                        case 13: {
                            string = "[CO:PX2] X+.(X.Y) --> X_2~.Y";
                            RegExp regExp52 = regExp2.left();
                            RegExp regExp53 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp52, 2), regExp53);
                            break block0;
                        }
                        case 14: {
                            string = "[CO:PO2] X+.(X?.Y) --> X+.Y";
                            RegExp regExp54 = regExp2.right();
                            this._normalForm = this.concat(regExp, regExp54);
                            break block0;
                        }
                        case 15: {
                            string = "[CO:PP2] X+.(X+.Y) --> X_2~.Y";
                            RegExp regExp55 = regExp.arg();
                            RegExp regExp56 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp55, 2), regExp56);
                            break block0;
                        }
                        case 16: {
                            string = "[CO:PS2] X+.(X*.Y) --> X+.Y";
                            RegExp regExp57 = regExp.arg();
                            RegExp regExp58 = regExp2.right();
                            this._normalForm = this.concat(this.plus(regExp57), regExp58);
                            break block0;
                        }
                        case 17: {
                            string = "[CO:PN2] X+.(X^q.Y) --> X_q+1~.Y";
                            RegExp regExp59 = regExp.arg();
                            int n = regExp2.left().power();
                            RegExp regExp60 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp59, this.plus(n, 1)), regExp60);
                            break block0;
                        }
                        case 18: {
                            string = "[CO:PR2] X+.(X_p^q.Y) --> X_p+1~.Y";
                            RegExp regExp61 = regExp.arg();
                            int n = regExp2.left().lower();
                            int n19 = regExp2.left().upper();
                            RegExp regExp62 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp61, this.plus(n, 1)), regExp62);
                            break block0;
                        }
                        case 19: {
                            string = "[CO:SX2] X*.(X.Y) --> X+.Y";
                            RegExp regExp63 = regExp2.left();
                            RegExp regExp64 = regExp2.right();
                            this._normalForm = this.concat(this.plus(regExp63), regExp64);
                            break block0;
                        }
                        case 20: {
                            string = "[CO:SO2] X*.(X?.Y) --> X*.Y";
                            RegExp regExp65 = regExp2.right();
                            this._normalForm = this.concat(regExp, regExp65);
                            break block0;
                        }
                        case 21: {
                            string = "[CO:SP2] X*.(X+.Y) --> X+.Y";
                            this._normalForm = regExp2;
                            break block0;
                        }
                        case 22: {
                            string = "[CO:SS2] X*.(X*.Y) --> X*.Y";
                            this._normalForm = regExp2;
                            break block0;
                        }
                        case 23: {
                            string = "[CO:SN2] X*.(X^q.Y) --> X_q~.Y";
                            RegExp regExp66 = regExp.arg();
                            int n = regExp2.left().power();
                            RegExp regExp67 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp66, n), regExp67);
                            break block0;
                        }
                        case 24: {
                            string = "[CO:SR2] X*.(X_p^q.Y) --> X_p~.Y";
                            RegExp regExp68 = regExp.arg();
                            int n = regExp2.left().lower();
                            RegExp regExp69 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp68, n), regExp69);
                            break block0;
                        }
                        case 25: {
                            string = "[CO:NX2] X^n.(X.Y) --> X^n+1.Y";
                            RegExp regExp70 = regExp2.left();
                            int n = regExp.power();
                            RegExp regExp71 = regExp2.right();
                            this._normalForm = this.concat(this.power(regExp70, this.plus(n, 1)), regExp71);
                            break block0;
                        }
                        case 26: {
                            string = "[CO:NO2] X^n.(X?.Y) --> X_n^n+1.Y";
                            RegExp regExp72 = regExp.arg();
                            int n = regExp.power();
                            RegExp regExp73 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp72, n, this.plus(n, 1)), regExp73);
                            break block0;
                        }
                        case 27: {
                            string = "[CO:NP2] X^n.(X+.Y) --> X_n+1~.Y";
                            RegExp regExp74 = regExp.arg();
                            int n = regExp.power();
                            RegExp regExp75 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp74, this.plus(n, 1)), regExp75);
                            break block0;
                        }
                        case 28: {
                            string = "[CO:NS2] X^n.(X*.Y) --> X_n~.Y";
                            RegExp regExp76 = regExp.arg();
                            int n = regExp.power();
                            RegExp regExp77 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp76, n), regExp77);
                            break block0;
                        }
                        case 29: {
                            string = "[CO:NN2] X^n.(X^q.Y) --> X^n+q.Y";
                            RegExp regExp78 = regExp.arg();
                            int n = regExp.power();
                            int n20 = regExp2.left().power();
                            RegExp regExp79 = regExp2.right();
                            this._normalForm = this.concat(this.power(regExp78, this.plus(n, n20)), regExp79);
                            break block0;
                        }
                        case 30: {
                            string = "[CO:NR2] X^n.(X_p^q.Y) --> X_n+p^n+q.Y";
                            RegExp regExp80 = regExp.arg();
                            int n = regExp.power();
                            int n21 = regExp2.left().lower();
                            int n22 = regExp2.left().upper();
                            RegExp regExp81 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp80, this.plus(n, n21), this.plus(n, n22)), regExp81);
                            break block0;
                        }
                        case 31: {
                            string = "[CO:RX2] X_m^n.(X.Y) --> X_m+1^n+1.Y";
                            RegExp regExp82 = regExp2.left();
                            int n = regExp.lower();
                            int n23 = regExp.upper();
                            RegExp regExp83 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp82, this.plus(n, 1), this.plus(n23, 1)), regExp83);
                            break block0;
                        }
                        case 32: {
                            string = "[CO:RO2] X_m^n.(X?.Y) --> X_m^n+1.Y";
                            RegExp regExp84 = regExp.arg();
                            int n = regExp.lower();
                            int n24 = regExp.upper();
                            RegExp regExp85 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp84, n, this.plus(n24, 1)), regExp85);
                            break block0;
                        }
                        case 33: {
                            string = "[CO:RP2] X_m^n.(X+.Y) --> X_m+1~.Y";
                            RegExp regExp86 = regExp.arg();
                            int n = regExp.lower();
                            int n25 = regExp.upper();
                            RegExp regExp87 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp86, this.plus(n, 1)), regExp87);
                            break block0;
                        }
                        case 34: {
                            string = "[CO:RS2] X_m^n.(X*.Y) --> X_m~.Y";
                            RegExp regExp88 = regExp.arg();
                            int n = regExp.lower();
                            int n26 = regExp.upper();
                            RegExp regExp89 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp88, n), regExp89);
                            break block0;
                        }
                        case 35: {
                            string = "[CO:RN2] X_m^n.(X^q.Y) --> X_m+q^n+q.Y";
                            RegExp regExp90 = regExp.arg();
                            int n = regExp.lower();
                            int n27 = regExp.upper();
                            int n28 = regExp2.left().power();
                            RegExp regExp91 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp90, this.plus(n, n28), this.plus(n27, n28)), regExp91);
                            break block0;
                        }
                        case 36: {
                            string = "[CO:RR2] X_m^n.(X_p^q.Y) --> X_m+p^n+q.Y";
                            RegExp regExp92 = regExp.arg();
                            int n = regExp.lower();
                            int n29 = regExp.upper();
                            int n30 = regExp2.left().lower();
                            int n31 = regExp2.left().upper();
                            RegExp regExp93 = regExp2.right();
                            this._normalForm = this.concat(this.range(regExp92, this.plus(n, n30), this.plus(n29, n31)), regExp93);
                            break block0;
                        }
                    }
                }
            }
        }
        this.traceRule(string);
        this.checkNormalForm();
    }

    private RegExp concat(ArrayList arrayList) {
        RegExp regExp = RegExpSymbol.EMPTY;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            regExp = this.concat((RegExp)iterator.next(), regExp);
        }
        return regExp;
    }

    private final boolean reOccursIn(RegExp regExp, ArrayList arrayList) {
        if (regExp.type() != 256) {
            return false;
        }
        arrayList.add(this.left());
        RegExpConcat regExpConcat = (RegExpConcat)regExp;
        if (this == regExpConcat.right()) {
            return true;
        }
        return this.reOccursIn(regExpConcat.right(), arrayList);
    }

    public final String toString() {
        Object object = this._left.toString();
        Object object2 = this._right.toString();
        if (this._left.isBinary()) {
            object = "(" + (String)object + ")";
        }
        if (this._right.isChoice()) {
            object2 = "(" + (String)object2 + ")";
        }
        return (String)object + "." + (String)object2;
    }

    @Override
    public final String toNormalString() {
        if (!this.inNormalForm()) {
            return this._normalForm.toNormalString();
        }
        Object object = this._left.toNormalString();
        Object object2 = this._right.toNormalString();
        if (this._left.isBinary()) {
            object = "(" + (String)object + ")";
        }
        if (this._right.isChoice()) {
            object2 = "(" + (String)object2 + ")";
        }
        return (String)object + "." + (String)object2;
    }
}

